/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;

final class TasksRequestConverters {
    private TasksRequestConverters() {
    }

    static Request cancelTasks(CancelTasksRequest cancelTasksRequest) {
        Request request = new Request("POST", "/_tasks/_cancel");
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withTimeout(cancelTasksRequest.getTimeout()).withTaskId(cancelTasksRequest.getTaskId()).withNodes(cancelTasksRequest.getNodes()).withParentTaskId(cancelTasksRequest.getParentTaskId()).withActions(cancelTasksRequest.getActions());
        return request;
    }

    static Request listTasks(ListTasksRequest listTaskRequest) {
        if (listTaskRequest.getTaskId() != null && listTaskRequest.getTaskId().isSet()) {
            throw new IllegalArgumentException("TaskId cannot be used for list tasks request");
        }
        Request request = new Request("GET", "/_tasks");
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withTimeout(listTaskRequest.getTimeout()).withDetailed(listTaskRequest.getDetailed()).withWaitForCompletion(listTaskRequest.getWaitForCompletion()).withParentTaskId(listTaskRequest.getParentTaskId()).withNodes(listTaskRequest.getNodes()).withActions(listTaskRequest.getActions()).putParam("group_by", "none");
        return request;
    }
}

