/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.GatlingMojo;
import io.gatling.mojo.MojoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.toolchain.ToolchainManager;

public abstract class AbstractGatlingMojo
extends AbstractMojo {
    @Parameter(property="gatling.bodiesFolder", alias="bdf", defaultValue="${project.basedir}/src/test/resources/bodies")
    protected File bodiesFolder;
    @Parameter(property="gatling.configFolder", alias="cd", defaultValue="${project.basedir}/src/test/resources")
    protected File configFolder;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", readonly=true)
    protected File compiledClassesFolder;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    protected ToolchainManager toolchainManager;
    @Component
    private RepositorySystem repository;

    protected List<String> buildTestClasspath(boolean includeCompiler) throws Exception {
        ArrayList<String> testClasspathElements = new ArrayList<String>();
        if (!new File(this.compiledClassesFolder, "gatling.conf").exists()) {
            testClasspathElements.add(this.configFolder.getCanonicalPath());
        }
        testClasspathElements.addAll(this.mavenProject.getTestClasspathElements());
        if (includeCompiler) {
            String scalaVersion = this.getVersion("org.scala-lang", "scala-library");
            Artifact scalaCompiler = (Artifact)this.resolve("org.scala-lang", "scala-compiler", scalaVersion, false).getArtifacts().iterator().next();
            testClasspathElements.add(scalaCompiler.getFile().getCanonicalPath());
        }
        testClasspathElements.add(MojoUtils.locateJar(GatlingMojo.class));
        return testClasspathElements;
    }

    protected String getVersion(String groupId, String artifactId) {
        for (Artifact artifact : this.mavenProject.getArtifacts()) {
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId)) continue;
            return artifact.getBaseVersion();
        }
        throw new UnsupportedOperationException("Couldn't locate " + groupId + ":" + artifactId + " in classpath");
    }

    protected ArtifactResolutionResult resolve(String groupId, String artifactId, String version, boolean resolveTransitively) throws Exception {
        Artifact artifact = this.repository.createArtifact(groupId, artifactId, version, "runtime", "jar");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setResolveRoot(true).setResolveTransitively(resolveTransitively).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies()).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        return this.repository.resolve(request);
    }

    protected void addToArgsIfNotNull(List<String> args, Object value, String flag) {
        if (value != null) {
            args.addAll(Arrays.asList("-" + flag, value.toString()));
        }
    }
}

