/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.empconf.server;

import com.yucheng.empconf.core.config.load.ConfigMgr;
import com.yucheng.empconf.core.config.model.EMPConf;
import com.yucheng.empconf.core.exception.EMPConfExcepton;
import com.yucheng.empconf.core.utils.PathUtils;
import com.yucheng.empconf.core.utils.ZKDataUtils;
import com.yucheng.empconf.core.zookeeper.ZookeeperMgr;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMPConfServerMgr {
    protected static final Logger logger = LoggerFactory.getLogger(EMPConfServerMgr.class);
    protected boolean debug = false;

    public void init(boolean debug) throws EMPConfExcepton {
        String rootPath;
        logger.info("EMPConf\u670d\u52a1\u7aef\u5f00\u59cb\u542f\u52a8....");
        EMPConf empConf = ConfigMgr.getInstance().init(false, "Server");
        if (empConf == null) {
            throw new EMPConfExcepton("EMPConf \u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519...");
        }
        ZookeeperMgr.getInstance().init(empConf, debug);
        PathUtils.rootPath = rootPath = PathUtils.getRootPath((EMPConf)empConf);
    }

    public void noticeZK(String znodeName, List<String> bizKey) throws EMPConfExcepton {
        String path = PathUtils.getWriteChildPath((String)znodeName);
        String data = ZKDataUtils.toZKData(bizKey);
        ZookeeperMgr.getInstance().writePersistentSeq(path, data);
    }

    public static EMPConfServerMgr getInstance() {
        return SingletonHolder.instance;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static void main(String[] args) throws EMPConfExcepton {
        EMPConfServerMgr.getInstance().init(false);
        ArrayList<String> bizKey = new ArrayList<String>();
        bizKey.add("admin");
        bizKey.add("\u674e\u56db");
        EMPConfServerMgr.getInstance().noticeZK("org", bizKey);
    }

    private static class SingletonHolder {
        private static EMPConfServerMgr instance = new EMPConfServerMgr();

        private SingletonHolder() {
        }
    }
}

