/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util.filelock;

import com.sunyard.ecm.server.bean.StoreObjectBean;
import com.sunyard.ecm.server.util.VolumnUtils;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.ecm3_1.StoreObjectUtil;
import com.sunyard.util.filelock.Lock;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProgrameLock
implements Lock {
    private static final Logger log = LoggerFactory.getLogger(FileProgrameLock.class);
    private String lockFileName = null;
    private FileChannel channel = null;
    private FileLock lock = null;

    public FileProgrameLock(String lockFileName, String modeCode) throws SunECMException {
        this.lockFileName = FileProgrameLock.getLockFileFullPath(lockFileName, modeCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean obtain() throws IOException {
        log.debug("obtain-->\u83b7\u53d6\u9501\u6587\u4ef6\uff0c\u65b0\u5efa\u6587\u4ef6\u4e3a [" + this.lockFileName + "]");
        File tf = new File(this.lockFileName);
        this.createFile();
        try {
            this.channel = new RandomAccessFile(tf, "rw").getChannel();
            this.lock = this.channel.lock();
            if (this.lock == null) {
                log.debug(" lock \u7684\u4e00\u4e2abug  \u6b64\u65f6lock\u6587\u4ef6 \u4e3a\u7a7a");
                boolean bl = false;
                return bl;
            }
            log.debug("--FileProgrameLock-->obtain-->\u83b7\u53d6\u9501\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6 [" + this.lockFileName + "] \u5df2\u72ec\u5360\u4f7f\u7528");
            boolean bl = true;
            return bl;
        }
        catch (OverlappingFileLockException e) {
            log.warn("--FileProgrameLock-->obtain-->\u83b7\u53d6\u9501\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6 [" + this.lockFileName + "] \u5df2\u88ab\u522b\u7684\u8fdb\u7a0b\u4f7f\u7528");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error("--FileProgrameLock-->obtain-->\u83b7\u53d6\u9501\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6 [" + this.lockFileName + "] \u53d1\u751f\u5f02\u5e38\u72b6\u51b5,\u5f02\u5e38\u4fe1\u606f\u4e3a: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
            this.channel = null;
        }
    }

    @Override
    public void unlock() {
        log.debug("--FileProgrameLock-->unlock-->\u91ca\u653e\u9501\u6587\u4ef6\uff0c\u6587\u4ef6\u4e3a [" + this.lockFileName + "]");
        try {
            if (this.lock != null) {
                this.lock.release();
            }
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
            this.lock = null;
            this.channel = null;
            this.deleteFile();
        }
        catch (IOException e) {
            log.warn("--FileProgrameLock-->unlock-->\u91ca\u653e\u9501\u6587\u4ef6\u5f02\u5e38\uff0c\u6587\u4ef6\u4e3a [" + this.lockFileName + "], \u5f02\u5e38\u4fe1\u606f\u4e3a:" + e.toString());
        }
    }

    private static String getLockFileFullPath(String fileName, String modeCodeName) throws SunECMException {
        StoreObjectBean storeObjectBean = StoreObjectUtil.getStoreObj(modeCodeName);
        String filePath = VolumnUtils.getsavePath((String)storeObjectBean.getRoot_path(), (String)storeObjectBean.getSave_path());
        String file = filePath + "TMP" + File.separator + fileName;
        log.debug("getLockFileFullPath-->\u5185\u5bb9\u6a21\u578b:[" + modeCodeName + "] ,\u6279\u6b21ID:[" + fileName + "] ,\u9501\u6587\u4ef6\u8def\u5f84:[" + file + "]");
        return file;
    }

    private void createFile() throws IOException {
        try {
            File tf = new File(this.lockFileName);
            File parent = tf.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (!tf.exists()) {
                tf.createNewFile();
            } else {
                if (tf.isDirectory()) {
                    tf.delete();
                }
                tf.createNewFile();
            }
        }
        catch (IOException e) {
            log.error("createFile-->\u521b\u5efa\u9501\u6587\u4ef6\u5f02\u5e38\uff0c\u6587\u4ef6\u4e3a [" + this.lockFileName + "]:", (Throwable)e);
            throw e;
        }
    }

    private void deleteFile() {
        log.debug("--FileProgrameLock-->deleteFile-->\u5220\u9664\u9501\u6587\u4ef6,\u6587\u4ef6\u4e3a :" + this.lockFileName);
        File tf = new File(this.lockFileName);
        if (tf.exists()) {
            tf.delete();
        }
    }
}

