/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import com.sunyard.common.Configuration;
import com.sunyard.util.EncryptUtil;
import java.io.IOException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLEnCode {
    private static final URLEnCode instance = new URLEnCode();
    private static final String encoding = "UTF-8";
    private static final String Algorithm = Configuration.get((String)"algorithm");
    private static final int Keysize = 168;
    public static final Logger logger = LoggerFactory.getLogger(URLEnCode.class);

    public static URLEnCode getInstance() {
        return instance;
    }

    public static String encryptAES(String content, String password) throws Exception {
        byte[] encryptResult = URLEnCode.encrypt(content, password);
        String encryptResultStr = URLEnCode.parseByte2HexStr(encryptResult);
        encryptResultStr = URLEnCode.ebotongEncrypto(encryptResultStr);
        return encryptResultStr;
    }

    public static String decryptAES(String encryptResultStr, String password) throws Exception {
        String decrpt = URLEnCode.ebotongDecrypto(encryptResultStr);
        byte[] decryptFrom = URLEnCode.parseHexStr2Byte(decrpt);
        byte[] decryptResult = URLEnCode.decrypt(decryptFrom, password);
        return new String(decryptResult, encoding);
    }

    public static String ebotongEncrypto(String str) throws Exception {
        logger.debug("ebotongEncrypto str=[" + str + "]");
        try {
            EncryptUtil util = EncryptUtil.getInstance("UK.dvc");
            String msg = util.Encrypt(str);
            if (msg != null && !msg.equals("")) {
                return msg.replaceAll("\r\n", "").replaceAll("\r", "").replaceAll("\n", "");
            }
        }
        catch (Exception e) {
            logger.warn("encrypto error,begin to use base 64", (Throwable)e);
        }
        Base64 base64encoder = new Base64();
        String result = str;
        if (str != null && str.length() > 0) {
            byte[] encodeByte = str.getBytes(encoding);
            result = new String(base64encoder.encode(encodeByte));
        }
        String msg = "";
        if (result != null) {
            msg = result.replaceAll("\r\n", "").replaceAll("\r", "").replaceAll("\n", "");
        }
        return msg;
    }

    public static String ebotongDecrypto(String str) throws IOException {
        try {
            EncryptUtil util = EncryptUtil.getInstance("UK.dvc");
            String msg = util.deEncrypt(str);
            if (msg != null && !msg.equals("")) {
                return msg;
            }
        }
        catch (Exception e) {
            logger.error("\u51fa\u9519");
        }
        Base64 base64decoder = new Base64();
        byte[] encodeByte = base64decoder.decode(str.getBytes());
        return new String(encodeByte);
    }

    private static byte[] encrypt(String content, String password) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance(Algorithm);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(password.getBytes());
        kgen.init(168, secureRandom);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, Algorithm);
        Cipher cipher = Cipher.getInstance(Algorithm);
        byte[] byteContent = content.getBytes(encoding);
        cipher.init(1, key);
        byte[] result = cipher.doFinal(byteContent);
        return result;
    }

    private static byte[] decrypt(byte[] content, String password) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance(Algorithm);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(password.getBytes());
        kgen.init(168, secureRandom);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, Algorithm);
        Cipher cipher = Cipher.getInstance(Algorithm);
        cipher.init(2, key);
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

