/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import com.sunyard.client.common.ClientConfiguration;
import com.sunyard.ecm.server.bean.BatchBean;
import com.sunyard.ecm.server.bean.HeightQuery;
import com.sunyard.ecm.server.bean.MigrateBatchBean;
import com.sunyard.ecm.server.dao.SunECMDao;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.StringUtil;
import com.sunyard.util.URLEnCode;
import com.sunyard.ws.utils.XMLUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRelUserUtil {
    private static final String DATE_FORMAT = "yyyyMMddHHmmssSSS";
    private static Logger log = LoggerFactory.getLogger(TokenRelUserUtil.class);
    private ThreadLocal<TokenInfoBean> threadBatchBean = new ThreadLocal();
    private static final String TOKEN = "TOKEN";
    private Map<String, TokenInfoBean> tokenMap = new ConcurrentHashMap<String, TokenInfoBean>();
    private SunECMDao sunECMDao;
    private ExecutorService clearPool = Executors.newSingleThreadExecutor();
    private Thread SCHEDULE_CLEAR_TOKEN_TASK;
    private static final long interval = 600000L;
    public static final String insertSql = "insert into token_user_rel(token_value,user_info,expired_time)values(?,?,?)";
    public static final String params_sql = "select PARAM_VALUE from PARAM_TABLE WHERE PARAM_NAME=?";

    public String getExpireTime() {
        Object[] params = new Object[]{"token_expire_time"};
        List val = this.sunECMDao.searchSql(params_sql, params);
        long token_expire_time = 1800000L;
        if (!val.isEmpty()) {
            token_expire_time = Long.parseLong((String)((Map)val.get(0)).get("PARAM_VALUE")) * 1000L;
        }
        long expire_time = System.currentTimeMillis() + token_expire_time;
        SimpleDateFormat sf = new SimpleDateFormat(DATE_FORMAT);
        String date = sf.format(new Date(expire_time));
        return date;
    }

    public long StringDate2Long(String date) {
        try {
            SimpleDateFormat sf = new SimpleDateFormat(DATE_FORMAT);
            Date time = sf.parse(date);
            return time.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public BatchBean reqXmlInfo2BatchBean(String xml) {
        TokenInfoBean tokenBean;
        BatchBean batchBean = (BatchBean)XMLUtil.xml2Bean((String)xml, BatchBean.class);
        if (!"true".equals(ClientConfiguration.get("openBreakPoint"))) {
            batchBean.setBreakPoint(false);
            log.info("breakpoint is close");
        }
        if ((tokenBean = this.removeThreadTokenBean()) == null) {
            return batchBean;
        }
        batchBean.setUser(tokenBean.getUser());
        batchBean.setPassWord(tokenBean.getPassword());
        return batchBean;
    }

    public MigrateBatchBean reqXmlInfo2MigrateBatchBean(String xml) {
        MigrateBatchBean migrateBean = MigrateBatchBean.toBean(xml);
        TokenInfoBean tokenBean = this.removeThreadTokenBean();
        if (tokenBean == null) {
            return migrateBean;
        }
        migrateBean.setUser(tokenBean.getUser());
        migrateBean.setPassWord(tokenBean.getPassword());
        return migrateBean;
    }

    public HeightQuery reqXml2HeightQueryBean(String xml) {
        HeightQuery heightQuery = (HeightQuery)XMLUtil.xml2Bean((String)xml, HeightQuery.class);
        TokenInfoBean tokenBean = this.removeThreadTokenBean();
        if (tokenBean == null) {
            return heightQuery;
        }
        heightQuery.setUserName(tokenBean.getUser());
        heightQuery.setPASSWORD(tokenBean.getPassword());
        return heightQuery;
    }

    public void setSunECMDao(SunECMDao sunECMDao) {
        this.sunECMDao = sunECMDao;
    }

    public void init() {
        this.SCHEDULE_CLEAR_TOKEN_TASK = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    TokenRelUserUtil.this.clear();
                    try {
                        Thread.sleep(600000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
        this.SCHEDULE_CLEAR_TOKEN_TASK.setName("SCHEDULE_CLEAR_TOKEN_TASK");
        this.SCHEDULE_CLEAR_TOKEN_TASK.setDaemon(true);
        this.SCHEDULE_CLEAR_TOKEN_TASK.start();
    }

    public void destroy() {
        this.SCHEDULE_CLEAR_TOKEN_TASK.interrupt();
        this.clearPool.shutdownNow();
    }

    private void clear() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                log.info("begin clear expired token");
                HashSet keys = new HashSet();
                keys.addAll(TokenRelUserUtil.this.tokenMap.keySet());
                long currentTime = System.currentTimeMillis();
                for (String token : keys) {
                    if (currentTime < ((TokenInfoBean)TokenRelUserUtil.this.tokenMap.get(token)).getExpiredTime()) continue;
                    TokenRelUserUtil.this.tokenMap.remove(token);
                }
                String clearSql = "delete from token_user_rel where expired_time <= ?";
                try {
                    SimpleDateFormat sf = new SimpleDateFormat(TokenRelUserUtil.DATE_FORMAT);
                    String dbres = TokenRelUserUtil.this.sunECMDao.deleteSql(clearSql, new Object[]{sf.format(new Date(currentTime))});
                    if (!"SUCCESS".equals(dbres)) {
                        log.warn("delete expired token fail!:{}", (Object)dbres);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                log.info(" clear expired token end");
            }
        });
        this.clearPool.execute(t);
    }

    public void tokenMessage2NormalMessage(Map<String, String> map) throws SunECMException {
        String token = map.get(TOKEN);
        if (map.get("USERNAME") != null) {
            return;
        }
        if (!StringUtil.stringIsNull(token)) {
            TokenInfoBean tokenbean = this.getTokenBean(token);
            map.put("USERNAME", tokenbean.getUser());
            map.put("PASSWORD", tokenbean.getPassword());
            this.threadBatchBean.set(tokenbean);
        }
    }

    public TokenInfoBean removeThreadTokenBean() {
        TokenInfoBean tokenBean = this.threadBatchBean.get();
        this.threadBatchBean.remove();
        return tokenBean;
    }

    public void putToken(String token, TokenInfoBean tokenBean) {
        this.tokenMap.put(token, tokenBean);
    }

    public String enCodeUserInfo(String username, String password) throws SunECMException {
        String user_info;
        try {
            user_info = URLEnCode.ebotongEncrypto(username + "<<::>>" + password);
        }
        catch (Exception e) {
            throw new SunECMException(715, (Throwable)e);
        }
        return user_info;
    }

    private TokenInfoBean deCodeUserInfo(String user_info) throws SunECMException {
        String[] userinfo;
        try {
            userinfo = URLEnCode.ebotongDecrypto(user_info).split("<<::>>");
        }
        catch (Exception e) {
            throw new SunECMException(715, (Throwable)e);
        }
        return new TokenInfoBean(userinfo[0], userinfo[1], 0L);
    }

    private TokenInfoBean getTokenBean(String token) throws SunECMException {
        long t;
        TokenInfoBean tokenbean = this.tokenMap.get(token);
        if (tokenbean == null) {
            String sql = "select USER_INFO,EXPIRED_TIME from token_user_rel where token_value=?";
            List res = this.sunECMDao.searchSql(sql, new Object[]{token});
            if (!res.isEmpty()) {
                tokenbean = this.deCodeUserInfo((String)((Map)res.get(0)).get("USER_INFO"));
                tokenbean.setExpiredTime(this.StringDate2Long((String)((Map)res.get(0)).get("EXPIRED_TIME")));
                this.tokenMap.put(token, tokenbean);
            } else {
                throw new SunECMException(730, "\u65e0\u6548\u7684\u4ee4\u724c");
            }
        }
        if ((t = System.currentTimeMillis()) >= tokenbean.getExpiredTime()) {
            this.tokenMap.remove(token);
            throw new SunECMException(730, "\u65e0\u6548\u7684\u4ee4\u724c");
        }
        return tokenbean;
    }

    public static class TokenInfoBean {
        private String user;
        private String password;
        private long expiredTime;

        public TokenInfoBean(String user, String password, long expiredTime) {
            this.user = user;
            this.password = password;
            this.expiredTime = expiredTime;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public long getExpiredTime() {
            return this.expiredTime;
        }

        private void setExpiredTime(long expiredTime) {
            this.expiredTime = expiredTime;
        }
    }
}

