/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import com.sunyard.exception.SunECMException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.SecureRandom;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static String getRandomFolder() {
        return FileUtil.getRandomFolder(1000);
    }

    public static String getLayerRandomFolder() {
        SecureRandom random = new SecureRandom();
        return String.valueOf(random.nextInt(1000));
    }

    public static String getRandomFolder(int max) {
        SecureRandom random = new SecureRandom();
        return String.valueOf(random.nextInt(max)) + File.separator + String.valueOf(random.nextInt(max));
    }

    public static String getLayerRandomFolder(int max) {
        SecureRandom random = new SecureRandom();
        return String.valueOf(random.nextInt(max));
    }

    public static boolean creatFolder(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static String fileNameOption(String fileId, String fileName) {
        int index = fileName.indexOf(".");
        if (index < 0) {
            return fileId;
        }
        return fileId + fileName.substring(index);
    }

    public static boolean existsFile(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static void copyFile(String oldRootPath, String newRootPath, String filePath) throws Exception {
        File oldPathFile = new File(oldRootPath + filePath);
        String oldPath = oldPathFile.getParent();
        File oldFile = new File(oldRootPath);
        String s = oldFile.getName();
        oldPath = oldPath.substring(oldPath.indexOf(s) + s.length());
        String newPath = newRootPath + oldPath;
        while (!FileUtil.creatFolder(newPath)) {
        }
        FileUtil.copyFile(oldRootPath + filePath, newRootPath + filePath);
    }

    public static void copyFile(String oldPath, String newPath) throws Exception {
        File oldFile = new File(oldPath);
        File newFile = new File(newPath);
        File pareFile = newFile.getParentFile();
        if (pareFile != null && !pareFile.exists()) {
            pareFile.mkdirs();
        }
        FileUtil.forChannel(oldFile, newFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forChannel(File f1, File f2) throws Exception {
        int length = 0x200000;
        FileInputStream in = null;
        FileOutputStream out = null;
        AbstractInterruptibleChannel inC = null;
        AbstractInterruptibleChannel outC = null;
        ByteBuffer b = null;
        try {
            in = new FileInputStream(f1);
            out = new FileOutputStream(f2);
            inC = in.getChannel();
            outC = out.getChannel();
            while (((FileChannel)inC).position() != ((FileChannel)inC).size()) {
                length = ((FileChannel)inC).size() - ((FileChannel)inC).position() < (long)length ? (int)(((FileChannel)inC).size() - ((FileChannel)inC).position()) : 0x200000;
                b = ByteBuffer.allocateDirect(length);
                ((FileChannel)inC).read(b);
                b.flip();
                ((FileChannel)outC).write(b);
                ((FileChannel)outC).force(false);
            }
        }
        finally {
            if (inC != null) {
                inC.close();
            }
            if (outC != null) {
                outC.close();
            }
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static boolean deleteFile(String filePath) {
        File file;
        block5: {
            file = new File(filePath);
            try {
                if (!file.exists()) break block5;
                for (int i = 0; i < 10; ++i) {
                    file.delete();
                    if (file.exists()) {
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("delete file:" + filePath, (Throwable)e);
            }
        }
        boolean result = file.exists();
        if (result) {
            log.error("file can not delete:" + filePath);
        }
        return result;
    }

    public static boolean isFileExists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String path) {
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(path);
            properties.load(inputStream);
        }
        catch (IOException e) {
            log.error("\u51fa\u9519", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    log.error("\u51fa\u9519");
                }
            }
        }
        return properties;
    }

    public static BufferedInputStream getFile(String filePath) throws SunECMException, FileNotFoundException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new SunECMException(707, "getFile: \u627e\u4e0d\u5230\u6587\u4ef6");
        }
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        return inputStream;
    }

    public static String readXml(String path) throws IOException, SunECMException {
        File file = new File(path);
        InputStream in = null;
        long date1 = System.currentTimeMillis();
        StringBuffer buffer = new StringBuffer();
        if (file.isFile()) {
            try {
                byte[] tempbytes = new byte[1024];
                in = new FileInputStream(file);
                int len = 0;
                while ((len = in.read(tempbytes)) != -1) {
                    buffer.append(new String(tempbytes, 0, len));
                }
            }
            catch (FileNotFoundException e) {
                throw new SunECMException(707, "FileUtil-->readXml: " + e.toString());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            String anStr = buffer.toString();
            long date2 = System.currentTimeMillis();
            log.debug("\u8bfb\u53d6\u4e00\u4e2a\u6279\u6ce8xml\u6587\u4ef6\u82b1\u8d39\u65f6\u95f4\uff1a " + (date2 - date1) + "\u6beb\u79d2");
            return anStr;
        }
        throw new SunECMException(707, "FileUtil-->readXml...path is not file name ...");
    }

    public static void writeXML(String xml, String filePath, String fileName) throws SunECMException {
        File path = new File(filePath);
        if (!path.exists()) {
            path.mkdirs();
        }
        File file = new File(filePath + fileName + ".xml");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, false);
            fileOutputStream.write(xml.getBytes());
        }
        catch (FileNotFoundException e) {
            throw new SunECMException(707, "FileUtil-->writeXML: " + e.toString());
        }
        catch (IOException e) {
            throw new SunECMException(720, "FileUtil-->writeXML: " + e.toString());
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                throw new SunECMException(720, "FileUtil-->writeXML: " + e.toString());
            }
        }
    }

    public static String createSaveName(String filePath, String fileNO) {
        if (!FileUtil.isFileExists(filePath + fileNO)) {
            return fileNO;
        }
        int i = 1;
        while (FileUtil.isFileExists(filePath + fileNO + "-" + i)) {
            ++i;
        }
        return fileNO + "-" + i;
    }
}

