/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import com.sunyard.ecm.server.service.EncrypterService;
import com.sunyard.util.SpringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMD5Verify {
    private static final Logger log = LoggerFactory.getLogger(FileMD5Verify.class);
    protected static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected MessageDigest messagedigest = null;

    public FileMD5Verify() {
        try {
            this.messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsaex) {
            log.error(FileMD5Verify.class.getName() + "\u521d\u59cb\u5316\u5931\u8d25\uff0cMessageDigest\u4e0d\u652f\u6301MD5Util?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileMD5String(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            int length = -1;
            while ((length = fis.read(buffer)) != -1) {
                this.messagedigest.update(buffer, 0, length);
            }
            String string = this.bufferToHex(this.messagedigest.digest()).toUpperCase();
            return string;
        }
        catch (IOException e) {
            log.error("\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                log.error("\u51fa\u9519");
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncryMD5String(File file, int beforeEncodeSize, int afterEncodeSize) {
        FileInputStream oldin = null;
        EncrypterService encrypterService = (EncrypterService)SpringUtil.getSpringBean("encrypterService");
        try {
            oldin = new FileInputStream(file);
            byte[] desencryText = new byte[beforeEncodeSize];
            byte[] encrybuffer = new byte[afterEncodeSize];
            byte[] lastbuffer = new byte[8192 - beforeEncodeSize];
            int length = -1;
            boolean flag = true;
            while (flag && ((InputStream)oldin).read(encrybuffer) != -1) {
                desencryText = encrypterService.desencryptData_ECB(encrybuffer);
                this.messagedigest.update(desencryText, 0, desencryText.length);
                flag = false;
            }
            while ((length = ((InputStream)oldin).read(lastbuffer)) != -1) {
                byte[] newbyte = this.byteMerger(desencryText, lastbuffer);
                this.messagedigest.update(newbyte, desencryText.length, length);
            }
            String string = this.bufferToHex(this.messagedigest.digest()).toUpperCase();
            return string;
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u89e3\u5bc6\u6587\u4ef6\u7684MD5\u7801\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                if (oldin != null) {
                    ((InputStream)oldin).close();
                }
            }
            catch (IOException e) {
                log.error("\u51fa\u9519");
            }
        }
        return "";
    }

    private String bufferToHex(byte[] bytes) {
        return this.bufferToHex(bytes, 0, bytes.length);
    }

    private String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            this.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    private void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xF0) >> 4];
        char c1 = hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }

    public String aa(File file) {
        String md5 = this.getFileMD5String(file);
        return md5;
    }

    public byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    public byte[] subByte(byte[] b, int off, int length) {
        byte[] b1 = new byte[length];
        System.arraycopy(b, off, b1, 0, length);
        return b1;
    }
}

