/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import com.sunyard.common.Configuration;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptUtil {
    private Key key = null;
    private Cipher cipher;
    public static final Logger logger = LoggerFactory.getLogger(EncryptUtil.class);
    private static ConcurrentLinkedQueue<SoftReference<EncryptUtil>> pool = new ConcurrentLinkedQueue();
    private SoftReference<EncryptUtil> ref;

    public static EncryptUtil getInstance(String keyFile) {
        EncryptUtil imp = null;
        SoftReference<EncryptUtil> pref = pool.poll();
        if (pref == null) {
            imp = new EncryptUtil(keyFile);
            imp.ref = new SoftReference<EncryptUtil>(imp);
        } else {
            imp = pref.get();
            if (imp == null) {
                imp = new EncryptUtil(keyFile);
                pref = new SoftReference<EncryptUtil>(imp);
                imp.ref = pref;
            }
        }
        return imp;
    }

    private EncryptUtil(String keyFile) {
        if (this.key == null) {
            SecretKeySpec keyspec = this.readInformation(keyFile);
            this.key = keyspec;
        }
        try {
            String algorithm = Configuration.get((String)"algorithm");
            this.cipher = Cipher.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("\u5b9e\u4f8b\u5316\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            logger.error("NoSuchAlgorithmException\uff1a", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error("\u5b9e\u4f8b\u5316\u52a0\u5bc6\u89e3\u5bc6\u5bf9\u8c61\u5931\u8d25\uff1a" + e.getMessage());
            logger.error("NoSuchPaddingException\uff1a", (Throwable)e);
        }
    }

    public String Encrypt(String str) {
        String encStr = "";
        byte[] encryptArray = new byte[]{};
        try {
            this.cipher.init(1, this.key);
            byte[] arrayStr = str.getBytes("UTF-8");
            encryptArray = this.cipher.doFinal(arrayStr);
            encStr = this.byteArrayToString(encryptArray);
        }
        catch (Exception e) {
            logger.error("\u51fa\u9519:" + str + "]", (Throwable)e);
        }
        pool.offer(this.ref);
        return encStr;
    }

    public String deEncrypt(String obj) {
        byte[] dencryptArray = new byte[]{};
        try {
            String value = new String(obj.getBytes("UTF-8"));
            byte[] dencStr = this.stringToByteArray(value);
            this.cipher.init(2, this.key);
            dencryptArray = this.cipher.doFinal(dencStr);
        }
        catch (Exception e) {
            logger.error("\u51fa\u9519[" + obj + "]");
        }
        pool.offer(this.ref);
        return new String(dencryptArray);
    }

    public byte[] stringToByteArray(String serializerStr) {
        Base64 decoder = new Base64();
        byte[] strByte = null;
        strByte = decoder.decode(serializerStr.getBytes());
        return strByte;
    }

    public String byteArrayToString(byte[] stream) {
        Base64 enc = new Base64();
        return new String(enc.encode(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SecretKeySpec readInformation(String keyFile) {
        SecretKeySpec keyGenerator = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(EncryptUtil.class.getClassLoader().getResourceAsStream(keyFile));
            if (ois != null) {
                keyGenerator = (SecretKeySpec)ois.readObject();
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u7c7b\uff1a" + e.getMessage());
            logger.error("ClassNotFoundException\uff1a", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u6587\u4ef6\uff1a" + e.getMessage());
            logger.error("FileNotFoundException\uff1a", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IO\u6d41\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error("IOException\uff1a", (Throwable)e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u51fa\u9519");
                }
            }
        }
        return keyGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInformation(String allpath, Object obj) throws IOException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(allpath);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
            oos.flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (oos != null) {
                oos.close();
            }
        }
    }
}

