/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.conn;

import com.sunyard.client.common.ClientConfiguration;
import com.sunyard.client.conn.FlowController;
import com.sunyard.client.conn.TransConn;
import com.sunyard.exception.SunECMException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketConn
implements TransConn,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(SocketConn.class);
    private Socket socket = null;
    private BufferedReader in = null;
    private PrintWriter out = null;
    private String socketAddrress;
    private DataOutputStream outStream;

    public SocketConn(Socket socket) throws IOException {
        this.socket = socket;
        try {
            this.socketAddrress = socket.getRemoteSocketAddress().toString();
            socket.setSendBufferSize(ClientConfiguration.getInt("client.socket.sendbuffersize", 65536));
            socket.setReceiveBufferSize(ClientConfiguration.getInt("client.socket.receivebuffersize", 65536));
            socket.setSoTimeout(ClientConfiguration.getInt("client.socket.timeout", 0) * 1000);
            this.in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
            this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), ClientConfiguration.get("client.socket.charset", "UTF-8"))), false);
            this.outStream = new DataOutputStream(socket.getOutputStream());
        }
        catch (IOException e) {
            log.error("--SocketConn-->SocketConn-->IOException-->" + e.toString());
            throw new IOException(e.toString());
        }
    }

    @Override
    public void sendMsg(String msg) {
        this.out.println(msg);
        this.out.flush();
    }

    @Override
    public String receiveMsg() throws IOException {
        try {
            String msg = this.in.readLine();
            return msg;
        }
        catch (IOException e) {
            log.error("-->SocketConn-->receiveMsg-->IOException-->" + e.toString());
            if (" Software caused connection abort: recv failed".equals(e.toString())) {
                return "#######\u4e0a\u4f20\u6279\u6b21\u8fd4\u56de\u7684\u4fe1\u606f[FAIL<<::>>741]#######";
            }
            throw new IOException(e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean sendFileData(String filePath, String contentID, String transType) throws SunECMException, IOException {
        int i = filePath.lastIndexOf(46);
        String format = "";
        if (i > -1 && i < filePath.length()) {
            format = filePath.substring(i + 1, filePath.length());
        }
        int transBufferSize = ClientConfiguration.getInt("client.socket.buffersize", 65536);
        int maxbps = 0;
        FileInputStream fileInputStream = null;
        File tempFile = null;
        int status = 700;
        try {
            try {
                String afterXml;
                File file = new File(filePath);
                if (!file.exists()) {
                    log.error("\u6587\u4ef6\u4e0d\u5b58\u5728,\u6587\u4ef6\u8def\u5f84\uff1a" + file.getPath());
                    boolean bl = false;
                    return bl;
                }
                long fileSize = file.length();
                filePath = filePath.replaceAll(",", "<<DH>>");
                String str = transType + "FILENAME=" + file.getName() + ",FILESIZE=" + Long.toString(fileSize) + ",BUFFERSIZE=" + transBufferSize + ",FILEPATH=" + filePath + ",CONTENTID = " + contentID + ",FORMAT=" + format;
                log.debug("\u5ba2\u6237\u7aef\u53d1\u9001\u6587\u4ef6\u62a5\u6587 , socket client send file msg=" + str);
                this.sendMsg(str);
                String result = this.receiveMsg();
                if (result == null || result.equals("")) {
                    log.error("\u5ba2\u6237\u7aef\u6587\u4ef6\u53d1\u9001\u524d\u63a5\u6536\u8fd4\u56de\u7684\u62a5\u6587,return msg \u4e3a\u7a7a [" + result + "]");
                    boolean bl = false;
                    return bl;
                }
                log.debug("\u5ba2\u6237\u7aef\u6587\u4ef6\u53d1\u9001\u524d\u63a5\u6536\u8fd4\u56de\u7684\u62a5\u6587,return msg = " + result);
                String[] content = result.split("<<::>>");
                if (!String.valueOf("0001").equals(content[0])) {
                    status = Integer.parseInt(content[0]);
                    String errorMsg = " server no msg";
                    if (content.length > 1) {
                        errorMsg = content[1];
                    }
                    log.error("---SunDM-->SocketClientTransImpl-->sendFile-->\u670d\u52a1\u7aef\u5f02\u5e38--" + errorMsg);
                    throw new SunECMException(status, "---SunDM-->SocketClientTransImpl-->sendFile-->\u670d\u52a1\u7aef\u5f02\u5e38--" + errorMsg);
                }
                long skipLength = 0L;
                if (content.length >= 2) {
                    maxbps = Integer.valueOf(content[1]);
                }
                if (content.length == 3) {
                    skipLength = Integer.valueOf(content[2]).intValue();
                }
                fileSize -= skipLength;
                fileInputStream = new FileInputStream(file);
                long skipedLength = fileInputStream.skip(skipLength);
                if (skipedLength != skipLength) {
                    throw new SunECMException("\u65ad\u70b9\u6587\u4ef6\u4e0e\u670d\u52a1\u7aef\u6587\u4ef6\u5927\u5c0f\u4e0d\u4e00\u81f4");
                }
                boolean transFlag = true;
                int off = 0;
                if (maxbps > 0) {
                    FlowController fin = new FlowController(fileInputStream, maxbps);
                    log.debug("\u5f53\u524d\u901f\u7387" + fin.check() / 1000 + "kbps,\u6587\u4ef6\u5927\u5c0f" + fin.available() / 1024 + "kb");
                    long start = System.currentTimeMillis();
                    byte[] buffer = new byte[1024];
                    int realLength = 0;
                    while ((realLength = fin.read(buffer)) > 0) {
                        this.outStream.write(buffer, 0, realLength);
                    }
                    fin.close();
                    long end = System.currentTimeMillis();
                    log.debug(Thread.currentThread().getName() + "\u8bfb\u53d6\u6587\u4ef6" + file + "\u8017\u65f6" + (end - start) / 600L + "\u79d2");
                }
                if (maxbps == 0) {
                    while (transFlag) {
                        byte[] buf;
                        int l;
                        int bufSize = transBufferSize;
                        if (fileSize < (long)transBufferSize) {
                            bufSize = Integer.parseInt(Long.toString(fileSize));
                            transFlag = false;
                        }
                        if ((l = fileInputStream.read(buf = new byte[bufSize])) != -1) {
                            this.outStream.write(buf, 0, l);
                        }
                        this.outStream.flush();
                        fileSize -= (long)transBufferSize;
                        off += transBufferSize;
                    }
                }
                if ((afterXml = this.receiveMsg()) == null) {
                    log.error("\u8fd4\u56de\u4e3a\u7a7a");
                    boolean buf = false;
                    return buf;
                }
                log.debug("\u5ba2\u6237\u7aef\u6587\u4ef6\u53d1\u9001\u540e\u5b8c\u6210\u8fd4\u56de\u7684\u62a5\u6587,return msg = " + afterXml);
                String[] results = afterXml.split("<<::>>");
                if (!"0001".equals(results[1])) {
                    log.warn(afterXml);
                    throw new SunECMException(afterXml);
                }
                boolean bl = true;
                return bl;
            }
            catch (SunECMException e) {
                log.error("-->SocketConn-->sendFileData-->SunECMException-->" + e.toString());
                throw new SunECMException(status, e.toString());
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
        catch (IOException e) {
            log.error("-->sendFileData-->sendFileData-->IOException-->" + e.toString());
            throw new IOException(e.toString());
        }
    }

    @Override
    public void destroy() {
        log.info("\u5173\u95edSOCKET\u8fde\u63a5" + this.socketAddrress);
        try {
            this.in.close();
        }
        catch (IOException e) {
            log.error("\u5173\u95ed\u8fde\u63a5\u51fa\u9519", (Throwable)e);
        }
        if (this.outStream != null) {
            try {
                this.outStream.flush();
                this.outStream.close();
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            log.warn("close socket get excption\uff1a" + this.socketAddrress, (Throwable)e);
        }
        log.info("\u5173\u95edSOCKET\u8fde\u63a5over" + this.socketAddrress);
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public String getSocketAddrress() {
        return this.socketAddrress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.sendMsg("0009");
            this.receiveMsg();
        }
        catch (Exception e) {
            log.error("\u51fa\u9519", (Throwable)e);
        }
        finally {
            this.destroy();
        }
    }
}

