/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client;

import com.sunyard.client.bean.HttpConnType;
import com.sunyard.client.conn.HttpConn;
import com.sunyard.client.conn.HttpsConn;
import com.sunyard.client.conn.TransConn;
import com.sunyard.client.connQueueControl.SocketConnObject;
import com.sunyard.common.Configuration;
import com.sunyard.ecm.server.bean.BatchFileBean;
import com.sunyard.ecm.server.bean.FileBean;
import com.sunyard.ecm.server.bean.GroupBean;
import com.sunyard.ecm.server.bean.MigrateBatchBean;
import com.sunyard.ecm.server.bean.NodeInfo;
import com.sunyard.ecm.server.bean.StoreObjectBean;
import com.sunyard.ecm.server.cache.LazySingleton;
import com.sunyard.ecm.server.util.EcmUtil;
import com.sunyard.ecm.server.util.GenerateMsg;
import com.sunyard.ecm.server.util.GroupServerUtil;
import com.sunyard.ecm.server.util.ModelUtil;
import com.sunyard.ecm.server.util.VolumnUtils;
import com.sunyard.exception.SunECMException;
import com.sunyard.msgqueue.MsgPut;
import com.sunyard.scheduler.dao.ContentMigrateDao;
import com.sunyard.util.CodeUtil;
import com.sunyard.util.SpringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateApi {
    private ContentMigrateDao migrateDao = (ContentMigrateDao)SpringUtil.getSpringBean("contentMigrateDao");
    private static final Logger log = LoggerFactory.getLogger(MigrateApi.class);
    private SocketConnObject connObject = null;
    private String serverName = Configuration.get((String)"localName", (String)"SunECMDM");
    private static String agreement = LazySingleton.getInstance().load.getConfigBean().getAgreement();

    private TransConn getTransTypeImpl(NodeInfo nodeInfo, String type) throws SunECMException {
        if (nodeInfo == null) {
            throw new SunECMException(753, "\u83b7\u53d6\u4f20\u8f93\u8fde\u63a5\u5bf9\u8c61\u65f6\uff0cnodeInfo \u4e3a\u7a7a(nodeInfo is null ,to get trans conn object)");
        }
        TransConn conn = null;
        if ("http".equals(agreement)) {
            String url = "";
            int connTimeOut = 30000;
            int reqTimeOut = 30000;
            url = "MSG".equals(type) ? this.createMsgURL(nodeInfo.getServer_ip(), nodeInfo.getHttp_port()) : this.createFileURL(nodeInfo.getServer_ip(), nodeInfo.getHttp_port());
            conn = new HttpConn(url, connTimeOut, reqTimeOut);
        } else if ("socket".equals(agreement)) {
            this.connObject = new SocketConnObject(nodeInfo.getServer_ip(), nodeInfo.getSocket_port());
            conn = this.connObject.getClientTrans();
        } else {
            String url = "";
            int connTimeOut = 30000;
            int reqTimeOut = 30000;
            url = "MSG".equals(type) ? this.createMsgURL(nodeInfo.getServer_ip(), nodeInfo.getHTTPS_PORT()) : this.createFileURL(nodeInfo.getServer_ip(), nodeInfo.getHTTPS_PORT());
            conn = new HttpsConn(url, connTimeOut, reqTimeOut);
        }
        return conn;
    }

    private String createMsgURL(String ip, String port) {
        ip = CodeUtil.changeIp(ip);
        if ("http".equals(agreement)) {
            return "http://" + ip + ":" + port + "/" + this.serverName + "/servlet/httpReqDispacher";
        }
        return "https://" + ip + ":" + port + "/" + this.serverName + "/servlet/httpReqDispacher";
    }

    private String createFileURL(String ip, String httpPort) {
        ip = CodeUtil.changeIp(ip);
        if ("http".equals(agreement)) {
            return "http://" + ip + ":" + httpPort + "/" + this.serverName + "/servlet/httpMigrateFileReceive";
        }
        return "https://" + ip + ":" + httpPort + "/" + this.serverName + "/servlet/httpMigrateFileReceive";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSocketConn() {
        block6: {
            log.debug("removeSocketConn-->\u79fb\u9664socket\u8fde\u63a5");
            if (this.connObject != null) {
                try {
                    if (!"socket".equals(agreement)) break block6;
                    try {
                        log.debug("\u5173\u95edsocket\u8fde\u63a5");
                        this.connObject.closeConn();
                    }
                    finally {
                        this.connObject = null;
                    }
                }
                catch (Exception e) {
                    log.warn("close socket get exception" + e.getMessage());
                }
            }
        }
    }

    public boolean migrate(MigrateBatchBean migrateBean, String modelType, GroupBean groupBean) throws SunECMException, Exception {
        long t = System.currentTimeMillis();
        String migrateStatus = "0";
        String modelCode = migrateBean.getModelCode();
        try {
            String errorVersion;
            int version;
            String id = migrateBean.getIndex_Object().getContentID();
            boolean versionContorl = ModelUtil.isVersionControl((String)migrateBean.getModelCode());
            String verStr = migrateBean.getIndex_Object().getVersion();
            if (versionContorl && (version = Integer.parseInt(verStr)) > 1 && EcmUtil.isNotBlank((String)(errorVersion = this.migrateDao.getMigrateErrorVersion(migrateBean)))) {
                log.warn("\u6279\u6b21\uff1a[" + id + "] \u5b58\u5728\u8fc1\u79fb\u5931\u8d25\u7684\u7248\u672c[" + errorVersion + "]\uff0c\u56e0\u6b64\u4e0d\u80fd\u8fc1\u79fb");
                this.migrateDao.insertIntoMigrate_error(id, migrateBean.getTABLE_NAME(), migrateBean.getModelCode(), "errorversion=" + errorVersion + "  migrate already has error", verStr);
                boolean bl = false;
                return bl;
            }
            NodeInfo nodeInfo = GroupServerUtil.getGroupNodeServerById((String)groupBean.getGroup_id());
            TransConn conn = this.getTransTypeImpl(nodeInfo, HttpConnType.MSG);
            String msg = "0002<<::>>OPTION=MIGRATE,START=START,CONTENTID=" + id + ",XML=" + migrateBean.toString();
            conn.sendMsg(msg);
            log.debug(msg);
            String rMsg1 = conn.receiveMsg();
            if (!"".equals(rMsg1) && !String.valueOf("0001").equals(rMsg1.split("<<::>>")[0])) {
                log.error("--MigrateApi-->MigrateApi-->\u8fc1\u79fb\u6279\u6b21\u670d\u52a1\u7aef\u53d1\u751f\u9519\u8bef, migrate content server error, the content id is" + rMsg1 + ";migrateBean is" + migrateBean.toString());
                throw new SunECMException(754, "--MigrateApi-->MigrateApi-->\u8fc1\u79fb\u6279\u6b21\u670d\u52a1\u7aef\u53d1\u751f\u9519\u8bef, migrate content server error, the content id is" + rMsg1 + ";migrateBean is" + migrateBean.toString());
            }
            if (!"0".equals(modelType) && ("1".equals(modelType) || "2".equals(modelType))) {
                if ("http".equals(agreement)) {
                    conn = this.getTransTypeImpl(nodeInfo, HttpConnType.FILE);
                }
                String modelName = migrateBean.getModelCode();
                List<BatchFileBean> tempList = migrateBean.getDocument_Objects();
                if (tempList != null) {
                    String root = "";
                    String filePath = "";
                    String contentID = migrateBean.getIndex_Object().getContentID();
                    if (contentID == null) {
                        contentID = tempList.get(0).getFiles().get(0).getContentID();
                    }
                    for (BatchFileBean fileBean : tempList) {
                        List<FileBean> files = fileBean.getFiles();
                        String file_part_table_name = fileBean.getFILE_PART_TABLE_NAME();
                        if (files == null) continue;
                        for (FileBean bean : files) {
                            String optionType = bean.getOptionType();
                            if (optionType.equals("3") || optionType.equals("4") && versionContorl) continue;
                            if (bean.getFilePath() != null && !"".equals(bean.getFilePath()) && !"null".equals(bean.getFilePath())) {
                                if ("".equals(root)) {
                                    StoreObjectBean storeBean = LazySingleton.getInstance().storeObject.getStoreObjectBeanByVId(bean.getVolume_id());
                                    root = VolumnUtils.getsavePath((String)storeBean.getRoot_path(), (String)storeBean.getSave_path());
                                }
                                if (!conn.sendFileData(filePath = root + bean.getFilePath() + bean.getSaveName(), contentID, msg = "0007<<::>>MODEL_NAME=" + modelName + ",FILE_NO=" + bean.getFileNO() + ",SAVE_NAME=" + bean.getSaveName() + ",FILE_FORMAT=" + bean.getFileFormat() + ",VERSION=" + bean.getVersion() + ",FILESIZE=" + bean.getFilesize())) {
                                    this.removeSocketConn();
                                    log.error("migrate-->send file fail ,contentID:" + contentID + ", file path:" + filePath);
                                    this.migrateDao.insertIntoMigrate_error_detail(contentID, migrateBean.getTABLE_NAME(), file_part_table_name, migrateBean.getModelCode(), fileBean.getFilePartName(), migrateBean.getBusinessStartDate(), verStr);
                                    boolean storeBean = false;
                                    return storeBean;
                                }
                                if ("http".equals(agreement)) {
                                    String rMsg = conn.receiveMsg();
                                    log.debug("--MigrateApi-->migrate-->\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + rMsg);
                                    if (!"".equals(rMsg) && !String.valueOf("0001").equals(rMsg.split("<<::>>")[0])) {
                                        log.error("--migrate-->MigrateApi-->send file fail ,contentID\uff1a" + contentID + ", file path\uff1a" + filePath);
                                    }
                                }
                            }
                            root = "";
                        }
                    }
                }
            }
            if ("http".equals(agreement)) {
                conn = this.getTransTypeImpl(nodeInfo, HttpConnType.MSG);
            }
            msg = "0002<<::>>OPTION=MIGRATE,START=END,CONTENTID=" + id;
            conn.sendMsg(msg);
            log.debug("--MigrateApi-->MigrateApi-->\u5185\u5bb9\u8fc1\u79fb\u53d1\u9001\u7684\u6d88\u606f\uff1a" + msg);
            String rMsg = conn.receiveMsg();
            log.debug("--MigrateApi-->MigrateApi-->\u5185\u5bb9\u8fc1\u79fb\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + rMsg);
            if (!"".equals(rMsg)) {
                if (String.valueOf("0001").equals(rMsg.split("<<::>>")[0])) {
                    this.migrateDao.updateMigrateSuccess(migrateBean);
                    migrateStatus = "1";
                    t = System.currentTimeMillis() - t;
                    boolean bl = true;
                    return bl;
                }
                log.error("--MigrateApi-->MigrateApi-->\u8fc1\u79fb\u6279\u6b21\u670d\u52a1\u7aef\u53d1\u751f\u9519\u8bef, migrate content server error, the content id is" + rMsg + ";migrateBean is" + migrateBean.toString());
                throw new SunECMException(754, "--MigrateApi-->MigrateApi-->\u8fc1\u79fb\u6279\u6b21\u670d\u52a1\u7aef\u53d1\u751f\u9519\u8bef, migrate content server error, the content id is" + rMsg + ";migrateBean is" + migrateBean.toString());
            }
            boolean bl = false;
            return bl;
        }
        catch (SunECMException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.removeSocketConn();
        }
    }

    private void putMsg(String modelCode, String optStatus, long takeTime) {
        String date = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String nodeId = LazySingleton.getInstance().load.getNodeInfoBean().getServer_id();
        String msg = GenerateMsg.getOptMsg((String)modelCode, (String)nodeId, (String)date, (String)"MIGRATE_VERSION", (String)optStatus, (long)takeTime);
        new MsgPut(msg).putMsg();
    }
}

