/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.servo;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StepCounter;
import com.netflix.servo.util.Clock;
import com.netflix.spectator.api.AbstractRegistry;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.servo.ServoClock;
import com.netflix.spectator.servo.ServoCounter;
import com.netflix.spectator.servo.ServoDistributionSummary;
import com.netflix.spectator.servo.ServoGauge;
import com.netflix.spectator.servo.ServoMeter;
import com.netflix.spectator.servo.ServoTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServoRegistry
extends AbstractRegistry
implements CompositeMonitor<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServoRegistry.class);
    static final long EXPIRATION_TIME_MILLIS = ServoRegistry.getExpirationTimeMillis();
    private static final MonitorConfig DEFAULT_CONFIG = new MonitorConfig.Builder("spectator.registry").build();
    private final MonitorConfig config;

    private static long getExpirationTimeMillis() {
        String key = "spectator.servo.expirationTimeInMinutes";
        long minutes = 15L;
        String v = System.getProperty("spectator.servo.expirationTimeInMinutes", "" + minutes);
        try {
            minutes = Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            LOGGER.error("invalid value for property 'spectator.servo.expirationTimeInMinutes', expecting integer: '" + v + "'." + " The default value of " + minutes + " minutes will be used.", (Throwable)e);
        }
        return TimeUnit.MINUTES.toMillis(minutes);
    }

    public ServoRegistry() {
        this(com.netflix.spectator.api.Clock.SYSTEM);
    }

    public ServoRegistry(com.netflix.spectator.api.Clock clock) {
        this(clock, DEFAULT_CONFIG);
    }

    ServoRegistry(com.netflix.spectator.api.Clock clock, MonitorConfig config) {
        super(clock);
        this.config = config;
        DefaultMonitorRegistry.getInstance().register((Monitor)this);
    }

    MonitorConfig toMonitorConfig(Id id) {
        MonitorConfig.Builder builder = new MonitorConfig.Builder(id.name());
        for (Tag t : id.tags()) {
            builder.withTag(t.key(), t.value());
        }
        return builder.build();
    }

    protected Counter newCounter(Id id) {
        MonitorConfig cfg = this.toMonitorConfig(id);
        StepCounter counter = new StepCounter(cfg, (Clock)new ServoClock(this.clock()));
        return new ServoCounter(this.clock(), counter);
    }

    protected DistributionSummary newDistributionSummary(Id id) {
        return new ServoDistributionSummary(this, id);
    }

    protected Timer newTimer(Id id) {
        return new ServoTimer(this, id);
    }

    public Integer getValue() {
        return 0;
    }

    public Integer getValue(int pollerIndex) {
        return 0;
    }

    public MonitorConfig getConfig() {
        return this.config;
    }

    public List<Monitor<?>> getMonitors() {
        ArrayList monitors = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Meter meter = (Meter)iterator.next();
            if (meter instanceof ServoMeter) {
                if (meter.hasExpired()) continue;
                ((ServoMeter)meter).addMonitors(monitors);
                continue;
            }
            for (Measurement m : meter.measure()) {
                monitors.add((Monitor<?>)new ServoGauge(this.toMonitorConfig(m.id()), m.value()));
            }
        }
        return monitors;
    }
}

