/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.servo;

import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.servo.ServoTag;
import java.util.Iterator;
import java.util.Map;

class ServoId
implements Id {
    private final MonitorConfig config;

    public ServoId(MonitorConfig config) {
        this.config = config;
    }

    MonitorConfig config() {
        return this.config;
    }

    public String name() {
        return this.config.getName();
    }

    public Iterable<Tag> tags() {
        return new Iterable<Tag>(){

            @Override
            public Iterator<Tag> iterator() {
                return new Iterator<Tag>(){
                    private final Iterator<com.netflix.servo.tag.Tag> iter;
                    {
                        this.iter = ServoId.this.config.getTags().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Tag next() {
                        return new ServoTag(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }
        };
    }

    public Id withTag(String k, String v) {
        return new ServoId(new MonitorConfig.Builder(this.config).withTag(k, v).build());
    }

    public Id withTag(Tag t) {
        return this.withTag(t.key(), t.value());
    }

    public Id withTags(Iterable<Tag> ts) {
        MonitorConfig.Builder builder = new MonitorConfig.Builder(this.config);
        for (Tag t : ts) {
            builder.withTag(t.key(), t.value());
        }
        return new ServoId(builder.build());
    }

    public Id withTags(Map<String, String> ts) {
        MonitorConfig.Builder builder = new MonitorConfig.Builder(this.config);
        for (Map.Entry<String, String> t : ts.entrySet()) {
            builder.withTag(t.getKey(), t.getValue());
        }
        return new ServoId(builder.build());
    }
}

