/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.servo;

import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.StepCounter;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.servo.ServoId;
import com.netflix.spectator.servo.ServoMeter;
import com.netflix.spectator.servo.ServoRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

class ServoCounter
implements Counter,
ServoMeter {
    private final Clock clock;
    private final StepCounter impl;
    private final AtomicLong count;
    private final AtomicLong lastUpdated;

    ServoCounter(Clock clock, StepCounter impl) {
        this.clock = clock;
        this.impl = impl;
        this.count = new AtomicLong(0L);
        this.lastUpdated = new AtomicLong(clock.wallTime());
    }

    @Override
    public void addMonitors(List<Monitor<?>> monitors) {
        monitors.add((Monitor<?>)this.impl);
    }

    public Id id() {
        return new ServoId(this.impl.getConfig());
    }

    public boolean hasExpired() {
        long now = this.clock.wallTime();
        return now - this.lastUpdated.get() > ServoRegistry.EXPIRATION_TIME_MILLIS;
    }

    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        double v = this.impl.getValue(0).doubleValue();
        return Collections.singleton(new Measurement(this.id(), now, v));
    }

    public void increment() {
        this.impl.increment();
        this.count.incrementAndGet();
        this.lastUpdated.set(this.clock.wallTime());
    }

    public void increment(long amount) {
        this.impl.increment(amount);
        this.count.addAndGet(amount);
        this.lastUpdated.set(this.clock.wallTime());
    }

    public long count() {
        return this.count.get();
    }
}

