/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.network;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.network.PeerName;
import com.ibm.msg.client.wmq.v6.network.SSLCRLHelper;
import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;

public class SSLHelper
implements HandshakeCompletedListener {
    private static X509Certificate[] certs;
    private static final String CLSNAME = "SSLHelper";
    private static Boolean inFipsMode;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/network/SSLHelper.java, jmscc.wmq.v6, k701, k701-112-140304 1.12.1.1 09/08/17 08:39:31";
    private boolean certSet = false;
    private X509Certificate serverCert = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SSLSocketFactory chooseSocketFactory(Object sslSocketFactory) throws MQException {
        SSLSocketFactory sslFact;
        block34: {
            if (Trace.isOn) {
                Trace.entry("com.ibm.msg.client.wmq.v6.network.SSLHelper", "chooseSocketFactory(Object)", new Object[]{sslSocketFactory});
            }
            sslFact = null;
            if (inFipsMode != null && inFipsMode.booleanValue()) {
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "FIPS mode has been selected", null);
                }
                System.setProperty("com.ibm.jsse2.JSSEFIPS", "true");
                try {
                    CSSystem.dynamicLoadClass("com.ibm.jsse2.IBMJSSEProvider2", SSLHelper.class);
                    Package thisPackage = Package.getPackage("com.ibm.jsse2");
                    String versionInfo = thisPackage.getImplementationVersion();
                    int index = versionInfo.indexOf("_");
                    String versionNum = null;
                    if (index != -1) {
                        versionNum = versionInfo.substring(index + 1);
                    }
                    int intVersion = 0;
                    if (versionNum != null && !versionNum.equals("")) {
                        intVersion = Integer.parseInt(versionNum);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "JSSE VERSION: " + intVersion, null);
                    }
                    if (intVersion >= 20041026) {
                        if (Trace.isOn) {
                            Trace.traceData(CLSNAME, "SR1a or greater available", null);
                        }
                        Class cls = CSSystem.dynamicLoadClass("com.ibm.crypto.fips.provider.IBMJCEFIPS", SSLHelper.class);
                        Provider provider = (Provider)cls.newInstance();
                        Security.insertProviderAt(provider, 1);
                        cls = CSSystem.dynamicLoadClass("com.ibm.jsse2.SSLSocketFactoryImpl", SSLHelper.class);
                        sslFact = (SSLSocketFactory)cls.newInstance();
                        if (Trace.isOn) {
                            Trace.traceData(CLSNAME, "Using JSSE2 for FIPS", null);
                        }
                        break block34;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "1.4.2 or lower available", null);
                    }
                    try {
                        Class cls = CSSystem.dynamicLoadClass("com.ibm.fips.jsse.JSSESocketFactory", SSLHelper.class);
                        sslFact = (SSLSocketFactory)cls.newInstance();
                        if (Trace.isOn) {
                            Trace.traceData(CLSNAME, "Using old JSSE for FIPS", null);
                        }
                        break block34;
                    }
                    catch (Exception e2) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLHelper", "chooseSocketFactory(Object)", e2, 1);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLSNAME, "JVM does not contain a FIPS compliant JSSE", null);
                        }
                        MQException traceRet1 = new MQException(2, 2393, (Object)CLSNAME);
                        if (Trace.isOn) {
                            Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLHelper", "chooseSocketFactory(Object)", traceRet1, 1);
                        }
                        throw traceRet1;
                    }
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLHelper", "chooseSocketFactory(Object)", e, 2);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "1.4.2 or lower available", null);
                    }
                    try {
                        Class cls = CSSystem.dynamicLoadClass("com.ibm.fips.jsse.JSSESocketFactory", SSLHelper.class);
                        sslFact = (SSLSocketFactory)cls.newInstance();
                        if (Trace.isOn) {
                            Trace.traceData(CLSNAME, "Using old JSSE for FIPS", null);
                        }
                        break block34;
                    }
                    catch (Exception e3) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLHelper", "chooseSocketFactory(Object)", e3, 3);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLSNAME, "JVM does not contain a FIPS compliant JSSE", null);
                        }
                        MQException traceRet2 = new MQException(2, 2393, (Object)CLSNAME);
                        if (Trace.isOn) {
                            Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLHelper", "chooseSocketFactory(Object)", traceRet2, 2);
                        }
                        throw traceRet2;
                    }
                }
            }
            if (sslSocketFactory == null) {
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "using default SSLSocketFactory", null);
                }
                sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
            } else if (sslSocketFactory instanceof SSLSocketFactory) {
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "using supplied SSLSocketFactory", null);
                }
                sslFact = (SSLSocketFactory)sslSocketFactory;
            } else {
                MQException traceRet3 = new MQException(2, 2046, (Object)Thread.currentThread(), "MQJE066", "sslSocketFactory");
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLHelper", "chooseSocketFactory(Object)", traceRet3, 3);
                }
                throw traceRet3;
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.network.SSLHelper", "chooseSocketFactory(Object)", sslFact);
        }
        return sslFact;
    }

    private static String configureSSLSocket(SSLSocket socket, String sslCipherSuite, String sslPeerName, Collection sslCertStores, boolean fipsRequired) throws MQException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.network.SSLHelper", "configureSSLSocket(SSLSocket,String,String,Collection,boolean)", new Object[]{socket, sslCipherSuite, sslPeerName, sslCertStores, fipsRequired});
        }
        String[] spec = new String[]{sslCipherSuite};
        try {
            socket.setEnabledCipherSuites(spec);
        }
        catch (IllegalArgumentException e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLHelper", "configureSSLSocket(SSLSocket,String,String,Collection,boolean)", e, 1);
            }
            MQException traceRet1 = new MQException(2, 2400, (Object)"static method in SSL code", "MQJE011");
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLHelper", "configureSSLSocket(SSLSocket,String,String,Collection,boolean)", traceRet1, 1);
            }
            throw traceRet1;
        }
        String protocol = sslCipherSuite.substring(0, 3);
        String[] protocols = new String[1];
        if (fipsRequired || protocol.equals("TLS")) {
            protocols[0] = "TLSv1";
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Setting protocol to TLSv1", null);
            }
        } else {
            protocols[0] = "SSLv3";
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Setting protocol to SSLv3", null);
            }
        }
        if (Trace.isOn) {
            String[] list = socket.getSupportedProtocols();
            String stringList = new String();
            for (int i = 0; i < list.length; ++i) {
                stringList = stringList + list[i] + ", ";
            }
            Trace.traceData(CLSNAME, "Supported Protocols are " + stringList, null);
        }
        socket.setEnabledProtocols(protocols);
        SSLHelper listener = new SSLHelper();
        socket.addHandshakeCompletedListener(listener);
        if (Trace.isOn) {
            Trace.traceData(CLSNAME, "calling startHandshake", null);
        }
        try {
            socket.startHandshake();
        }
        catch (SSLException e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLHelper", "configureSSLSocket(SSLSocket,String,String,Collection,boolean)", e, 2);
            }
            MQException mqex = new MQException(2, 2397, (Object)"static method in SSL code", "MQJE056");
            mqex.initCause((Throwable)e);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLHelper", "configureSSLSocket(SSLSocket,String,String,Collection,boolean)", mqex, 2);
            }
            throw mqex;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLHelper", "configureSSLSocket(SSLSocket,String,String,Collection,boolean)", e, 3);
            }
            MQException mqex = new MQException(2, 2397, (Object)"static method in SSL code", "MQJE030");
            mqex.initCause((Throwable)e);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLHelper", "configureSSLSocket(SSLSocket,String,String,Collection,boolean)", mqex, 3);
            }
            throw mqex;
        }
        X509Certificate cert = listener.getServerCert();
        Principal p = cert.getSubjectDN();
        String serverPN = p.getName();
        if (sslPeerName != null && !sslPeerName.equals("")) {
            PeerName pn2;
            PeerName pn;
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "checking peername", null);
            }
            if ((pn = new PeerName(sslPeerName, true)).isMatchingPeerName(pn2 = new PeerName(serverPN, false))) {
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "peerName matches", null);
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "peerName " + pn.getDN() + " doesn't match " + pn2.getDN(), null);
                }
                try {
                    socket.close();
                }
                catch (IOException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLHelper", "configureSSLSocket(SSLSocket,String,String,Collection,boolean)", e, 4);
                    }
                    MQException traceRet2 = new MQException(2, 2059, (Object)"static method in SSL code", "MQJE013");
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLHelper", "configureSSLSocket(SSLSocket,String,String,Collection,boolean)", traceRet2, 4);
                    }
                    throw traceRet2;
                }
                MQException traceRet3 = new MQException(2, 2398, (Object)"static method in SSL code", "MQJE067", pn.getDN(), pn2.getDN());
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLHelper", "configureSSLSocket(SSLSocket,String,String,Collection,boolean)", traceRet3, 5);
                }
                throw traceRet3;
            }
        }
        if (sslCertStores != null) {
            SSLCRLHelper.check(certs[0], sslCertStores);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.network.SSLHelper", "configureSSLSocket(SSLSocket,String,String,Collection,boolean)", (Object)serverPN);
        }
        return serverPN;
    }

    public static SSLSocket createSSLSocket(String hostname, int port, String sslCipherSuite, String sslPeerName, Collection sslCertStores, Object sslSocketFactory, Socket s, boolean clientAuth, boolean asServer) throws MQException {
        SSLSocket socket;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.network.SSLHelper", "createSSLSocket(String,int,String,String,Collection,Object,Socket,boolean,boolean)", new Object[]{hostname, new Integer(port), sslCipherSuite, sslPeerName, sslCertStores, sslSocketFactory, s, clientAuth, asServer});
        }
        SSLSocketFactory sslFact = SSLHelper.chooseSocketFactory(sslSocketFactory);
        if (Trace.isOn) {
            Trace.traceData(CLSNAME, "creating SSL socket from non-SSL one", null);
        }
        try {
            socket = (SSLSocket)sslFact.createSocket(s, hostname, port, false);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLHelper", "createSSLSocket(String,int,String,String,Collection,Object,Socket,boolean,boolean)", e);
            }
            MQException mqex = new MQException(2, 2397, (Object)"static method in SSL code", "MQJE030");
            mqex.initCause((Throwable)e);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLHelper", "createSSLSocket(String,int,String,String,Collection,Object,Socket,boolean,boolean)", mqex);
            }
            throw mqex;
        }
        socket.setNeedClientAuth(clientAuth);
        socket.setUseClientMode(!asServer);
        boolean fipsMode = false;
        if (inFipsMode != null) {
            fipsMode = inFipsMode;
        }
        SSLHelper.configureSSLSocket(socket, sslCipherSuite, sslPeerName, sslCertStores, fipsMode);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.network.SSLHelper", "createSSLSocket(String,int,String,String,Collection,Object,Socket,boolean,boolean)", socket);
        }
        return socket;
    }

    private synchronized X509Certificate getServerCert() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.network.SSLHelper", "getServerCert()");
        }
        while (!this.certSet) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException e) {
                if (!Trace.isOn) continue;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.network.SSLHelper", "getServerCert()", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.network.SSLHelper", "getServerCert()", this.serverCert);
        }
        return this.serverCert;
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        block8: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.network.SSLHelper", "handshakeCompleted(HandshakeCompletedEvent)", new Object[]{event});
            }
            try {
                certs = event.getPeerCertificateChain();
                if (certs != null && certs.length > 0) {
                    this.setServerCert(certs[0]);
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "Remote peer name = " + certs[0].getSubjectDN(), null);
                        Trace.traceData(CLSNAME, "Remote issuer    = " + certs[0].getIssuerDN(), null);
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "no peer certificates", null);
                    }
                    this.setServerCert(null);
                }
            }
            catch (Exception e) {
                if (!Trace.isOn) break block8;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.network.SSLHelper", "handshakeCompleted(HandshakeCompletedEvent)", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.network.SSLHelper", "handshakeCompleted(HandshakeCompletedEvent)");
        }
    }

    private synchronized void setServerCert(X509Certificate x) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.network.SSLHelper", "setServerCert(X509Certificate)", "setter", x);
        }
        this.serverCert = x;
        this.certSet = true;
        this.notifyAll();
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.network.SSLHelper", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/network/SSLHelper.java, jmscc.wmq.v6, k701, k701-112-140304  1.12.1.1 09/08/17 08:39:31");
        }
        inFipsMode = null;
    }
}

