/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.network;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509CRLSelector;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public class SSLCRLHelper {
    public static final String CLSNAME = "SSLCRLHelper";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/network/SSLCRLHelper.java, jmscc.wmq.v6, k701, k701-112-140304 1.10.1.1 09/08/17 08:39:14";

    public static void addCertStoreAsString(String URI2, Collection col) throws MQException {
        String currentHost;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "addCertStoreAsString(String,Collection)", new Object[]{URI2, col});
        }
        int port = 389;
        int portpos = URI2.indexOf(58, 7);
        if (portpos != -1) {
            currentHost = URI2.substring(7, portpos);
            port = Integer.parseInt(URI2.substring(portpos + 1));
        } else {
            currentHost = URI2.substring(7);
        }
        try {
            col.add(CertStore.getInstance("LDAP", new LDAPCertStoreParameters(currentHost, port)));
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "addCertStoreAsString(String,Collection)", e, 2);
            }
            MQException traceRet1 = new MQException(2, 2195, (Object)URI2);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "addCertStoreAsString(String,Collection)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "addCertStoreAsString(String,Collection)");
        }
    }

    static void check(X509Certificate cert, Collection sslCertStores) throws MQException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", new Object[]{cert, sslCertStores});
        }
        if (sslCertStores.size() == 0) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", 1);
            }
            return;
        }
        CertStore certStore = null;
        Exception rcse = null;
        boolean searched_a_CRL = false;
        Iterator it = sslCertStores.iterator();
        while (it.hasNext() && !searched_a_CRL) {
            try {
                certStore = (CertStore)it.next();
            }
            catch (ClassCastException cce) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", cce, 1);
                }
                if (rcse != null) continue;
                rcse = cce;
                continue;
            }
            if (certStore == null) {
                if (rcse != null) continue;
                rcse = new NullPointerException();
                continue;
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Searching CRL server", null);
            }
            X509CRLSelector certSelector = new X509CRLSelector();
            Principal p = cert.getIssuerDN();
            String issuer = p.getName();
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Setting issuer to " + issuer, null);
            }
            try {
                certSelector.addIssuerName(new X500Principal(issuer).getName("CANONICAL"));
            }
            catch (IOException e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", e, 2);
                }
                MQException traceRet1 = new MQException(2, 2397, (Object)"static method in SSLCRL code", "MQJE013");
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", traceRet1, 1);
                }
                throw traceRet1;
            }
            Collection<Object> crls = new Vector();
            try {
                Certificate certToCheck;
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "Retrieving CRLs", null);
                }
                try {
                    crls = certStore.getCRLs(certSelector);
                }
                catch (CertStoreException cse) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", cse, 3);
                    }
                    if (cse.getCause() instanceof NamingException) {
                        NamingException ne = (NamingException)cse.getCause();
                        if (ne.getRootCause() instanceof NameNotFoundException) {
                            if (Trace.isOn) {
                                Trace.traceData(CLSNAME, "Caught Sun NameNotFoundException - ignoring", null);
                            }
                        }
                        if (Trace.isOn) {
                            Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", cse, 2);
                        }
                        throw cse;
                    }
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", cse, 3);
                    }
                    throw cse;
                }
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X509");
                    certToCheck = cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
                }
                catch (java.security.cert.CertificateException ce) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", ce, 4);
                    }
                    MQException traceRet2 = new MQException(2, 2195, (Object)cert);
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", traceRet2, 4);
                    }
                    throw traceRet2;
                }
                catch (CertificateException ce) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", ce, 5);
                    }
                    MQException traceRet3 = new MQException(2, 2195, (Object)cert);
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", traceRet3, 5);
                    }
                    throw traceRet3;
                }
                if (crls.size() == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "Issuer has no revoked certificates - accepting", null);
                    }
                    searched_a_CRL = true;
                    continue;
                }
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "Validating certificate against CRL", null);
                }
                Iterator<Object> i = crls.iterator();
                while (i.hasNext()) {
                    CRL crl = (CRL)i.next();
                    if (crl.isRevoked(certToCheck)) {
                        MQException traceRet4 = new MQException(2, 2401, (Object)Thread.currentThread(), "MQJE068");
                        if (Trace.isOn) {
                            Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", traceRet4, 6);
                        }
                        throw traceRet4;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "Not revoked - accepting", null);
                    }
                    searched_a_CRL = true;
                }
            }
            catch (CertStoreException e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", e, 6);
                }
                if (rcse != null) continue;
                rcse = e;
            }
        }
        if (!searched_a_CRL) {
            MQException mqex = new MQException(2, 2402, (Object)"static method in SSLCRL code", "MQJE069");
            mqex.initCause((Throwable)rcse);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", mqex, 7);
            }
            throw mqex;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "check(X509Certificate,Collection)", 2);
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.network.SSLCRLHelper", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/network/SSLCRLHelper.java, jmscc.wmq.v6, k701, k701-112-140304  1.10.1.1 09/08/17 08:39:14");
        }
    }
}

