/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.network;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.Vector;

class PeerName {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int DNCLEAR = 1;
    private static final int DNFINISHED = 5;
    private static final int DNQVALUE = 4;
    private static final int DNSYMBOL = 2;
    private static final int DNVALUE = 3;
    private String C = null;
    private String CN = null;
    private String L = null;
    private boolean matcher;
    private String O = null;
    private String originalName = null;
    private Vector OU = new Vector();
    private String ST = null;
    private String T = null;

    protected PeerName(String DN, boolean validate) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "<init>(String,boolean)", new Object[]{DN, validate});
        }
        this.originalName = DN;
        this.matcher = validate;
        this.parseDN(DN);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "<init>(String,boolean)");
        }
    }

    protected String getDN() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "getDN()", "getter", this.originalName);
        }
        return this.originalName;
    }

    protected boolean isMatchingPeerName(PeerName name) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "isMatchingPeerName(PeerName)", new Object[]{name});
        }
        if (Trace.isOn) {
            Trace.traceData(this, "Comparing \"" + this.getDN() + "\" with \"" + name.getDN() + "\"", null);
        }
        boolean match = true;
        if (this.CN != null && !this.wequals(this.CN, name.CN)) {
            match = false;
        }
        if (this.T != null && !this.wequals(this.T, name.T)) {
            match = false;
        }
        if (this.O != null && !this.wequals(this.O, name.O)) {
            match = false;
        }
        if (this.L != null && !this.wequals(this.L, name.L)) {
            match = false;
        }
        if (this.ST != null && !this.wequals(this.ST, name.ST)) {
            match = false;
        }
        if (this.C != null && !this.wequals(this.C, name.C)) {
            match = false;
        }
        if (this.OU.size() > name.OU.size()) {
            match = false;
        } else {
            for (int i = 0; i < this.OU.size(); ++i) {
                if (this.wequals((String)this.OU.elementAt(i), (String)name.OU.elementAt(i))) continue;
                match = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.network.PeerName", "isMatchingPeerName(PeerName)", match);
        }
        return match;
    }

    private void parseDN(String DN) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "parseDN(String)", new Object[]{DN});
        }
        int state = 1;
        String symbol = "";
        String value = "";
        if (DN != null && DN.equals("")) {
            state = 5;
        }
        try {
            for (int i = 0; i < DN.length(); ++i) {
                char ch = DN.charAt(i);
                if (state == 1) {
                    if (ch == '\"' || ch == ',' || ch == ';' || ch == '=') {
                        MQException traceRet1 = new MQException(2, 2399, (Object)this);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "parseDN(String)", traceRet1, 1);
                        }
                        throw traceRet1;
                    }
                    if (ch == ' ' || ch == '\t') continue;
                    symbol = symbol + ch;
                    state = 2;
                    continue;
                }
                if (state == 2) {
                    if (ch == ' ' || ch == '\"') {
                        MQException traceRet2 = new MQException(2, 2399, (Object)this);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "parseDN(String)", traceRet2, 2);
                        }
                        throw traceRet2;
                    }
                    if (ch == '=') {
                        value = "";
                        if (i + 1 >= DN.length()) {
                            state = 3;
                            continue;
                        }
                        if (DN.charAt(i + 1) == '\"') {
                            ++i;
                            state = 4;
                            continue;
                        }
                        state = 3;
                        continue;
                    }
                    symbol = symbol + ch;
                    continue;
                }
                if (state == 3) {
                    if (!(ch != ',' && ch != ';' || i != 0 && DN.charAt(i - 1) == '\\')) {
                        state = 1;
                        this.setValue(symbol, value.trim());
                        symbol = "";
                        continue;
                    }
                    value = value + ch;
                    continue;
                }
                if (state == 4) {
                    if (ch == '\"' && (i == 0 || DN.charAt(i - 1) != '\\')) {
                        state = 5;
                        this.setValue(symbol, value);
                        symbol = "";
                        continue;
                    }
                    value = value + ch;
                    continue;
                }
                if (state != 5) continue;
                if (ch == ',' || ch == ';') {
                    state = 1;
                    continue;
                }
                if (ch == ' ' || ch == '\t') continue;
                MQException traceRet3 = new MQException(2, 2399, (Object)this);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "parseDN(String)", traceRet3, 3);
                }
                throw traceRet3;
            }
            if (state == 3) {
                this.setValue(symbol, value.trim());
            }
            if (state == 2 || state == 1) {
                MQException traceRet4 = new MQException(2, 2399, (Object)this);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "parseDN(String)", traceRet4, 4);
                }
                throw traceRet4;
            }
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "parseDN(String)", e);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "parseDN(String)", e, 5);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "parseDN(String)");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setValue(String rawsymbol, String value) throws MQException {
        block30: {
            String symbol;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "setValue(String,String)", new Object[]{rawsymbol, value});
            }
            if ((symbol = rawsymbol.toUpperCase()).equals("CN")) {
                if (this.CN == null) {
                    this.CN = value.toUpperCase();
                    break block30;
                } else {
                    MQException traceRet1 = new MQException(2, 2399, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "setValue(String,String)", traceRet1, 1);
                    }
                    throw traceRet1;
                }
            }
            if (symbol.equals("T")) {
                if (this.T == null) {
                    this.T = value.toUpperCase();
                    break block30;
                } else {
                    MQException traceRet2 = new MQException(2, 2399, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "setValue(String,String)", traceRet2, 2);
                    }
                    throw traceRet2;
                }
            }
            if (symbol.equals("O")) {
                if (this.O == null) {
                    this.O = value.toUpperCase();
                    break block30;
                } else {
                    MQException traceRet3 = new MQException(2, 2399, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "setValue(String,String)", traceRet3, 3);
                    }
                    throw traceRet3;
                }
            }
            if (symbol.equals("L")) {
                if (this.L == null) {
                    this.L = value.toUpperCase();
                    break block30;
                } else {
                    MQException traceRet4 = new MQException(2, 2399, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "setValue(String,String)", traceRet4, 4);
                    }
                    throw traceRet4;
                }
            }
            if (symbol.equals("ST") || symbol.equals("SP") || symbol.equals("S")) {
                if (this.ST == null) {
                    this.ST = value.toUpperCase();
                    break block30;
                } else {
                    MQException traceRet5 = new MQException(2, 2399, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "setValue(String,String)", traceRet5, 5);
                    }
                    throw traceRet5;
                }
            }
            if (symbol.equals("C")) {
                if (this.C == null) {
                    this.C = value.toUpperCase();
                    break block30;
                } else {
                    MQException traceRet6 = new MQException(2, 2399, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "setValue(String,String)", traceRet6, 6);
                    }
                    throw traceRet6;
                }
            }
            if (symbol.equals("OU")) {
                this.OU.add(value.toUpperCase());
            } else if (this.matcher) {
                MQException traceRet7 = new MQException(2, 2399, (Object)this);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "setValue(String,String)", traceRet7, 7);
                }
                throw traceRet7;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "setValue(String,String)");
        }
    }

    private boolean wequals(String pattern, String real) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "wequals(String,String)", new Object[]{pattern, real});
        }
        if (real == null) {
            if (pattern != null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "wequals(String,String)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "wequals(String,String)", true, 2);
            }
            return true;
        }
        String realsmashed = real.toUpperCase();
        if (pattern.equals("*")) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "wequals(String,String)", true, 3);
            }
            return true;
        }
        if (pattern.charAt(0) == '*') {
            if (pattern.charAt(pattern.length() - 1) == '*') {
                boolean traceRet1;
                boolean bl = traceRet1 = realsmashed.indexOf(realsmashed.substring(1, pattern.length() - 2)) != -1;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "wequals(String,String)", traceRet1, 4);
                }
                return traceRet1;
            }
            boolean traceRet2 = realsmashed.endsWith(pattern.substring(1));
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "wequals(String,String)", traceRet2, 5);
            }
            return traceRet2;
        }
        if (pattern.charAt(pattern.length() - 1) == '*' && pattern.charAt(pattern.length() - 2) != '\\') {
            boolean traceRet3 = realsmashed.startsWith(pattern.substring(0, pattern.length() - 1));
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "wequals(String,String)", traceRet3, 6);
            }
            return traceRet3;
        }
        StringBuffer bPattern = new StringBuffer(pattern);
        for (int pos = 0; pos < bPattern.length(); ++pos) {
            if (bPattern.charAt(pos) != '\\') continue;
            bPattern.deleteCharAt(pos);
        }
        String unescapedPattern = bPattern.toString();
        StringBuffer bReal = new StringBuffer(realsmashed);
        for (int pos = 0; pos < bReal.length(); ++pos) {
            if (bReal.charAt(pos) != '\\') continue;
            bReal.deleteCharAt(pos);
        }
        String unescapedRealsmashed = bReal.toString();
        if (Trace.isOn) {
            Trace.traceData(this, "Comparing " + unescapedPattern, null);
        }
        if (Trace.isOn) {
            Trace.traceData(this, "     with " + unescapedRealsmashed, null);
        }
        boolean traceRet4 = unescapedPattern.equals(unescapedRealsmashed);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.network.PeerName", "wequals(String,String)", traceRet4, 7);
        }
        return traceRet4;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.network.PeerName", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/network/SSLHelper.java, jmscc.wmq.v6, k701, k701-112-140304  1.12.1.1 09/08/17 08:39:31");
        }
    }
}

