/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.network;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQChannelDefinition;
import com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Hashtable;

public abstract class FWHelper {
    public static final String CLSNAME = "FWHelper";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/network/FWHelper.java, jmscc.wmq.v6, k701, k701-112-140304 1.11.1.1 09/08/17 08:39:04";
    static PrintWriter debug_out;
    private static boolean FW_DEBUG_ENABLED;
    public static final String FW_END_PORT = "END_PORT";
    public static final String FW_HOST = "HOST";
    public static final String FW_OBJECT = "FIREWALL_SETTINGS";
    public static final String FW_START_PORT = "START_PORT";

    private static InetAddress decodeLocalAddress(Object encoded) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.network.FWHelper", "decodeLocalAddress(Object)", new Object[]{encoded});
        }
        try {
            if (encoded instanceof Hashtable) {
                Hashtable encHash = (Hashtable)encoded;
                InetAddress data = (InetAddress)encHash.get(FW_HOST);
                if (Trace.isOn && FW_DEBUG_ENABLED) {
                    Trace.traceData(CLSNAME, "Retrieved: " + data, null);
                }
                if (Trace.isOn) {
                    Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "decodeLocalAddress(Object)", data, 1);
                }
                return data;
            }
            if (Trace.isOn && FW_DEBUG_ENABLED) {
                Trace.traceData(CLSNAME, "Encoded object is not a hashtable - return null", null);
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "decodeLocalAddress(Object)", (Object)null, 2);
            }
            return null;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "decodeLocalAddress(Object)", e);
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Exception occurred during decoding", null);
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, e.toString(), null);
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "decodeLocalAddress(Object)", (Object)null, 3);
            }
            return null;
        }
    }

    private static int decodePort(Object encoded, String portType) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.network.FWHelper", "decodePort(Object,String)", new Object[]{encoded, portType});
        }
        try {
            if (encoded instanceof Hashtable) {
                Hashtable encHash = (Hashtable)encoded;
                Integer data = (Integer)encHash.get(portType);
                if (Trace.isOn && FW_DEBUG_ENABLED) {
                    Trace.traceData(CLSNAME, "Retrieved: " + data, null);
                }
                if (data != null) {
                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                        Trace.traceData(CLSNAME, "Returning: " + data, null);
                    }
                    int traceRet1 = data;
                    if (Trace.isOn) {
                        Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "decodePort(Object,String)", new Integer(traceRet1), 1);
                    }
                    return traceRet1;
                }
                if (Trace.isOn && FW_DEBUG_ENABLED) {
                    Trace.traceData(CLSNAME, "Returning: 0", null);
                }
                if (Trace.isOn) {
                    Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "decodePort(Object,String)", new Integer(0), 2);
                }
                return 0;
            }
            if (Trace.isOn && FW_DEBUG_ENABLED) {
                Trace.traceData(CLSNAME, "Encoded object is not a hashtable - return 0", null);
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "decodePort(Object,String)", new Integer(0), 3);
            }
            return 0;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "decodePort(Object,String)", e);
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Exception occurred during decoding - return 0", null);
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, e.toString(), null);
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "decodePort(Object,String)", new Integer(0), 4);
            }
            return 0;
        }
    }

    public static Object encodeToObject(String setting) throws MQException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.network.FWHelper", "encodeToObject(String)", new Object[]{setting});
        }
        try {
            Hashtable<String, Serializable> encoded = new Hashtable<String, Serializable>();
            InetAddress address = FWHelper.getLocalIP(setting);
            if (address != null) {
                encoded.put(FW_HOST, address);
            }
            encoded.put(FW_START_PORT, new Integer(FWHelper.getStartPort(setting)));
            encoded.put(FW_END_PORT, new Integer(FWHelper.getEndPort(setting)));
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "encodeToObject(String)", encoded);
            }
            return encoded;
        }
        catch (MQException m) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "encodeToObject(String)", m, 1);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "encodeToObject(String)", m, 1);
            }
            throw m;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "encodeToObject(String)", e, 2);
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Exception occurred during encoding", null);
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, e.toString(), null);
            }
            MQException traceRet1 = new MQException(2, 2059, (Object)"FWHelper encodeToObject", "MQJE071");
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "encodeToObject(String)", traceRet1, 2);
            }
            throw traceRet1;
        }
    }

    public static boolean fuzzyCompare(MQManagedConnectionJ11 mc, Object settingObject) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.network.FWHelper", "fuzzyCompare(MQManagedConnectionJ11,Object)", new Object[]{mc, settingObject});
        }
        String localInetAddress = null;
        int localPort = 0;
        MQSESSION sess = mc.getMQSESSION();
        switch (sess.getJmqiBindType()) {
            case 1: 
            case 2: {
                MQChannelDefinition clientConn = sess.getMQCD();
                localInetAddress = clientConn.localAddress;
                localPort = clientConn.port;
                break;
            }
            default: {
                if (Trace.isOn) {
                    Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "fuzzyCompare(MQManagedConnectionJ11,Object)", false, 1);
                }
                return false;
            }
        }
        InetAddress decoded = FWHelper.decodeLocalAddress(settingObject);
        if (decoded == null || localInetAddress != null && localInetAddress.equals(decoded)) {
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Local address object matches.", null);
            }
            int lower = FWHelper.decodePort(settingObject, FW_START_PORT);
            int upper = FWHelper.decodePort(settingObject, FW_END_PORT);
            if (upper == 0) {
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "No port restrictrictions set.", null);
                }
                if (Trace.isOn) {
                    Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "fuzzyCompare(MQManagedConnectionJ11,Object)", true, 2);
                }
                return true;
            }
            if (localPort >= lower && localPort <= upper) {
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "Bound port is within range", null);
                }
                if (Trace.isOn) {
                    Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "fuzzyCompare(MQManagedConnectionJ11,Object)", true, 3);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Bound port " + localPort + " is outside range [" + lower + ", " + upper + "]", null);
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "fuzzyCompare(MQManagedConnectionJ11,Object)", false, 4);
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.traceData(CLSNAME, "Local address object does not match", null);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "fuzzyCompare(MQManagedConnectionJ11,Object)", false, 5);
        }
        return false;
    }

    public static int getEndPort(String setting) throws MQException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", new Object[]{setting});
        }
        int returnCode = 0;
        try {
            String stringSetting = null;
            if (setting != null) {
                int commaIndex = setting.indexOf(",");
                if (commaIndex == -1) {
                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                        Trace.traceData(CLSNAME, "No comma specified - default to getStartPort", null);
                    }
                    int traceRet1 = FWHelper.getStartPort(setting);
                    if (Trace.isOn) {
                        Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", new Integer(traceRet1), 1);
                    }
                    return traceRet1;
                }
                int endChar = 0;
                endChar = setting.indexOf(")", commaIndex);
                if (endChar == -1) {
                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                        Trace.traceData(CLSNAME, "Malformed setting string. No closing bracket found - return " + returnCode, null);
                    }
                    MQException traceRet2 = new MQException(2, 2059, (Object)"FWHelper getEndPort", "MQJE071");
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", traceRet2, 1);
                    }
                    throw traceRet2;
                }
                stringSetting = setting.substring(commaIndex + 1, endChar);
                if (Trace.isOn && FW_DEBUG_ENABLED) {
                    Trace.traceData(CLSNAME, "String form of end port: " + stringSetting, null);
                }
                try {
                    int portEnd;
                    if (stringSetting != null) {
                        stringSetting = stringSetting.trim();
                    }
                    if (stringSetting.length() == 0) {
                        stringSetting = "0";
                    }
                    if ((portEnd = Integer.valueOf(stringSetting).intValue()) >= 0) {
                        if (Trace.isOn && FW_DEBUG_ENABLED) {
                            Trace.traceData(CLSNAME, "Converted to int successfully: " + portEnd, null);
                        }
                        if (Trace.isOn) {
                            Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", new Integer(portEnd), 2);
                        }
                        return portEnd;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "Negative port number: " + portEnd, null);
                    }
                    MQException traceRet3 = new MQException(2, 2059, (Object)"FWHelper getEndPort", "MQJE071");
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", traceRet3, 2);
                    }
                    throw traceRet3;
                }
                catch (MQException m) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", m, 1);
                    }
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", m, 3);
                    }
                    throw m;
                }
                catch (Exception g) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", g, 2);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "Exception occurred converting string to int - return " + returnCode, null);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, g.toString(), null);
                    }
                    MQException traceRet4 = new MQException(2, 2059, (Object)"FWHelper getEndPort", "MQJE071");
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", traceRet4, 4);
                    }
                    throw traceRet4;
                }
            }
            if (Trace.isOn && FW_DEBUG_ENABLED) {
                Trace.traceData(CLSNAME, "setting string is null - default to startPort", null);
            }
            int traceRet5 = FWHelper.getStartPort(setting);
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", new Integer(traceRet5), 3);
            }
            return traceRet5;
        }
        catch (MQException m) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", m, 3);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", m, 5);
            }
            throw m;
        }
        catch (Exception g) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", g, 4);
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Exception occurred - return " + returnCode, null);
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, g.toString(), null);
            }
            MQException traceRet6 = new MQException(2, 2059, (Object)"FWHelper getEndPort", "MQJE071");
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getEndPort(String)", traceRet6, 6);
            }
            throw traceRet6;
        }
    }

    public static InetAddress getLocalIP(String setting) throws MQException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.network.FWHelper", "getLocalIP(String)", new Object[]{setting});
        }
        try {
            InetAddress fw_localip = null;
            String hostSetting = null;
            if (setting != null) {
                int bracketIndex = setting.indexOf("(");
                if (bracketIndex == -1) {
                    bracketIndex = setting.length();
                }
                hostSetting = setting.substring(0, bracketIndex);
            } else {
                hostSetting = null;
            }
            try {
                if (hostSetting != null && hostSetting.trim().length() == 0) {
                    hostSetting = null;
                }
                if (Trace.isOn && FW_DEBUG_ENABLED) {
                    Trace.traceData(CLSNAME, "Attempt to get local ip setting from this string: '" + hostSetting + "'", null);
                }
                if ((fw_localip = hostSetting == null || hostSetting.equalsIgnoreCase("localhost") || hostSetting.equalsIgnoreCase("127.0.0.1") ? InetAddress.getLocalHost() : InetAddress.getByName(hostSetting)) != null) {
                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                        Trace.traceData(CLSNAME, "Parsed local IP setting: " + fw_localip.getHostAddress(), null);
                    }
                } else if (Trace.isOn && FW_DEBUG_ENABLED) {
                    Trace.traceData(CLSNAME, "Parsed local IP setting is null", null);
                }
                if (Trace.isOn) {
                    Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "getLocalIP(String)", fw_localip);
                }
                return fw_localip;
            }
            catch (IOException e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getLocalIP(String)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "IO Error determining local InetAddress", null);
                }
                MQException traceRet1 = new MQException(2, 2059, (Object)"FWHelper getLocalIP", "MQJE071");
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getLocalIP(String)", traceRet1, 1);
                }
                throw traceRet1;
            }
            catch (Exception f) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getLocalIP(String)", f, 2);
                }
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "Error determining local InetAddress", null);
                }
                MQException traceRet2 = new MQException(2, 2059, (Object)"FWHelper getLocalIP", "MQJE071");
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getLocalIP(String)", traceRet2, 2);
                }
                throw traceRet2;
            }
        }
        catch (MQException m) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getLocalIP(String)", m, 3);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getLocalIP(String)", m, 3);
            }
            throw m;
        }
        catch (Exception g) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getLocalIP(String)", g, 4);
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Exception occurred", null);
            }
            MQException traceRet3 = new MQException(2, 2059, (Object)"FWHelper getLocalIP", "MQJE071");
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getLocalIP(String)", traceRet3, 4);
            }
            throw traceRet3;
        }
    }

    public static int getStartPort(String setting) throws MQException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", new Object[]{setting});
        }
        int returnCode = 0;
        try {
            String stringSetting = null;
            if (setting != null) {
                int bracketIndex = setting.indexOf("(");
                if (bracketIndex == -1) {
                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                        Trace.traceData(CLSNAME, "No starting bracket specified - default to 0", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", new Integer(0), 1);
                    }
                    return 0;
                }
                int endChar = 0;
                endChar = setting.indexOf(",", bracketIndex);
                if (endChar == -1 && (endChar = setting.indexOf(")", bracketIndex)) == -1) {
                    if (Trace.isOn && FW_DEBUG_ENABLED) {
                        Trace.traceData(CLSNAME, "Malformed setting string. No comma or closing bracket found - return " + returnCode, null);
                    }
                    MQException traceRet1 = new MQException(2, 2059, (Object)"FWHelper getStartPort", "MQJE071");
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", traceRet1, 1);
                    }
                    throw traceRet1;
                }
                stringSetting = setting.substring(bracketIndex + 1, endChar);
                if (Trace.isOn && FW_DEBUG_ENABLED) {
                    Trace.traceData(CLSNAME, "String form of start port: '" + stringSetting + "'", null);
                }
                try {
                    int portStart;
                    if (stringSetting != null) {
                        stringSetting = stringSetting.trim();
                    }
                    if (stringSetting.length() == 0) {
                        stringSetting = "0";
                    }
                    if ((portStart = Integer.valueOf(stringSetting).intValue()) >= 0) {
                        if (Trace.isOn && FW_DEBUG_ENABLED) {
                            Trace.traceData(CLSNAME, "Converted to int successfully: " + portStart, null);
                        }
                        if (Trace.isOn) {
                            Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", new Integer(portStart), 2);
                        }
                        return portStart;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "Negative port number: " + portStart, null);
                    }
                    MQException traceRet2 = new MQException(2, 2059, (Object)"FWHelper getStartPort", "MQJE071");
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", traceRet2, 2);
                    }
                    throw traceRet2;
                }
                catch (MQException m) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", m, 1);
                    }
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", m, 3);
                    }
                    throw m;
                }
                catch (Exception g) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", g, 2);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "Exception occurred converting string to int - return " + returnCode, null);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, g.toString(), null);
                    }
                    MQException traceRet3 = new MQException(2, 2059, (Object)"FWHelper getStartPort", "MQJE071");
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", traceRet3, 4);
                    }
                    throw traceRet3;
                }
            }
            if (Trace.isOn && FW_DEBUG_ENABLED) {
                Trace.traceData(CLSNAME, "setting string is null - default to 0", null);
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", new Integer(0), 3);
            }
            return 0;
        }
        catch (MQException m) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", m, 3);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", m, 5);
            }
            throw m;
        }
        catch (Exception g) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", g, 4);
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "Exception occurred - return " + returnCode, null);
            }
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, g.toString(), null);
            }
            MQException traceRet4 = new MQException(2, 2059, (Object)"FWHelper getStartPort", "MQJE071");
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.network.FWHelper", "getStartPort(String)", traceRet4, 6);
            }
            throw traceRet4;
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.network.FWHelper", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/network/FWHelper.java, jmscc.wmq.v6, k701, k701-112-140304  1.11.1.1 09/08/17 08:39:04");
        }
        debug_out = null;
        FW_DEBUG_ENABLED = false;
    }
}

