/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQC;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.PCF;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.GregorianCalendar;
import javax.jms.JMSException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

class Utils {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/Utils.java, jmscc.wmq.v6, k701, k701-112-140304 1.25.1.1 09/08/17 08:17:50";
    static final int MQCA_BASE_Q_NAME = 2002;
    static final int MQCA_Q_MGR_NAME = 2015;
    static final int MQCA_Q_NAME = 2016;
    static final int MQCA_Q_MGR_IDENTIFIER = 2032;
    static final int MQCA_DEAD_LETTER_Q_NAME = 2006;
    static final int MQCA_BACKOUT_REQ_Q_NAME = 2019;
    static final int MQIA_DEFINITION_TYPE = 7;
    static final int MQIA_Q_TYPE = 20;
    static final int MQIA_BACKOUT_THRESHOLD = 22;
    private static final String CLASSNAME = "com.ibm.msg.client.wmq.v6.jms.internal.Utils";
    private static final int BUFSIZE = 128;
    private static final String BLANK48 = "                                                ";
    private static Object xactionManager;
    private static boolean wasNotDetected;
    private static final Object xactionManagerLock;

    Utils() {
    }

    protected static String[] listMatchingQueues(MQQueueManager qm, MQQueue replyQ, String filter) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "listMatchingQueues(MQQueueManager,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,String)", new Object[]{qm, replyQ, filter});
        }
        String[] ret = null;
        try {
            PCF replyPCF;
            MQQueue commandQueue = qm.accessQueue("SYSTEM.ADMIN.COMMAND.QUEUE", 8208);
            PCF pcf = new PCF(18);
            pcf.addParameter(2016, filter);
            pcf.addParameter(20, 1);
            MQMessage message = new MQMessage();
            message.replyToQueueName = replyQ.name;
            message.expiry = 5000;
            pcf.write(message);
            commandQueue.put(message, new MQPutMessageOptions());
            commandQueue.close();
            MQGetMessageOptions gmo = new MQGetMessageOptions();
            gmo.options = 8193;
            gmo.waitInterval = 5000;
            message.correlationId = message.messageId;
            message.messageId = MQC.MQMI_NONE;
            replyQ.get(message, gmo);
            if (message != null && (replyPCF = new PCF(message)).getParameterCount() == 1 && replyPCF.getParameterType(0) == 6) {
                ret = ((PCF.MQCFSL)replyPCF.getParameterAt(0)).getStrings();
            }
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "listMatchingQueues(MQQueueManager,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,String)", ret, 1);
            }
            return ret;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "listMatchingQueues(MQQueueManager,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,String)", e);
            }
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "listMatchingQueues(MQQueueManager,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,String)", (Object)null, 2);
            }
            return null;
        }
    }

    private static String bytesToHex(byte[] bArray, int maxLength) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "bytesToHex(byte [ ],int)", new Object[]{bArray, new Integer(maxLength)});
        }
        if (bArray == null) {
            String traceRet1 = "<null>";
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "bytesToHex(byte [ ],int)", (Object)traceRet1, 1);
            }
            return traceRet1;
        }
        int dumpLength = bArray.length;
        if (maxLength != -1 && maxLength < dumpLength) {
            dumpLength = maxLength;
        }
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < dumpLength; ++i) {
            int binByte = bArray[i];
            if (binByte < 0) {
                binByte += 256;
            }
            if (binByte < 16) {
                hex.append('0');
            }
            hex.append(Integer.toHexString(binByte).toUpperCase());
        }
        String traceRet2 = hex.toString();
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "bytesToHex(byte [ ],int)", (Object)traceRet2, 2);
        }
        return traceRet2;
    }

    protected static String bytesToHex(byte[] bArray) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "bytesToHex(byte [ ])", new Object[]{bArray});
        }
        String traceRet1 = Utils.bytesToHex(bArray, -1);
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "bytesToHex(byte [ ])", (Object)traceRet1);
        }
        return traceRet1;
    }

    protected static byte[] hexToBytes(String hex) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "hexToBytes(String)", new Object[]{hex});
        }
        byte[] out = null;
        if (hex != null) {
            int len = hex.length();
            if (len % 2 != 0) {
                JMSException traceRet1 = ConfigEnvironment.newException("MQJMS1044");
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "hexToBytes(String)", traceRet1, 1);
                }
                throw traceRet1;
            }
            out = new byte[len /= 2];
            for (int i = 0; i < len; ++i) {
                int digit1 = Character.digit(hex.charAt(2 * i), 16);
                int digit2 = Character.digit(hex.charAt(2 * i + 1), 16);
                if (digit1 == -1 || digit2 == -1) {
                    JMSException traceRet2 = ConfigEnvironment.newException("MQJMS1044");
                    if (Trace.isOn) {
                        Trace.throwing(CLASSNAME, "hexToBytes(String)", traceRet2, 2);
                    }
                    throw traceRet2;
                }
                out[i] = (byte)(digit1 * 16 + digit2);
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "hexToBytes(String)", out);
        }
        return out;
    }

    protected static String inquireString(MQManagedObject obj, int attr) {
        String result;
        block4: {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "inquireString(com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject,int)", new Object[]{obj, new Integer(attr)});
            }
            result = null;
            try {
                result = obj.getAttributeString(attr, 128).trim();
            }
            catch (Exception e) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(CLASSNAME, "inquireString(com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject,int)", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "inquireString(com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject,int)", (Object)result);
        }
        return result;
    }

    protected static int inquireInt(MQManagedObject obj, int attr) {
        int result;
        block4: {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "inquireInt(com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject,int)", new Object[]{obj, new Integer(attr)});
            }
            result = -1;
            try {
                int[] selectors = new int[]{attr};
                int[] intAttrs = new int[1];
                byte[] charAttrs = null;
                obj.inquire(selectors, intAttrs, charAttrs);
                result = intAttrs[0];
            }
            catch (Exception e) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(CLASSNAME, "inquireInt(com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject,int)", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "inquireInt(com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject,int)", new Integer(result));
        }
        return result;
    }

    protected static String padString(String str, int len) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "padString(String,int)", new Object[]{str, new Integer(len)});
        }
        if (len > 0) {
            int origLength;
            if (str == null) {
                str = "";
            }
            if ((origLength = str.length()) > len) {
                str = str.substring(0, len);
            } else if (origLength < len) {
                int diff = len - origLength;
                while (diff > 0) {
                    str = str + BLANK48.substring(0, diff < 48 ? diff : 48);
                    diff = len - str.length();
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "padString(String,int)", (Object)str);
        }
        return str;
    }

    protected static String getDate(GregorianCalendar dateTime) {
        String output;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getDate(GregorianCalendar)", new Object[]{dateTime});
        }
        if (dateTime != null) {
            int year = dateTime.get(1);
            int month = dateTime.get(2) + 1;
            int day = dateTime.get(5);
            output = "00000000" + (year * 10000 + month * 100 + day);
            output = output.substring(output.length() - 8);
        } else {
            output = "        ";
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "getDate(GregorianCalendar)", (Object)output);
        }
        return output;
    }

    protected static String getTime(GregorianCalendar dateTime) {
        String output;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getTime(GregorianCalendar)", new Object[]{dateTime});
        }
        if (dateTime != null) {
            int hour = dateTime.get(11);
            int min = dateTime.get(12);
            int sec = dateTime.get(13);
            int hund = dateTime.get(14) / 10;
            output = "00000000" + (hour * 1000000 + min * 10000 + sec * 100 + hund);
            output = output.substring(output.length() - 8);
        } else {
            output = "        ";
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "getTime(GregorianCalendar)", (Object)output);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isRRSTransactionInProgress() {
        boolean traceRet2;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "isRRSTransactionInProgress()");
        }
        if (wasNotDetected) {
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Previous call did not detect a WAS OS/390 TransactionManager", null);
            }
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "isRRSTransactionInProgress()", false, 1);
            }
            return false;
        }
        if (xactionManager == null) {
            Object object = xactionManagerLock;
            synchronized (object) {
                if (xactionManager == null) {
                    try {
                        CSSystem.dynamicLoadClass("javax.transaction.TransactionManager", Utils.class);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(CLASSNAME, "isRRSTransactionInProgress()", cnfe, 1);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Class javax.transaction.TransactionManager not found; WAS OS/390 not detected", null);
                        }
                        wasNotDetected = true;
                        if (Trace.isOn) {
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress()", false, 2);
                        }
                        return false;
                    }
                    String tmProperty = "com.ibm.ws390.jta.TransactionManager";
                    PropertyStore.register(tmProperty, "com.ibm.ws390.tx.TransactionManagerImpl");
                    String classname = PropertyStore.getStringProperty(tmProperty);
                    Method getTxMgrMth = null;
                    try {
                        Class txMgrClass = CSSystem.dynamicLoadClass(classname, Utils.class);
                        getTxMgrMth = txMgrClass.getMethod("getTransactionManager", null);
                    }
                    catch (NullPointerException npe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(CLASSNAME, "isRRSTransactionInProgress()", npe, 2);
                        }
                        wasNotDetected = true;
                        if (Trace.isOn) {
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress()", false, 3);
                        }
                        return false;
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(CLASSNAME, "isRRSTransactionInProgress()", cnfe, 3);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Class " + classname + " not found; WAS OS/390 not detected", null);
                        }
                        wasNotDetected = true;
                        if (Trace.isOn) {
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress()", false, 4);
                        }
                        return false;
                    }
                    catch (NoSuchMethodException nsme) {
                        if (Trace.isOn) {
                            Trace.catchBlock(CLASSNAME, "isRRSTransactionInProgress()", nsme, 4);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Method getTransactionManager() not found on tm implementation", null);
                        }
                        wasNotDetected = true;
                        if (Trace.isOn) {
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress()", false, 5);
                        }
                        return false;
                    }
                    try {
                        TransactionManager txMgr = (TransactionManager)getTxMgrMth.invoke(null, (Object[])null);
                        if (txMgr == null) {
                            if (Trace.isOn) {
                                Trace.traceData(CLASSNAME, "No TransactionManager present. Reverting to local transaction behaviour for this JVM", null);
                            }
                            wasNotDetected = true;
                            if (Trace.isOn) {
                                Trace.exit(CLASSNAME, "isRRSTransactionInProgress()", false, 6);
                            }
                            return false;
                        }
                        xactionManager = txMgr;
                    }
                    catch (InvocationTargetException ite) {
                        if (Trace.isOn) {
                            Trace.catchBlock(CLASSNAME, "isRRSTransactionInProgress()", ite, 5);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Error when finding TransactionManager", null);
                        }
                        wasNotDetected = true;
                        if (Trace.isOn) {
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress()", false, 7);
                        }
                        return false;
                    }
                    catch (IllegalAccessException iae) {
                        if (Trace.isOn) {
                            Trace.catchBlock(CLASSNAME, "isRRSTransactionInProgress()", iae, 6);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Error when finding TransactionManager", null);
                        }
                        wasNotDetected = true;
                        if (Trace.isOn) {
                            Trace.exit(CLASSNAME, "isRRSTransactionInProgress()", false, 8);
                        }
                        return false;
                    }
                }
            }
        }
        Transaction tran = null;
        try {
            TransactionManager txMgr = (TransactionManager)xactionManager;
            tran = txMgr.getTransaction();
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "isRRSTransactionInProgress()", e, 7);
            }
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Unexpected exception while getting Transaction", null);
            }
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "isRRSTransactionInProgress()", false, 9);
            }
            return false;
        }
        if (Trace.isOn) {
            if (tran == null) {
                Trace.traceData(CLASSNAME, "No global transaction present.", null);
            } else {
                Trace.traceData(CLASSNAME, "Global transaction active on this thread.", null);
            }
        }
        boolean bl = traceRet2 = tran != null;
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "isRRSTransactionInProgress()", traceRet2, 10);
        }
        return traceRet2;
    }

    static {
        if (Trace.isOn) {
            Trace.data(CLASSNAME, "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/Utils.java, jmscc.wmq.v6, k701, k701-112-140304  1.25.1.1 09/08/17 08:17:50");
        }
        xactionManager = null;
        wasNotDetected = false;
        xactionManagerLock = new Object();
    }
}

