/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQC;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.BrokerConnectionInfo;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH2;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl;
import javax.jms.JMSException;

public class SubscriptionHelper {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/SubscriptionHelper.java, jmscc.wmq.v6, k701, k701-112-140304 1.26.1.1 09/08/17 08:17:42";
    private static final int NON_DURABLE = 0;
    private static final int DURABLE = 1;
    private static final int REGISTER_SUBSCRIBER = 0;
    private static final int DEREGISTER_SUBSCRIBER = 1;
    private static final int REGISTER_SHAREDQ_SUBSCRIBER = 2;
    private static final int DEREGISTER_SHAREDQ_SUBSCRIBER = 3;
    private static final String CLASSNAME = "com.ibm.msg.client.wmq.v6.jms.internal.SubscriptionHelper";
    private static final int BROKER_TIMEOUT = 120000;

    static String validateQueueName(String queueName, int durability) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "validateQueueName(String,int)", new Object[]{queueName, new Integer(durability)});
        }
        String ret = null;
        if (queueName.trim().equals("")) {
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "queueName is blank; reverting to MQJMSv1 approach", null);
            }
            ret = durability == 0 ? "SYSTEM.JMS.ND.*" : "SYSTEM.JMS.D.*";
        } else {
            if (durability == 0 && !queueName.startsWith("SYSTEM.JMS.ND.") || durability == 1 && !queueName.startsWith("SYSTEM.JMS.D.")) {
                JMSException je = ConfigEnvironment.newException("MQJMS3021", queueName);
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "validateQueueName(String,int)", je);
                }
                throw je;
            }
            ret = queueName;
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "validateQueueName(String,int)", (Object)ret);
        }
        return ret;
    }

    static String createSubscriberQueue(MQQueueManager qm, String queuePrefix) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "createSubscriberQueue(MQQueueManager,String)", new Object[]{qm, queuePrefix});
        }
        try {
            String retName = null;
            if (!queuePrefix.endsWith("*")) {
                JMSException traceRet1 = ConfigEnvironment.newException("MQJMS3021", queuePrefix);
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "createSubscriberQueue(MQQueueManager,String)", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Creating a new PERMDYN queue", null);
                Trace.traceData(CLASSNAME, "Model:  SYSTEM.JMS.MODEL.QUEUE", null);
                Trace.traceData(CLASSNAME, "Prefix: " + queuePrefix, null);
            }
            MQQueue dynQueue = qm.accessQueue("SYSTEM.JMS.MODEL.QUEUE", 8225, null, queuePrefix, null);
            retName = dynQueue.name;
            dynQueue.close();
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "createSubscriberQueue(MQQueueManager,String)", (Object)retName);
            }
            return retName;
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "createSubscriberQueue(MQQueueManager,String)", mqe);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS2008", "Queue prefix: " + queuePrefix);
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(CLASSNAME, "createSubscriberQueue(MQQueueManager,String)", je, 2);
            }
            throw je;
        }
    }

    static MQQueue getSubscriberQueue(MQQueueManager qm, String queueName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getSubscriberQueue(MQQueueManager,String)", new Object[]{qm, queueName});
        }
        try {
            MQQueue retQueue = null;
            if (queueName.endsWith("*")) {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Using multi-queue approach", null);
                    Trace.traceData(CLASSNAME, "Model:  SYSTEM.JMS.MODEL.QUEUE", null);
                    Trace.traceData(CLASSNAME, "Prefix: " + queueName, null);
                }
                retQueue = qm.accessQueue("SYSTEM.JMS.MODEL.QUEUE", 8225, null, queueName, null);
            } else {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Using shared-queue approach", null);
                }
                retQueue = qm.accessQueue(queueName, 8225);
            }
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "QName:  " + retQueue.name, null);
            }
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "getSubscriberQueue(MQQueueManager,String)", retQueue);
            }
            return retQueue;
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "getSubscriberQueue(MQQueueManager,String)", mqe);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS2008", queueName);
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(CLASSNAME, "getSubscriberQueue(MQQueueManager,String)", je);
            }
            throw je;
        }
    }

    /*
     * Loose catch block
     */
    static void sendBrokerCommand(MQQueueManager qm, BrokerConnectionInfo brk, int brkVersion, int commandType, String topic, String mqBrkSubQName, byte[] correlId, boolean report, String userId) throws JMSException {
        block40: {
            MQMsg2 response;
            block41: {
                MQQueue replyQ;
                block38: {
                    MQMsg2 msg;
                    block37: {
                        if (Trace.isOn) {
                            Trace.entry(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)", new Object[]{qm, brk, new Integer(brkVersion), new Integer(commandType), topic, mqBrkSubQName, correlId, report, userId});
                        }
                        MQBrokerMessage bm = null;
                        switch (brkVersion) {
                            case -1: {
                                bm = new RFH1BrokerMessageImpl();
                                break;
                            }
                            case 0: {
                                bm = new RFH1BrokerMessageImpl();
                                break;
                            }
                            case 1: {
                                bm = new RFH2BrokerMessageImpl();
                                break;
                            }
                            default: {
                                JMSException je = ConfigEnvironment.newException("MQJMS1016");
                                if (Trace.isOn) {
                                    Trace.throwing(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)", je, 1);
                                }
                                throw je;
                            }
                        }
                        switch (commandType) {
                            case 0: {
                                bm.set("MQPSCommand", "RegSub");
                                break;
                            }
                            case 1: {
                                bm.set("MQPSCommand", "DeregSub");
                                break;
                            }
                            case 2: {
                                bm.set("MQPSCommand", "RegSub");
                                bm.setOption("MQPSRegOpts", 1);
                                break;
                            }
                            case 3: {
                                bm.set("MQPSCommand", "DeregSub");
                                bm.setOption("MQPSRegOpts", 1);
                                break;
                            }
                            default: {
                                JMSException je = ConfigEnvironment.newException("MQJMS1016");
                                if (Trace.isOn) {
                                    Trace.throwing(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)", je, 2);
                                }
                                throw je;
                            }
                        }
                        bm.set("MQPSTopic", topic);
                        bm.set("MQPSStreamName", brk.streamQ);
                        bm.set("MQPSQName", mqBrkSubQName);
                        msg = new MQMsg2();
                        try {
                            int openOptions = 8208;
                            MQPutMessageOptions pmo = new MQPutMessageOptions();
                            pmo.options = 8196;
                            if (userId != null) {
                                msg.setUserId(userId);
                                openOptions |= 0x400;
                                pmo.options |= 0x400;
                            }
                            msg.setFormat(bm.getHeaderFormat());
                            bm.writeToMessage(msg);
                            msg.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                            if (report) {
                                msg.setReport(3);
                            }
                            if (correlId != null) {
                                msg.setCorrelationId(correlId);
                            }
                            qm.putMsg2(brk.controlQ, brk.qmName, msg, pmo);
                        }
                        catch (MQException mqe) {
                            if (Trace.isOn) {
                                Trace.catchBlock(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)", mqe, 1);
                            }
                            if (mqe.completionCode == 1 && mqe.reasonCode == 2104) break block37;
                            JMSException je = ConfigEnvironment.newException("MQJMS2007");
                            je.setLinkedException((Exception)((Object)mqe));
                            if (Trace.isOn) {
                                Trace.throwing(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)", je, 3);
                            }
                            throw je;
                        }
                    }
                    if (!report) break block40;
                    response = new MQMsg2();
                    replyQ = null;
                    try {
                        replyQ = qm.accessQueue("SYSTEM.JMS.REPORT.QUEUE", 8193);
                        response.setCorrelationId(msg.getMessageId());
                        MQGetMessageOptions gmo = new MQGetMessageOptions();
                        gmo.options = 1;
                        gmo.waitInterval = 120000;
                        replyQ.getMsg2(response, gmo);
                        Object var16_20 = null;
                        if (!Trace.isOn) break block38;
                    }
                    catch (Throwable throwable) {
                        block39: {
                            Object var16_21 = null;
                            if (Trace.isOn) {
                                Trace.finallyBlock(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)");
                            }
                            if (replyQ != null) {
                                try {
                                    replyQ.close();
                                }
                                catch (MQException e) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)", e, 3);
                                    }
                                    if (!Trace.isOn) break block39;
                                    Trace.traceData(CLASSNAME, "sendBrokerCommand failed to close replyQ.", null);
                                }
                            }
                        }
                        throw throwable;
                    }
                    Trace.finallyBlock(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)");
                }
                if (replyQ != null) {
                    try {
                        replyQ.close();
                    }
                    catch (MQException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)", e, 3);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "sendBrokerCommand failed to close replyQ.", null);
                        }
                    }
                }
                break block41;
                {
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)", mqe, 2);
                        }
                        NoBrokerResponseException je = new NoBrokerResponseException("Unable to retreive report message", Integer.toString(mqe.reasonCode));
                        je.setLinkedException((Exception)((Object)mqe));
                        if (Trace.isOn) {
                            Trace.throwing(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)", (Throwable)((Object)je), 4);
                        }
                        throw je;
                    }
                }
            }
            SubscriptionHelper.checkResponse(response);
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean,String)");
        }
    }

    static void sendBrokerCommand(MQQueueManager qm, BrokerConnectionInfo brk, int brkVersion, int commandType, String topic, String mqBrkSubQName, byte[] correlId, boolean report) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean)", new Object[]{qm, brk, new Integer(brkVersion), new Integer(commandType), topic, mqBrkSubQName, correlId, report});
        }
        SubscriptionHelper.sendBrokerCommand(qm, brk, brkVersion, commandType, topic, mqBrkSubQName, correlId, report, null);
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "sendBrokerCommand(MQQueueManager,BrokerConnectionInfo,int,int,String,String,byte [ ],boolean)");
        }
    }

    static void deleteSubscriber(MQQueueSubscription subscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "deleteSubscriber(MQQueueSubscription)", new Object[]{subscription});
        }
        String fullName = subscription.isDurable() ? subscription.getClientId() + ":" + subscription.getSubName() : "";
        MQSubEntry subEntry = new MQSubEntry(fullName, subscription.getTopic(), subscription.getQueueName(), subscription.getSelector(), subscription.getNoLocal(), subscription.getStatusMgrId(), subscription.isSharedQueue());
        MQQueueManager qm = subscription.getMQSession().getQM();
        BrokerConnectionInfo brk = subscription.getMQSession().getBrk();
        MQQueue subQ = subscription.getSubscriberQueue();
        subEntry.setSubscriberId(subscription.getCorrelationId());
        SubscriptionHelper.deleteSubscriber(qm, brk, subEntry, subQ);
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "deleteSubscriber(MQQueueSubscription)");
        }
    }

    static void deleteSubscriber(MQQueueManager qm, BrokerConnectionInfo brk, MQSubEntry subEntry) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "deleteSubscriber(MQQueueManager,BrokerConnectionInfo,MQSubEntry)", new Object[]{qm, brk, subEntry});
        }
        MQQueue subQ = SubscriptionHelper.accessQueue(qm, subEntry);
        SubscriptionHelper.deleteSubscriber(qm, brk, subEntry, subQ);
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "deleteSubscriber(MQQueueManager,BrokerConnectionInfo,MQSubEntry)");
        }
    }

    static void deleteSubscriber(MQQueueManager qm, BrokerConnectionInfo brk, MQSubEntry subEntry, MQQueue queue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "deleteSubscriber(MQQueueManager,BrokerConnectionInfo,MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", new Object[]{qm, brk, subEntry, queue});
        }
        JMSException deregException = null;
        try {
            int deregType = subEntry.getSharedQueue() ? 3 : 1;
            int brokerVer = 0;
            String ctxtUserId = null;
            boolean retry = true;
            block10: while (retry) {
                try {
                    SubscriptionHelper.sendBrokerCommand(qm, brk, brokerVer, deregType, subEntry.getTopic(), subEntry.getQName(), subEntry.getSubscriberId(), true, ctxtUserId);
                    retry = false;
                }
                catch (BrokerCommandFailedException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(CLASSNAME, "deleteSubscriber(MQQueueManager,BrokerConnectionInfo,MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", (Throwable)((Object)e), 1);
                    }
                    int rc = e.getReason();
                    switch (rc) {
                        case 3073: {
                            if (brokerVer == 0 || brokerVer == -1) {
                                if (Trace.isOn) {
                                    Trace.traceData(CLASSNAME, "Failed using RFH1 retrying dereg with an RFH2 \n" + (Object)((Object)e), null);
                                }
                                brokerVer = 1;
                                retry = true;
                                continue block10;
                            }
                            deregException = e;
                            retry = false;
                            if (!Trace.isOn) continue block10;
                            Trace.traceData(CLASSNAME, "Failed to deregister.", null);
                            continue block10;
                        }
                        case 3078: {
                            if (ctxtUserId == null) {
                                if (Trace.isOn) {
                                    Trace.traceData(CLASSNAME, "retrying deregister with set_id_ctxt", null);
                                }
                                ctxtUserId = e.getUserId();
                                retry = true;
                                continue block10;
                            }
                            if (Trace.isOn) {
                                Trace.traceData(CLASSNAME, "Failed to deregister.", null);
                            }
                            deregException = e;
                            retry = false;
                            continue block10;
                        }
                        case 3072: {
                            if (!(brokerVer != 0 && brokerVer != -1 || subEntry.getTopic().indexOf(43) == -1 && subEntry.getTopic().indexOf(35) == -1 && subEntry.getTopic().indexOf(42) == -1 && subEntry.getTopic().indexOf(63) == -1)) {
                                if (Trace.isOn) {
                                    Trace.traceData(CLASSNAME, "Retrying with RFH2 deregsiter", null);
                                }
                                brokerVer = 1;
                                retry = true;
                                continue block10;
                            }
                            if (Trace.isOn) {
                                Trace.traceData(CLASSNAME, "Failed to deregister.", null);
                            }
                            deregException = e;
                            retry = false;
                            continue block10;
                        }
                    }
                    deregException = e;
                    retry = false;
                    if (!Trace.isOn) continue;
                    Trace.traceData(CLASSNAME, "Failed to deregister.", null);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(CLASSNAME, "deleteSubscriber(MQQueueManager,BrokerConnectionInfo,MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", je, 2);
                    }
                    deregException = je;
                    retry = false;
                    if (!Trace.isOn) continue;
                    Trace.traceData(CLASSNAME, "Failed to deregister.", null);
                }
            }
            SubscriptionHelper.deleteSubscriberMessages(subEntry, queue);
            if (deregException != null) {
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "deleteSubscriber(MQQueueManager,BrokerConnectionInfo,MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", deregException, 1);
                }
                throw deregException;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "deleteSubscriber(MQQueueManager,BrokerConnectionInfo,MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", je, 3);
            }
            if (deregException != null && je != deregException) {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "NOTE! Throwing pending deregException instead!", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "deleteSubscriber(MQQueueManager,BrokerConnectionInfo,MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", deregException, 2);
                }
                throw deregException;
            }
            if (Trace.isOn) {
                Trace.throwing(CLASSNAME, "deleteSubscriber(MQQueueManager,BrokerConnectionInfo,MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "deleteSubscriber(MQQueueManager,BrokerConnectionInfo,MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)");
        }
    }

    static void deleteSubscriberMessages(MQQueueManager qm, MQSubEntry subEntry) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "deleteSubscriberMessages(MQQueueManager,MQSubEntry)", new Object[]{qm, subEntry});
        }
        MQQueue subQ = null;
        String qName = subEntry.getQName();
        try {
            if (subEntry.getSharedQueue()) {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Opening queue AS_Q_DEF", null);
                }
                subQ = qm.accessQueue(qName, 8193);
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Opened OK", null);
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Opening queue EXCLUSIVE", null);
                }
                subQ = qm.accessQueue(qName, 8196);
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Opened OK", null);
                }
            }
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "deleteSubscriberMessages(MQQueueManager,MQSubEntry)", mqe);
            }
            switch (mqe.reasonCode) {
                case 2052: 
                case 2085: {
                    if (!Trace.isOn) break;
                    Trace.traceData(CLASSNAME, "Warning: SubQ '" + qName + "' missing. Continuing though.", null);
                    break;
                }
                default: {
                    JMSException je = ConfigEnvironment.newException("MQJMS3014", qName);
                    je.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.throwing(CLASSNAME, "deleteSubscriberMessages(MQQueueManager,MQSubEntry)", je);
                    }
                    throw je;
                }
            }
        }
        SubscriptionHelper.deleteSubscriberMessages(subEntry, subQ);
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "deleteSubscriberMessages(MQQueueManager,MQSubEntry)");
        }
    }

    static void deleteSubscriberMessages(MQQueueSubscription subscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "deleteSubscriberMessages(MQQueueSubscription)", new Object[]{subscription});
        }
        String fullName = subscription.isDurable() ? subscription.getClientId() + ":" + subscription.getSubName() : "";
        MQSubEntry subEntry = new MQSubEntry(fullName, subscription.getTopic(), subscription.getQueueName(), subscription.getSelector(), subscription.getNoLocal(), subscription.getStatusMgrId(), subscription.isSharedQueue());
        MQQueue subQ = subscription.getSubscriberQueue();
        subEntry.setSubscriberId(subscription.getCorrelationId());
        SubscriptionHelper.deleteSubscriberMessages(subEntry, subQ);
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "deleteSubscriberMessages(MQQueueSubscription)");
        }
    }

    static void deleteSubscriberMessages(MQSubEntry subEntry, MQQueue subQ) throws JMSException {
        block28: {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "deleteSubscriberMessages(MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", new Object[]{subEntry, subQ});
            }
            try {
                if (!subEntry.getSharedQueue() && subQ != null) {
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Closing & deleting non-shared queue", null);
                        }
                        subQ.closeOptions = 2;
                        subQ.close();
                        if (Trace.isOn) {
                            Trace.traceData(CLASSNAME, "Close & delete completed OK", null);
                        }
                        break block28;
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(CLASSNAME, "deleteSubscriberMessages(MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", mqe, 1);
                        }
                        if (subQ != null) {
                            subQ.closeOptions = 0;
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS3017", subEntry.getQName());
                        je.setLinkedException((Exception)((Object)mqe));
                        if (Trace.isOn) {
                            Trace.throwing(CLASSNAME, "deleteSubscriberMessages(MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", je, 1);
                        }
                        throw je;
                    }
                }
                if (!subEntry.getSharedQueue() || subQ == null) break block28;
                try {
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "deleteSubscriberMessages(e,q) attempting shared queue message cleanup.", null);
                    }
                    MQMessage msg = new MQMessage();
                    msg.correlationId = subEntry.getSubscriberId();
                    MQGetMessageOptions gmo = new MQGetMessageOptions();
                    gmo.options = 8256;
                    gmo.matchOptions = 2;
                    int cleanupCount = 0;
                    boolean cleanupComplete = false;
                    while (!cleanupComplete) {
                        try {
                            msg.messageId = MQC.MQMI_NONE;
                            subQ.get(msg, gmo, 1);
                            ++cleanupCount;
                        }
                        catch (MQException ex) {
                            if (Trace.isOn) {
                                Trace.catchBlock(CLASSNAME, "deleteSubscriberMessages(MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", ex, 2);
                            }
                            if (ex.reasonCode == 2079) {
                                ++cleanupCount;
                                continue;
                            }
                            cleanupComplete = true;
                            if (!Trace.isOn) continue;
                            if (ex.reasonCode == 2033) {
                                Trace.traceData(CLASSNAME, "deleteSubscriberMessages cleanup complete: 2033 reached. Removed " + cleanupCount + " messages.", null);
                                continue;
                            }
                            Trace.traceData(CLASSNAME, "deleteSubscriberMessages cleanup: Unexpected MQException thrown", null);
                        }
                    }
                    subQ.close();
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(CLASSNAME, "deleteSubscriberMessages(MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", mqe, 3);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS3017", subEntry.getQName());
                    je.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.throwing(CLASSNAME, "deleteSubscriberMessages(MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", je, 2);
                    }
                    throw je;
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(CLASSNAME, "deleteSubscriberMessages(MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", je, 4);
                }
                MQException e = (MQException)((Object)je.getLinkedException());
                switch (e.reasonCode) {
                    case 2052: 
                    case 2085: {
                        if (!Trace.isOn) break;
                        Trace.traceData(CLASSNAME, "deleteSubscriberMessages: Warning: subscription queue " + subEntry.getQName() + " couldn't be found", null);
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.throwing(CLASSNAME, "deleteSubscriberMessages(MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", je, 3);
                        }
                        throw je;
                    }
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "deleteSubscriberMessages(MQSubEntry,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)");
        }
    }

    static MQQueue createOrOpenQueue(MQQueueManager qm, String qName, boolean shared) throws MQException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "createOrOpenQueue(MQQueueManager,String,boolean)", new Object[]{qm, qName, shared});
        }
        MQQueue retQ = null;
        int openOptions = 8226;
        retQ = qName.endsWith("*") ? qm.accessQueue("SYSTEM.JMS.MODEL.QUEUE", openOptions, null, qName, null) : qm.accessQueue(qName, openOptions);
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "createOrOpenQueue(MQQueueManager,String,boolean)", retQ);
        }
        return retQ;
    }

    private static MQQueue accessQueue(MQQueueManager qm, MQSubEntry e) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "accessQueue(MQQueueManager,MQSubEntry)", new Object[]{qm, e});
        }
        MQQueue q = null;
        try {
            q = e.getSharedQueue() ? qm.accessQueue(e.getQName(), 8193) : qm.accessQueue(e.getQName(), 8196);
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "accessQueue(MQQueueManager,MQSubEntry)", mqe);
            }
            switch (mqe.reasonCode) {
                case 2052: 
                case 2085: {
                    if (!Trace.isOn) break;
                    Trace.traceData(CLASSNAME, "Warning: Subscription queue '" + e.getQName() + "' no longer exists.", null);
                    break;
                }
                default: {
                    JMSException je = ConfigEnvironment.newException("MQJMS3014");
                    je.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.throwing(CLASSNAME, "accessQueue(MQQueueManager,MQSubEntry)", je);
                    }
                    throw je;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "accessQueue(MQQueueManager,MQSubEntry)", q);
        }
        return q;
    }

    protected static void checkResponse(MQMsg2 response) throws BrokerCommandFailedException, JMSException {
        String format;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", new Object[]{response});
        }
        if (response == null) {
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "response is NULL", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1074");
            if (Trace.isOn) {
                Trace.throwing(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 1);
            }
            throw je;
        }
        try {
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Getting format", null);
            }
            format = response.getFormat();
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Got format: " + format, null);
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", e, 1);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1087");
            if (Trace.isOn) {
                Trace.throwing(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 2);
            }
            throw je;
        }
        if (format.compareTo("MQHRF   ") == 0) {
            String reasonText;
            int reason;
            int compCode;
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "RFH1 header found", null);
            }
            RFH rfh = null;
            try {
                rfh = new RFH(response);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 2);
                }
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 3);
                }
                throw je;
            }
            try {
                compCode = Integer.parseInt(rfh.getValue("MQPSCompCode"));
                reason = Integer.parseInt(rfh.getValue("MQPSReason"));
                reasonText = rfh.getValue("MQPSReasonText");
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "MQPSCompCode returned " + compCode, null);
                    Trace.traceData(CLASSNAME, "MQPSReason returned " + reason, null);
                    if (reasonText != null) {
                        Trace.traceData(CLASSNAME, "MQPSReasonText returned " + reasonText, null);
                    }
                }
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", e, 3);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1087");
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 4);
                }
                throw je;
            }
            if (compCode == 2) {
                BrokerCommandFailedException bcfe = new BrokerCommandFailedException("Broker command failed: " + reasonText + " Reason code " + reason, Integer.toString(reason));
                bcfe.setReason(reason);
                switch (reason) {
                    case 3078: {
                        String userId = rfh.getValue("MQPSUserId");
                        bcfe.setUserId(userId);
                    }
                }
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", (Throwable)((Object)bcfe), 5);
                }
                throw bcfe;
            }
            if (compCode == 1 && reason == 3081) {
                BrokerCommandFailedException bcfe = new BrokerCommandFailedException("Broker command failed: " + reasonText + " Reason code " + reason, Integer.toString(reason));
                bcfe.setReason(reason);
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", (Throwable)((Object)bcfe), 6);
                }
                throw bcfe;
            }
        } else {
            String Completion;
            String nameValueString;
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "RFH2 header found", null);
            }
            try {
                RFH2 responseMsg = new RFH2(response);
                nameValueString = responseMsg.getNameValueString();
                int index1 = nameValueString.indexOf("<pscr>");
                int index2 = nameValueString.indexOf("</pscr>");
                if (index1 > 0 && index2 > 0) {
                    nameValueString = nameValueString.substring(index1, index2 + 7);
                }
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Response NameValue CCSID is " + responseMsg.getCodedCharSetId(), null);
                    Trace.traceData(CLASSNAME, "Response NameValue string is " + nameValueString, null);
                }
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", e, 4);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1087");
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 7);
                }
                throw je;
            }
            if (!nameValueString.startsWith("<pscr><Completion>")) {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "nameValueString does not start with <pscr><Completion>", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1087");
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 8);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "nameValueString DID start with <pscr><Completion>", null);
                Trace.traceData(CLASSNAME, "Extract the completion value", null);
            }
            if ((Completion = nameValueString.substring(nameValueString.indexOf("<Completion>") + 12, nameValueString.indexOf("</Completion>"))).compareTo("ok") != 0) {
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Extract the reason value", null);
                }
                String ReasonString = nameValueString.substring(nameValueString.indexOf("<Reason>") + 8, nameValueString.indexOf("</Reason>"));
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Extract numeric reason code", null);
                }
                int reason = Integer.valueOf(ReasonString);
                if (Trace.isOn) {
                    Trace.traceData(CLASSNAME, "Numeric reason code expected", null);
                }
                BrokerCommandFailedException bcfe = new BrokerCommandFailedException("Broker command failed: Reason code " + reason, Integer.toString(reason));
                bcfe.setReason(reason);
                if (Trace.isOn) {
                    Trace.throwing(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", (Throwable)((Object)bcfe), 9);
                }
                throw bcfe;
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "checkResponse(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)");
        }
    }

    private static void MQPUT1(MQQueueManager qm, String brokerQMName, String qName, MQJMSMessage msg, boolean setIdentityContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "MQPUT1(MQQueueManager,String,String,MQJMSMessage,boolean)", new Object[]{qm, brokerQMName, qName, msg, setIdentityContext});
        }
        if (Trace.isOn) {
            Trace.traceData(CLASSNAME, "About to perform an MQPUT1. Params follow:", null);
            Trace.traceData(CLASSNAME, "   QueueManager:       '" + qm.name + "'", null);
            Trace.traceData(CLASSNAME, "   BrokerQueueManager: '" + brokerQMName + "'", null);
            Trace.traceData(CLASSNAME, "   Queue:              '" + qName + "'", null);
            Trace.traceData(CLASSNAME, "   ProviderMessage:            '" + ((Object)((Object)msg)).toString() + "'", null);
        }
        MQQueue q = null;
        try {
            int openOptions = 8208;
            if (setIdentityContext) {
                openOptions |= 0x400;
            }
            q = qm.accessQueue(qName, openOptions, brokerQMName, null, null);
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "MQPUT1(MQQueueManager,String,String,MQJMSMessage,boolean)", mqe, 1);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS2008", qName);
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Failed to access broker queue.", null);
            }
            if (Trace.isOn) {
                Trace.throwing(CLASSNAME, "MQPUT1(MQQueueManager,String,String,MQJMSMessage,boolean)", je, 1);
            }
            throw je;
        }
        try {
            MQPutMessageOptions pmo = new MQPutMessageOptions();
            pmo.options |= 0x2000;
            if (setIdentityContext) {
                pmo.options |= 0x400;
            }
            q.putMsg2(msg, pmo);
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "MQPUT1(MQQueueManager,String,String,MQJMSMessage,boolean)", mqe, 2);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3011");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Failed to MQPUT broker command.", null);
            }
            if (Trace.isOn) {
                Trace.throwing(CLASSNAME, "MQPUT1(MQQueueManager,String,String,MQJMSMessage,boolean)", je, 2);
            }
            throw je;
        }
        try {
            q.close();
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "MQPUT1(MQQueueManager,String,String,MQJMSMessage,boolean)", mqe, 3);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS2000");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Failed to close broker command.", null);
            }
            if (Trace.isOn) {
                Trace.throwing(CLASSNAME, "MQPUT1(MQQueueManager,String,String,MQJMSMessage,boolean)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "MQPUT1(MQQueueManager,String,String,MQJMSMessage,boolean)");
        }
    }

    protected static void MQPUT1(MQQueueManager qm, String brokerQMName, String qName, MQJMSMessage msg) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "MQPUT1(MQQueueManager,String,String,MQJMSMessage)", new Object[]{qm, brokerQMName, qName, msg});
        }
        SubscriptionHelper.MQPUT1(qm, brokerQMName, qName, msg, false);
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "MQPUT1(MQQueueManager,String,String,MQJMSMessage)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data(CLASSNAME, "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/SubscriptionHelper.java, jmscc.wmq.v6, k701, k701-112-140304  1.26.1.1 09/08/17 08:17:42");
        }
    }
}

