/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.jms.NoMsgListenerException;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.JMSException;

public class SessionAsyncHelper
implements Runnable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String PROBE_01 = "01";
    private static final String PROBE_02 = "02";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/SessionAsyncHelper.java, jmscc.wmq.v6, k701, k701-112-140304 1.28.1.3 09/12/01 16:36:31";
    private static int tId;
    private static final Object tidLock;
    private Thread asyncThread = null;
    private MQConnection connection;
    private boolean finished = false;
    private boolean going = true;
    private int msgBatchSize;
    private int pollingInterval;
    private PausedStateLock pausedStateLock = new PausedStateLock();
    private boolean paused = false;
    private Vector receivers = new Vector();
    private MQSession session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SessionAsyncHelper(MQConnection con, MQSession ses) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "<init>(MQConnection,MQSession)", new Object[]{con, ses});
        }
        this.connection = con;
        this.session = ses;
        this.msgBatchSize = this.connection.getMsgBatchSize();
        this.pollingInterval = this.connection.getPollingInterval();
        Object object = tidLock;
        synchronized (object) {
            String tName = "asyncDelivery" + tId;
            ++tId;
            this.asyncThread = this.createThread(this, tName);
        }
        this.asyncThread.start();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "<init>(MQConnection,MQSession)");
        }
    }

    private Thread createThread(final Runnable r, final String name) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "createThread(final Runnable,final String)", new Object[]{r, name});
        }
        Thread t = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()");
                }
                Thread t2 = new Thread(r, name);
                t2.setDaemon(true);
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.null", "run()", t2);
                }
                return t2;
            }
        });
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "createThread(final Runnable,final String)", t);
        }
        return t;
    }

    void addReceiver(MQMessageConsumer rcvr) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "addReceiver(MQMessageConsumer)", new Object[]{rcvr});
        }
        if (!this.receivers.contains(rcvr)) {
            this.receivers.addElement(rcvr);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "addReceiver(MQMessageConsumer)");
        }
    }

    boolean callingFromOnMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "callingFromOnMessage()");
        }
        Thread caller = Thread.currentThread();
        boolean result = caller.equals(this.asyncThread);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "callingFromOnMessage()", result);
        }
        return result;
    }

    boolean hasReceivers() {
        boolean traceRet1;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "hasReceivers()");
        }
        boolean bl = traceRet1 = this.receivers.size() > 0;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "hasReceivers()", traceRet1);
        }
        return traceRet1;
    }

    void removeReceiver(MQMessageConsumer rcvr) {
        boolean wasFound;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "removeReceiver(MQMessageConsumer)", new Object[]{rcvr});
        }
        if (!(wasFound = this.receivers.removeElement(rcvr)) && Trace.isOn) {
            Trace.traceData(this, "removeReceiver() didn't find the receiver on the list!", null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "removeReceiver(MQMessageConsumer)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()");
        }
        MQMessageConsumer rcvr = null;
        while (this.going) {
            MQMessageConsumer blockOnConsumer;
            block53: {
                Vector recvClone = (Vector)this.receivers.clone();
                Enumeration en = recvClone.elements();
                boolean nothingReceived = true;
                blockOnConsumer = null;
                if (recvClone.size() > 1) {
                    while (this.going) {
                        try {
                            boolean msgDelivered;
                            rcvr = (MQMessageConsumer)en.nextElement();
                            for (int i = 0; i < this.msgBatchSize && this.going && (msgDelivered = rcvr.receiveAsync(0L)); ++i) {
                                nothingReceived = false;
                                blockOnConsumer = rcvr;
                            }
                        }
                        catch (NoMsgListenerException e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", (Throwable)((Object)e), 1);
                            }
                            this.receivers.removeElement(rcvr);
                        }
                        catch (JMSException e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", e, 2);
                            }
                            this.receivers.removeElement(rcvr);
                            this.connection.deliverException(e);
                            if (Trace.isOn) {
                                Trace.traceData(this, "Leaving the Recvr polling loop, since connection is broken = ", (Object)e);
                            }
                            PausedStateLock msgDelivered = this.pausedStateLock;
                            synchronized (msgDelivered) {
                                this.paused = true;
                                this.pausedStateLock.notifyAll();
                                break;
                            }
                        }
                        catch (NoSuchElementException e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", e, 3);
                            }
                            if (!Trace.isOn) break;
                            Trace.traceData(this, "leaving the recvr polling loop, nothingReceived = " + nothingReceived, null);
                            break;
                        }
                        catch (Throwable e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", e, 4);
                            }
                            HashMap<String, Object> ffstData = new HashMap<String, Object>();
                            ffstData.put("Exception", e);
                            ffstData.put("Message", "MQJMS1016");
                            Trace.ffst(this, "run()", PROBE_01, ffstData, null);
                        }
                    }
                }
                if (!this.going || !nothingReceived) continue;
                if (blockOnConsumer == null) {
                    try {
                        blockOnConsumer = (MQMessageConsumer)this.receivers.firstElement();
                    }
                    catch (NoSuchElementException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", e, 5);
                        }
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", e, 6);
                        }
                        if (!Trace.isOn) break block53;
                        Trace.traceData(this, "failed to find a consumer for blocking read.", null);
                    }
                }
            }
            if (!this.session.isStarted()) {
                PausedStateLock e = this.pausedStateLock;
                synchronized (e) {
                    this.paused = true;
                    this.pausedStateLock.notifyAll();
                }
                try {
                    this.session.waitForStart(this.pollingInterval);
                    if (!this.session.isStarted()) continue;
                    e = this.pausedStateLock;
                    synchronized (e) {
                        this.paused = false;
                        continue;
                    }
                }
                catch (SessionClosedException e2) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", (Throwable)((Object)e2), 7);
                    }
                    this.going = false;
                    continue;
                }
                catch (JMSException e3) {
                    if (!Trace.isOn) continue;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", e3, 8);
                    continue;
                }
            }
            PausedStateLock e3 = this.pausedStateLock;
            synchronized (e3) {
                this.paused = false;
            }
            if (blockOnConsumer == null || this.session.getPlayNice()) {
                try {
                    Thread.sleep(this.pollingInterval);
                }
                catch (InterruptedException e4) {
                    if (!Trace.isOn) continue;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", e4, 9);
                }
                continue;
            }
            try {
                blockOnConsumer.receiveAsync(this.pollingInterval);
            }
            catch (NoMsgListenerException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", (Throwable)((Object)e), 10);
                }
                this.receivers.removeElement(blockOnConsumer);
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", e, 11);
                }
                this.receivers.removeElement(blockOnConsumer);
                this.connection.deliverException(e);
                if (Trace.isOn) {
                    Trace.traceData(this, "Breaking from the Receiver polling loop, since connection is broken = ", (Object)e);
                }
                PausedStateLock ffstData = this.pausedStateLock;
                synchronized (ffstData) {
                    this.paused = true;
                    this.pausedStateLock.notifyAll();
                    break;
                }
            }
            catch (Throwable e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()", e, 12);
                }
                HashMap<String, Object> ffstData = new HashMap<String, Object>();
                ffstData.put("Exception", e);
                ffstData.put("Message", "MQJMS1016");
                Trace.ffst(this, "run()", PROBE_02, ffstData, null);
            }
        }
        this.setFinished();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "run()");
        }
    }

    private synchronized void setFinished() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "setFinished()");
        }
        this.finished = true;
        this.notifyAll();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "setFinished()");
        }
    }

    synchronized void shutdown() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "shutdown()");
        }
        this.going = false;
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (!Trace.isOn) continue;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "shutdown()", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "shutdown()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPaused() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "waitForPaused()");
        }
        PausedStateLock pausedStateLock = this.pausedStateLock;
        synchronized (pausedStateLock) {
            block8: {
                try {
                    while (!this.paused) {
                        this.pausedStateLock.wait();
                    }
                }
                catch (InterruptedException e) {
                    if (!Trace.isOn) break block8;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "waitForPaused()", e);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "waitForPaused()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/SessionAsyncHelper.java, jmscc.wmq.v6, k701, k701-112-140304  1.28.1.3 09/12/01 16:36:31");
        }
        tId = 0;
        tidLock = new Object();
    }

    static class PausedStateLock {
        PausedStateLock() {
        }
    }
}

