/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.disthub2.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthub2.impl.matching.FormattedMessage;
import com.ibm.disthub2.impl.matching.NoSuchFieldNameException;
import com.ibm.disthub2.impl.matching.selector.BooleanValue;
import com.ibm.disthub2.impl.matching.selector.NumericValue;
import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import javax.jms.JMSException;

class SelectorDataAccessor
implements FormattedMessage {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/SelectorDataAccessor.java, jmscc.wmq.v6, k701, k701-112-140304 1.23.1.1 09/08/17 08:17:14";
    private ProviderMessage omsgJMS;
    private MQMsg2 omsgMQSeries;

    public SelectorDataAccessor(ProviderMessage msgJMS, MQMsg2 msgMQSeries) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "<init>(ProviderMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", new Object[]{msgJMS, msgMQSeries});
        }
        this.omsgJMS = msgJMS;
        this.omsgMQSeries = msgMQSeries;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "<init>(ProviderMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)");
        }
    }

    public boolean isValidHeaderValue(String fieldName) throws BadMessageFormatMatchingException, NoSuchFieldNameException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "isValidHeaderValue(String)", new Object[]{fieldName});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "isValidHeaderValue(String)", false);
        }
        return false;
    }

    public Object getHeaderValue(String fieldName) throws BadMessageFormatMatchingException, NoSuchFieldNameException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getHeaderValue(String)", new Object[]{fieldName});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getHeaderValue(String)", null);
        }
        return null;
    }

    public Object getHeaderStringValue(String fieldName) throws BadMessageFormatMatchingException, NoSuchFieldNameException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getHeaderStringValue(String)", new Object[]{fieldName});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getHeaderStringValue(String)", null);
        }
        return null;
    }

    public Object getHeaderNumberValue(String fieldName) throws BadMessageFormatMatchingException, NoSuchFieldNameException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getHeaderNumberValue(String)", new Object[]{fieldName});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getHeaderNumberValue(String)", null);
        }
        return null;
    }

    public String getPropertiesTopic() throws BadMessageFormatMatchingException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getPropertiesTopic()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getPropertiesTopic()", null);
        }
        return null;
    }

    public Object getFieldValue(String fieldName) throws BadMessageFormatMatchingException, NoSuchFieldNameException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getFieldValue(String)", new Object[]{fieldName});
        }
        try {
            try {
                Object b;
                Object o = null;
                if (fieldName.indexOf("JMS.") == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "fieldName = '" + fieldName + "'", null);
                    }
                    fieldName = fieldName.substring(4);
                    if (Trace.isOn) {
                        Trace.traceData(this, "fieldName = '" + fieldName + "'", null);
                    }
                }
                if (fieldName.indexOf("JMSX") == 0) {
                    if (fieldName.equals("JMSXApplID")) {
                        if (this.omsgMQSeries != null) {
                            o = this.omsgMQSeries.getPutApplicationName();
                        }
                    } else if (fieldName.equals("JMSXDeliveryCount")) {
                        if (this.omsgMQSeries != null) {
                            o = new Integer(this.omsgMQSeries.getBackoutCount() + 1);
                        }
                    } else if (fieldName.equals("JMSXUserID") && this.omsgMQSeries != null) {
                        o = this.omsgMQSeries.getUserId();
                    }
                    if (o == null) {
                        o = this.omsgJMS.getObjectProperty(fieldName);
                    }
                } else if (fieldName.indexOf("JMS_") == 0) {
                    if (this.omsgMQSeries != null) {
                        if (fieldName.equals("JMS_IBM_Feedback")) {
                            o = new Integer(this.omsgMQSeries.getFeedback());
                        } else if (fieldName.equals("JMS_IBM_Format")) {
                            o = this.omsgJMS.getObjectProperty("JMS_IBM_Format");
                        } else if (fieldName.equals("JMS_IBM_MsgType")) {
                            o = new Integer(this.omsgMQSeries.getMessageType());
                        } else if (fieldName.equals("JMS_IBM_PutApplType")) {
                            o = new Integer(this.omsgMQSeries.getPutApplicationType());
                        } else if (fieldName.equals("JMS_IBM_PutDate")) {
                            String s = "";
                            b = this.omsgMQSeries.getPutDateAsBytes();
                            for (int i = 0; i < ((BooleanValue)b).length; ++i) {
                                s = s + (char)b[i];
                            }
                            o = s;
                        } else if (fieldName.equals("JMS_IBM_PutTime")) {
                            o = new String(this.omsgMQSeries.getPutTimeAsBytes());
                        } else if (fieldName.equals("JMS_IBM_Report_COA")) {
                            o = new Integer(this.omsgMQSeries.getReport() & 0x700);
                        } else if (fieldName.equals("JMS_IBM_Report_COD")) {
                            o = new Integer(this.omsgMQSeries.getReport() & 0x3800);
                        } else if (fieldName.equals("JMS_IBM_Report_Pass_Correl_ID")) {
                            o = new Integer(this.omsgMQSeries.getReport() & 0x40);
                        } else if (fieldName.equals("JMS_IBM_Report_Exception")) {
                            o = new Integer(this.omsgMQSeries.getReport() & 0x7000000);
                        } else if (fieldName.equals("JMS_IBM_Report_Expiration")) {
                            o = new Integer(this.omsgMQSeries.getReport() & 0xE00000);
                        } else if (fieldName.equals("JMS_IBM_Report_Pass_Msg_ID")) {
                            o = new Integer(this.omsgMQSeries.getReport() & 0x80);
                        } else if (fieldName.equals("JMS_IBM_Report_NAN")) {
                            o = new Integer(this.omsgMQSeries.getReport() & 2);
                        } else if (fieldName.equals("JMS_IBM_Report_PAN")) {
                            o = new Integer(this.omsgMQSeries.getReport() & 1);
                        } else if (fieldName.equals("JMS_IBM_Report_Discard_Msg")) {
                            o = new Integer(this.omsgMQSeries.getReport() & 0x8000000);
                        } else if (fieldName.equals("JMS_IBM_Last_Msg_In_Group")) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "@PN - Last ProviderMessage in group returning " + ((this.omsgMQSeries.getMessageFlags() & 0x10) > 0), null);
                            }
                            o = new Boolean((this.omsgMQSeries.getMessageFlags() & 0x10) > 0);
                        } else if (fieldName.equals("JMS_IBM_ArmCorrelator")) {
                            o = this.omsgJMS.getObjectProperty("JMS_IBM_ArmCorrelator");
                        } else if (fieldName.equals("JMS_IBM_RMCorrelator")) {
                            o = this.omsgJMS.getObjectProperty("JMS_IBM_RMCorrelator");
                        }
                    } else {
                        o = null;
                    }
                } else if (fieldName.indexOf("JMS") == 0) {
                    WMQDestinationURIParser destParser;
                    String destination;
                    if (fieldName.equals("JMSCorrelationID")) {
                        o = this.omsgJMS.getJMSCorrelationID();
                    } else if (fieldName.equals("JMSDeliveryMode")) {
                        switch (this.omsgJMS.getJMSDeliveryMode()) {
                            case 2: {
                                o = new String("PERSISTENT");
                                break;
                            }
                            case 1: {
                                o = new String("NON_PERSISTENT");
                                break;
                            }
                            default: {
                                o = null;
                                break;
                            }
                        }
                    } else if (fieldName.equals("JMSDestination")) {
                        destination = this.omsgJMS.getJMSDestinationAsString();
                        destParser = new WMQDestinationURIParser(destination);
                        o = destParser.getDestinationName();
                    } else if (fieldName.equals("JMSExpiration")) {
                        o = this.omsgJMS.getJMSExpiration();
                    } else if (fieldName.equals("JMSMessageID")) {
                        o = this.omsgJMS.getJMSMessageID();
                    } else if (fieldName.equals("JMSPriority")) {
                        o = this.omsgJMS.getJMSPriority();
                    } else if (fieldName.equals("JMSRedelivered")) {
                        o = this.omsgJMS.getJMSRedelivered();
                    } else if (fieldName.equals("JMSReplyTo")) {
                        destination = this.omsgJMS.getJMSReplyToAsString();
                        destParser = new WMQDestinationURIParser(destination);
                        o = destParser.getDestinationName();
                    } else if (fieldName.equals("JMSTimestamp")) {
                        o = this.omsgJMS.getJMSTimestamp();
                    } else if (fieldName.equals("JMSType")) {
                        o = this.omsgJMS.getJMSType();
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Checking for user property " + fieldName, null);
                    }
                    o = this.omsgJMS.getObjectProperty(fieldName);
                }
                if (o == null) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Property " + fieldName + " has a null value", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getFieldValue(String)", null, 1);
                    }
                    return null;
                }
                if (o instanceof String) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Property " + fieldName + " has string value " + o, null);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getFieldValue(String)", o, 2);
                    }
                    return o;
                }
                if (o instanceof Boolean) {
                    boolean x = (Boolean)o;
                    if (Trace.isOn) {
                        Trace.traceData(this, "Property " + fieldName + " has boolean value " + o, null);
                    }
                    b = BooleanValue.valueOf((boolean)x);
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getFieldValue(String)", b, 3);
                    }
                    return b;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Property " + fieldName + " has numeric value " + o, null);
                }
                NumericValue n = new NumericValue((Number)o);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getFieldValue(String)", n, 4);
                }
                return n;
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getFieldValue(String)", mqe, 1);
                }
                NoSuchFieldNameException e = new NoSuchFieldNameException("JMSException: " + fieldName + " " + mqe.toString());
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getFieldValue(String)", e, 1);
                }
                throw e;
            }
            catch (JMSException eJMS) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getFieldValue(String)", eJMS, 2);
                }
                NoSuchFieldNameException e = new NoSuchFieldNameException("JMSException: " + fieldName + " " + eJMS.toString());
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getFieldValue(String)", e, 2);
                }
                throw e;
            }
        }
        catch (NoSuchFieldNameException fne) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getFieldValue(String)", fne, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "getFieldValue(String)", fne, 3);
            }
            throw fne;
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/SelectorDataAccessor.java, jmscc.wmq.v6, k701, k701-112-140304  1.23.1.1 09/08/17 08:17:14");
        }
    }
}

