/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.Vector;

public class RFH2Folder {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/RFH2Folder.java, jmscc.wmq.v6, k701, k701-112-140304 1.17.1.1 09/08/17 08:16:52";
    public static final int DT_STRING = 0;
    public static final int DT_BOOLEAN = 1;
    public static final int DT_BINHEX = 2;
    public static final int DT_I1 = 3;
    public static final int DT_I2 = 4;
    public static final int DT_I4 = 5;
    public static final int DT_I8 = 6;
    public static final int DT_INT = 7;
    public static final int DT_R4 = 8;
    public static final int DT_R8 = 9;
    private static final String[] DT_LOOKUP_TABLE;
    private static final int DT_NONE = -1;
    private String name = null;
    private int type = -1;
    private Vector children = null;
    private String content = null;
    private boolean ownRolled = false;

    public RFH2Folder() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "<init>()");
        }
        this.ownRolled = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "<init>()");
        }
    }

    public RFH2Folder(String name) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "<init>(String)", new Object[]{name});
        }
        this.name = name;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "<init>(String)");
        }
    }

    public void setContent(String content, int type) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "setContent(String,int)", new Object[]{content, new Integer(type)});
        }
        if (this.children != null) {
            Exception traceRet1 = new Exception("Cannot set content for a parental folder");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "setContent(String,int)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.ownRolled && type != -1) {
            Exception traceRet2 = new Exception("Cannot set typed content for ownRolled folder");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "setContent(String,int)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (this.content != null) {
            Exception traceRet3 = new Exception("Content already set to '" + content + "'");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "setContent(String,int)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.content = content;
        this.type = type;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "setContent(String,int)");
        }
    }

    public void setContent(String content) throws Exception {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "setContent(String)", "setter", content);
        }
        this.setContent(content, -1);
    }

    public void addFolder(RFH2Folder child) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "addFolder(RFH2Folder)", new Object[]{child});
        }
        if (this.ownRolled) {
            Exception traceRet1 = new Exception("Cannot add a folder to an ownRolled folder");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "addFolder(RFH2Folder)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.content != null) {
            Exception traceRet2 = new Exception("Cannot add a child folder to an infertile folder");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "addFolder(RFH2Folder)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(child);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "addFolder(RFH2Folder)");
        }
    }

    public String render() {
        int i;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "render()");
        }
        StringBuffer buf = new StringBuffer();
        if (this.ownRolled) {
            buf.append(this.content);
        } else {
            buf.append("<" + this.name);
            if (this.type != -1) {
                buf.append(" dt=\"" + DT_LOOKUP_TABLE[this.type] + "\"");
            }
            buf.append(">");
            if (this.children != null) {
                int numKids = this.children.size();
                for (i = 0; i < numKids; ++i) {
                    RFH2Folder child = (RFH2Folder)this.children.elementAt(i);
                    buf.append(child.renderNoPad());
                }
            } else {
                buf.append(this.content == null ? "" : this.content);
            }
            buf.append("</" + this.name + ">");
        }
        int mod = buf.length() % 4;
        if (mod != 0) {
            for (i = mod; i < 4; ++i) {
                buf.append(" ");
            }
        }
        String traceRet1 = buf.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "render()", traceRet1);
        }
        return traceRet1;
    }

    private String renderNoPad() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "renderNoPad()");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<" + this.name);
        if (this.type != -1) {
            buf.append(" dt=\"" + DT_LOOKUP_TABLE[this.type] + "\"");
        }
        buf.append(">");
        if (this.children != null) {
            int numKids = this.children.size();
            for (int i = 0; i < numKids; ++i) {
                RFH2Folder child = (RFH2Folder)this.children.elementAt(i);
                buf.append(child.renderNoPad());
            }
        } else {
            buf.append(this.content == null ? "" : this.content);
        }
        buf.append("</" + this.name + ">");
        String traceRet1 = buf.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "renderNoPad()", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/RFH2Folder.java, jmscc.wmq.v6, k701, k701-112-140304  1.17.1.1 09/08/17 08:16:52");
        }
        DT_LOOKUP_TABLE = new String[]{"string", "boolean", "bin.hex", "i1", "i2", "i4", "i8", "int", "r4", "r8"};
    }
}

