/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH2;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.JMSException;

class RFH2BrokerMessageImpl
extends MQBrokerMessage {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/RFH2BrokerMessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.19.1.2 11/11/23 17:29:15";
    private static final String clsName = "RFH2BrokerMessageImpl";
    private RFH2 rfh2 = null;
    private Vector auxilliaryNVPairs = new Vector();

    public RFH2BrokerMessageImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "<init>()");
        }
    }

    public void clear() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "clear()");
        }
        this.rfh2 = null;
        this.auxilliaryNVPairs = new Vector();
        super.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "clear()");
        }
    }

    public void initializeFromMessage(MQMsg2 message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "initializeFromMessage(MQMsg2)", new Object[]{message});
        }
        try {
            this.clear();
            this.rfh2 = new RFH2(message);
            String pscrFolder = null;
            this.setEncoding(this.rfh2.getEncoding());
            this.setCodedCharSetId(this.rfh2.getCodedCharSetId());
            this.setFormat(this.rfh2.getFormat());
            String nameValueString = this.rfh2.getNameValueString();
            if (Trace.isOn) {
                Trace.traceData(this, "nameValueString is " + nameValueString, null);
            }
            int index1 = nameValueString.indexOf("<pscr>");
            int index2 = nameValueString.indexOf("</pscr>");
            if (Trace.isOn) {
                Trace.traceData(this, "searched for pscr folder. Got index " + index1 + " and " + index2, null);
            }
            if (index1 > -1 && index2 > 0) {
                pscrFolder = nameValueString.substring(index1, index2 + 7);
                if (Trace.isOn) {
                    Trace.traceData(this, "PscrFolder is " + pscrFolder, null);
                }
                if (pscrFolder != null) {
                    this.parsePubSubFolder(pscrFolder);
                }
            }
            index1 = nameValueString.indexOf("<psc>");
            index2 = nameValueString.indexOf("</psc>");
            if (Trace.isOn) {
                Trace.traceData(this, "searched for psc folder. Got index " + index1 + " and " + index2, null);
            }
            if (index1 > -1 && index2 > 0) {
                String pscFolder = nameValueString.substring(index1, index2 + 6);
                if (Trace.isOn) {
                    Trace.traceData(this, "Parsing psc folder: \"" + pscFolder + "\"", null);
                }
                if (pscFolder != null) {
                    this.parsePubSubFolder(pscFolder);
                }
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "initializeFromMessage(MQMsg2)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "initializeFromMessage(MQMsg2)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "initializeFromMessage(MQMsg2)");
        }
    }

    public void writeToMessage(MQMsg2 message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "writeToMessage(MQMsg2)", new Object[]{message});
        }
        try {
            String field;
            if (this.rfh2 == null) {
                this.rfh2 = new RFH2();
            }
            this.rfh2.setEncoding(this.getEncoding());
            this.rfh2.setCodedCharSetId(this.getCodedCharSetId());
            this.rfh2.setFormat(this.getFormat());
            StringBuffer nvpBuffer = new StringBuffer();
            nvpBuffer.append("<psc>");
            String value = this.get("MQPSCommand");
            if (value != null) {
                nvpBuffer.append("<Command>");
                this.appendToken(nvpBuffer, value);
                nvpBuffer.append("</Command>");
            }
            Enumeration enumVar = this.getFields();
            while (enumVar.hasMoreElements()) {
                field = (String)enumVar.nextElement();
                if (field.equals("MQPSCommand") || field.equals("MQPSStreamName")) continue;
                value = this.get(field);
                if ((field = field.equals("MQPSRegOpts") ? "RegOpt" : (field.equals("MQPSPubOpts") ? "PubOpt" : field.substring(4))).equals("QName")) {
                    value = value.trim();
                }
                nvpBuffer.append("<");
                this.appendToken(nvpBuffer, field);
                nvpBuffer.append(">");
                this.appendToken(nvpBuffer, value);
                nvpBuffer.append("</" + field + ">");
            }
            enumVar = this.auxilliaryNVPairs.elements();
            while (enumVar.hasMoreElements()) {
                field = (String)enumVar.nextElement();
                value = (String)enumVar.nextElement();
                nvpBuffer.append("<");
                this.appendToken(nvpBuffer, field);
                nvpBuffer.append(">");
                this.appendToken(nvpBuffer, value);
                nvpBuffer.append(" </" + field + ">");
            }
            nvpBuffer.append("</psc>");
            String nameValueString = nvpBuffer.toString();
            if (Trace.isOn) {
                Trace.traceData(this, "RFH2 nameValueString is " + nameValueString, null);
            }
            this.rfh2.setNameValueString(nameValueString);
            this.rfh2.setNameValueLength(nameValueString.length());
            this.rfh2.write(message);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "writeToMessage(MQMsg2)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "writeToMessage(MQMsg2)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "writeToMessage(MQMsg2)");
        }
    }

    public String getHeaderFormat() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "getHeaderFormat()", "getter", "MQHRF2  ");
        }
        return "MQHRF2  ";
    }

    private void appendToken(StringBuffer sb, String token) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "appendToken(StringBuffer,String)", new Object[]{sb, token});
        }
        String formattedToken = "";
        if (token.equals("")) {
            sb.append(token);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "appendToken(StringBuffer,String)", 1);
            }
            return;
        }
        for (int i = 0; i < token.length(); ++i) {
            formattedToken = token.charAt(i) == '&' ? formattedToken + "&amp;" : (token.charAt(i) == '\'' ? formattedToken + "&apos;" : (token.charAt(i) == '\"' ? formattedToken + "&quot;" : (token.charAt(i) == '>' ? formattedToken + "&gt;" : (token.charAt(i) == '<' ? formattedToken + "&lt;" : formattedToken + token.charAt(i)))));
        }
        sb.append(formattedToken);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "appendToken(StringBuffer,String)", 2);
        }
    }

    private String removeEscapes(String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "removeEscapes(String)", new Object[]{value});
        }
        if (value == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "removeEscapes(String)", null, 1);
            }
            return null;
        }
        if (value.equals("") || value.indexOf(38) < 0) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "removeEscapes(String)", value, 2);
            }
            return value;
        }
        StringBuffer sb = new StringBuffer(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '&') {
                String entity = value.substring(i + 1, i + 4);
                if (entity.startsWith("lt;")) {
                    sb.append('<');
                    i += 3;
                    continue;
                }
                if (entity.startsWith("gt;")) {
                    sb.append('>');
                    i += 3;
                    continue;
                }
                if (entity.startsWith("amp")) {
                    sb.append("&");
                    i += 4;
                    continue;
                }
                if (entity.startsWith("apo")) {
                    sb.append('\'');
                    i += 5;
                    continue;
                }
                if (entity.startsWith("quo")) {
                    sb.append('\"');
                    i += 5;
                    continue;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Error: invalid escape sequence found &" + entity, null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1054", "&" + entity);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "removeEscapes(String)", je);
                }
                throw je;
            }
            sb.append(ch);
        }
        String traceRet1 = sb.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "removeEscapes(String)", traceRet1, 3);
        }
        return traceRet1;
    }

    private void parsePubSubFolder(String folder) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "parsePubSubFolder(String)", new Object[]{folder});
        }
        String reason = null;
        StringTokenizer strtok = new StringTokenizer(folder, "<>");
        String foldername = strtok.nextToken();
        if (!foldername.equals("pscr") && !foldername.equals("psc")) {
            if (Trace.isOn) {
                Trace.traceData(this, "Invalid psc or pscr folder", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1050");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "parsePubSubFolder(String)", je, 1);
            }
            throw je;
        }
        String name = strtok.nextToken();
        while (!name.equals("/" + foldername)) {
            String tempvalue = strtok.nextToken();
            if (!tempvalue.equals("/" + name)) {
                String endname;
                String value = this.removeEscapes(tempvalue);
                if (name.startsWith("Completion")) {
                    if (value.equals("ok")) {
                        value = Integer.toString(0);
                        reason = Integer.toString(0);
                        this.rfh2_update("MQPSReason", reason);
                        this.rfh2_update("MQPSReasonText", reason + " ");
                    } else if (value.equals("warning")) {
                        value = Integer.toString(1);
                    } else if (value.equals("error")) {
                        value = Integer.toString(2);
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Invalid Completion Code in pscr folder", null);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS1050");
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "parsePubSubFolder(String)", je, 2);
                        }
                        throw je;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "CompletionCode is " + value, null);
                    }
                    this.rfh2_update("MQPSCompCode", value);
                    endname = strtok.nextToken();
                } else if (name.startsWith("Response")) {
                    if (value.startsWith("Reason")) {
                        value = strtok.nextToken();
                        if (Trace.isOn) {
                            Trace.traceData(this, "Reason is " + value, null);
                        }
                        if (value != null) {
                            this.rfh2_update("MQPSReason", value);
                            this.rfh2_update("MQPSReasonText", value + " ");
                        }
                        endname = strtok.nextToken();
                        while (!endname.equals("/Response")) {
                            endname = strtok.nextToken();
                        }
                    }
                } else if (name.startsWith("Reason")) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Reason is " + value, null);
                    }
                    if (value != null) {
                        this.rfh2_update("MQPSReason", value);
                        this.rfh2_update("MQPSReasonText", value + " ");
                    }
                    endname = strtok.nextToken();
                } else if (name.startsWith("RegOpt")) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "RegOpt are " + value, null);
                    }
                    if (value != null) {
                        this.rfh2_update("MQPSRegOpts", value);
                    }
                    endname = strtok.nextToken();
                } else if (name.startsWith("PubOpt")) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "PubOpt are " + value, null);
                    }
                    if (value != null) {
                        this.rfh2_update("MQPSPubOpts", value);
                    }
                    endname = strtok.nextToken();
                } else if (name.startsWith("DelOpt")) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "DelOpt are " + value, null);
                    }
                    if (value != null) {
                        this.rfh2_update("MQPSDelOpts", value);
                    }
                    endname = strtok.nextToken();
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Name is " + name + ", Value is " + value, null);
                    }
                    if (value != null) {
                        this.rfh2_update("MQPS" + name, value);
                    }
                    endname = strtok.nextToken();
                }
            } else {
                this.rfh2_update("MQPS" + name, "");
            }
            name = strtok.nextToken();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "parsePubSubFolder(String)");
        }
    }

    public void rfh2_update(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "rfh2_update(String,String)", new Object[]{name, value});
        }
        try {
            this.update(name, value);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "rfh2_update(String,String)", je);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Repeated Name/Value found, saving in auxilliary array Name " + name + "Value " + value, null);
            }
            this.auxilliaryNVPairs.addElement(name);
            this.auxilliaryNVPairs.addElement(value);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "rfh2_update(String,String)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/RFH2BrokerMessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.19.1.2 11/11/23 17:29:15");
        }
    }
}

