/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH2Folder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.jms.JMSException;

public class RFH2 {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/RFH2.java, jmscc.wmq.v6, k701, k701-112-140304 1.22.1.2 10/09/02 15:34:51";
    private static final String MQRFH_STRUC_ID = "RFH ";
    private static final int MQRFH_ASCII_STRUC_ID_INT = 1380337696;
    private static final int MQRFH_EBCDIC_STRUC_ID_INT = -641284032;
    private static final int MQRFH_VERSION_2 = 2;
    private static final int MQRFH_STRUC_LENGTH_FIXED_2 = 36;
    private String strucId = "RFH ";
    private int version = 2;
    private int strucLength = 36;
    private int encoding = 273;
    private int codedCharSetId = -2;
    private String format = "MQSTR   ";
    private int flags = 0;
    private int nameValueCCSID = 1208;
    private Vector folders = null;
    private String nameValueString;
    private int nameValueLength = 0;
    private int msgCharSet;
    private int msgEncoding;
    private static final byte[] SPACES;

    public RFH2() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "<init>()");
        }
        this.folders = new Vector();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "<init>()");
        }
    }

    public RFH2(MQMsg2 message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", new Object[]{message});
        }
        this.folders = new Vector();
        if (message == null) {
            JMSException je = ConfigEnvironment.newException("MQJMS1074");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 1);
            }
            throw je;
        }
        this.msgCharSet = message.getCharacterSet();
        this.msgEncoding = message.getEncoding();
        try {
            int strucIdAsInt = message.readInt(1);
            switch (strucIdAsInt) {
                case 1380337696: {
                    this.msgCharSet = 819;
                    this.strucId = MQRFH_STRUC_ID;
                    break;
                }
                case -641284032: {
                    this.msgCharSet = 500;
                    this.strucId = MQRFH_STRUC_ID;
                    break;
                }
                default: {
                    Exception traceRet1 = new Exception("strucId");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", traceRet1, 2);
                    }
                    throw traceRet1;
                }
            }
            this.version = message.readInt(this.msgEncoding);
            if (this.version != 2) {
                Exception traceRet2 = new Exception("version");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", traceRet2, 3);
                }
                throw traceRet2;
            }
            this.strucLength = message.readInt(this.msgEncoding);
            this.encoding = message.readInt(this.msgEncoding);
            this.codedCharSetId = message.readInt(this.msgEncoding);
            byte[] tmp = new byte[8];
            message.read(tmp);
            this.format = this.getString(tmp);
            this.flags = message.readInt(this.msgEncoding);
            this.nameValueCCSID = message.readInt(this.msgEncoding);
            if (this.strucLength > 36) {
                int remainingBytes = this.strucLength - 40;
                message.skipReadingBytes(4);
                tmp = new byte[remainingBytes];
                message.read(tmp);
                try {
                    this.nameValueString = this.getString(tmp, JmqiCodepage.getJmqiCodepage((JmqiEnvironment)MQSESSION.getJmqiEnv(), (int)this.nameValueCCSID).charsetId);
                }
                catch (UnsupportedEncodingException uee) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", uee, 1);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "RFH2, NameValue CCSID " + this.nameValueCCSID + " not valid, using 819", null);
                    }
                    this.nameValueString = this.getString(tmp, "819");
                }
            } else {
                this.nameValueString = "";
            }
            if (Trace.isOn) {
                Trace.traceData(this, "The following fields have been read:\n" + this.toString(), null);
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", e, 2);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1086");
            je.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)");
        }
    }

    public void addFolder(RFH2Folder folder) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "addFolder(RFH2Folder)", new Object[]{folder});
        }
        int folderLength = folder.render().length();
        this.folders.addElement(folder);
        this.strucLength += 4;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "addFolder(RFH2Folder)");
        }
    }

    private byte[] getByteArray(String str) throws UnsupportedEncodingException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getByteArray(String)", new Object[]{str});
        }
        try {
            byte[] traceRet1 = str.getBytes(MQJMSMessage.getCharacterSetString(this.msgCharSet, this.msgEncoding));
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getByteArray(String)", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getByteArray(String)", je, 1);
            }
            UnsupportedEncodingException uee = new UnsupportedEncodingException(je.getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getByteArray(String))", uee, 1);
            }
            throw uee;
        }
    }

    public int getCodedCharSetId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getCodedCharSetId()", "getter", new Integer(this.codedCharSetId));
        }
        return this.codedCharSetId;
    }

    public int getEncoding() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getEncoding()", "getter", new Integer(this.encoding));
        }
        return this.encoding;
    }

    public String getFormat() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getFormat()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getFormat()", this.format);
        }
        return this.format;
    }

    public int getMsgEncoding() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getMsgEncoding()", "getter", new Integer(this.msgEncoding));
        }
        return this.msgEncoding;
    }

    public int getNameValueCCSID() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getNameValueCCSID()", "getter", new Integer(this.nameValueCCSID));
        }
        return this.nameValueCCSID;
    }

    public int getNameValueLength() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getNameValueLength()", "getter", new Integer(this.nameValueLength));
        }
        return this.nameValueLength;
    }

    public String getNameValueString() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getNameValueString()", "getter", this.nameValueString);
        }
        return this.nameValueString;
    }

    private String getString(byte[] barray) throws UnsupportedEncodingException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getString(byte [ ])", new Object[]{barray});
        }
        try {
            String traceRet1 = new String(barray, MQJMSMessage.getCharacterSetString(this.msgCharSet, this.msgEncoding));
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getString(byte [ ])", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getString(byte [ ])", je, 1);
            }
            UnsupportedEncodingException uee = new UnsupportedEncodingException(je.getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getString(byte [ ])", uee, 1);
            }
            throw uee;
        }
    }

    private String getString(byte[] barray, String CCSID) throws UnsupportedEncodingException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getString(byte [ ],String)", new Object[]{barray, CCSID});
        }
        String traceRet1 = new String(barray, CCSID);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getString(byte [ ],String)", traceRet1);
        }
        return traceRet1;
    }

    public String getStrucId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getStrucId()", "getter", this.strucId);
        }
        return this.strucId;
    }

    public int getStrucLength() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "getStrucLength()", "getter", new Integer(this.strucLength));
        }
        return this.strucLength;
    }

    public void setCodedCharSetId(int newCodedCharSetId) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "setCodedCharSetId(int)", "setter", new Integer(newCodedCharSetId));
        }
        this.codedCharSetId = newCodedCharSetId;
    }

    public void setEncoding(int newEncoding) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "setEncoding(int)", "setter", new Integer(newEncoding));
        }
        this.encoding = newEncoding;
    }

    public void setFormat(String newFormat) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "setFormat(java.lang.String)", new Object[]{newFormat});
        }
        this.format = newFormat;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "setFormat(java.lang.String)");
        }
    }

    public void setMsgEncoding(int newMsgEncoding) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "setMsgEncoding(int)", "setter", new Integer(newMsgEncoding));
        }
        this.msgEncoding = newMsgEncoding;
    }

    public void setNameValueCCSID(int newNameValueCCSID) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "setNameValueCCSID(int)", "setter", new Integer(newNameValueCCSID));
        }
        this.nameValueCCSID = newNameValueCCSID;
    }

    public void setNameValueLength(int newNameValueLength) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "setNameValueLength(int)", "setter", new Integer(newNameValueLength));
        }
        this.nameValueLength = newNameValueLength;
    }

    public void setNameValueString(String newNameValueString) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "setNameValueString(java.lang.String)", "setter", newNameValueString);
        }
        this.nameValueString = newNameValueString;
    }

    public void setStrucId(String newStrucId) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "setStrucId(java.lang.String)", "setter", newStrucId);
        }
        this.strucId = newStrucId;
    }

    public void setStrucLength(int newStrucLength) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "setStrucLength(int)", "setter", new Integer(newStrucLength));
        }
        this.strucLength = newStrucLength;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append("Dumping fixed portion of RFH2");
            buf.append("\n   StrucId        = " + this.strucId);
            buf.append("\n   Version        = " + this.version);
            buf.append("\n   StrucLength    = " + this.strucLength);
            buf.append("\n   Encoding       = " + this.encoding);
            buf.append("\n   CodedCharSetId = " + this.codedCharSetId);
            buf.append("\n   Format         = " + this.format);
            buf.append("\n   Flags          = " + this.flags);
            buf.append("\n   NameValueCCSID = " + this.nameValueCCSID);
            for (int i = 0; i < this.folders.size(); ++i) {
                String thisFolder = this.folders.elementAt(i).toString();
                buf.append("\n\nDumping folder " + (i + 1));
                buf.append("\n   " + thisFolder);
                buf.append("\n NameValueLength " + this.nameValueLength);
            }
            String traceRet1 = buf.toString();
            return traceRet1;
        }
        catch (Exception e) {
            buf.append("\n\nRFH2 toString() Exception:\n" + e);
            String traceRet2 = buf.toString();
            return traceRet2;
        }
    }

    public void write(MQMsg2 message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", new Object[]{message});
        }
        try {
            int nameValuePad = 0;
            byte[] nameValueBytes = null;
            if (this.nameValueString != null) {
                nameValueBytes = this.nameValueString.getBytes("UTF8");
                this.nameValueLength = nameValueBytes.length;
                nameValuePad = 3 - (this.nameValueLength - 1) % 4;
                this.nameValueLength += nameValuePad;
                if (this.nameValueLength > 0) {
                    this.strucLength = this.strucLength + this.nameValueLength + 4;
                }
            } else {
                this.strucLength = 36;
            }
            this.msgEncoding = message.getEncoding();
            this.msgCharSet = message.getCharacterSet();
            message.appendByteArray(this.getByteArray(this.strucId));
            message.appendInt(this.version, this.msgEncoding);
            message.appendInt(this.strucLength, this.msgEncoding);
            message.appendInt(this.encoding, this.msgEncoding);
            message.appendInt(this.codedCharSetId, this.msgEncoding);
            message.appendByteArray(this.getByteArray(this.format));
            message.appendInt(this.flags, this.msgEncoding);
            message.appendInt(this.nameValueCCSID, this.msgEncoding);
            if (this.nameValueString != null) {
                message.appendInt(this.nameValueLength, this.msgEncoding);
                message.appendByteArray(nameValueBytes);
                message.appendByteArray(SPACES, 0, nameValuePad);
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1085");
            je.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)");
        }
    }

    public void writeToMessage(MQMessage message) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "writeToMessage(MQMessage)", new Object[]{message});
        }
        if (message == null) {
            Exception traceRet1 = new Exception("Null message passed in");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "writeToMessage(MQMessage)", traceRet1, 1);
            }
            throw traceRet1;
        }
        message.format = "MQHRF2  ";
        try {
            message.writeString(this.strucId);
            message.writeInt(this.version);
            message.writeInt(this.strucLength);
            message.writeInt(this.encoding);
            message.writeInt(this.codedCharSetId);
            message.writeString(this.format);
            message.writeInt(this.flags);
            message.writeInt(this.nameValueCCSID);
            for (int i = 0; i < this.folders.size(); ++i) {
                RFH2Folder thisFolder = (RFH2Folder)this.folders.elementAt(i);
                String rendered = thisFolder.render();
                message.writeInt(rendered.length());
            }
        }
        catch (IOException iox) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "writeToMessage(MQMessage)", iox);
            }
            Exception e = new Exception("IOException in writeToMessage: " + iox);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "writeToMessage(MQMessage)", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "writeToMessage(MQMessage)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.RFH2", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/RFH2.java, jmscc.wmq.v6, k701, k701-112-140304  1.22.1.2 10/09/02 15:34:51");
        }
        SPACES = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    }
}

