/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.JMSException;

class RFH1BrokerMessageImpl
extends MQBrokerMessage {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/RFH1BrokerMessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.17.1.3 11/03/29 14:33:08";
    private static final String clsName = "RFH1BrokerMessageImpl";
    private RFH rfh = null;
    private Vector auxilliaryNVPairs = new Vector();
    private static final int PARSE_STATE_START = 0;
    private static final int PARSE_STATE_UNQUOTED_TOKEN = 1;
    private static final int PARSE_STATE_QUOTED_TOKEN = 2;
    private static final int PARSE_STATE_AFTER_ONE_QUOTE = 3;
    private static final int PARSE_STATE_FINISHED = 4;
    private static final int PARSE_TOKEN_NORMAL = 0;
    private static final int PARSE_TOKEN_SPACE = 1;
    private static final int PARSE_TOKEN_QUOTE = 2;
    private static final int PARSE_TOKEN_END = 3;

    public RFH1BrokerMessageImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "<init>()");
        }
    }

    public void clear() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "clear()");
        }
        this.rfh = null;
        this.auxilliaryNVPairs = new Vector();
        super.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "clear()");
        }
    }

    public void initializeFromMessage(MQMsg2 message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "initializeFromMessage(MQMsg2)", new Object[]{message});
        }
        try {
            this.clear();
            this.rfh = new RFH(message);
            this.setEncoding(this.rfh.getEncoding());
            this.setCodedCharSetId(this.rfh.getCodedCharSetId());
            this.setFormat(this.rfh.getFormat());
            String nameValueString = this.rfh.getNameValueString();
            Vector v = this.parseNameValues(nameValueString);
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                String value;
                String name;
                try {
                    name = (String)e.nextElement();
                    value = (String)e.nextElement();
                }
                catch (NoSuchElementException nsee) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "initializeFromMessage(MQMsg2)", nsee, 1);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS1087");
                    je.setLinkedException((Exception)nsee);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "initializeFromMessage(MQMsg2)", je, 1);
                    }
                    throw je;
                }
                try {
                    this.update(name, value);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "initializeFromMessage(MQMsg2)", je, 2);
                    }
                    this.auxilliaryNVPairs.addElement(name);
                    this.auxilliaryNVPairs.addElement(value);
                }
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "initializeFromMessage(MQMsg2)", je, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "initializeFromMessage(MQMsg2)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "initializeFromMessage(MQMsg2)");
        }
    }

    public void writeToMessage(MQMsg2 message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "writeToMessage(MQMsg2)", new Object[]{message});
        }
        try {
            String field;
            if (this.rfh == null) {
                this.rfh = new RFH();
            }
            this.rfh.setEncoding(this.getEncoding());
            this.rfh.setCodedCharSetId(this.getCodedCharSetId());
            this.rfh.setFormat(this.getFormat());
            StringBuffer nvpBuffer = new StringBuffer();
            boolean prependSpace = false;
            String value = this.get("MQPSCommand");
            if (value != null) {
                if (prependSpace) {
                    nvpBuffer.append(' ');
                }
                nvpBuffer.append("MQPSCommand");
                nvpBuffer.append(' ');
                this.appendToken(nvpBuffer, value);
                prependSpace = true;
            }
            Enumeration enumVar = this.getFields();
            while (enumVar.hasMoreElements()) {
                field = (String)enumVar.nextElement();
                if (field.equals("MQPSCommand")) continue;
                value = this.get(field);
                if (prependSpace) {
                    nvpBuffer.append(' ');
                }
                this.appendToken(nvpBuffer, field);
                nvpBuffer.append(' ');
                this.appendToken(nvpBuffer, value);
                prependSpace = true;
            }
            enumVar = this.auxilliaryNVPairs.elements();
            while (enumVar.hasMoreElements()) {
                field = (String)enumVar.nextElement();
                value = (String)enumVar.nextElement();
                if (prependSpace) {
                    nvpBuffer.append(' ');
                }
                this.appendToken(nvpBuffer, field);
                nvpBuffer.append(' ');
                this.appendToken(nvpBuffer, value);
                prependSpace = true;
            }
            String nameValueString = nvpBuffer.toString();
            this.rfh.setNameValueString(nameValueString);
            this.rfh.write(message);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "writeToMessage(MQMsg2)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "writeToMessage(MQMsg2)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "writeToMessage(MQMsg2)");
        }
    }

    public String getHeaderFormat() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "getHeaderFormat()", "getter", "MQHRF   ");
        }
        return "MQHRF   ";
    }

    private Vector parseNameValues(String nvs) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "parseNameValues(String)", new Object[]{nvs});
        }
        int state = 0;
        Vector<String> out = new Vector<String>();
        String partialToken = null;
        if (Trace.isOn) {
            Trace.traceData(this, "parseNameValues>>" + nvs, null);
        }
        String null_char = "\u0000";
        String blank = "";
        int i = nvs.indexOf(null_char);
        while (i != -1 && i < nvs.length()) {
            nvs = nvs.substring(0, i) + blank + nvs.substring(i + null_char.length(), nvs.length());
            i = nvs.indexOf(null_char, i);
        }
        if (Trace.isOn) {
            Trace.traceData(this, "parseNameValues<<" + nvs, null);
        }
        try {
            StringTokenizer stok = new StringTokenizer(nvs, " \"\u0000", true);
            block32: while (state != 4) {
                int tokType;
                String tok;
                if (stok.hasMoreElements()) {
                    tok = stok.nextToken();
                    tokType = 0;
                    if (tok.equals(" ")) {
                        tokType = 1;
                    } else if (tok.equals("\"")) {
                        tokType = 2;
                    } else if (tok.equals("\u0000")) {
                        tokType = 3;
                    }
                } else {
                    tokType = 3;
                    tok = null;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Parser state is " + state + ", token is " + tok + " of type " + tokType, null);
                }
                switch (state) {
                    case 0: {
                        switch (tokType) {
                            case 0: {
                                out.addElement(tok);
                                state = 1;
                                continue block32;
                            }
                            case 1: {
                                state = 0;
                                continue block32;
                            }
                            case 2: {
                                state = 2;
                                partialToken = "";
                                continue block32;
                            }
                            case 3: {
                                state = 4;
                                continue block32;
                            }
                        }
                        this.badTokType();
                        continue block32;
                    }
                    case 1: {
                        switch (tokType) {
                            case 0: 
                            case 2: {
                                this.invalidNVPairs();
                                continue block32;
                            }
                            case 1: {
                                state = 0;
                                continue block32;
                            }
                            case 3: {
                                state = 4;
                                continue block32;
                            }
                        }
                        this.badTokType();
                        continue block32;
                    }
                    case 2: {
                        switch (tokType) {
                            case 0: {
                                partialToken = partialToken + tok;
                                state = 2;
                                continue block32;
                            }
                            case 1: {
                                partialToken = partialToken + ' ';
                                state = 2;
                                continue block32;
                            }
                            case 2: {
                                state = 3;
                                continue block32;
                            }
                            case 3: {
                                this.invalidNVPairs();
                                continue block32;
                            }
                        }
                        this.badTokType();
                        continue block32;
                    }
                    case 3: {
                        switch (tokType) {
                            case 0: {
                                this.invalidNVPairs();
                                continue block32;
                            }
                            case 1: {
                                out.addElement(partialToken);
                                partialToken = null;
                                state = 0;
                                continue block32;
                            }
                            case 2: {
                                partialToken = partialToken + '\"';
                                state = 2;
                                continue block32;
                            }
                            case 3: {
                                out.addElement(partialToken);
                                partialToken = null;
                                state = 4;
                                continue block32;
                            }
                        }
                        this.badTokType();
                        continue block32;
                    }
                }
                this.badState();
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "parseNameValues(String)", out);
            }
            return out;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "parseNameValues(String)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "parseNameValues(String)", je);
            }
            throw je;
        }
    }

    private void badTokType() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "badTokType()");
        }
        String detail = "RFH1BrokerMessageImpl encountered impossible token type";
        JMSException je = ConfigEnvironment.newException("MQJMS1016", detail);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "badTokType()", je);
        }
        throw je;
    }

    private void badState() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "badState()");
        }
        String detail = "RFH1BrokerMessageImpl encountered impossible state value";
        JMSException je = ConfigEnvironment.newException("MQJMS1016", detail);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "badState()", je);
        }
        throw je;
    }

    private void invalidNVPairs() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "invalidNVPairs()");
        }
        JMSException je = ConfigEnvironment.newException("MQJMS1087");
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "invalidNVPairs()", je);
        }
        throw je;
    }

    private void appendToken(StringBuffer sb, String token) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "appendToken(StringBuffer,String)", new Object[]{sb, token});
        }
        RFH1BrokerMessageImpl.formatNameValueValue(sb, token);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "appendToken(StringBuffer,String)");
        }
    }

    public static void formatNameValueValue(StringBuffer buffer, String value) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "formatNameValueValue(StringBuffer,String)", new Object[]{buffer.toString(), value});
        }
        if (value.equals("")) {
            buffer.append("\"\"");
        } else if (value.indexOf("\"") == -1) {
            if (value.indexOf(" ") == -1) {
                buffer.append(value);
            } else {
                buffer.append("\"");
                buffer.append(value);
                buffer.append("\"");
            }
        } else {
            StringTokenizer tok = new StringTokenizer(value, "\"", true);
            buffer.append("\"");
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken();
                if (s.equals("\"")) {
                    buffer.append("\"\"");
                    continue;
                }
                buffer.append(s);
            }
            buffer.append("\"");
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "formatNameValueValue(StringBuffer,String)", new Object[]{buffer.toString()});
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/RFH1BrokerMessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.17.1.3 11/03/29 14:33:08");
        }
    }
}

