/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.jms.JMSException;

class RFH {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/RFH.java, jmscc.wmq.v6, k701, k701-112-140304 1.17.1.2 10/09/02 15:30:06";
    private static final String MQRFH_STRUC_ID = "RFH ";
    private static final int MQRFH_ASCII_STRUC_ID_INT = 1380337696;
    private static final int MQRFH_EBCDIC_STRUC_ID_INT = -641284032;
    private static final int MQRFH_VERSION_1 = 1;
    private static final int MQRFH_STRUC_LENGTH_FIXED = 32;
    private String strucId;
    private int version;
    private int strucLength;
    private int encoding;
    private int codedCharSetId;
    private String format;
    private int flags;
    private String nameValueString;
    private int msgCharSet;
    private int msgEncoding;

    RFH() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "<init>()");
        }
        this.strucId = MQRFH_STRUC_ID;
        this.version = 1;
        this.strucLength = 32;
        this.encoding = 273;
        this.codedCharSetId = 0;
        this.format = "        ";
        this.flags = 0;
        this.nameValueString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "<init>()");
        }
    }

    RFH(MQMsg2 message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", new Object[]{message});
        }
        if (message == null) {
            JMSException je = ConfigEnvironment.newException("MQJMS1074");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 1);
            }
            throw je;
        }
        this.msgCharSet = message.getCharacterSet();
        this.msgEncoding = message.getEncoding();
        try {
            int strucIdAsInt = message.readInt(1);
            switch (strucIdAsInt) {
                case 1380337696: {
                    this.msgCharSet = 819;
                    this.strucId = MQRFH_STRUC_ID;
                    break;
                }
                case -641284032: {
                    this.msgCharSet = 500;
                    this.strucId = MQRFH_STRUC_ID;
                    break;
                }
                default: {
                    Exception traceRet1 = new Exception("strucId");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", traceRet1, 2);
                    }
                    throw traceRet1;
                }
            }
            this.version = message.readInt(this.msgEncoding);
            if (this.version != 1) {
                Exception traceRet2 = new Exception("version");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", traceRet2, 3);
                }
                throw traceRet2;
            }
            this.strucLength = message.readInt(this.msgEncoding);
            this.encoding = message.readInt(this.msgEncoding);
            this.codedCharSetId = message.readInt(this.msgEncoding);
            byte[] tmp = new byte[8];
            message.read(tmp);
            this.format = this.getString(tmp);
            this.flags = message.readInt(this.msgEncoding);
            int remainingBytes = this.strucLength - 32;
            tmp = new byte[remainingBytes];
            message.read(tmp);
            this.nameValueString = this.getString(tmp);
            if (Trace.isOn) {
                Trace.traceData(this, "The following fields have been read:\n" + this.toString(), null);
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1086");
            je.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)");
        }
    }

    String getNameValueString() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getNameValueString()", "getter", this.nameValueString);
        }
        return this.nameValueString;
    }

    void setNameValueString(String nameValueString) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "setNameValueString(String)", "setter", nameValueString);
        }
        this.nameValueString = nameValueString;
    }

    String getValue(String name) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getValue(String)", new Object[]{name});
        }
        if (Trace.isOn) {
            Trace.traceData(this, "nameValueString='" + this.nameValueString + "'", null);
        }
        StringTokenizer tok = new StringTokenizer(this.nameValueString);
        while (tok.hasMoreTokens()) {
            String thisName = tok.nextToken();
            String value = tok.nextToken();
            if (!thisName.equals(name)) continue;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getValue(String)", value, 1);
            }
            return value;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getValue(String)", null, 2);
        }
        return null;
    }

    void write(MQMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", new Object[]{message});
        }
        try {
            this.encoding = message.encoding;
            this.codedCharSetId = message.characterSet;
            this.format = message.format;
            message.encoding = 273;
            message.characterSet = 0;
            message.format = "MQHRF   ";
            int bodyLen = message.getMessageLength();
            byte[] bodyBuffer = new byte[bodyLen];
            message.seek(0);
            message.readFully(bodyBuffer);
            message.seek(0);
            this.writeRFHFields(message);
            message.write(bodyBuffer);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1085");
            je.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)");
        }
    }

    private void writeRFHFields(MQMessage m) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "writeRFHFields(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", new Object[]{m});
        }
        if (this.nameValueString != null) {
            while (this.nameValueString.length() % 4 != 0) {
                this.nameValueString = this.nameValueString + " ";
            }
            this.strucLength = 32 + this.nameValueString.length();
        }
        m.writeString(this.strucId);
        m.writeInt(this.version);
        m.writeInt(this.strucLength);
        m.writeInt(this.encoding);
        m.writeInt(this.codedCharSetId);
        m.writeString(this.format);
        m.writeInt(this.flags);
        if (this.nameValueString != null) {
            m.writeString(this.nameValueString);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "writeRFHFields(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)");
        }
    }

    public void write(MQMsg2 message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", new Object[]{message});
        }
        try {
            if (this.nameValueString != null) {
                int l = this.nameValueString.length();
                while (l % 4 != 0) {
                    this.nameValueString = this.nameValueString + " ";
                    ++l;
                }
                this.strucLength = 32 + this.nameValueString.length();
            } else {
                this.strucLength = 32;
            }
            this.msgEncoding = message.getEncoding();
            this.msgCharSet = message.getCharacterSet();
            message.appendByteArray(this.getByteArray(this.strucId));
            message.appendInt(this.version, this.msgEncoding);
            message.appendInt(this.strucLength, this.msgEncoding);
            message.appendInt(this.encoding, this.msgEncoding);
            message.appendInt(this.codedCharSetId, this.msgEncoding);
            message.appendByteArray(this.getByteArray(this.format));
            message.appendInt(this.flags, this.msgEncoding);
            if (this.nameValueString != null) {
                message.appendByteArray(this.getByteArray(this.nameValueString));
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1085");
            je.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)");
        }
    }

    private String getString(byte[] barray) throws UnsupportedEncodingException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getString(byte [ ])", new Object[]{barray});
        }
        try {
            String traceRet1 = new String(barray, MQJMSMessage.getCharacterSetString(this.msgCharSet, this.msgEncoding));
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getString(byte [ ])", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getString(byte [ ])", je, 1);
            }
            UnsupportedEncodingException uee = new UnsupportedEncodingException(je.getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getString(byte [ ])", uee, 1);
            }
            throw uee;
        }
    }

    private byte[] getByteArray(String str) throws UnsupportedEncodingException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getByteArray(String)", new Object[]{str});
        }
        try {
            byte[] traceRet1 = str.getBytes(MQJMSMessage.getCharacterSetString(this.msgCharSet, this.msgEncoding));
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getByteArray(String)", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getByteArray(String)", je, 1);
            }
            UnsupportedEncodingException uee = new UnsupportedEncodingException(je.getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getByteArray(String))", uee, 1);
            }
            throw uee;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("StrucId='" + this.strucId + "'\n");
        buf.append("Version=" + this.version + "\n");
        buf.append("StrucLength=" + this.strucLength + "\n");
        buf.append("Encoding=" + this.encoding + "\n");
        buf.append("CodedCharSetId=" + this.codedCharSetId + "\n");
        buf.append("Format='" + this.format + "'\n");
        buf.append("Flags=" + this.flags + "\n");
        if (this.nameValueString != null) {
            buf.append("NameValueString='" + this.nameValueString + "'");
        }
        String traceRet1 = buf.toString();
        return traceRet1;
    }

    public void setEncoding(int encoding) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "setEncoding(int)", "setter", new Integer(encoding));
        }
        this.encoding = encoding;
    }

    public int getEncoding() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getEncoding()", "getter", new Integer(this.encoding));
        }
        return this.encoding;
    }

    public void setCodedCharSetId(int codedCharSetId) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "setCodedCharSetId(int)", "setter", new Integer(codedCharSetId));
        }
        this.codedCharSetId = codedCharSetId;
    }

    public int getCodedCharSetId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getCodedCharSetId()", "getter", new Integer(this.codedCharSetId));
        }
        return this.codedCharSetId;
    }

    public void setFormat(String format) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "setFormat(String)", new Object[]{format});
        }
        this.format = format;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "setFormat(String)");
        }
    }

    public String getFormat() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getFormat()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.RFH", "getFormat()", this.format);
        }
        return this.format;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.RFH", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/RFH.java, jmscc.wmq.v6, k701, k701-112-140304  1.17.1.2 10/09/02 15:30:06");
        }
    }
}

