/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import java.util.Vector;
import javax.jms.JMSException;

public class PCF {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/PCF.java, jmscc.wmq.v6, k701, k701-112-140304 1.19.1.1 09/08/17 08:15:47";
    private static final int MQCFH_STRUC_LENGTH = 36;
    private static final int MQCFH_VERSION_1 = 1;
    private static final int MQCFC_LAST = 1;
    private static final int MQCFC_NOT_LAST = 0;
    public static final int MQCFT_COMMAND = 1;
    public static final int MQCFT_RESPONSE = 2;
    public static final int MQCFT_INTEGER = 3;
    public static final int MQCFT_STRING = 4;
    public static final int MQCFT_INTEGER_LIST = 5;
    public static final int MQCFT_STRING_LIST = 6;
    public static final int MQCFT_EVENT = 7;
    public static final int MQCACF_TOPIC = 3031;
    public static final int MQCACF_PUBLISH_TIMESTAMP = 3034;
    public static final int MQCACF_REG_TIME = 3038;
    public static final int MQCACF_REG_USER_ID = 3039;
    public static final int MQCACF_REG_Q_MGR_NAME = 3042;
    public static final int MQCACF_REG_Q_NAME = 3043;
    public static final int MQCACF_REG_CORREL_ID = 3044;
    public static final int MQCMD_CLEAR_Q = 9;
    public static final int MQCMD_INQUIRE_Q_NAMES = 18;
    public static final int MQCA_Q_NAME = 2016;
    public static final int MQIA_Q_TYPE = 20;
    public static final int MQCFIL_STRUC_LENGTH_FIXED = 16;
    public static final int MQCFIN_STRUC_LENGTH = 16;
    public static final int MQCFSL_STRUC_LENGTH_FIXED = 24;
    public static final int MQCFST_STRUC_LENGTH_FIXED = 20;
    int type;
    int strucLength;
    int version;
    int command;
    int msgSeqNumber;
    int control;
    int compCode;
    int reason;
    int parameterCount;
    int[] paramTypes = null;
    Object[] paramValues = null;
    private Vector paramOut = null;

    public PCF(int command) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "<init>(int)", new Object[]{new Integer(command)});
        }
        this.type = 1;
        this.strucLength = 36;
        this.version = 1;
        this.command = command;
        this.msgSeqNumber = 1;
        this.control = 1;
        this.compCode = 0;
        this.reason = 0;
        this.parameterCount = 0;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "<init>(int)");
        }
    }

    public PCF(MQMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "<init>(MQMessage)", new Object[]{message});
        }
        if (message == null) {
            JMSException je = ConfigEnvironment.newException("MQJMS1074");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "<init>(MQMessage)", je, 1);
            }
            throw je;
        }
        try {
            this.type = message.readInt();
            this.strucLength = message.readInt();
            this.version = message.readInt();
            this.command = message.readInt();
            this.msgSeqNumber = message.readInt();
            this.control = message.readInt();
            this.compCode = message.readInt();
            this.reason = message.readInt();
            this.parameterCount = message.readInt();
            if (this.version != 1) {
                Exception traceRet1 = new Exception("Unknown version: " + this.version);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "<init>(MQMessage)", traceRet1, 2);
                }
                throw traceRet1;
            }
            this.paramTypes = new int[this.parameterCount];
            this.paramValues = new Object[this.parameterCount];
            for (int p = 0; p < this.parameterCount; ++p) {
                int paramType;
                this.paramTypes[p] = paramType = message.readInt();
                if (paramType == 4) {
                    this.paramValues[p] = new MQCFST(message);
                    continue;
                }
                if (paramType == 3) {
                    this.paramValues[p] = new MQCFIN(message);
                    continue;
                }
                if (paramType == 6) {
                    this.paramValues[p] = new MQCFSL(message);
                    continue;
                }
                Exception traceRet2 = new Exception("Unknown paramType: " + paramType);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "<init>(MQMessage)", traceRet2, 3);
                }
                throw traceRet2;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "The following fields have been read:\n" + this.toString(), null);
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "<init>(MQMessage)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1086");
            je.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "<init>(MQMessage)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "<init>(MQMessage)");
        }
    }

    public void write(MQMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", new Object[]{message});
        }
        try {
            message.messageType = 1;
            message.expiry = 1000;
            message.format = "MQADMIN ";
            message.feedback = 0;
            message.writeInt(this.type);
            message.writeInt(this.strucLength);
            message.writeInt(this.version);
            message.writeInt(this.command);
            message.writeInt(this.msgSeqNumber);
            message.writeInt(this.control);
            message.writeInt(this.compCode);
            message.writeInt(this.reason);
            message.writeInt(this.parameterCount);
            for (int p = 0; p < this.parameterCount; ++p) {
                Object param = this.paramOut.elementAt(p);
                if (param instanceof MQCFST) {
                    ((MQCFST)param).writeTo(message);
                    continue;
                }
                if (param instanceof MQCFIN) {
                    ((MQCFIN)param).writeTo(message);
                    continue;
                }
                Exception traceRet1 = new Exception("Unable to write unknown parameter: " + p);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", traceRet1, 1);
                }
                throw traceRet1;
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1085");
            je.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Type='" + this.type + "'\n");
        buf.append("StrucLength='" + this.strucLength + "'\n");
        buf.append("Version='" + this.version + "'\n");
        buf.append("Command='" + this.command + "'\n");
        buf.append("MsgSeqNumber='" + this.msgSeqNumber + "'\n");
        buf.append("Control='" + this.control + "'\n");
        buf.append("CompCode='" + this.compCode + "'\n");
        buf.append("Reason='" + this.reason + "'\n");
        buf.append("ParameterCount='" + this.parameterCount + "'\n");
        for (int p = 0; p < this.parameterCount; ++p) {
            buf.append("  Parameter " + (p + 1) + "\n");
            buf.append("    " + this.paramValues[p].toString() + "\n");
        }
        String traceRet1 = buf.toString();
        return traceRet1;
    }

    public int getParameterCount() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "getParameterCount()", "getter", new Integer(this.parameterCount));
        }
        return this.parameterCount;
    }

    public Object getParameterAt(int i) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "getParameterAt(int)", new Object[]{new Integer(i)});
        }
        if (i < this.parameterCount) {
            Object traceRet1 = this.paramValues[i];
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "getParameterAt(int)", traceRet1, 1);
            }
            return traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "getParameterAt(int)", null, 2);
        }
        return null;
    }

    public int getParameterType(int i) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "getParameterType(int)", new Object[]{new Integer(i)});
        }
        if (i < this.parameterCount) {
            int traceRet1 = this.paramTypes[i];
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "getParameterType(int)", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        int traceRet2 = -1;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "getParameterType(int)", new Integer(traceRet2), 2);
        }
        return traceRet2;
    }

    public int getControl() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "getControl()", "getter", new Integer(this.control));
        }
        return this.control;
    }

    public int getMsgSeqNumber() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "getMsgSeqNumber()", "getter", new Integer(this.msgSeqNumber));
        }
        return this.msgSeqNumber;
    }

    public int getCompCode() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "getCompCode()", "getter", new Integer(this.compCode));
        }
        return this.compCode;
    }

    public int getReason() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "getReason()", "getter", new Integer(this.reason));
        }
        return this.reason;
    }

    public void addParameter(int paramId, int value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "addParameter(int,int)", new Object[]{new Integer(paramId), new Integer(value)});
        }
        if (this.paramOut == null) {
            this.paramOut = new Vector();
        }
        MQCFIN param = new MQCFIN(paramId, value);
        this.paramOut.addElement(param);
        ++this.parameterCount;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "addParameter(int,int)");
        }
    }

    public void addParameter(int paramId, String value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "addParameter(int,String)", new Object[]{new Integer(paramId), value});
        }
        if (this.paramOut == null) {
            this.paramOut = new Vector();
        }
        MQCFST param = new MQCFST(paramId, value);
        this.paramOut.addElement(param);
        ++this.parameterCount;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.PCF", "addParameter(int,String)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.PCF", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/PCF.java, jmscc.wmq.v6, k701, k701-112-140304  1.19.1.1 09/08/17 08:15:47");
        }
    }

    public class MQCFSL {
        int type = 6;
        int strucLength;
        int paramId;
        int CCSID;
        int count;
        int strLength;
        String[] strings;

        MQCFSL(MQMessage msg) throws Exception {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFSL", "<init>(MQMessage)", new Object[]{msg});
            }
            this.strucLength = msg.readInt();
            this.paramId = msg.readInt();
            this.CCSID = msg.readInt();
            this.count = msg.readInt();
            this.strLength = msg.readInt();
            this.strings = new String[this.count];
            for (int s = 0; s < this.count; ++s) {
                byte[] strBuf = new byte[this.strLength];
                msg.readFully(strBuf);
                this.strings[s] = new String(strBuf);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFSL", "<init>(MQMessage)");
            }
        }

        public String[] getStrings() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFSL", "getStrings()", "getter", this.strings);
            }
            return this.strings;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("MQCFSL [StrucLength=" + this.strucLength + ",ParamId=" + this.paramId + ",CCSID=" + this.CCSID + ",Count=" + this.count + ",StrLength=" + this.strLength + ",Strings={");
            for (int i = 0; i < this.count; ++i) {
                String s = this.strings[i];
                buf.append(s);
                if (i < this.count - 1) {
                    buf.append(",");
                    continue;
                }
                buf.append("}]");
            }
            String traceRet1 = buf.toString();
            return traceRet1;
        }
    }

    public class MQCFIN {
        int strucLength;
        int paramId;
        int value;

        MQCFIN(MQMessage msg) throws Exception {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFIN", "<init>(MQMessage)", new Object[]{msg});
            }
            this.strucLength = msg.readInt();
            this.paramId = msg.readInt();
            this.value = msg.readInt();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFIN", "<init>(MQMessage)");
            }
        }

        MQCFIN(int paramId, int value) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFIN", "<init>(int,int)", new Object[]{new Integer(paramId), new Integer(value)});
            }
            this.value = value;
            this.paramId = paramId;
            this.strucLength = 16;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFIN", "<init>(int,int)");
            }
        }

        public void writeTo(MQMessage msg) throws Exception {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFIN", "writeTo(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", new Object[]{msg});
            }
            msg.writeInt(3);
            msg.writeInt(this.strucLength);
            msg.writeInt(this.paramId);
            msg.writeInt(this.value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFIN", "writeTo(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)");
            }
        }

        public String toString() {
            String traceRet1 = "MQCFIN [StrucLength=" + this.strucLength + ",ParamId=" + this.paramId + ",Value=" + this.value + "]";
            return traceRet1;
        }
    }

    public class MQCFST {
        int strucLength;
        int paramId;
        int CCSID;
        int strLength;
        String value;

        MQCFST(MQMessage msg) throws Exception {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFST", "<init>(MQMessage)", new Object[]{msg});
            }
            this.strucLength = msg.readInt();
            this.paramId = msg.readInt();
            this.CCSID = msg.readInt();
            this.strLength = msg.readInt();
            byte[] strBuf = new byte[this.strLength];
            msg.readFully(strBuf);
            this.value = new String(strBuf);
            int mod = this.strLength % 4;
            if (mod != 0) {
                int skip = 4 - mod;
                byte[] dummy = new byte[skip];
                msg.readFully(dummy);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFST", "<init>(MQMessage)");
            }
        }

        MQCFST(int paramId, String value) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFST", "<init>(int,String)", new Object[]{new Integer(paramId), value});
            }
            this.value = value;
            this.paramId = paramId;
            this.CCSID = 0;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFST", "<init>(int,String)");
            }
        }

        public void writeTo(MQMessage msg) throws Exception {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFST", "writeTo(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", new Object[]{msg});
            }
            this.strLength = this.value == null ? 0 : this.value.length();
            int padding = this.strLength % 4;
            if (padding != 0) {
                padding = 4 - padding;
            }
            this.strucLength = 20 + this.strLength + padding;
            msg.writeInt(4);
            msg.writeInt(this.strucLength);
            msg.writeInt(this.paramId);
            msg.writeInt(msg.characterSet);
            msg.writeInt(this.strLength);
            msg.writeString(this.value);
            while (padding-- > 0) {
                msg.write(32);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQCFST", "writeTo(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)");
            }
        }

        public String toString() {
            String traceRet1 = "MQCFST [StrucLength=" + this.strucLength + ",ParamId=" + this.paramId + ",CCSID=" + this.CCSID + ",StrLength=" + this.strLength + ",Value=" + this.value + "]";
            return traceRet1;
        }
    }
}

