/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.jmqi.JmqiXAResource;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderSession;
import com.ibm.msg.client.provider.ProviderXASession;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TransactionInProgressException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class MQXASession
extends MQSession
implements ProviderXASession {
    private static final long serialVersionUID = -5044711013870900284L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQXASession.java, jmscc.wmq.v6, k701, k701-112-140304 1.28.1.3 12/12/14 14:16:34";
    private XAResource resource;
    private MQSession session = null;

    public MQXASession(MQConnection connection, MQQueueManager qm, MQSession session, JmqiXAResource resource) throws JMSException {
        super(connection, qm, true, 0);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "<init>(MQConnection,MQQueueManager,MQSession,JmqiXAResource)", new Object[]{connection, qm, session, resource});
        }
        this.session = session;
        this.setQM(qm);
        this.resource = resource;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", (Object)"Set MQXASession resolved variables to those within the session");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "<init>(MQConnection,MQQueueManager,MQSession,JmqiXAResource)");
        }
    }

    public XAResource getXAResource() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "getXAResource()", "getter", this.resource);
        }
        return this.resource;
    }

    public boolean isXASessionActive() {
        boolean isActive = false;
        if (this.resource != null) {
            isActive = ((JmqiXAResource)this.resource).getActiveState();
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.internal.MQXASession", "isXASessionActive()", (Object)new Boolean(isActive));
        }
        return isActive;
    }

    public boolean getTransacted() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "getTransacted()", "getter", true);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void close(boolean closingFromConnection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "close(boolean)", new Object[]{closingFromConnection});
        }
        try {
            try {
                ((JmqiXAResource)this.resource).close();
            }
            catch (XAException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "close(boolean)", e, 2);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS2012");
                je.setLinkedException((Exception)e);
                if (!Trace.isOn) throw je;
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "close(boolean)", je, 2);
                throw je;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            try {
                this.session.close(closingFromConnection);
                this.session.discQM();
                throw throwable;
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "close(boolean)", e, 1);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS2012");
                je.setLinkedException((Exception)((Object)e));
                if (!Trace.isOn) throw je;
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "close(boolean)", je, 1);
                throw je;
            }
        }
        try {}
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "close(boolean)", e, 1);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS2012");
            je.setLinkedException((Exception)((Object)e));
            if (!Trace.isOn) throw je;
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "close(boolean)", je, 1);
            throw je;
        }
        this.session.close(closingFromConnection);
        this.session.discQM();
        if (!Trace.isOn) return;
        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "close(boolean)");
    }

    void acknowledge() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "acknowledge()");
        }
        JMSException traceRet1 = ConfigEnvironment.newException("MQJMS1016", "MQXASession.acknowledge");
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "acknowledge()", traceRet1);
        }
        throw traceRet1;
    }

    public void commit() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "commit()");
        }
        String msg = ConfigEnvironment.getErrorMessage("MQJMS1069");
        TransactionInProgressException traceRet1 = new TransactionInProgressException(msg);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "commit()", traceRet1);
        }
        throw traceRet1;
    }

    public void rollback() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "rollback()");
        }
        String msg = ConfigEnvironment.getErrorMessage("MQJMS1069");
        TransactionInProgressException traceRet1 = new TransactionInProgressException(msg);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "rollback()", traceRet1);
        }
        throw traceRet1;
    }

    public void recover() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "recover()");
        }
        String msg = ConfigEnvironment.getErrorMessage("MQJMS1069");
        IllegalStateException traceRet1 = new IllegalStateException(msg);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "recover()", traceRet1);
        }
        throw traceRet1;
    }

    public ProviderSession getSession() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "getSession()", "getter", this.session);
        }
        return this.session;
    }

    public boolean isStarted() {
        boolean traceRet1 = this.session.isStarted();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "isStarted()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public boolean isStopped() {
        boolean traceRet1 = this.session.isStopped();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "isStopped()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void start() throws SessionClosedException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "start()");
        }
        super.start();
        this.session.start();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "start()");
        }
    }

    public void stop() throws SessionClosedException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "stop()");
        }
        super.stop();
        this.session.stop();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "stop()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQXASession", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQXASession.java, jmscc.wmq.v6, k701, k701-112-140304  1.28.1.3 12/12/14 14:16:34");
        }
    }
}

