/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.jmqi.JmqiXAResource;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderSession;
import com.ibm.msg.client.provider.ProviderXAConnection;
import com.ibm.msg.client.provider.ProviderXASession;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.base.internal.MQXAQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQXASession;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;

public class MQXAConnection
extends MQConnection
implements ProviderXAConnection {
    private static final long serialVersionUID = 3871567461900448615L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQXAConnection.java, jmscc.wmq.v6, k701, k701-112-140304 1.31.1.2 10/11/29 06:41:11";

    public MQXAConnection(String username, String password, JmsPropertyContext connectionProps) throws JMSException {
        super(username, password, connectionProps);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXAConnection", "<init>(String,String,JmsPropertyContext)", new Object[]{username, password == null ? password : "********", connectionProps});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXAConnection", "<init>(String,String,JmsPropertyContext)");
        }
    }

    public ProviderXASession createXASession(JmsPropertyContext properties) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXAConnection", "createXASession(JmsPropertyContext)", new Object[]{properties});
        }
        MQSession ts = null;
        try {
            ts = (MQSession)super.createSessionInternal(true, 0, 1);
            MQQueueManager qm = ts.getQM();
            MQXAQueueManager xaqm = new MQXAQueueManager(qm);
            JmqiXAResource xar = xaqm.getXAResource();
            MQXASession xats = new MQXASession((MQConnection)this, qm, ts, xar);
            xats.setPropertyContext(properties);
            xats.setDistTransactionMode(1);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXAConnection", "createXASession(JmsPropertyContext)", xats);
            }
            return xats;
        }
        catch (XAException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXAConnection", "createXASession(JmsPropertyContext)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1068");
            je.setLinkedException((Exception)e);
            if (ts != null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Disabling XA transaction mode on MQSession", null);
                }
                ts.setDistTransactionMode(0);
            } else if (Trace.isOn) {
                Trace.traceData(this, "MQSession is null, unable to disable XA transaction mode.", null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXAConnection", "createXASession(JmsPropertyContext)", je);
            }
            throw je;
        }
    }

    public ProviderSession createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXAConnection", "createSession(boolean,int)", new Object[]{transacted, new Integer(acknowledgeMode)});
        }
        ProviderSession traceRet1 = super.createSessionInternal(transacted, acknowledgeMode, 0);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQXAConnection", "createSession(boolean,int)", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQXAConnection", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQXAConnection.java, jmscc.wmq.v6, k701, k701-112-140304  1.31.1.2 10/11/29 06:41:11");
        }
    }
}

