/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription;
import javax.jms.JMSException;

abstract class MQSubscriptionEngine {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQSubscriptionEngine.java, jmscc.wmq.v6, k701, k701-112-140304 1.24.1.1 09/08/17 08:14:37";
    private static final String CLASSNAME = "MQSubscriptionEngine";
    static final int NON_DURABLE = 0;
    static final int DURABLE = 1;
    protected MQConnection connection = null;
    protected static final int DEFAULT_BROKER_TIMEOUT = 120000;

    public MQSubscriptionEngine(MQConnection connection) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "<init>(MQConnection)", new Object[]{connection});
        }
        this.connection = connection;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "<init>(MQConnection)");
        }
    }

    public abstract MQSubscription openSubscription(MQSession var1, WMQDestination var2, String var3, boolean var4, boolean var5, String var6) throws JMSException;

    public abstract void closeSubscription(MQSubscription var1) throws JMSException;

    public abstract MQSubscription openDurableSubscription(MQSession var1, WMQDestination var2, String var3, boolean var4, boolean var5, String var6, String var7) throws JMSException;

    public abstract void closeDurableSubscription(MQSubscription var1) throws JMSException;

    public abstract void durableUnsubscribe(MQSession var1, String var2) throws JMSException;

    public abstract void close();

    public final MQConnection getMQConnection() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "getMQConnection()", "getter", this.connection);
        }
        return this.connection;
    }

    static String validateQueueName(String queueName, int durability) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "validateQueueName(String,int)", new Object[]{queueName, new Integer(durability)});
        }
        String ret = null;
        if (queueName.trim().equals("")) {
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "queueName is blank; reverting to MQJMSv1 approach", null);
            }
            ret = durability == 0 ? "SYSTEM.JMS.ND.*" : "SYSTEM.JMS.D.*";
        } else {
            if (durability == 0 && !queueName.startsWith("SYSTEM.JMS.ND.") || durability == 1 && !queueName.startsWith("SYSTEM.JMS.D.")) {
                JMSException je = ConfigEnvironment.newException("MQJMS3021", queueName);
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "validateQueueName(String,int)", je);
                }
                throw je;
            }
            ret = queueName;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "validateQueueName(String,int)", (Object)ret);
        }
        return ret;
    }

    protected MQQueue openSubscriberQueue(MQSession mqs, String queueName, boolean sharedQueue, boolean durable, int fiqBehaviour) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "openSubscriberQueue(MQSession,String,boolean,boolean,int)", new Object[]{mqs, queueName, sharedQueue, durable, new Integer(fiqBehaviour)});
        }
        MQQueue subscriberQueue = null;
        int openOptions = 161;
        if (this.connection.getSparseSubscriptions()) {
            openOptions |= 8;
        }
        if (fiqBehaviour == 1) {
            openOptions |= 0x2000;
        }
        String queuePrefix = durable ? "SYSTEM.JMS.D." : "SYSTEM.JMS.ND.";
        if (queueName.trim().equals("") && !sharedQueue) {
            queueName = durable ? "SYSTEM.JMS.D.*" : "SYSTEM.JMS.ND.*";
        } else if (!queueName.startsWith(queuePrefix)) {
            JMSException je = ConfigEnvironment.newException("MQJMS3021", queueName);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "openSubscriberQueue(MQSession,String,boolean,boolean,int)", je, 1);
            }
            throw je;
        }
        try {
            if (queueName.endsWith("*") && !sharedQueue) {
                if (Trace.isOn) {
                    Trace.traceData(this, "opening new non-shared subscriber queue", null);
                }
                subscriberQueue = mqs.getQM().accessQueue("SYSTEM.JMS.MODEL.QUEUE", openOptions, null, queueName, null);
                queueName = subscriberQueue.name;
                if (Trace.isOn) {
                    Trace.traceData(this, "Using non-shared queue approach.", null);
                    Trace.traceData(this, "Model:  SYSTEM.JMS.MODEL.QUEUE", null);
                    Trace.traceData(this, "Prefix: " + queuePrefix, null);
                    Trace.traceData(this, "QName:  " + queueName, null);
                }
            } else if (sharedQueue) {
                subscriberQueue = mqs.getQM().accessQueue(queueName, openOptions);
                queueName = subscriberQueue.name;
                if (Trace.isOn) {
                    Trace.traceData(this, "Using shared queue approach.", null);
                    Trace.traceData(this, "Prefix: " + queuePrefix, null);
                    Trace.traceData(this, "QName:  " + queueName, null);
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "Must be re-opening a non-shared queue for an existing subscription", null);
                }
                subscriberQueue = mqs.getQM().accessQueue(queueName, openOptions);
                queueName = subscriberQueue.name;
                if (Trace.isOn) {
                    Trace.traceData(this, "Using non-shared queue approach.", null);
                    Trace.traceData(this, "Prefix: " + queuePrefix, null);
                    Trace.traceData(this, "QName:  " + queueName, null);
                }
            }
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "openSubscriberQueue(MQSession,String,boolean,boolean,int)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS2008", queueName);
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "openSubscriberQueue(MQSession,String,boolean,boolean,int)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "openSubscriberQueue(MQSession,String,boolean,boolean,int)", subscriberQueue);
        }
        return subscriberQueue;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQSubscriptionEngine.java, jmscc.wmq.v6, k701, k701-112-140304  1.24.1.1 09/08/17 08:14:37");
        }
    }
}

