/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.disthub2.impl.matching.selector.MatchParser;
import com.ibm.disthub2.impl.matching.selector.Resolver;
import com.ibm.disthub2.impl.matching.selector.Selector;
import com.ibm.disthub2.impl.matching.selector.Transformer;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSResolver;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import javax.jms.JMSException;

abstract class MQSubscription {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#)  com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQSubscription.java, jmscc.wmq.v6, k701, k701-112-140304 1.23.1.1 09/08/17 08:14:25";
    private MQSubscriptionEngine subscriptionEngine;
    private boolean durable;
    private boolean sharedQueue;
    private String qmgrName;
    private String clientId;
    private String subName;
    private String topic;
    private WMQDestination mqTopic;
    private String selector;
    private String filter = null;
    private boolean noLocal;
    private String queueName;
    private byte[] correlationId;
    private MQSession session;
    private MQQueue subscriberQueue;
    private boolean closed = false;

    protected MQSubscription(MQSubscriptionEngine subscriptionEngine) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "<init>(MQSubscriptionEngine)", new Object[]{subscriptionEngine});
        }
        this.subscriptionEngine = subscriptionEngine;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "<init>(MQSubscriptionEngine)");
        }
    }

    protected MQSubscription(MQSubscriptionEngine subscriptionEngine, MQSession session, boolean durable, boolean sharedQueue, String qmgrName, String clientId, String subName, WMQDestination topic, String selector, boolean noLocal, String queueName, MQQueue subscriberQueue, byte[] correlationId) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "<init>(MQSubscriptionEngine,MQSession,boolean,boolean,String,String,String,WMQDestination,String,boolean,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,byte [ ])", new Object[]{subscriptionEngine, session, durable, sharedQueue, qmgrName, clientId, subName, topic, selector, noLocal, queueName, subscriberQueue, correlationId});
        }
        this.subscriptionEngine = subscriptionEngine;
        this.session = session;
        this.durable = durable;
        this.sharedQueue = sharedQueue;
        this.qmgrName = qmgrName;
        this.clientId = clientId;
        this.subName = subName;
        this.topic = topic != null ? topic.getName() : null;
        this.mqTopic = topic;
        this.noLocal = noLocal;
        this.queueName = queueName;
        this.subscriberQueue = subscriberQueue;
        if (correlationId == null) {
            this.correlationId = null;
        } else {
            this.correlationId = new byte[correlationId.length];
            System.arraycopy(correlationId, 0, this.correlationId, 0, correlationId.length);
        }
        this.setSelector(selector);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "<init>(MQSubscriptionEngine,MQSession,boolean,boolean,String,String,String,WMQDestination,String,boolean,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,byte [ ])");
        }
    }

    protected final MQSession getMQSession() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getMQSession()", "getter", this.session);
        }
        return this.session;
    }

    protected void setDurable(boolean durable) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setDurable(boolean)", "setter", durable);
        }
        this.durable = durable;
    }

    protected boolean isDurable() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "isDurable()", "getter", this.durable);
        }
        return this.durable;
    }

    protected void setSharedQueue(boolean sharedQueue) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setSharedQueue(boolean)", "setter", sharedQueue);
        }
        this.sharedQueue = sharedQueue;
    }

    protected boolean isSharedQueue() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "isSharedQueue()", "getter", this.sharedQueue);
        }
        return this.sharedQueue;
    }

    protected void setQmgrName(String qmgrName) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setQmgrName(String)", "setter", qmgrName);
        }
        this.qmgrName = qmgrName;
    }

    protected String getQmgrName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getQmgrName()", "getter", this.qmgrName);
        }
        return this.qmgrName;
    }

    protected final WMQDestination getMQTopic() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getMQTopic()", "getter", this.mqTopic);
        }
        return this.mqTopic;
    }

    protected void setMQTopic(WMQDestination newMQTopic) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setMQTopic(WMQDestination)", "setter", newMQTopic);
        }
        this.mqTopic = newMQTopic;
        if (this.topic == null && Trace.isOn) {
            Trace.traceData(this, "New MQTopic set in subscription. TopicName still null", null);
        }
    }

    protected void setClientId(String clientId) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setClientId(String)", "setter", clientId);
        }
        this.clientId = clientId;
    }

    protected String getClientId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getClientId()", "getter", this.clientId);
        }
        return this.clientId;
    }

    protected void setSubName(String subName) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setSubName(String)", "setter", subName);
        }
        this.subName = subName;
    }

    protected String getSubName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getSubName()", "getter", this.subName);
        }
        return this.subName;
    }

    protected void setTopic(String topic) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setTopic(String)", "setter", topic);
        }
        this.topic = topic;
    }

    protected String getTopic() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getTopic()", "getter", this.topic);
        }
        return this.topic;
    }

    protected void setSelector(String selector) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setSelector(String)", new Object[]{selector});
        }
        this.selector = selector;
        if (selector == null) {
            this.filter = null;
        } else {
            int connMsgSelection;
            try {
                connMsgSelection = this.session.getConnectionMsgSelection();
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setSelector(String)", je, 1);
                }
                RuntimeException traceRet1 = new RuntimeException(ConfigEnvironment.getErrorMessage("MQJMS1016"));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setSelector(String)", traceRet1);
                }
                throw traceRet1;
            }
            if (connMsgSelection == 1) {
                String rawSelectorProperty = "com.ibm.mq.jms.pubsub.rawBrokerSelectors";
                PropertyStore.register(rawSelectorProperty, "");
                String rawSelector = PropertyStore.getStringProperty(rawSelectorProperty);
                if (rawSelector != "") {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Passing unparsed raw selector to the broker - BYPASSING VALIDATION", null);
                    }
                    this.filter = selector;
                } else {
                    try {
                        JMSResolver jmsResolver = new JMSResolver();
                        MatchParser matchParser = MatchParser.prime(null, (String)selector, (boolean)true);
                        Selector selectorTree = matchParser.getSelector();
                        if (selectorTree.type == 2) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "Reverting to Client side filtering due to SyntaxException", null);
                            }
                            this.filter = null;
                        } else {
                            Selector filterTree = Transformer.resolve((Selector)selectorTree, (Resolver)jmsResolver, null);
                            this.filter = filterTree.toString();
                            if (Trace.isOn) {
                                Trace.traceData(this, "Filter is " + this.filter, null);
                            }
                            if (this.filter != null && this.filter.indexOf("Root.MQRFH2.jms.Dlv") >= 0) {
                                int index = 0;
                                index = this.filter.indexOf("'NON_PERSISTENT'");
                                if (index > 0) {
                                    this.filter = this.filter.substring(0, index) + 1 + this.filter.substring(index + 16);
                                } else {
                                    index = this.filter.indexOf("'PERSISTENT'");
                                    if (index > 0) {
                                        this.filter = this.filter.substring(0, index) + 2 + this.filter.substring(index + 12);
                                    }
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Adjusted filter is " + this.filter, null);
                                }
                            }
                            if (this.filter.indexOf("JMS_ERROR") >= 0) {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Reverting to Client side filtering", null);
                                }
                                this.filter = null;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setSelector(String)", e, 2);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Reverting to Client side filtering due to SyntaxException", null);
                        }
                        this.filter = null;
                    }
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setSelector(String)");
        }
    }

    protected String getSelector() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getSelector()", "getter", this.selector);
        }
        return this.selector;
    }

    protected String getFilter() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getFilter()", "getter", this.filter);
        }
        return this.filter;
    }

    protected void setNoLocal(boolean noLocal) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setNoLocal(boolean)", "setter", noLocal);
        }
        this.noLocal = noLocal;
    }

    protected boolean getNoLocal() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getNoLocal()", "getter", this.noLocal);
        }
        return this.noLocal;
    }

    protected void setQueueName(String queueName) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setQueueName(String)", "setter", queueName);
        }
        this.queueName = queueName;
    }

    protected String getQueueName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getQueueName()", "getter", this.queueName);
        }
        return this.queueName;
    }

    protected void setSubscriberQueue(MQQueue subscriberQueue) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setSubscriberQueue(com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", "setter", subscriberQueue);
        }
        this.subscriberQueue = subscriberQueue;
    }

    protected MQQueue getSubscriberQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getSubscriberQueue()");
        }
        if (this.subscriberQueue == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "subscriber queue is null!", null);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getSubscriberQueue()", null, 1);
            }
            return null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getSubscriberQueue()", this.subscriberQueue, 2);
        }
        return this.subscriberQueue;
    }

    protected void setCorrelationId(byte[] correlationId) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "setCorrelationId(byte [ ])", "setter", correlationId);
        }
        if (correlationId == null) {
            this.correlationId = null;
        } else {
            this.correlationId = new byte[correlationId.length];
            System.arraycopy(correlationId, 0, this.correlationId, 0, correlationId.length);
        }
    }

    protected byte[] getCorrelationId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "getCorrelationId()", "getter", this.correlationId);
        }
        return this.correlationId;
    }

    protected boolean isClosed() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "isClosed()", "getter", this.closed);
        }
        return this.closed;
    }

    protected void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "close()");
        }
        try {
            if (this.isDurable()) {
                this.subscriptionEngine.closeDurableSubscription(this);
            } else {
                this.subscriptionEngine.closeSubscription(this);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "close()", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "close()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "close()");
        }
    }

    public String toString() {
        String traceRet1 = new String("\nsubName       : " + this.subName + "\nTopic         : " + this.topic + "\nQueue Manager : " + this.qmgrName + "\nQueue Name    : " + this.queueName + "\nSelector      : " + this.selector + "\nnoLocal?      : " + (this.noLocal ? "Y" : "N") + "\nClient Id     : " + this.clientId + "\ncorrelationId : " + Utils.bytesToHex(this.correlationId) + "\nsharedQ?      : " + (this.sharedQueue ? "Y" : "N") + "\ndurable?      : " + (this.durable ? "Y" : "N"));
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQSubscription.java, jmscc.wmq.v6, k701, k701-112-140304  1.23.1.1 09/08/17 08:14:25");
        }
    }
}

