/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;

public class MQSubEntry {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQSubEntry.java, jmscc.wmq.v6, k701, k701-112-140304 1.17.1.1 09/08/17 08:14:16";
    static final String SIGNATURE = "MQJMS_PS_SUBENTRY_v2";
    static final String v1SIGNATURE = "MQJMS_PS_ADMIN_ENTRY";
    private boolean validity = false;
    private String name = null;
    private String topic = null;
    private String qName = null;
    private String selector = null;
    private boolean noLocal = false;
    private byte[] statusMgrId;
    private byte[] subscriberId;
    private boolean shared_queue = false;
    private int version = 2;
    private char subscriberState = (char)117;

    MQSubEntry(String name, String topic, String qname, String sel, boolean noLocal, byte[] statusMgrId, boolean shared_queue) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "<init>(String,String,String,String,boolean,byte [ ],boolean)", new Object[]{name, topic, qname, sel, noLocal, statusMgrId, shared_queue});
        }
        this.name = name;
        this.topic = topic;
        this.qName = qname;
        this.selector = sel;
        this.noLocal = noLocal;
        this.statusMgrId = statusMgrId;
        this.shared_queue = shared_queue;
        this.subscriberState = (char)117;
        this.validity = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "<init>(String,String,String,String,boolean,byte [ ],boolean)");
        }
    }

    MQSubEntry(String name, String topic, String qname, byte[] statusMgrId, boolean shared_queue) {
        this(name, topic, qname, null, false, statusMgrId, shared_queue);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "<init>(String,String,String,byte [ ],boolean)", new Object[]{name, topic, qname, statusMgrId, shared_queue});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "<init>(String,String,String,byte [ ],boolean)");
        }
    }

    MQSubEntry(MQMessage m) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "<init>(MQMessage)", new Object[]{m});
        }
        try {
            String sig = m.readStringOfByteLength(SIGNATURE.length());
            if (!sig.equals(SIGNATURE)) {
                if (sig.equals(v1SIGNATURE)) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "v1 style subscriber entry found on DurSubAdmin queue.", null);
                    }
                    this.version = 1;
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Non-DurSubEntry message on DurSubAdmin queue!", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "<init>(MQMessage)", 1);
                    }
                    return;
                }
            }
            int l = m.readInt();
            this.name = m.readStringOfByteLength(l);
            l = m.readInt();
            this.topic = m.readStringOfByteLength(l);
            l = m.readInt();
            this.qName = m.readStringOfByteLength(l);
            l = m.readInt();
            if (l > 0) {
                this.selector = m.readStringOfByteLength(l);
            }
            boolean bl = this.noLocal = m.readChar() == 'y';
            if (this.version == 2) {
                this.shared_queue = m.readChar() == 'y';
                this.subscriberState = m.readChar();
                this.statusMgrId = m.correlationId;
                this.subscriberId = m.messageId;
            }
            this.validity = true;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "<init>(MQMessage)", e);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Could not create MQSubEntry", null);
            }
            this.validity = false;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "<init>(MQMessage)", 2);
        }
    }

    public void setName(String name) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "setName(String)", "setter", name);
        }
        this.name = name;
    }

    public String getName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "getName()", "getter", this.name);
        }
        return this.name;
    }

    void setTopic(String top) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "setTopic(String)", "setter", top);
        }
        this.topic = top;
    }

    public String getTopic() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "getTopic()", "getter", this.topic);
        }
        return this.topic;
    }

    void setQName(String qname) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "setQName(String)", "setter", qname);
        }
        this.qName = qname;
    }

    public String getQName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "getQName()", "getter", this.qName);
        }
        return this.qName;
    }

    void setSelector(String sel) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "setSelector(String)", "setter", sel);
        }
        this.selector = sel;
    }

    public String getSelector() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "getSelector()", "getter", this.selector);
        }
        return this.selector;
    }

    void setNoLocal(boolean nl) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "setNoLocal(boolean)", "setter", nl);
        }
        this.noLocal = nl;
    }

    public boolean getNoLocal() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "getNoLocal()", "getter", this.noLocal);
        }
        return this.noLocal;
    }

    void setSubscriberId(byte[] subId) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "setSubscriberId(byte [ ])", "setter", subId);
        }
        this.subscriberId = subId;
    }

    byte[] getSubscriberId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "getSubscriberId()", "getter", this.subscriberId);
        }
        return this.subscriberId;
    }

    void setStatusMgrId(byte[] smId) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "setStatusMgrId(byte [ ])", "setter", smId);
        }
        this.statusMgrId = smId;
    }

    byte[] getStatusMgrId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "getStatusMgrId()", "getter", this.statusMgrId);
        }
        return this.statusMgrId;
    }

    void setSharedQueue(boolean sq) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "setSharedQueue(boolean)", "setter", sq);
        }
        this.shared_queue = sq;
    }

    boolean getSharedQueue() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "getSharedQueue()", "getter", this.shared_queue);
        }
        return this.shared_queue;
    }

    void setSubscriberState(char st) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "setSubscriberState(char)", "setter", new Character(st));
        }
        this.subscriberState = st;
    }

    char getSubscriberState() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "getSubscriberState()", "getter", new Character(this.subscriberState));
        }
        return this.subscriberState;
    }

    void setVersion(int v) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "setVersion(int)", "setter", new Integer(v));
        }
        this.version = v;
    }

    int getVersion() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "getVersion()", "getter", new Integer(this.version));
        }
        return this.version;
    }

    boolean isValid() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "isValid()", "getter", this.validity);
        }
        return this.validity;
    }

    MQMessage toMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "toMessage()");
        }
        MQMessage ret = new MQMessage();
        try {
            ret.writeString(SIGNATURE);
            ret.writeInt(this.name.length());
            ret.writeString(this.name);
            ret.writeInt(this.topic.length());
            ret.writeString(this.topic);
            ret.writeInt(this.qName.length());
            ret.writeString(this.qName);
            if (this.selector == null) {
                ret.writeInt(0);
            } else {
                ret.writeInt(this.selector.length());
                ret.writeString(this.selector);
            }
            ret.writeChar(this.noLocal ? 121 : 110);
            ret.writeChar(this.shared_queue ? 121 : 110);
            ret.writeChar(this.subscriberState);
            if (this.subscriberId != null) {
                ret.messageId = this.subscriberId;
            }
            if (this.statusMgrId != null) {
                ret.correlationId = this.statusMgrId;
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "toMessage()", e);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Could not convert MQSubEntry to MQMessage", null);
            }
            ret = null;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "toMessage()", (Object)ret);
        }
        return ret;
    }

    public String toString() {
        String traceRet1 = "\nName         : " + this.name + "\nTopic        : " + this.topic + "\nQueue Name   : " + this.qName + "\nSelector     : " + this.selector + "\nnoLocal?     : " + (this.noLocal ? "Y" : "N") + "\nsubscriberId : " + Utils.bytesToHex(this.subscriberId) + "\nsharedQ?     : " + (this.shared_queue ? "Y" : "N");
        return traceRet1;
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof MQSubEntry) {
            MQSubEntry entry = (MQSubEntry)obj;
            ret = this.selector == null ? this.name.equals(entry.name) && this.topic.equals(entry.topic) && entry.selector == null : this.name.equals(entry.name) && this.topic.equals(entry.topic) && this.selector.equals(entry.selector);
        }
        return ret;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQSubEntry.java, jmscc.wmq.v6, k701, k701-112-140304  1.17.1.1 09/08/17 08:14:16");
        }
    }
}

