/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQC;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.BrokerConnectionInfo;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry;
import com.ibm.msg.client.wmq.v6.jms.internal.SubscriptionHelper;
import java.util.Vector;
import javax.jms.JMSException;

public class MQSubAdmin {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQSubAdmin.java, jmscc.wmq.v6, k701, k701-112-140304 1.22.1.1 09/08/17 08:14:04";
    private MQQueue adminQueue = null;
    private int dbSize = -1;

    public MQSubAdmin(MQQueueManager qm) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "<init>(MQQueueManager)", new Object[]{qm});
        }
        int MAXRETRIES = 20;
        int MAXWAIT = 5000;
        int attempt = 0;
        block7: while (true) {
            try {
                this.adminQueue = qm.accessQueue("SYSTEM.JMS.ADMIN.QUEUE", 8252);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "<init>(MQQueueManager)", e, 1);
                }
                switch (e.reasonCode) {
                    case 2042: {
                        if (++attempt < 20) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "admin queue locked, suppressing exception and retrying", null);
                            }
                            try {
                                Thread.sleep((long)(100.0 + 5000.0 * Math.random()));
                            }
                            catch (InterruptedException ie) {
                                if (!Trace.isOn) continue block7;
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "<init>(MQQueueManager)", ie, 2);
                            }
                            continue block7;
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "<init>(MQQueueManager)", je, 1);
                        }
                        throw je;
                    }
                    default: {
                        JMSException je = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "<init>(MQQueueManager)", je, 2);
                        }
                        throw je;
                    }
                }
                continue;
            }
            break;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "Obtaining the admin queue lock required " + attempt + " retries", null);
        }
        this.dbSize = this.getNumRecords();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "<init>(MQQueueManager)");
        }
    }

    void clearAll() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "clearAll()");
        }
        MQGetMessageOptions gmo = new MQGetMessageOptions();
        boolean carryOn = true;
        while (carryOn) {
            try {
                MQMessage msg = new MQMessage();
                this.adminQueue.get(msg, gmo);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "clearAll()", e);
                }
                carryOn = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "clearAll()");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "close()");
        }
        try {
            if (this.adminQueue != null) {
                this.adminQueue.close();
                this.adminQueue = null;
            }
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "close()", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS2000");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "close()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "close()");
        }
    }

    int getNumRecords() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "getNumRecords()");
        }
        int i = -1;
        try {
            i = this.adminQueue.getCurrentDepth();
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "getNumRecords()", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS2011");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "getNumRecords()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "getNumRecords()", new Integer(i));
        }
        return i;
    }

    public Vector getAll() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "getAll()");
        }
        Vector<MQSubEntry> retVec = new Vector<MQSubEntry>();
        MQSubEntry ae = null;
        Object ret = null;
        MQGetMessageOptions gmo = new MQGetMessageOptions();
        gmo.options = 16;
        boolean carryOn = true;
        while (carryOn) {
            try {
                MQMessage msg = new MQMessage();
                this.adminQueue.get(msg, gmo);
                ae = new MQSubEntry(msg);
                retVec.addElement(ae);
                gmo.options = 32;
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "getAll()", e);
                }
                carryOn = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "getAll()", retVec);
        }
        return retVec;
    }

    boolean contains(String key) throws JMSException {
        boolean traceRet1;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "contains(String)", new Object[]{key});
        }
        boolean bl = traceRet1 = this.get(key) != null;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "contains(String)", traceRet1);
        }
        return traceRet1;
    }

    MQSubEntry get(String key) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "get(String)", new Object[]{key});
        }
        MQSubEntry traceRet1 = this.get(key, null, null, false);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "get(String)", traceRet1);
        }
        return traceRet1;
    }

    MQSubEntry get(String key, byte[] subscriberId, byte[] jvmReferenceId, boolean getNext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "get(String,byte [ ],byte [ ],boolean)", new Object[]{key, subscriberId, jvmReferenceId, getNext});
        }
        MQSubEntry ae = null;
        MQSubEntry ret = null;
        MQGetMessageOptions gmo = new MQGetMessageOptions();
        gmo.options = getNext ? 32 : 16;
        boolean carryOn = true;
        while (carryOn) {
            try {
                MQMessage msg = new MQMessage();
                if (subscriberId != null) {
                    msg.messageId = subscriberId;
                }
                if (jvmReferenceId != null) {
                    msg.correlationId = jvmReferenceId;
                }
                this.adminQueue.get(msg, gmo);
                ae = new MQSubEntry(msg);
                if (key == null && ae.isValid()) {
                    ret = ae;
                    carryOn = false;
                    continue;
                }
                if (key != null && ae.isValid() && ae.getName().equals(key)) {
                    ret = ae;
                    carryOn = false;
                    continue;
                }
                gmo.options = 32;
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "get(String,byte [ ],byte [ ],boolean)", e);
                }
                carryOn = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "get(String,byte [ ],byte [ ],boolean)", ret);
        }
        return ret;
    }

    MQSubEntry getResolved(MQQueueManager qm, BrokerConnectionInfo brk, String key, byte[] jvmRefId, boolean getNext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "getResolved(MQQueueManager,BrokerConnectionInfo,String,byte [ ],boolean)", new Object[]{qm, brk, key, jvmRefId, getNext});
        }
        MQSubEntry subEntry1 = null;
        MQSubEntry subEntry2 = null;
        subEntry1 = this.get(key, null, jvmRefId, getNext);
        if (subEntry1 != null && subEntry1.getVersion() > 1) {
            if (Trace.isOn) {
                Trace.traceData(this, "Matching subscriber found. Checking for a second record.", null);
            }
            subEntry2 = this.get(null, subEntry1.getSubscriberId(), null, true);
        }
        if (subEntry2 != null) {
            if (Trace.isOn) {
                Trace.traceData(this, "Second record found: earlier problem must have occurred.", null);
            }
            if (this.get(null, subEntry1.getSubscriberId(), null, false) == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "getResolved ERROR: couldn't reset browse cursor position", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3013");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "getResolved(MQQueueManager,BrokerConnectionInfo,String,byte [ ],boolean)", je);
                }
                throw je;
            }
            if (subEntry1.getSubscriberState() == 't' || subEntry2.getSubscriberState() == 't') {
                if (Trace.isOn) {
                    Trace.traceData(this, "Trying to resolve problem detected with earlier create or unsubscribe.", null);
                }
                SubscriptionHelper.deleteSubscriber(qm, brk, subEntry1);
                this.remove(subEntry1);
                this.remove(subEntry2);
                if (jvmRefId != null) {
                    subEntry1.setSubscriberState('i');
                } else {
                    subEntry1 = null;
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "Trying to resolve problem detected with earlier re-create or close.", null);
                }
                MQSubEntry newEntry = subEntry1;
                subEntry1.setSubscriberState('i');
                subEntry1.setStatusMgrId(MQC.MQCI_NONE);
                this.remove(subEntry1);
                this.add(newEntry, false);
                this.remove(subEntry2);
                subEntry1 = newEntry;
            }
        } else if (subEntry1 != null && subEntry1.getSubscriberState() == 't') {
            block23: {
                if (Trace.isOn) {
                    Trace.traceData(this, "Trying to resolve problem detected with earlier create or unsubscribe.", null);
                }
                try {
                    SubscriptionHelper.deleteSubscriber(qm, brk, subEntry1);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "getResolved(MQQueueManager,BrokerConnectionInfo,String,byte [ ],boolean)", je);
                    }
                    if (!Trace.isOn) break block23;
                    Trace.traceData(this, "cleanup ERROR: deleteSubscriber encountered error ", null);
                }
            }
            this.remove(subEntry1);
            if (jvmRefId != null) {
                subEntry1.setSubscriberState('i');
            } else {
                subEntry1 = null;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "getResolved(MQQueueManager,BrokerConnectionInfo,String,byte [ ],boolean)", subEntry1);
        }
        return subEntry1;
    }

    public MQSubEntry remove(MQSubEntry subEntry) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "remove(MQSubEntry)", new Object[]{subEntry});
        }
        MQSubEntry ae = null;
        MQSubEntry ret = null;
        byte[] subscriberId = subEntry.getSubscriberId();
        String key = subEntry.getName();
        MQGetMessageOptions gmo = new MQGetMessageOptions();
        if (subscriberId == null) {
            gmo.options = 16;
        }
        boolean carryOn = true;
        while (carryOn) {
            try {
                MQMessage msg = new MQMessage();
                if (subscriberId != null) {
                    msg.messageId = subscriberId;
                }
                this.adminQueue.get(msg, gmo);
                ae = new MQSubEntry(msg);
                if (subscriberId != null) {
                    ret = ae;
                    carryOn = false;
                    continue;
                }
                if (ae.isValid() && ae.getName().equals(key)) {
                    ret = ae;
                    gmo.options = 256;
                    MQMessage delmsg = new MQMessage();
                    this.adminQueue.get(delmsg, gmo);
                    carryOn = false;
                    continue;
                }
                gmo.options = 32;
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "remove(MQSubEntry)", e);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3013");
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.traceData(this, "cannot remove msg!", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "remove(MQSubEntry)", je);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "remove(MQSubEntry)", ret);
        }
        return ret;
    }

    public boolean removeByQueueName(String qName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "removeByQueueName(String)", new Object[]{qName});
        }
        boolean ret = false;
        MQSubEntry ae = null;
        MQGetMessageOptions gmo = new MQGetMessageOptions();
        gmo.options = 16;
        boolean carryOn = true;
        while (carryOn) {
            try {
                MQMessage msg = new MQMessage();
                this.adminQueue.get(msg, gmo);
                ae = new MQSubEntry(msg);
                if (ae.isValid() && ae.getQName().trim().equals(qName)) {
                    gmo.options = 256;
                    MQMessage delmsg = new MQMessage();
                    this.adminQueue.get(delmsg, gmo);
                    carryOn = false;
                    ret = true;
                    continue;
                }
                gmo.options = 32;
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "removeByQueueName(String)", e);
                }
                carryOn = false;
                ret = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "removeByQueueName(String)", ret);
        }
        return ret;
    }

    public byte[] add(MQSubEntry adminEntry, boolean checkExists) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "add(MQSubEntry,boolean)", new Object[]{adminEntry, checkExists});
        }
        byte[] subscriberId = null;
        if (checkExists && this.contains(adminEntry.getName())) {
            if (Trace.isOn) {
                Trace.traceData(this, "entry already exists!", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3013");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "add(MQSubEntry,boolean)", je, 1);
            }
            throw je;
        }
        MQMessage m = adminEntry.toMessage();
        if (Trace.isOn) {
            Trace.traceData(this, "MQPUT with messageId: ", (Object)m.messageId);
        }
        try {
            this.adminQueue.put(m, new MQPutMessageOptions());
            subscriberId = m.messageId;
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "add(MQSubEntry,boolean)", e);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "unable to MQPUT new entry", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3013");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "add(MQSubEntry,boolean)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "add(MQSubEntry,boolean)", subscriberId);
        }
        return subscriberId;
    }

    public byte[] add(MQSubEntry adminEntry) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "add(MQSubEntry)", new Object[]{adminEntry});
        }
        byte[] traceRet1 = this.add(adminEntry, true);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "add(MQSubEntry)", traceRet1);
        }
        return traceRet1;
    }

    public MQQueue checkInactive(MQQueueManager qm, MQSubEntry adminEntry) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "checkInactive(MQQueueManager,MQSubEntry)", new Object[]{qm, adminEntry});
        }
        MQQueue subQ = null;
        boolean subInactive = false;
        if (adminEntry.getSubscriberState() == 'i') {
            subInactive = true;
        } else if (adminEntry.getSubscriberState() != 'u') {
            if (Trace.isOn) {
                Trace.traceData(this, "checkInactive: state is neither unknown or inactive!", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3005");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "checkInactive(MQQueueManager,MQSubEntry)", je, 1);
            }
            throw je;
        }
        try {
            if (adminEntry.getSharedQueue() && !subInactive) {
                int openOptions = 8202;
                MQQueue statusQueue = qm.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", openOptions);
                MQMessage jvmMessage = new MQMessage();
                jvmMessage.messageId = adminEntry.getStatusMgrId();
                MQGetMessageOptions gmo = new MQGetMessageOptions();
                gmo.options = 16;
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "attempting MQGET for jvm reference msg.", null);
                    }
                    statusQueue.get(jvmMessage, gmo);
                }
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "checkInactive(MQQueueManager,MQSubEntry)", e, 1);
                    }
                    if (e.reasonCode == 2033) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "shared subscriber assumed active.", null);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS3023");
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "checkInactive(MQQueueManager,MQSubEntry)", je, 2);
                        }
                        throw je;
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "checkInactive(MQQueueManager,MQSubEntry)", e, 3);
                    }
                    throw e;
                }
                statusQueue.close();
            }
            if (Trace.isOn) {
                Trace.traceData(this, "opening subscription queue", null);
            }
            subQ = !adminEntry.getSharedQueue() ? qm.accessQueue(adminEntry.getQName(), 8228) : qm.accessQueue(adminEntry.getQName(), 8193);
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "checkInactive(MQQueueManager,MQSubEntry)", e, 2);
            }
            JMSException je = e.reasonCode == 2042 ? ConfigEnvironment.newException("MQJMS3023") : ConfigEnvironment.newException("MQJMS3005");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "checkInactive(MQQueueManager,MQSubEntry)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "checkInactive(MQQueueManager,MQSubEntry)", subQ);
        }
        return subQ;
    }

    public static byte[] addND(MQQueueManager qm, MQSubEntry adminEntry) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "addND(MQQueueManager,MQSubEntry)", new Object[]{qm, adminEntry});
        }
        MQMessage ndEntry = adminEntry.toMessage();
        try {
            MQQueue statusQueue = qm.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 8208);
            statusQueue.put(ndEntry);
            statusQueue.close();
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "addND(MQQueueManager,MQSubEntry)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3013");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "addND(MQQueueManager,MQSubEntry)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "addND(MQQueueManager,MQSubEntry)", ndEntry.messageId);
        }
        return ndEntry.messageId;
    }

    /*
     * Loose catch block
     */
    public static void removeND(MQQueueManager qm, byte[] subscriberId) throws JMSException {
        block19: {
            MQQueue statusQueue;
            block17: {
                if (Trace.isOn) {
                    Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "removeND(MQQueueManager,byte [ ])", new Object[]{qm, subscriberId});
                }
                statusQueue = null;
                MQMessage ndEntry = new MQMessage();
                ndEntry.messageId = subscriberId;
                try {
                    statusQueue = qm.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 8194);
                    statusQueue.get(ndEntry);
                    statusQueue.close();
                    statusQueue = null;
                    Object var7_4 = null;
                    if (!Trace.isOn) break block17;
                }
                catch (Throwable throwable) {
                    block18: {
                        Object var7_5 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "removeND(MQQueueManager,byte [ ])");
                        }
                        if (statusQueue != null) {
                            try {
                                statusQueue.close();
                            }
                            catch (Exception e) {
                                if (Trace.isOn) {
                                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "removeND(MQQueueManager,byte [ ])", e, 2);
                                }
                                if (!Trace.isOn) break block18;
                                Trace.traceData("MQSubAdmin", "closing statusQueue in finally clause generated exception", null);
                            }
                        }
                    }
                    throw throwable;
                }
                Trace.finallyBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "removeND(MQQueueManager,byte [ ])");
            }
            if (statusQueue != null) {
                try {
                    statusQueue.close();
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "removeND(MQQueueManager,byte [ ])", e, 2);
                    }
                    if (Trace.isOn) {
                        Trace.traceData("MQSubAdmin", "closing statusQueue in finally clause generated exception", null);
                    }
                }
            }
            break block19;
            {
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "removeND(MQQueueManager,byte [ ])", e, 1);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS3013");
                    je.setLinkedException((Exception)((Object)e));
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "removeND(MQQueueManager,byte [ ])", je);
                    }
                    throw je;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "removeND(MQQueueManager,byte [ ])");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQSubAdmin.java, jmscc.wmq.v6, k701, k701-112-140304  1.22.1.1 09/08/17 08:14:04");
        }
    }
}

