/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.mq.jms.SyntaxException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderBytesMessage;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMapMessage;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageConsumer;
import com.ibm.msg.client.provider.ProviderMessageListener;
import com.ibm.msg.client.provider.ProviderMessageProducer;
import com.ibm.msg.client.provider.ProviderMessageReference;
import com.ibm.msg.client.provider.ProviderObjectMessage;
import com.ibm.msg.client.provider.ProviderQueueBrowser;
import com.ibm.msg.client.provider.ProviderSession;
import com.ibm.msg.client.provider.ProviderStreamMessage;
import com.ibm.msg.client.provider.ProviderTextMessage;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyContext;
import com.ibm.msg.client.wmq.common.internal.WMQTemporaryQueue;
import com.ibm.msg.client.wmq.common.internal.WMQTemporaryTopic;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.BrokerConnectionInfo;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSAcknowledgePoint;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSNullMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSStringResources;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSStringResources;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.SessionAsyncHelper;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.TransactionRolledBackException;

public class MQSession
extends WMQPropertyContext
implements ProviderSession,
JMSAcknowledgePoint {
    private static final long serialVersionUID = 5764756656822339804L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQSession.java, jmscc.wmq.v6, k701, k701-112-140304 1.73.1.9 11/07/13 17:06:51";
    private static final int DEFAULT_BROKER_TIMEOUT = 120000;
    protected static final int DEREGISTER_SHAREDQ_SUBSCRIBER = 5;
    protected static final int DEREGISTER_SUBSCRIBER = 3;
    protected static final int DIST_TRAN_NONE = 0;
    protected static final int DIST_TRAN_RRS = 2;
    protected static final int DIST_TRAN_XA = 1;
    protected static final JMSStringResources jmsStrings;
    private static final int MQCA_QSG_NAME = 2040;
    private static final String MQPS_Q_NAME_B = " MQPSQName ";
    private static final String MQPS_STREAM_NAME_B = " MQPSStreamName ";
    private static final String PROBE_01 = "01";
    private static final String PROBE_02 = "02";
    private static final String PROBE_03 = "03";
    private static final String PROBE_04 = "04";
    private static final String PROBE_05 = "05";
    protected static final String PUBLISH_CMD_PREFIX = "MQPSCommand Publish MQPSTopic ";
    protected static final int REGISTER_SHAREDQ_SUBSCRIBER = 4;
    protected static final int REGISTER_SUBSCRIBER = 2;
    private static final int STATE_CLOSED = 2;
    private static final int STATE_STARTED = 1;
    private static final int STATE_STOPPED = 0;
    protected int acknowledgeMode;
    private SessionAsyncHelper asyncHelper;
    protected BrokerConnectionInfo brk;
    protected int brkOptLevel;
    private MQGetMessageOptions brokerReponseGmo;
    private int brokerTimeout;
    private MQQueue cbInputQueue;
    protected int checkInterval;
    private boolean commitRequired;
    private Object commitLock;
    protected MQConnection connection;
    private String deadLetterQueue;
    private int distTransactionMode;
    private boolean ITXSupportChecked;
    private boolean ITXSupported;
    private String lastQueueName;
    private boolean mapNameStyle;
    private Vector messageConsumers;
    private ProviderMessageListener messageListener;
    private boolean calledByAsf;
    private Vector messageProducers;
    private String messageQueueName;
    private JMSServicesMgr mqServices;
    protected String nondur_subscribeQ;
    private boolean optimisticPublication;
    private boolean outcomeNotification;
    protected boolean persistenceFromMD;
    private boolean playNice;
    private int processDuration;
    protected int publishCount;
    protected boolean pubsubInit;
    private MQQueueManager qm;
    private int receiveIsolation;
    protected MQQueue replyQ;
    private String resolvedQmName;
    private String resolvedQSGName;
    protected byte[] responseCorrelId;
    protected int responseInterval;
    protected boolean responseOnCommit;
    protected long responsePutTime;
    protected boolean responseRequested;
    protected byte[] sessionName;
    private int state;
    private Object stateChangeSem;
    protected String SUBSCRIBE_CMD_POSTFIX;
    protected boolean transacted;
    private Object transactionLock;
    public Object brokerResponseLock;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected MQSession(MQConnection connection, boolean transacted, int acknowledgeMode) {
        block20: {
            super(connection);
            this.asyncHelper = null;
            this.brk = new BrokerConnectionInfo(null, null, null);
            this.brokerTimeout = 120000;
            this.cbInputQueue = null;
            this.checkInterval = 0;
            this.commitRequired = false;
            this.commitLock = new Object();
            this.connection = null;
            this.deadLetterQueue = null;
            this.distTransactionMode = 0;
            this.ITXSupportChecked = false;
            this.ITXSupported = false;
            this.lastQueueName = null;
            this.mapNameStyle = true;
            this.messageConsumers = new Vector();
            this.calledByAsf = false;
            this.messageProducers = new Vector();
            this.mqServices = null;
            this.optimisticPublication = false;
            this.outcomeNotification = true;
            this.playNice = false;
            this.processDuration = 0;
            this.publishCount = 0;
            this.pubsubInit = false;
            this.qm = null;
            this.receiveIsolation = 0;
            this.replyQ = null;
            this.resolvedQmName = null;
            this.resolvedQSGName = null;
            this.responseCorrelId = new byte[24];
            this.responseInterval = 0;
            this.responseOnCommit = false;
            this.responsePutTime = 0L;
            this.responseRequested = false;
            this.state = 0;
            this.stateChangeSem = new Object();
            this.transactionLock = new Object();
            this.brokerResponseLock = new Object();
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQConnection,boolean,int)", new Object[]{connection, transacted, new Integer(acknowledgeMode)});
            }
            try {
                int selector;
                this.connection = connection;
                this.transacted = transacted;
                this.acknowledgeMode = acknowledgeMode;
                this.persistenceFromMD = connection != null ? connection.getPersistenceFromMD() : false;
                if (Trace.isOn) {
                    Trace.traceData(this, "Resolving QMName", null);
                }
                if (connection.qm != null) {
                    try {
                        selector = 2015;
                        this.resolvedQmName = connection.qm.getAttributeString(selector, 48).trim();
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQConnection,boolean,int)", e, 1);
                        }
                        this.resolvedQmName = connection.qm.name;
                    }
                } else if (connection.qmgrName != null) {
                    this.resolvedQmName = connection.qmgrName;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Resolving QSGName", null);
                }
                if (connection.qm != null) {
                    try {
                        selector = 2040;
                        this.resolvedQSGName = connection.qm.getAttributeString(selector, 4).trim();
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQConnection,boolean,int)", e, 2);
                        }
                        this.resolvedQSGName = null;
                        if (Trace.isOn) {
                            Trace.traceData(this, "Setting QSGName to null", null);
                        }
                    }
                } else {
                    this.resolvedQSGName = null;
                    if (Trace.isOn) {
                        Trace.traceData(this, "No qm, setting QSGName to null", null);
                    }
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "QSGName set to " + this.resolvedQSGName, null);
                }
            }
            catch (Exception e) {
                if (!Trace.isOn) break block20;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQConnection,boolean,int)", e, 3);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQConnection,boolean,int)");
        }
    }

    protected MQSession(MQConnection connection, MQQueueManager qm, boolean transacted, int acknowledgeMode) throws JMSException {
        block14: {
            int selector;
            this(connection, transacted, acknowledgeMode);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQConnection,MQQueueManager,boolean,int)", new Object[]{connection, qm, transacted, new Integer(acknowledgeMode)});
            }
            this.qm = qm;
            this.connection = connection;
            MQSubscriptionEngine subEngine = this.connection.getSubscriptionEngine();
            this.sessionName = null;
            if (subEngine instanceof MQBrokerSubscriptionEngine) {
                this.sessionName = ((MQBrokerSubscriptionEngine)subEngine).createSessionName(this);
            } else if (subEngine instanceof MQMigrateSubscriptionEngine) {
                this.sessionName = ((MQMigrateSubscriptionEngine)subEngine).createSessionName(this);
            }
            this.brk.controlQ = this.connection.getBrkControlQueue();
            this.brk.streamQ = this.connection.getBrkPubQueue();
            this.brk.qmName = this.connection.getBrkQueueManager();
            this.brkOptLevel = this.connection.getBrkOptLevel();
            this.nondur_subscribeQ = this.connection.getBrkSubQueue();
            this.mapNameStyle = this.connection.getMapNameStyle();
            this.SUBSCRIBE_CMD_POSTFIX = new String(MQPS_STREAM_NAME_B + this.brk.streamQ + MQPS_Q_NAME_B);
            this.responseInterval = this.connection.getPubAckInterval();
            this.checkInterval = this.responseInterval / 2;
            this.receiveIsolation = this.connection.getReceiveIsolation();
            this.processDuration = this.connection.getProcessDuration();
            this.outcomeNotification = this.connection.getOutcomeNotification();
            this.optimisticPublication = this.connection.getOptimisticPublication();
            int openOptions = 1;
            if (connection.getFailIfQuiesce() == 1) {
                openOptions |= 0x2000;
            }
            this.brokerReponseGmo = new MQGetMessageOptions();
            this.brokerReponseGmo.options = 1;
            this.brokerReponseGmo.waitInterval = this.brokerTimeout;
            if (connection.getFailIfQuiesce() == 1) {
                this.brokerReponseGmo.options |= 0x2000;
            }
            try {
                selector = 2015;
                this.resolvedQmName = qm.getAttributeString(selector, 48).trim();
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQConnection,MQQueueManager,boolean,int)", e, 1);
                }
                this.resolvedQmName = qm.name;
            }
            try {
                selector = 2040;
                this.resolvedQSGName = qm.getAttributeString(selector, 4).trim();
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQConnection,MQQueueManager,boolean,int)", e, 2);
                }
                this.resolvedQSGName = null;
                if (!Trace.isOn) break block14;
                Trace.traceData(this, "Setting QSGName to null", null);
            }
        }
        if (Trace.isOn) {
            Trace.traceData(this, "QSGName set to " + this.resolvedQSGName, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQConnection,MQQueueManager,boolean,int)");
        }
    }

    protected MQSession(MQQueueManager qm, String controlQName, String streamQName) throws JMSException {
        block19: {
            super(null);
            this.asyncHelper = null;
            this.brk = new BrokerConnectionInfo(null, null, null);
            this.brokerTimeout = 120000;
            this.cbInputQueue = null;
            this.checkInterval = 0;
            this.commitRequired = false;
            this.commitLock = new Object();
            this.connection = null;
            this.deadLetterQueue = null;
            this.distTransactionMode = 0;
            this.ITXSupportChecked = false;
            this.ITXSupported = false;
            this.lastQueueName = null;
            this.mapNameStyle = true;
            this.messageConsumers = new Vector();
            this.calledByAsf = false;
            this.messageProducers = new Vector();
            this.mqServices = null;
            this.optimisticPublication = false;
            this.outcomeNotification = true;
            this.playNice = false;
            this.processDuration = 0;
            this.publishCount = 0;
            this.pubsubInit = false;
            this.qm = null;
            this.receiveIsolation = 0;
            this.replyQ = null;
            this.resolvedQmName = null;
            this.resolvedQSGName = null;
            this.responseCorrelId = new byte[24];
            this.responseInterval = 0;
            this.responseOnCommit = false;
            this.responsePutTime = 0L;
            this.responseRequested = false;
            this.state = 0;
            this.stateChangeSem = new Object();
            this.transactionLock = new Object();
            this.brokerResponseLock = new Object();
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQQueueManager,String,String)", new Object[]{qm, controlQName, streamQName});
            }
            try {
                int selector;
                this.connection = null;
                this.transacted = false;
                this.acknowledgeMode = 1;
                this.persistenceFromMD = false;
                if (Trace.isOn) {
                    Trace.traceData(this, "Resolving QMName", null);
                }
                if (qm != null) {
                    try {
                        selector = 2015;
                        this.resolvedQmName = qm.getAttributeString(selector, 48).trim();
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQQueueManager,String,String)", e, 1);
                        }
                        this.resolvedQmName = qm.name;
                    }
                } else {
                    Trace.ffst(this, "<init>(MQQueueManager,String,String)", "XO00J001", null, null);
                    this.resolvedQmName = this.connection.qmgrName;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Resolving QSGName", null);
                }
                if (qm != null) {
                    try {
                        selector = 2040;
                        this.resolvedQSGName = qm.getAttributeString(selector, 4).trim();
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQQueueManager,String,String)", "Caught expected exception at catch index 2", e);
                        }
                        this.resolvedQSGName = null;
                        if (Trace.isOn) {
                            Trace.traceData(this, "Setting QSGName to null", null);
                        }
                    }
                } else {
                    this.resolvedQSGName = null;
                    if (Trace.isOn) {
                        Trace.traceData(this, "No qm, setting QSGName to null", null);
                    }
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "QSGName set to" + this.resolvedQSGName, null);
                }
            }
            catch (Exception e) {
                if (!Trace.isOn) break block19;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQQueueManager,String,String)", e, 3);
            }
        }
        this.qm = qm;
        this.brk.controlQ = controlQName;
        this.brk.streamQ = streamQName;
        this.SUBSCRIBE_CMD_POSTFIX = new String(MQPS_STREAM_NAME_B + this.brk.streamQ + MQPS_Q_NAME_B);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "<init>(MQQueueManager,String,String)");
        }
    }

    public void _acknowledge(boolean forceAck) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledge(boolean)", new Object[]{forceAck});
        }
        try {
            switch (this.getAcknowledgeMode()) {
                case 1: {
                    if (!Trace.isOn) break;
                    Trace.traceData(this, "AUTO_ACKNOWLEDGE ProviderSession. forceAck = " + forceAck, null);
                    break;
                }
                case 3: {
                    if (!Trace.isOn) break;
                    Trace.traceData(this, "DUPS_OK_ACKNOWELDGE ProviderSession. forceAck = " + forceAck, null);
                    break;
                }
                case 0: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "SESSION_TRANSACTED ProviderSession. Returning", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledge(boolean)", 1);
                    }
                    return;
                }
                case 2: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "CLIENT_ACKNOWLEDGE ProviderSession. Acknowledging message", null);
                    }
                    this._acknowledgeInternal();
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledge(boolean)", 2);
                    }
                    return;
                }
                default: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Unknown AcknowledgeMode. GIving up and returning", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledge(boolean)", 3);
                    }
                    return;
                }
            }
            if (forceAck) {
                this._acknowledgeInternal();
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledge(boolean)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledge(boolean)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledge(boolean)", 4);
        }
    }

    protected void _acknowledgeInternal() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledgeInternal()");
        }
        try {
            if (this.transacted) {
                String key = "MQJMS1020";
                String msg = ConfigEnvironment.getErrorMessage(key);
                IllegalStateException je = new IllegalStateException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledgeInternal()", je, 1);
                }
                throw je;
            }
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledgeInternal()", je, 2);
                }
                throw je;
            }
            try {
                boolean async = false;
                try {
                    async = !this.outcomeNotification && this.qm instanceof MQQueueManager && this.qm.spiSupportsInherited();
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledgeInternal()", mqe, 1);
                    }
                    async = false;
                }
                if (async) {
                    this.qm.asyncCommit();
                } else {
                    this.qm.commit();
                }
                if (this.acknowledgeMode == 2) {
                    this.setCommitRequired(false);
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledgeInternal()", e, 2);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS2009");
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledgeInternal()", je, 3);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledgeInternal()", je, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledgeInternal()", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "_acknowledgeInternal()");
        }
    }

    protected void addAsync(MQMessageConsumer consumer) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addAsync(MQMessageConsumer)", new Object[]{consumer});
        }
        if (this.asyncHelper == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "creating asyncHelper Thread", null);
            }
            this.asyncHelper = new SessionAsyncHelper(this.connection, this);
        }
        this.asyncHelper.addReceiver(consumer);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addAsync(MQMessageConsumer)");
        }
    }

    private void addConsumer(ProviderMessageConsumer consumer) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addConsumer(ProviderMessageConsumer)", new Object[]{consumer});
        }
        this.messageConsumers.addElement(consumer);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addConsumer(ProviderMessageConsumer)");
        }
    }

    private void addProducer(ProviderMessageProducer producer) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addProducer(ProviderMessageProducer)", new Object[]{producer});
        }
        this.messageProducers.addElement(producer);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addProducer(ProviderMessageProducer)");
        }
    }

    protected void addPubSubServices() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addPubSubServices()");
        }
        try {
            this.mqServices = this.connection.getMQPubSubServices(this.transacted, this.acknowledgeMode, this);
            this.pubsubInit = true;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addPubSubServices()", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addPubSubServices()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addPubSubServices()");
        }
    }

    protected void addQueueServices() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addQueueServices()");
        }
        try {
            if (this.mqServices == null || !this.mqServices.queueSet) {
                this.mqServices = this.connection.getMQQueueServices(this.qm, this.transacted, this.acknowledgeMode);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addQueueServices()", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addQueueServices()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "addQueueServices()");
        }
    }

    boolean callingFromOnMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "callingFromOnMessage()");
        }
        boolean result = this.asyncHelper == null ? false : this.asyncHelper.callingFromOnMessage();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "callingFromOnMessage()", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void close(boolean closingFromConnection) throws JMSException {
        block52: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)", new Object[]{closingFromConnection});
            }
            try {
                block53: {
                    Object e2;
                    if (this.getServicesMgr() != null && this.getServicesMgr().pubSubSet) {
                        this.closeT();
                    }
                    if (this.state == 1 || this.state == 0) {
                        block50: {
                            if (this.getAcknowledgeMode() == 1 || this.getAcknowledgeMode() == 3) {
                                try {
                                    this._acknowledge(true);
                                }
                                catch (Exception e2) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)", e2, 1);
                                    }
                                    if (!Trace.isOn) break block50;
                                    Trace.traceData(this, "_acknowledge() from close() failed : Not throwing Exception", null);
                                }
                            }
                        }
                        this.state = 2;
                        e2 = this.stateChangeSem;
                        synchronized (e2) {
                            this.stateChangeSem.notifyAll();
                        }
                        if (this.connection != null) {
                            this.connection.removeSession(this);
                        }
                    } else if (this.state != 2) {
                        JMSException je = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_CLOSED");
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)", je, 1);
                        }
                        throw je;
                    }
                    if (this.asyncHelper != null) {
                        this.asyncHelper.shutdown();
                        this.asyncHelper = null;
                    }
                    if (this.qm != null) {
                        if (this.distTransactionMode == 0 || this.distTransactionMode == 2 && !Utils.isRRSTransactionInProgress()) {
                            try {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "backing out queueManager", null);
                                }
                                this.qm.backout();
                            }
                            catch (MQException e3) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)", e3, 2);
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "backout failed.", null);
                                }
                                switch (e3.reasonCode) {
                                    case 2071: 
                                    case 2102: 
                                    case 2124: 
                                    case 2195: 
                                    case 2219: {
                                        JMSException je = ConfigEnvironment.newException("MQJMS1032", e3.getMessage());
                                        je.setLinkedException((Exception)((Object)e3));
                                        if (Trace.isOn) {
                                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)", je, 2);
                                        }
                                        throw je;
                                    }
                                    case 2009: 
                                    case 2012: 
                                    case 2018: 
                                    case 2019: 
                                    case 2101: 
                                    case 2123: 
                                    case 2130: 
                                    case 2157: 
                                    case 2162: {
                                        if (Trace.isOn) {
                                            Trace.data(this, "Exception backing out queueManager (ignoring)", (Object)e3);
                                        }
                                        break;
                                    }
                                    default: {
                                        HashMap<String, Object> ffstData = new HashMap<String, Object>();
                                        ffstData.put("Exception", (Object)e3);
                                        ffstData.put("RC", new Integer(e3.reasonCode));
                                        ffstData.put("Message", "MQJMS1016");
                                        Trace.ffst(this, "close()", PROBE_02, ffstData, JMSException.class);
                                        break;
                                    }
                                }
                            }
                        } else if (Trace.isOn) {
                            if (this.distTransactionMode == 1) {
                                Trace.traceData(this, "not calling qm.backout since we are under XA", null);
                            } else {
                                Trace.traceData(this, "not calling qm.backout since an RRS global transaction is in progress", null);
                            }
                        }
                    }
                    e2 = this.getTransactionLock();
                    synchronized (e2) {
                        this.closeAllChildren(closingFromConnection);
                    }
                    if (this.qm == null) break block52;
                    if (this.distTransactionMode == 1) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "qm.disc postponed because this session is XA aware", null);
                        }
                        break block52;
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(this, "disconnecting queueManager", null);
                        }
                        this.qm.disconnect();
                        Object var7_13 = null;
                        if (!Trace.isOn) break block53;
                    }
                    catch (Throwable throwable) {
                        Object var7_14 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)");
                        }
                        this.qm = null;
                        throw throwable;
                    }
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)");
                }
                this.qm = null;
                {
                    break block52;
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)", e, 3);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS2003");
                        je.setLinkedException(e);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)", je, 3);
                        }
                        throw je;
                    }
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)", je, 4);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)", je, 4);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "close(boolean)");
        }
    }

    private void closeAllChildren(boolean closingFromConnection) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "closeAllChildren(boolean)", new Object[]{closingFromConnection});
        }
        Vector producers = (Vector)this.messageProducers.clone();
        Enumeration en = producers.elements();
        while (en.hasMoreElements()) {
            try {
                ProviderMessageProducer mp = (ProviderMessageProducer)en.nextElement();
                mp.close(true);
            }
            catch (JMSException je) {
                if (!Trace.isOn) continue;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "closeAllChildren(boolean)", je, 1);
            }
            catch (NoSuchElementException e) {
                if (!Trace.isOn) break;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "closeAllChildren(boolean)", e, 2);
                break;
            }
        }
        Vector consumers = (Vector)this.messageConsumers.clone();
        en = consumers.elements();
        while (en.hasMoreElements()) {
            try {
                ProviderMessageConsumer mc = (ProviderMessageConsumer)en.nextElement();
                mc.close(true);
            }
            catch (JMSException je) {
                if (!Trace.isOn) continue;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "closeAllChildren(boolean)", je, 3);
            }
            catch (NoSuchElementException e) {
                if (!Trace.isOn) break;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "closeAllChildren(boolean)", e, 4);
                break;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "closeAllChildren(boolean)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeT() {
        block17: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "closeT()");
            }
            if (this.isStarted() && this.usingAsyncMode()) {
                try {
                    this.stop();
                }
                catch (JMSException e) {
                    if (!Trace.isOn) break block17;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "closeT()", e, 1);
                }
            }
        }
        if (Trace.isOn) {
            Trace.traceData(this, "getting Broker Response Lock", null);
        }
        Object object = this.getBrokerResponseLock();
        synchronized (object) {
            block19: {
                if (Trace.isOn) {
                    Trace.traceData(this, "got Broker Response Lock", null);
                }
                if (this.replyQ != null) {
                    block18: {
                        if (this.responseRequested) {
                            try {
                                MQMsg2 response = new MQMsg2();
                                this.getServicesMgr().getBrokerResponse(this, response, false);
                            }
                            catch (JMSException e) {
                                if (!Trace.isOn) break block18;
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "closeT()", e, 2);
                            }
                        }
                    }
                    try {
                        this.replyQ.close();
                        this.replyQ = null;
                    }
                    catch (MQException e) {
                        if (!Trace.isOn) break block19;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "closeT()", e, 3);
                    }
                }
            }
        }
        if (Trace.isOn) {
            Trace.traceData(this, "releasing Broker Response Lock", null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "closeT()");
        }
    }

    public void commit() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commit()");
        }
        if (!this.transacted && this.acknowledgeMode != 2 && !this.calledByAsf) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commit()", 1);
            }
            return;
        }
        if (this.calledByAsf || this.acknowledgeMode == 2) {
            block15: {
                try {
                    this.qm.commit();
                    this.setCommitRequired(false);
                }
                catch (MQException mqe) {
                    if (!Trace.isOn) break block15;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commit()", mqe);
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commit()", 2);
            }
            return;
        }
        if (this.getServicesMgr().queueSet) {
            this.commitQ();
        }
        if (this.getServicesMgr().pubSubSet) {
            this.commitT();
        } else {
            if (!this.transacted) {
                String key = "MQJMS1019";
                String msg = ConfigEnvironment.getErrorMessage(key);
                IllegalStateException je = new IllegalStateException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commit()", je, 1);
                }
                throw je;
            }
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commit()", je, 2);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commit()", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitQ() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitQ()");
        }
        try {
            if (!this.transacted) {
                String key = "MQJMS1019";
                String msg = ConfigEnvironment.getErrorMessage(key);
                IllegalStateException je = new IllegalStateException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitQ()", je, 1);
                }
                throw je;
            }
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitQ()", je, 2);
                }
                throw je;
            }
            try {
                Object je = this.getTransactionLock();
                synchronized (je) {
                    this.qm.commit();
                    this.setCommitRequired(false);
                }
            }
            catch (MQException e) {
                JMSException je;
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitQ()", e, 1);
                }
                int compCode = e.completionCode;
                int reasonCode = e.reasonCode;
                if (compCode == 1 && reasonCode == 2003) {
                    String key = "MQJMS0011";
                    String msg = ConfigEnvironment.getErrorMessage(key);
                    je = new TransactionRolledBackException(msg, key);
                } else {
                    je = ConfigEnvironment.newException("MQJMS2009");
                }
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitQ()", je, 3);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitQ()", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitQ()", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitQ()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitT() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitT()");
        }
        try {
            if (!this.transacted) {
                String key = "MQJMS1019";
                String msg = ConfigEnvironment.getErrorMessage(key);
                IllegalStateException je = new IllegalStateException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitT()", je, 1);
                }
                throw je;
            }
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitT()", je, 2);
                }
                throw je;
            }
            try {
                Object je = this.getTransactionLock();
                synchronized (je) {
                    boolean async = false;
                    boolean bl = async = !this.outcomeNotification && this.qm instanceof MQQueueManager && this.supportsInherited();
                    if (async) {
                        this.qm.asyncCommit();
                    } else {
                        this.qm.commit();
                    }
                    this.setCommitRequired(false);
                    if (this.responseOnCommit) {
                        this.responseOnCommit = false;
                        this.responseRequested = true;
                        this.responsePutTime = System.currentTimeMillis();
                        if (this.getServicesMgr().checkForResponse(this)) {
                            try {
                                MQMsg2 response = new MQMsg2();
                                this.getServicesMgr().getBrokerResponse(this, response, false);
                            }
                            catch (JMSException e) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitT()", e, 1);
                                }
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitT()", e, 3);
                                }
                                throw e;
                            }
                        }
                    }
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitT()", e, 2);
                }
                int compCode = e.completionCode;
                int reasonCode = e.reasonCode;
                JMSException je = compCode == 1 && reasonCode == 2003 ? new TransactionRolledBackException(ConfigEnvironment.getMessage("MQJMS0011")) : ConfigEnvironment.newException("MQJMS2009");
                if (this.responseOnCommit) {
                    this.responseOnCommit = false;
                }
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitT()", je, 4);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitT()", je, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitT()", je, 5);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "commitT()");
        }
    }

    private ProviderMessage consume(ProviderMessageReference mRef) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", new Object[]{mRef});
        }
        int reasonCode = 0;
        try {
            MQGetMessageOptions gmo;
            MQMessageReference mr;
            block47: {
                if (!(mRef instanceof MQMessageReference)) {
                    JMSException je = new JMSException("MQJMS1096");
                    if (Trace.isOn) {
                        Trace.traceData(this, "MessageReference is not an MQMessageReference.", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", je, 1);
                    }
                    throw je;
                }
                mr = (MQMessageReference)mRef;
                String queueName = mr.getReferenceQueue();
                if (Trace.isOn) {
                    Trace.traceData(this, "Got referenceQueueName = '" + queueName + "'", null);
                }
                this.messageQueueName = queueName;
                gmo = new MQGetMessageOptions(true);
                MQQueueManager qm = this.getQM();
                if (Trace.isOn) {
                    Trace.traceData(this, "Setting up GMO", null);
                }
                if (mr.checkIfOptionalFieldIsPresent((byte)1)) {
                    System.arraycopy(mr.getMsgToken(), 0, gmo.msgToken, 0, 16);
                    gmo.matchOptions = 32;
                } else {
                    gmo.matchOptions = 1;
                }
                gmo.options = 8256;
                gmo.options = this.calculateUseSPIP() ? (gmo.options |= 0x1000) : (gmo.options |= 2);
                try {
                    if (this.cbInputQueue == null || this.lastQueueName == null || !this.lastQueueName.equals(this.messageQueueName)) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "MQQueue " + this.messageQueueName + " to be opened", null);
                        }
                        if (this.cbInputQueue != null) {
                            this.cbInputQueue.close();
                        }
                        this.cbInputQueue = qm.accessQueue(this.messageQueueName, 8194);
                        this.lastQueueName = this.messageQueueName;
                        if (Trace.isOn) {
                            Trace.traceData(this, "Got access to " + this.cbInputQueue.name, null);
                        }
                    } else if (Trace.isOn) {
                        Trace.traceData(this, "using cached queue for " + this.messageQueueName, null);
                    }
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", mqe, 1);
                    }
                    if (mqe.completionCode != 2) break block47;
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", mqe, 2);
                    }
                    throw mqe;
                }
            }
            JMSMessage outMessage = null;
            if (this.cbInputQueue != null) {
                MQJMSMessage dummyMessage;
                if (mr.getDataQuantity() == 2) {
                    outMessage = mr.getJMSMessage();
                    dummyMessage = mr.getMQJMSMessage();
                    if (dummyMessage == null) {
                        dummyMessage = new MQJMSMessage();
                        dummyMessage.setMessageId(mr.getMessageId());
                        dummyMessage.setCorrelationId(mr.getCorrelId());
                    }
                    if ((reasonCode = this.cbInputQueue.getMsg2NoExc(dummyMessage, gmo, mr.getMsgDataLength())) == 2079) {
                        reasonCode = 0;
                    }
                    if (reasonCode != 0) {
                        outMessage = null;
                    }
                } else {
                    dummyMessage = mr.getMQJMSMessage();
                    if (dummyMessage == null) {
                        dummyMessage = new MQJMSMessage();
                        dummyMessage.setMessageId(mr.getMessageId());
                        dummyMessage.setCorrelationId(mr.getCorrelId());
                    }
                    gmo.options &= 0xFFFFFFBF;
                    reasonCode = this.cbInputQueue.getMsg2NoExc(dummyMessage, gmo);
                    if (reasonCode == 0) {
                        outMessage = dummyMessage.createJMSMessage(this, mr.getDestination());
                    }
                }
                if (reasonCode == 2033) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "NO_MSG_AVAILABLE - message removed from queue", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", null, 1);
                    }
                    return null;
                }
                if (reasonCode != 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Got MQRC " + reasonCode, null);
                    }
                    MQException traceRet1 = new MQException(2, reasonCode, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", traceRet1, 3);
                    }
                    throw traceRet1;
                }
            } else {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", null, 2);
                }
                return null;
            }
            if (!this.getTransacted()) {
                outMessage._setSession(this);
            }
            outMessage.setGotByConsume(true);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", outMessage, 3);
            }
            return outMessage;
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", mqe, 2);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS2002");
            je.setLinkedException((Exception)((Object)mqe));
            this.connection.deliverException(je);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", je, 4);
            }
            throw je;
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", ioe, 3);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "badly formatted message.", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS0006");
            je.setLinkedException((Exception)ioe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", je, 5);
            }
            throw je;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", je, 4);
            }
            this.connection.deliverException(je);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "consume(ProviderMessageReference)", je, 6);
            }
            throw je;
        }
    }

    private MQQueueBrowser createBrowser(WMQDestination queue, String messageSelector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createBrowser(WMQDestination,String)", new Object[]{queue, messageSelector});
        }
        try {
            if (queue == null || !queue.isQueue()) {
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createBrowser(WMQDestination,String)", (Throwable)je, 1);
                }
                throw je;
            }
            this.addQueueServices();
            WMQDestination jmsQueue = queue;
            String qmgrName = jmsQueue.getStringProperty("XMSC_WMQ_QUEUE_MANAGER");
            this.getServicesMgr().checkQueueAccess(jmsQueue, this);
            if (!(qmgrName == null || qmgrName.equals("") || qmgrName.equals(this.resolvedQmName) || qmgrName.equals(this.resolvedQSGName))) {
                JMSException je = ConfigEnvironment.newException("MQJMS1017");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createBrowser(WMQDestination,String)", je, 2);
                }
                throw je;
            }
            String queueName = jmsQueue.getName();
            if (queueName == null) {
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createBrowser(WMQDestination,String)", (Throwable)je, 3);
                }
                throw je;
            }
            MQQueueBrowser browse = new MQQueueBrowser(queue, messageSelector, this);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createBrowser(WMQDestination,String)", browse);
            }
            return browse;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createBrowser(WMQDestination,String)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createBrowser(WMQDestination,String)", je, 4);
            }
            throw je;
        }
    }

    public ProviderQueueBrowser createBrowser(ProviderDestination destination, String selector, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createBrowser(ProviderDestination,String,JmsPropertyContext)", new Object[]{destination, selector, propertyContext});
        }
        MQQueueBrowser mqQueueBrowser = this.createBrowser((WMQDestination)destination, selector);
        mqQueueBrowser.setPropertyContext(propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createBrowser(ProviderDestination,String,JmsPropertyContext)", mqQueueBrowser);
        }
        return mqQueueBrowser;
    }

    public ProviderBytesMessage createBytesMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createBytesMessage()");
        }
        JMSBytesMessage traceRet1 = new JMSBytesMessage(jmsStrings);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createBytesMessage()", traceRet1);
        }
        return traceRet1;
    }

    private MQMessageConsumer createConsumer(ProviderDestination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createConsumer(ProviderDestination,String,boolean)", new Object[]{destination, messageSelector, noLocal});
        }
        try {
            if (destination.isQueue()) {
                MQMessageConsumer qMsgConsumer = this.createQConsumer((WMQDestination)destination, messageSelector);
                this.addConsumer(qMsgConsumer);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createConsumer(ProviderDestination,String,boolean)", qMsgConsumer, 1);
                }
                return qMsgConsumer;
            }
            if (destination.isTopic()) {
                MQMessageConsumer tMsgConsumer = this.createTConsumer((WMQDestination)destination, messageSelector, noLocal);
                this.addConsumer(tMsgConsumer);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createConsumer(ProviderDestination,String,boolean)", tMsgConsumer, 2);
                }
                return tMsgConsumer;
            }
            String key = "MQJMS0003";
            String msg = ConfigEnvironment.getErrorMessage(key);
            InvalidDestinationException je = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createConsumer(ProviderDestination,String,boolean)", (Throwable)je, 1);
            }
            throw je;
        }
        catch (JMSException jexc) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createConsumer(ProviderDestination,String,boolean)", jexc);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createConsumer(ProviderDestination,String,boolean)", jexc, 2);
            }
            throw jexc;
        }
    }

    public ProviderMessageConsumer createConsumer(ProviderDestination destination, String selector, boolean nolocal, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", new Object[]{destination, selector, nolocal, propertyContext});
        }
        MQMessageConsumer mqConsumer = this.createConsumer(destination, selector, nolocal);
        mqConsumer.setPropertyContext(propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", mqConsumer);
        }
        return mqConsumer;
    }

    private MQMessageConsumer createDurableSubscriber(WMQDestination topic, String name, String selector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", new Object[]{topic, name, selector, noLocal});
        }
        MQSubscription subscription = null;
        MQMessageConsumer retSub = null;
        String durSubQName = null;
        boolean shared_queue = true;
        try {
            this.addPubSubServices();
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", je, 1);
                }
                throw je;
            }
            if (!topic.isTopic()) {
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", (Throwable)je, 2);
                }
                throw je;
            }
            if (name == null || name.trim().equals("")) {
                String key = "MQJMS3039";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", (Throwable)je, 3);
                }
                throw je;
            }
            WMQDestination mqtopic = topic;
            if (mqtopic.containsAnyWildcard() && mqtopic.getIntProperty("brokerVersion") != this.connection.getBrkVersion()) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Invalid wildcard.", null);
                }
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", (Throwable)je, 4);
                }
                throw je;
            }
            if (topic.isTemporary()) {
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", (Throwable)je, 5);
                }
                throw je;
            }
            durSubQName = topic.getStringProperty("brokerDurSubQueue");
            if (durSubQName.trim().equals("")) {
                durSubQName = "SYSTEM.JMS.D.*";
            } else if (!durSubQName.startsWith("SYSTEM.JMS.D.")) {
                JMSException je = ConfigEnvironment.newException("MQJMS3021", durSubQName);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", je, 6);
                }
                throw je;
            }
            if (durSubQName.endsWith("*")) {
                shared_queue = false;
            }
            if (selector != null && !selector.equals("")) {
                try {
                    MQMessageSelector tempSelector = new MQMessageSelector();
                    tempSelector.setSelector(selector);
                }
                catch (SyntaxException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", e, 1);
                    }
                    String key = "MQJMS0004";
                    String msg = ConfigEnvironment.getErrorMessage(key);
                    InvalidSelectorException je = new InvalidSelectorException(msg, key);
                    je.setLinkedException((Exception)e);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", je, 7);
                    }
                    throw je;
                }
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Topic name = " + topic.getName(), null);
                Trace.traceData(this, "Sub Q name = " + durSubQName, null);
                Trace.traceData(this, "Name       = " + name, null);
                Trace.traceData(this, "Selector   = " + selector, null);
                Trace.traceData(this, "noLocal    = " + noLocal, null);
            }
            try {
                subscription = this.connection.getSubscriptionEngine().openDurableSubscription(this, mqtopic, selector, noLocal, shared_queue, durSubQName, name);
                retSub = new MQMessageConsumer(mqtopic, this, subscription, this.transacted, this.acknowledgeMode);
                this.addConsumer(retSub);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", je, 2);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", je, 8);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", je, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", je, 9);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(WMQDestination,String,String,boolean)", retSub);
        }
        return retSub;
    }

    public ProviderMessageConsumer createDurableSubscriber(ProviderDestination destination, String subscriptionName, String selector, boolean nolocal, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(ProviderDestination,String,String,boolean,JmsPropertyContext)", new Object[]{destination, subscriptionName, selector, nolocal, propertyContext});
        }
        MQMessageConsumer mqTopicSubscriber = this.createDurableSubscriber((WMQDestination)destination, subscriptionName, selector, nolocal);
        mqTopicSubscriber.setPropertyContext(propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createDurableSubscriber(ProviderDestination,String,String,boolean,JmsPropertyContext)", mqTopicSubscriber);
        }
        return mqTopicSubscriber;
    }

    public ProviderMapMessage createMapMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createMapMessage()");
        }
        JMSMapMessage message = new JMSMapMessage(jmsStrings);
        message.mapNameStyle = this.mapNameStyle;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createMapMessage()", message);
        }
        return message;
    }

    public ProviderMessage createMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createMessage()");
        }
        JMSNullMessage traceRet1 = new JMSNullMessage(jmsStrings);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createMessage()", traceRet1);
        }
        return traceRet1;
    }

    public String createMessageID() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createMessageID()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createMessageID()", null);
        }
        return null;
    }

    public ProviderObjectMessage createObjectMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createObjectMessage()");
        }
        JMSObjectMessage traceRet1 = new JMSObjectMessage(jmsStrings);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createObjectMessage()", traceRet1);
        }
        return traceRet1;
    }

    public ProviderObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createObjectMessage(Serializable)", new Object[]{object});
        }
        JMSObjectMessage traceRet1 = new JMSObjectMessage(jmsStrings, object);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createObjectMessage(Serializable)", traceRet1);
        }
        return traceRet1;
    }

    private MQMessageProducer createProducer(ProviderDestination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createProducer(ProviderDestination)", new Object[]{destination});
        }
        try {
            if (destination == null) {
                if (this.qm == null) {
                    JMSException je = ConfigEnvironment.newException("MQJMS2004");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createProducer(ProviderDestination)", je, 1);
                    }
                    throw je;
                }
                MQMessageProducer qMsgProducer = new MQMessageProducer(null, this.qm, this.connection, this);
                this.addProducer(qMsgProducer);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createProducer(ProviderDestination)", qMsgProducer, 1);
                }
                return qMsgProducer;
            }
            if (destination.isQueue()) {
                MQMessageProducer qMsgProducer = this.createQProducer((WMQDestination)destination);
                this.addProducer(qMsgProducer);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createProducer(ProviderDestination)", qMsgProducer, 2);
                }
                return qMsgProducer;
            }
            if (destination.isTopic()) {
                MQMessageProducer tMsgProducer = (MQMessageProducer)this.createTProducer((WMQDestination)destination);
                this.addProducer(tMsgProducer);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createProducer(ProviderDestination)", tMsgProducer, 3);
                }
                return tMsgProducer;
            }
            String key = "MQJMS0003";
            String msg = ConfigEnvironment.getErrorMessage(key);
            InvalidDestinationException je = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createProducer(ProviderDestination)", (Throwable)je, 2);
            }
            throw je;
        }
        catch (JMSException jexc) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createProducer(ProviderDestination)", jexc);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createProducer(ProviderDestination)", jexc, 3);
            }
            throw jexc;
        }
    }

    public ProviderMessageProducer createProducer(ProviderDestination destination, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createProducer(ProviderDestination,JmsPropertyContext)", new Object[]{destination, propertyContext});
        }
        MQMessageProducer mqProducer = this.createProducer(destination);
        mqProducer.setPropertyContext(propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createProducer(ProviderDestination,JmsPropertyContext)", mqProducer);
        }
        return mqProducer;
    }

    private MQMessageConsumer createQConsumer(WMQDestination queue, String messageSelector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQConsumer(WMQDestination,String)", new Object[]{queue, messageSelector});
        }
        MQQueue mqqueue = null;
        try {
            this.addQueueServices();
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQConsumer(WMQDestination,String)", je, 1);
                }
                throw je;
            }
            if (!queue.isQueue()) {
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQConsumer(WMQDestination,String)", (Throwable)je, 2);
                }
                throw je;
            }
            WMQDestination queueSpec = queue;
            if (Trace.isOn) {
                Trace.traceData(this, "queueSpec: " + queueSpec, null);
            }
            this.getServicesMgr().checkQueueAccess(queueSpec, this);
            String qName = queueSpec.getName();
            String qMgrName = queueSpec.getStringProperty("XMSC_WMQ_QUEUE_MANAGER");
            if (!(qMgrName == null || qMgrName.equals("") || qMgrName.equals(this.resolvedQmName) || qMgrName.equals(this.resolvedQSGName))) {
                if (Trace.isOn) {
                    Trace.traceData(this, "qmgr " + qMgrName + " != " + this.resolvedQmName, null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1017");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQConsumer(WMQDestination,String)", je, 3);
                }
                throw je;
            }
            int openOptions = 137;
            openOptions |= 0x20;
            int fiqBehaviour = this.connection.getFailIfQuiesce();
            if (queueSpec != null) {
                fiqBehaviour = queueSpec.getFailIfQuiesce();
            }
            if (fiqBehaviour == 1) {
                openOptions |= 0x2000;
            }
            try {
                mqqueue = this.qm.accessQueue(qName, openOptions);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQConsumer(WMQDestination,String)", e, 1);
                }
                JMSException je = this.getServicesMgr().getQueueOpenException(e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQConsumer(WMQDestination,String)", je, 4);
                }
                throw je;
            }
            MQMessageConsumer msgConsumer = new MQMessageConsumer(queueSpec, messageSelector, mqqueue, this.transacted, this.acknowledgeMode, this);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQConsumer(WMQDestination,String)", msgConsumer);
            }
            return msgConsumer;
        }
        catch (JMSException je) {
            block23: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQConsumer(WMQDestination,String)", je, 2);
                }
                if (mqqueue != null) {
                    try {
                        mqqueue.close();
                    }
                    catch (MQException mqe) {
                        if (!Trace.isOn) break block23;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQConsumer(WMQDestination,String)", mqe, 3);
                    }
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQConsumer(WMQDestination,String)", je, 5);
            }
            throw je;
        }
    }

    private MQMessageProducer createQProducer(WMQDestination queue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQProducer(WMQDestination)", new Object[]{queue});
        }
        try {
            WMQDestination queueSpec = null;
            MQQueue mqqueue = null;
            this.addQueueServices();
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQProducer(WMQDestination)", je, 1);
                }
                throw je;
            }
            if (queue != null) {
                if (!queue.isQueue()) {
                    String key = "MQJMS0003";
                    String msg = ConfigEnvironment.getErrorMessage(key);
                    InvalidDestinationException je = new InvalidDestinationException(msg, key);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQProducer(WMQDestination)", (Throwable)je, 2);
                    }
                    throw je;
                }
                queueSpec = queue;
                mqqueue = this.getServicesMgr().getOutputQueue(queueSpec, this);
            }
            MQMessageProducer msgProducer = new MQMessageProducer(queueSpec, mqqueue, this);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQProducer(WMQDestination)", msgProducer);
            }
            return msgProducer;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQProducer(WMQDestination)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createQProducer(WMQDestination)", je, 3);
            }
            throw je;
        }
    }

    public ProviderStreamMessage createStreamMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createStreamMessage()");
        }
        JMSStreamMessage traceRet1 = new JMSStreamMessage(jmsStrings);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createStreamMessage()", traceRet1);
        }
        return traceRet1;
    }

    private MQMessageConsumer createTConsumer(WMQDestination topic, String selector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", new Object[]{topic, selector, noLocal});
        }
        MQMessageConsumer subscriber = null;
        MQSubscription subscription = null;
        boolean shared_queue = true;
        try {
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", je, 1);
                }
                throw je;
            }
            if (!topic.isTopic()) {
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", (Throwable)je, 2);
                }
                throw je;
            }
            this.addPubSubServices();
            WMQDestination mqtopic = topic;
            if (mqtopic.containsAnyWildcard() && mqtopic.getIntProperty("brokerVersion") != this.connection.getBrkVersion()) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Invalid wildcard.", null);
                }
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", (Throwable)je, 3);
                }
                throw je;
            }
            if (topic.isTemporary()) {
                WMQTemporaryTopic tt = (WMQTemporaryTopic)topic;
                if (tt.isDeleted()) {
                    String key = "MQJMS3019";
                    String msg = ConfigEnvironment.getErrorMessage(key);
                    InvalidDestinationException je = new InvalidDestinationException(msg, key);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", (Throwable)je, 4);
                    }
                    throw je;
                }
                if (!tt.isScopedBy(this.connection)) {
                    String key = "MQJMS3020";
                    String msg = ConfigEnvironment.getErrorMessage(key);
                    InvalidDestinationException je = new InvalidDestinationException(msg, key);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", (Throwable)je, 5);
                    }
                    throw je;
                }
            }
            if (this.nondur_subscribeQ.trim().equals("")) {
                this.nondur_subscribeQ = "SYSTEM.JMS.ND.*";
            } else if (!this.nondur_subscribeQ.startsWith("SYSTEM.JMS.ND.")) {
                JMSException je = ConfigEnvironment.newException("MQJMS3021", this.nondur_subscribeQ);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", je, 6);
                }
                throw je;
            }
            if (this.nondur_subscribeQ.endsWith("*")) {
                shared_queue = false;
                if (Trace.isOn) {
                    Trace.traceData(this, "Using multi-queue approach.", null);
                }
            } else {
                shared_queue = true;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Prefix: SYSTEM.JMS.ND.", null);
                Trace.traceData(this, "QName:  " + this.nondur_subscribeQ, null);
            }
            subscription = this.connection.getSubscriptionEngine().openSubscription(this, mqtopic, selector, noLocal, shared_queue, this.nondur_subscribeQ);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", je, 1);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", je, 7);
            }
            throw je;
        }
        try {
            subscriber = new MQMessageConsumer(topic, this, subscription, this.transacted, this.acknowledgeMode);
        }
        catch (JMSException je) {
            block34: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", je, 2);
                }
                if (subscription != null) {
                    try {
                        subscription.close();
                    }
                    catch (JMSException je2) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", je2, 3);
                        }
                        if (!Trace.isOn) break block34;
                        Trace.traceData(this, "Warning: could not close subcription - The subscription may remain active", null);
                    }
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", je, 8);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTConsumer(WMQDestination,String,boolean)", subscriber);
        }
        return subscriber;
    }

    public ProviderDestination createTemporaryDestination(int destType, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryDestination(int,JmsPropertyContext)", new Object[]{new Integer(destType), propertyContext});
        }
        WMQDestination mqTemporaryDestination = null;
        if (destType == 1) {
            mqTemporaryDestination = this.createTemporaryQueue(propertyContext);
        } else if (destType == 2) {
            mqTemporaryDestination = this.createTemporaryTopic(propertyContext);
        } else {
            String key = "MQJMS0003";
            String msg = ConfigEnvironment.getErrorMessage(key);
            InvalidDestinationException ide = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryDestination(int,JmsPropertyContext)", (Throwable)ide);
            }
            throw ide;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryDestination(int,JmsPropertyContext)", mqTemporaryDestination);
        }
        return mqTemporaryDestination;
    }

    private WMQTemporaryQueue createTemporaryQueue(JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryQueue(JmsPropertyContext)", new Object[]{propertyContext});
        }
        try {
            if (this.connection == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS1018");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryQueue(JmsPropertyContext)", je, 1);
                }
                throw je;
            }
            WMQTemporaryQueue traceRet1 = (WMQTemporaryQueue)this.connection.createTemporaryDestination(1, propertyContext);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryQueue(JmsPropertyContext)", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryQueue(JmsPropertyContext)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryQueue(JmsPropertyContext)", je, 2);
            }
            throw je;
        }
    }

    private WMQTemporaryTopic createTemporaryTopic(JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryTopic(JmsPropertyContext)", new Object[]{propertyContext});
        }
        try {
            this.addPubSubServices();
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryTopic(JmsPropertyContext)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryTopic(JmsPropertyContext)", je);
            }
            throw je;
        }
        WMQTemporaryTopic traceRet1 = (WMQTemporaryTopic)this.connection.createTemporaryDestination(2, propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTemporaryTopic(JmsPropertyContext)", traceRet1);
        }
        return traceRet1;
    }

    public ProviderTextMessage createTextMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTextMessage()");
        }
        JMSTextMessage traceRet1 = new JMSTextMessage(jmsStrings);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTextMessage()", traceRet1);
        }
        return traceRet1;
    }

    public ProviderTextMessage createTextMessage(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTextMessage(String)", new Object[]{string});
        }
        JMSTextMessage traceRet1 = new JMSTextMessage(jmsStrings, string);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTextMessage(String)", traceRet1);
        }
        return traceRet1;
    }

    private ProviderMessageProducer createTProducer(WMQDestination topic) throws JMSException {
        MQMessageProducer publisher;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTProducer(WMQDestination)", new Object[]{topic});
        }
        int openOptions = 16;
        MQQueue mqBrkPubQ = null;
        String mqBrkPubQName = null;
        try {
            String brokerTempQMgrName;
            WMQTemporaryTopic tt;
            String mqTempBrokerPubQ;
            this.addPubSubServices();
            mqBrkPubQName = this.connection.getBrkPubQueue();
            if (topic != null && topic.isTopic() && (mqTempBrokerPubQ = topic.getStringProperty("XMSC_WMQ_BROKER_PUBQ")) != null && !mqTempBrokerPubQ.equals("")) {
                mqBrkPubQName = mqTempBrokerPubQ;
            }
            if (topic != null && topic.isTopic() && topic.getFailIfQuiesce() == 1) {
                openOptions |= 0x2000;
            }
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTProducer(WMQDestination)", je, 1);
                }
                throw je;
            }
            if (topic.isTemporary() && (tt = (WMQTemporaryTopic)topic).isDeleted()) {
                JMSException e = new JMSException("TemporaryTopic already deleted");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTProducer(WMQDestination)", e, 2);
                }
                throw e;
            }
            String brokerQMgrName = this.brk.qmName;
            if (topic != null && topic.isTopic() && (brokerTempQMgrName = topic.getStringProperty("XMSC_WMQ_BROKER_PUBQ_QMGR")) != null && !brokerTempQMgrName.equals("")) {
                brokerQMgrName = brokerTempQMgrName;
            }
            try {
                mqBrkPubQ = this.qm.accessQueue(mqBrkPubQName, openOptions, brokerQMgrName, null, null);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTProducer(WMQDestination)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "createTProducer failed to access publish queue because of " + (Object)((Object)e), null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS2008", mqBrkPubQName);
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTProducer(WMQDestination)", je, 3);
                }
                throw je;
            }
            publisher = new MQMessageProducer(topic, mqBrkPubQ, this.qm, this.connection, this);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTProducer(WMQDestination)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTProducer(WMQDestination)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "createTProducer(WMQDestination)", publisher);
        }
        return publisher;
    }

    public void deleteDurableSubscriber(String subscriptionName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "deleteDurableSubscriber(String)", new Object[]{subscriptionName});
        }
        this.unsubscribe(subscriptionName);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "deleteDurableSubscriber(String)");
        }
    }

    public void deleteTemporaryDestination(ProviderDestination dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "deleteTemporaryDestination(ProviderDestination)", new Object[]{dest});
        }
        if (dest.isTemporary()) {
            ((WMQDestination)dest).delete();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "deleteTemporaryDestination(ProviderDestination)");
        }
    }

    void discQM() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "discQM()");
        }
        if (this.qm != null) {
            try {
                this.qm.disconnect();
                this.qm = null;
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "discQM()", e);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "qm.disconnect failed.", null);
                }
            }
        } else if (Trace.isOn) {
            Trace.traceData(this, "qm already null", null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "discQM()");
        }
    }

    protected final int getAcknowledgeMode() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getAcknowledgeMode()", "getter", new Integer(this.transacted ? 0 : this.acknowledgeMode));
        }
        return this.transacted ? 0 : this.acknowledgeMode;
    }

    protected BrokerConnectionInfo getBrk() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getBrk()", "getter", this.brk);
        }
        return this.brk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean getCommitRequired() {
        Object object = this.commitLock;
        synchronized (object) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getCommitRequired()", "getter", this.commitRequired);
            }
            return this.commitRequired;
        }
    }

    protected int getConnectionBrokerVersion() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionBrokerVersion()");
        }
        try {
            int traceRet1 = this.connection.getBrkVersion();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionBrokerVersion()", new Integer(traceRet1));
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionBrokerVersion()", je);
            }
            RuntimeException traceRet2 = new RuntimeException("MQJMS1016");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionBrokerVersion()", traceRet2);
            }
            throw traceRet2;
        }
    }

    protected String getConnectionID() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionID()");
        }
        try {
            String traceRet1 = this.connection.getConnectionID();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionID()", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionID()", je);
            }
            RuntimeException traceRet2 = new RuntimeException("MQJMS1016");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionID()", traceRet2);
            }
            throw traceRet2;
        }
    }

    protected int getConnectionMsgSelection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionMsgSelection()");
        }
        try {
            int traceRet1 = this.connection.getMsgSelection();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionMsgSelection()", new Integer(traceRet1));
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionMsgSelection()", je);
            }
            RuntimeException traceRet2 = new RuntimeException("MQJMS1016");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getConnectionMsgSelection()", traceRet2);
            }
            throw traceRet2;
        }
    }

    protected final int getDistTransactionMode() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getDistTransactionMode()", "getter", new Integer(this.distTransactionMode));
        }
        return this.distTransactionMode;
    }

    protected final String getDLQName() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getDLQName()", "getter", this.deadLetterQueue);
        }
        return this.deadLetterQueue;
    }

    protected final int getFailIfQuiesce() {
        int traceRet1 = this.connection.getFailIfQuiesce();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getFailIfQuiesce()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    protected boolean getOptimisticPublication() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getOptimisticPublication()", "getter", this.optimisticPublication);
        }
        return this.optimisticPublication;
    }

    protected boolean getOutcomeNotification() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getOutcomeNotification()", "getter", this.outcomeNotification);
        }
        return this.outcomeNotification;
    }

    protected final boolean getPersistenceFromMD() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getPersistenceFromMD()", "getter", this.persistenceFromMD);
        }
        return this.persistenceFromMD;
    }

    protected final boolean getPlayNice() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getPlayNice()", "getter", this.playNice);
        }
        return this.playNice;
    }

    protected int getProcessDuration() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getProcessDuration()", "getter", new Integer(this.processDuration));
        }
        return this.processDuration;
    }

    protected final MQQueueManager getQM() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getQM()", "getter", this.qm);
        }
        return this.qm;
    }

    protected final String getQMName() {
        String traceRet1;
        String string = traceRet1 = this.qm != null ? this.qm.name : null;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getQMName()", "getter", traceRet1);
        }
        return traceRet1;
    }

    protected final void setQM(MQQueueManager theQM) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "setQM(MQQueueManager)", "setter", theQM);
        }
        this.qm = theQM;
    }

    protected int getReceiveIsolation() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getReceiveIsolation()", "getter", new Integer(this.receiveIsolation));
        }
        return this.receiveIsolation;
    }

    protected MQQueue getResponseQueue() throws JMSException {
        MQQueue traceRet1 = this.getServicesMgr().getResponseQueue(this);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getResponseQueue()", "getter", traceRet1);
        }
        return traceRet1;
    }

    protected JMSServicesMgr getServicesMgr() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getServicesMgr()");
        }
        if (this.connection == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "Null ProviderConnection Value", null);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getServicesMgr()", null, 1);
            }
            return null;
        }
        JMSServicesMgr traceRet1 = this.connection.getServicesMgr();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getServicesMgr()", traceRet1, 2);
        }
        return traceRet1;
    }

    protected byte[] getSessionName() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getSessionName()", "getter", this.sessionName);
        }
        return this.sessionName;
    }

    protected boolean getSparseSubscriptions() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getSparseSubscriptions()");
        }
        if (this.connection != null) {
            boolean traceRet1 = this.connection.getSparseSubscriptions();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getSparseSubscriptions()", traceRet1, 1);
            }
            return traceRet1;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "getSparseSubscriptions, connection null.", null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getSparseSubscriptions()", false, 2);
        }
        return false;
    }

    protected boolean getSyncpointAllGets() {
        boolean traceRet1 = this.connection.getSyncpointAllGets();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getSyncpointAllGets()", "getter", traceRet1);
        }
        return traceRet1;
    }

    protected boolean getTransacted() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getTransacted()");
        }
        try {
            switch (this.distTransactionMode) {
                case 0: 
                case 1: {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getTransacted()", this.transacted, 1);
                    }
                    return this.transacted;
                }
                case 2: {
                    boolean traceRet1;
                    boolean bl = traceRet1 = this.transacted || Utils.isRRSTransactionInProgress();
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getTransacted()", traceRet1, 2);
                    }
                    return traceRet1;
                }
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Bad distributed transactional mode " + this.distTransactionMode, null);
            }
            JMSException traceRet2 = ConfigEnvironment.newException("MQJMS1016");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getTransacted()", traceRet2, 1);
            }
            throw traceRet2;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getTransacted()", je);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "throwing " + (Object)((Object)je), null);
                Exception le = je.getLinkedException();
                if (le != null) {
                    Trace.traceData(this, "linked excpetion: " + le, null);
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getTransacted()", je, 2);
            }
            throw je;
        }
    }

    protected final Object getTransactionLock() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getTransactionLock()", "getter", this.transactionLock);
        }
        return this.transactionLock;
    }

    final Object getBrokerResponseLock() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getBrokerResponseLock", "getter", this.brokerResponseLock);
        }
        return this.brokerResponseLock;
    }

    protected final boolean hasMessageListener() {
        boolean traceRet1;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "hasMessageListener()");
        }
        boolean bl = traceRet1 = this.messageListener != null;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "hasMessageListener()", traceRet1);
        }
        return traceRet1;
    }

    protected void inhibitITX() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "inhibitITX()");
        }
        this.processDuration = 0;
        switch (this.getAcknowledgeMode()) {
            case 0: {
                this.rollback();
                break;
            }
            case 2: {
                this.recover();
                break;
            }
        }
        String key = "MQJMS0011";
        String msg = ConfigEnvironment.getErrorMessage(key);
        TransactionRolledBackException je = new TransactionRolledBackException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "inhibitITX()", (Throwable)je);
        }
        throw je;
    }

    protected boolean isStarted() {
        boolean ret;
        boolean bl = ret = this.state == 1;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "isStarted()", "getter", ret);
        }
        return ret;
    }

    protected boolean isStopped() {
        boolean ret;
        boolean bl = ret = this.state == 0;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "isStopped()", "getter", ret);
        }
        return ret;
    }

    public void loadMessageReference(ProviderMessageReference messageReference) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "loadMessageReference(ProviderMessageReference)", new Object[]{messageReference});
        }
        this.calledByAsf = true;
        ProviderMessage msg = this.consume(messageReference);
        if (!$assertionsDisabled && !(messageReference instanceof MQMessageReference)) {
            throw new AssertionError();
        }
        MQMessageReference mqMsgRef = (MQMessageReference)messageReference;
        mqMsgRef.setJMSMessage(msg, 2);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "loadMessageReference(ProviderMessageReference)");
        }
    }

    private void recover() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recover()");
        }
        if (this.getServicesMgr().queueSet) {
            this.recoverQ();
        }
        if (this.getServicesMgr().pubSubSet) {
            this.recoverT();
        } else {
            if (this.transacted) {
                String key = "MQJMS1020";
                String msg = ConfigEnvironment.getErrorMessage(key);
                IllegalStateException je = new IllegalStateException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recover()", je, 1);
                }
                throw je;
            }
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recover()", je, 2);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recover()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverQ() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverQ()");
        }
        try {
            if (this.transacted) {
                String key = "MQJMS1020";
                String msg = ConfigEnvironment.getErrorMessage(key);
                IllegalStateException je = new IllegalStateException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverQ()", je, 1);
                }
                throw je;
            }
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverQ()", je, 2);
                }
                throw je;
            }
            try {
                this.setPlayNice(true);
                Object je = this.getTransactionLock();
                synchronized (je) {
                    this.setPlayNice(false);
                    if (this.qm.isConnected()) {
                        try {
                            this.qm.backout();
                        }
                        catch (NullPointerException e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverQ()", e, 1);
                            }
                            JMSException je2 = ConfigEnvironment.newException("MQJMS1021");
                            je2.setLinkedException((Exception)e);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverQ()", je2, 3);
                            }
                            throw je2;
                        }
                    } else if (Trace.isOn) {
                        Trace.traceData(this, "qm not connected - race condition?", null);
                    }
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverQ()", e, 2);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1021");
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverQ()", je, 4);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverQ()", je, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverQ()", je, 5);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverQ()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverT() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverT()");
        }
        try {
            if (this.transacted) {
                String key = "MQJMS1024";
                String msg = ConfigEnvironment.getErrorMessage(key);
                IllegalStateException je = new IllegalStateException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverT()", je, 1);
                }
                throw je;
            }
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverT()", je, 2);
                }
                throw je;
            }
            try {
                this.setPlayNice(true);
                Object je = this.getTransactionLock();
                synchronized (je) {
                    this.setPlayNice(false);
                    if (this.qm.isConnected()) {
                        try {
                            this.qm.backout();
                            this.setCommitRequired(false);
                        }
                        catch (NullPointerException e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverT()", e, 1);
                            }
                            JMSException je2 = ConfigEnvironment.newException("MQJMS1021");
                            je2.setLinkedException((Exception)e);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverT()", je2, 3);
                            }
                            throw je2;
                        }
                    } else if (Trace.isOn) {
                        Trace.traceData(this, "qm not connected - race condition?", null);
                    }
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverT()", e, 2);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1021");
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverT()", je, 4);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverT()", je, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverT()", je, 5);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recoverT()");
        }
    }

    public ProviderMessageReference recreateMessageReference(byte[] flatMR, ProviderDestination dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recreateMessageReference(byte [ ],ProviderDestination)", new Object[]{flatMR, dest});
        }
        try {
            MQMessageReference traceRet1 = new MQMessageReference(this, flatMR, dest);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recreateMessageReference(byte [ ],ProviderDestination)", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recreateMessageReference(byte [ ],ProviderDestination)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "recreateMessageReference(byte [ ],ProviderDestination)", je);
            }
            throw je;
        }
    }

    public String getDestinationURI(byte[] flatMR) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getDestinationURI(byte [ ])", new Object[]{flatMR});
        }
        String uri = MQMessageReference.getDestinationURI(flatMR);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "getDestinationURI(byte [ ])", uri);
        }
        return uri;
    }

    /*
     * Loose catch block
     */
    protected void redirectMessage(String qName, MQMsg2 message, boolean syncPoint) throws JMSException {
        block27: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)", new Object[]{qName, message, syncPoint});
            }
            MQQueue queue = null;
            try {
                block26: {
                    if (this.qm == null) {
                        JMSException je = ConfigEnvironment.newException("MQJMS2004");
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)", je, 1);
                        }
                        throw je;
                    }
                    try {
                        MQPutMessageOptions pmo = new MQPutMessageOptions();
                        if (syncPoint) {
                            pmo.options |= 2;
                            pmo.options &= 0xFFFFFFFB;
                        } else {
                            pmo.options |= 4;
                            pmo.options &= 0xFFFFFFFD;
                        }
                        this.qm.putMsg2(qName, "", message, pmo);
                        Object var8_9 = null;
                        if (!Trace.isOn) break block26;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)");
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "redirectMessage finally block", null);
                        }
                        if (queue != null) {
                            try {
                                queue.close();
                            }
                            catch (MQException e) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)", e, 2);
                                }
                                HashMap<String, Object> ffstData = new HashMap<String, Object>();
                                ffstData.put("Exception", (Object)e);
                                ffstData.put("Message", "MQJMS2000");
                                Trace.ffst(this, "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)", PROBE_05, ffstData, JMSException.class);
                            }
                        }
                        throw throwable;
                    }
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)");
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "redirectMessage finally block", null);
                }
                if (queue != null) {
                    try {
                        queue.close();
                    }
                    catch (MQException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)", e, 2);
                        }
                        HashMap<String, Object> ffstData = new HashMap<String, Object>();
                        ffstData.put("Exception", (Object)e);
                        ffstData.put("Message", "MQJMS2000");
                        Trace.ffst(this, "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)", PROBE_05, ffstData, JMSException.class);
                    }
                }
                break block27;
                {
                    catch (MQException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)", e, 1);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS1022");
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)", je, 2);
                        }
                        throw je;
                    }
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)", je, 3);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)", je, 3);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean)");
        }
    }

    protected void removeAsync(MQMessageConsumer consumer) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "removeAsync(MQMessageConsumer)", new Object[]{consumer});
        }
        if (this.asyncHelper != null) {
            this.asyncHelper.removeReceiver(consumer);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "removeAsync(MQMessageConsumer)");
        }
    }

    protected void removeConsumer(ProviderMessageConsumer consumer) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "removeConsumer(ProviderMessageConsumer)", new Object[]{consumer});
        }
        this.messageConsumers.removeElement(consumer);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "removeConsumer(ProviderMessageConsumer)");
        }
    }

    protected void removeProducer(ProviderMessageProducer producer) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "removeProducer(ProviderMessageProducer)", new Object[]{producer});
        }
        this.messageProducers.removeElement(producer);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "removeProducer(ProviderMessageProducer)");
        }
    }

    protected void removePublisher(MQMessageProducer pub) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "removePublisher(MQMessageProducer)", new Object[]{pub});
        }
        this.removeProducer(pub);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "removePublisher(MQMessageProducer)");
        }
    }

    protected void removeSender(MQMessageProducer sender) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "removeSender(MQMessageProducer)", new Object[]{sender});
        }
        this.removeProducer(sender);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "removeSender(MQMessageProducer)");
        }
    }

    protected void responseRequested(long putTime, byte[] correlId) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "responseRequested(long,byte [ ])", new Object[]{new Long(putTime), correlId});
        }
        if (!this.transacted) {
            this.responseRequested = true;
            this.responsePutTime = putTime;
        } else {
            this.responseOnCommit = true;
        }
        System.arraycopy(correlId, 0, this.responseCorrelId, 0, correlId.length);
        for (int i = correlId.length; i < this.responseCorrelId.length; ++i) {
            this.responseCorrelId[i] = 0;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "setting responseCorrelId to ", (Object)this.responseCorrelId);
        }
        this.publishCount = 0;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "responseRequested(long,byte [ ])");
        }
    }

    public void rollback() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollback()");
        }
        if (!this.transacted && !this.calledByAsf) {
            this.recover();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollback()", 1);
            }
            return;
        }
        if (this.calledByAsf) {
            block15: {
                try {
                    this.qm.backout();
                }
                catch (MQException mqe) {
                    if (!Trace.isOn) break block15;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollback()", mqe);
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollback()", 2);
            }
            return;
        }
        if (this.getServicesMgr().queueSet) {
            this.rollbackQ();
        }
        if (this.getServicesMgr().pubSubSet) {
            this.rollbackT();
        } else {
            if (!this.transacted) {
                String key = "MQJMS1019";
                String msg = ConfigEnvironment.getErrorMessage(key);
                IllegalStateException je = new IllegalStateException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollback()", je, 1);
                }
                throw je;
            }
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollback()", je, 2);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollback()", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackQ() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackQ()");
        }
        try {
            if (!this.transacted) {
                String key = "MQJMS1019";
                String msg = ConfigEnvironment.getErrorMessage(key);
                IllegalStateException je = new IllegalStateException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackQ()", je, 1);
                }
                throw je;
            }
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackQ()", je, 2);
                }
                throw je;
            }
            try {
                Object je = this.getTransactionLock();
                synchronized (je) {
                    this.qm.backout();
                    this.setCommitRequired(false);
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackQ()", e, 1);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1023");
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackQ()", je, 3);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackQ()", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackQ()", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackQ()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackT() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackT()");
        }
        try {
            if (!this.transacted) {
                String key = "MQJMS1019";
                String msg = ConfigEnvironment.getErrorMessage(key);
                IllegalStateException je = new IllegalStateException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackT()", je, 1);
                }
                throw je;
            }
            if (this.qm == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackT()", je, 2);
                }
                throw je;
            }
            try {
                Object je = this.getTransactionLock();
                synchronized (je) {
                    this.qm.backout();
                    this.setCommitRequired(false);
                    if (this.responseOnCommit) {
                        this.responseOnCommit = false;
                    }
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackT()", e, 1);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1023");
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackT()", je, 3);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackT()", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackT()", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "rollbackT()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCommitRequired(boolean newVal) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "setCommitRequired(boolean)", "setter", newVal);
        }
        Object object = this.commitLock;
        synchronized (object) {
            this.commitRequired = newVal;
        }
    }

    protected void setDistTransactionMode(int newMode) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "setDistTransactionMode(int)", "setter", new Integer(newMode));
        }
        this.distTransactionMode = newMode;
    }

    protected void setPlayNice(boolean x) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "setPlayNice(boolean)", "setter", x);
        }
        this.playNice = x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SessionClosedException, JMSException {
        block13: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "start()");
            }
            try {
                if (this.state == 2) {
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException je = new SessionClosedException(msg);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "start()", (Throwable)((Object)je), 1);
                    }
                    throw je;
                }
                if (this.state == 1) break block13;
                if (this.state == 0) {
                    this.state = 1;
                    Object msg = this.stateChangeSem;
                    synchronized (msg) {
                        this.stateChangeSem.notifyAll();
                        break block13;
                    }
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_STARTED");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "start()", je, 2);
                }
                throw je;
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "start()", je);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "start()", je, 3);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "start()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stop() throws SessionClosedException, JMSException {
        block9: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "stop()");
            }
            try {
                if (this.state == 2) {
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException je = new SessionClosedException(msg);
                    if (!Trace.isOn) throw je;
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "stop()", (Throwable)((Object)je), 1);
                    throw je;
                }
                if (this.state == 1) {
                    this.state = 0;
                    Object msg = this.transactionLock;
                    // MONITORENTER : msg
                    // MONITOREXIT : msg
                    if (this.asyncHelper != null) {
                        this.asyncHelper.waitForPaused();
                    }
                    break block9;
                }
                if (this.state != 0) {
                    JMSException je = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_STOPPED");
                    if (!Trace.isOn) throw je;
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "stop()", je, 2);
                    throw je;
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "stop()", je);
                }
                if (!Trace.isOn) throw je;
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "stop()", je, 3);
                throw je;
            }
        }
        if (!Trace.isOn) return;
        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "stop()");
    }

    protected boolean supportsInherited() {
        block15: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "supportsInherited()");
            }
            if (this.distTransactionMode == 1 || this.distTransactionMode == 2) {
                this.ITXSupported = false;
            } else if (!this.ITXSupportChecked) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Haven't yet checked for session ITX support. Checking now", null);
                }
                try {
                    if (this.qm instanceof MQQueueManager && this.qm.spiSupportsInherited()) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Queue manager supports ITX", null);
                        }
                        this.ITXSupported = true;
                        this.ITXSupportChecked = true;
                        break block15;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Queue manager doesn't support ITX", null);
                    }
                    this.ITXSupported = false;
                    this.ITXSupportChecked = true;
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "supportsInherited()", mqe);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Exception thrown checking for ITX support. Assuming not supported", null);
                    }
                    this.ITXSupported = false;
                    this.ITXSupportChecked = true;
                }
            } else if (Trace.isOn) {
                Trace.traceData(this, "ITXSupport was previously checked. ITXSupported = " + this.ITXSupported, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "supportsInherited()", this.ITXSupported);
        }
        return this.ITXSupported;
    }

    private void unsubscribe(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "unsubscribe(String)", new Object[]{name});
        }
        try {
            this.addPubSubServices();
            MQSubscriptionEngine engine = this.connection.getSubscriptionEngine();
            if (engine != null) {
                engine.durableUnsubscribe(this, name);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "unsubscribe(String)", je, 1);
            }
            Throwable newJE = null;
            try {
                int rc = Integer.parseInt(je.getErrorCode());
                if (rc == 3157) {
                    String key = "MQJMS3023";
                    String msg = ConfigEnvironment.getErrorMessage(key);
                    newJE = new IllegalStateException(msg, key);
                    newJE.setLinkedException(je.getLinkedException());
                } else {
                    newJE = je;
                }
            }
            catch (NumberFormatException nfe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "unsubscribe(String)", nfe, 2);
                }
                newJE = je;
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "unsubscribe(String)", newJE);
            }
            throw newJE;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "unsubscribe(String)");
        }
    }

    protected boolean usingAsyncMode() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "usingAsyncMode()");
        }
        boolean result = this.asyncHelper == null ? false : this.asyncHelper.hasReceivers();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "usingAsyncMode()", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForStart() throws SessionClosedException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart()");
        }
        try {
            while (this.state == 0) {
                Object object = this.stateChangeSem;
                synchronized (object) {
                    block18: {
                        try {
                            this.stateChangeSem.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            if (!Trace.isOn) break block18;
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart()", e, 1);
                        }
                    }
                }
            }
            switch (this.state) {
                case 1: {
                    break;
                }
                case 2: {
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException sce = new SessionClosedException(msg);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart()", (Throwable)((Object)sce), 1);
                    }
                    throw sce;
                }
                default: {
                    String detail = ConfigEnvironment.getMessage("MQJMS1006", "state", String.valueOf(this.state));
                    HashMap<String, String> ffstData = new HashMap<String, String>();
                    ffstData.put("Message", "MQJMS1016");
                    ffstData.put("Comment", detail);
                    Trace.ffst(this, "waitForStart()", PROBE_03, ffstData, JMSException.class);
                    JMSException je = ConfigEnvironment.newException("MQJMS1016", "unknown value of state " + this.state);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart()", je, 2);
                    }
                    throw je;
                }
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart()", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart()", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long waitForStart(long timeout) throws SessionClosedException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart(long)", new Object[]{new Long(timeout)});
        }
        try {
            long output = 0L;
            long timeEntered = System.currentTimeMillis();
            long endTime = timeEntered + timeout;
            long currTime = timeEntered;
            while (this.state == 0 && currTime < endTime) {
                Object object = this.stateChangeSem;
                synchronized (object) {
                    block19: {
                        try {
                            this.stateChangeSem.wait(endTime - currTime);
                        }
                        catch (InterruptedException e) {
                            if (!Trace.isOn) break block19;
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart(long)", e, 1);
                        }
                    }
                    currTime = System.currentTimeMillis();
                }
            }
            currTime = System.currentTimeMillis();
            switch (this.state) {
                case 1: {
                    output = Math.max(0L, endTime - currTime);
                    break;
                }
                case 2: {
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException sce = new SessionClosedException(msg);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart(long)", (Throwable)((Object)sce), 1);
                    }
                    throw sce;
                }
                case 0: {
                    output = 0L;
                    break;
                }
                default: {
                    String detail = ConfigEnvironment.getMessage("MQJMS1006", "state", String.valueOf(this.state));
                    HashMap<String, String> ffstData = new HashMap<String, String>();
                    ffstData.put("Message", "MQJMS1016");
                    ffstData.put("Comment", detail);
                    Trace.ffst(this, "waitForStart(long)", PROBE_04, ffstData, JMSException.class);
                    JMSException je = ConfigEnvironment.newException("MQJMS1016", "unknown value of state " + this.state);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart(long)", je, 2);
                    }
                    throw je;
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart(long)", new Long(output));
            }
            return output;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart(long)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "waitForStart(long)", je, 3);
            }
            throw je;
        }
    }

    public boolean isMessageAlien(ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "isMessageAlien(ProviderMessage)", new Object[]{message});
        }
        if (message instanceof JMSMessage) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "isMessageAlien(ProviderMessage)", false, 1);
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "isMessageAlien(ProviderMessage)", true, 2);
        }
        return true;
    }

    public boolean isInGlobalTransaction() {
        boolean uow;
        boolean bl = uow = this.distTransactionMode == 1 || Utils.isRRSTransactionInProgress();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "isInGlobalTransaction()", "getter", uow);
        }
        return uow;
    }

    boolean calculateUseSPIP() throws JMSException {
        boolean useSPIP = !this.getTransacted() && this.acknowledgeMode != 2 && !this.getSyncpointAllGets();
        if (Trace.isOn) {
            Trace.traceData(this, "calculateUseSPIP set useSPIP to ", (Object)new Boolean(useSPIP));
        }
        return useSPIP;
    }

    static {
        boolean bl = $assertionsDisabled = !MQSession.class.desiredAssertionStatus();
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQSession", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQSession.java, jmscc.wmq.v6, k701, k701-112-140304  1.73.1.9 11/07/13 17:06:51");
        }
        jmsStrings = new MQJMSStringResources();
    }
}

