/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.base.internal.MQC;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.SubscriptionHelper;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

class MQQueueSubscriptionEngine
extends MQSubscriptionEngine {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueSubscriptionEngine.java, jmscc.wmq.v6, k701, k701-112-140304 1.30.1.1 09/08/17 08:13:41";
    private static final int REGISTER_SUBSCRIBER = 1;
    private static final int DEREGISTER_SUBSCRIBER = 2;
    private static final int REGISTER_PUBLISHER = 3;
    private static final int DEREGISTER_PUBLISHER = 4;
    private MQPSStatusMgr pubsubStatusMgr;
    private byte[] statusMgrId;

    public MQQueueSubscriptionEngine(MQConnection connection, MQQueueManager qm) {
        super(connection);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "<init>(MQConnection,MQQueueManager)", new Object[]{connection, qm});
        }
        try {
            this.pubsubStatusMgr = new MQPSStatusMgr(qm, connection.getBrkControlQueue(), connection.getBrkPubQueue());
            this.statusMgrId = this.pubsubStatusMgr.addConnection(connection);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "<init>(MQConnection,MQQueueManager)", je);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "<init>(MQConnection,MQQueueManager)", 1);
            }
            return;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "<init>(MQConnection,MQQueueManager)", 2);
        }
    }

    public MQSubscription openSubscription(MQSession mqs, WMQDestination topic, String selector, boolean noLocal, boolean sharedQueue, String queueName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", new Object[]{mqs, topic, selector, noLocal, sharedQueue, queueName});
        }
        MQQueue subscriberQueue = null;
        MQQueueSubscription subscription = null;
        byte[] correlationId = null;
        boolean registered = false;
        try {
            int fiqBehaviour = 1;
            if (topic != null) {
                fiqBehaviour = topic.getIntProperty("failIfQuiesce");
            } else if (mqs != null) {
                fiqBehaviour = mqs.getFailIfQuiesce();
            }
            try {
                subscription = new MQQueueSubscription(this, mqs, false, sharedQueue, mqs.getQMName(), this.getMQConnection().getClientID(), null, topic, selector, noLocal, queueName, null, null);
                if (Trace.isOn) {
                    Trace.traceData(this, "setting StatusMgrId = ", (Object)this.statusMgrId);
                }
                subscription.setStatusMgrId(this.statusMgrId);
                subscriberQueue = this.openSubscriberQueue(mqs, queueName, sharedQueue, false, fiqBehaviour);
                subscription.setSubscriberQueue(subscriberQueue);
                subscription.setQueueName(subscriberQueue.name);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 1);
                }
                throw je;
            }
            try {
                correlationId = MQQueueSubscriptionEngine.addNDSubscriptionEntry(subscription);
                subscription.setCorrelationId(correlationId);
                if (Trace.isOn) {
                    Trace.traceData(this, "Using correl ID = ", (Object)correlationId);
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 2);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 2);
                }
                throw je;
            }
            try {
                this.sendBrokerCommand(subscription, 1, true);
                registered = true;
            }
            catch (NoBrokerResponseException nbre) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", (Throwable)((Object)nbre), 3);
                }
                registered = true;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", (Throwable)((Object)nbre), 3);
                }
                throw nbre;
            }
            catch (BrokerCommandFailedException bcfe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", (Throwable)((Object)bcfe), 4);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", (Throwable)((Object)bcfe), 4);
                }
                throw bcfe;
            }
        }
        catch (JMSException je) {
            boolean cleanupProblems;
            block40: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 5);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "cleaning up partial subscription", null);
                }
                cleanupProblems = false;
                if (registered) {
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(this, "deregistering", null);
                        }
                        this.sendBrokerCommand(subscription, 2, true);
                    }
                    catch (JMSException sce) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", sce, 6);
                        }
                        cleanupProblems = true;
                        if (!Trace.isOn) break block40;
                        Trace.traceData(this, "the cancel command also failed.", null);
                    }
                }
            }
            if (subscriberQueue != null) {
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "deleting subscription queue", null);
                    }
                    if (!sharedQueue) {
                        subscriberQueue.closeOptions = 2;
                    }
                    subscriberQueue.close();
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", e, 7);
                    }
                    cleanupProblems = true;
                }
            }
            if (!cleanupProblems) {
                MQQueueSubscriptionEngine.removeNDSubscriptionEntry(subscription);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 5);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", subscription);
        }
        return subscription;
    }

    public void closeSubscription(MQSubscription sub) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeSubscription(MQSubscription)", new Object[]{sub});
        }
        try {
            MQQueueSubscription subscription;
            block21: {
                subscription = null;
                if (!(sub instanceof MQQueueSubscription)) {
                    JMSException je = ConfigEnvironment.newException("MQJMS1016");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeSubscription(MQSubscription)", je, 1);
                    }
                    throw je;
                }
                subscription = (MQQueueSubscription)sub;
                if (!subscription.isDurable()) {
                    try {
                        if (subscription.isClosed()) {
                            if (subscription.getSubscriberQueue() != null) {
                                SubscriptionHelper.deleteSubscriberMessages(subscription);
                            }
                        } else {
                            this.deleteSubscriber(subscription);
                        }
                        subscription.setSubscriberQueue(null);
                    }
                    catch (JMSException je) {
                        Exception e;
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeSubscription(MQSubscription)", je, 1);
                        }
                        if ((e = je.getLinkedException()) instanceof MQException && ((MQException)((Object)e)).reasonCode == 2055) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "close ignoring MQException 2055", null);
                            }
                            break block21;
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "closeSubscription() ignoring exception.", null);
                        }
                        subscription.setSubscriberQueue(null);
                    }
                } else {
                    JMSException je = ConfigEnvironment.newException("MQJMS1016");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeSubscription(MQSubscription)", je, 2);
                    }
                    throw je;
                }
            }
            if (!subscription.isClosed() && !subscription.isDurable()) {
                MQQueueSubscriptionEngine.removeNDSubscriptionEntry(subscription);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeSubscription(MQSubscription)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeSubscription(MQSubscription)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeSubscription(MQSubscription)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MQSubscription openDurableSubscription(MQSession mqs, WMQDestination topic, String selector, boolean noLocal, boolean sharedQueue, String queueName, String subName) throws JMSException {
        MQQueueSubscription returnSub;
        MQQueue adminQueue;
        block35: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", new Object[]{mqs, topic, selector, noLocal, sharedQueue, queueName, subName});
            }
            adminQueue = null;
            MQQueueSubscription subscription = null;
            MQQueueSubscription testSub = null;
            returnSub = null;
            try {
                block34: {
                    try {
                        String canonSel2;
                        if (Trace.isOn) {
                            Trace.traceData(this, "Topic name = " + topic.getStringProperty("XMSC_DESTINATION_NAME"), null);
                            Trace.traceData(this, "Sub Q name = " + queueName, null);
                            Trace.traceData(this, "sub Name   = " + subName, null);
                            Trace.traceData(this, "Selector   = " + selector, null);
                            Trace.traceData(this, "noLocal    = " + noLocal, null);
                        }
                        int fiqBehaviour = 1;
                        if (topic != null) {
                            fiqBehaviour = topic.getIntProperty("failIfQuiesce");
                        } else if (mqs != null) {
                            fiqBehaviour = mqs.getFailIfQuiesce();
                        }
                        adminQueue = this.getAdminQueueAccess(mqs, fiqBehaviour);
                        String clientID = this.getMQConnection().getClientID();
                        if (clientID == null) {
                            JMSException je = ConfigEnvironment.newException("MQJMS3024");
                            if (!Trace.isOn) throw je;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 1);
                            throw je;
                        }
                        testSub = new MQQueueSubscription(this, mqs, true, sharedQueue, mqs.getQMName(), clientID, subName, topic, selector, noLocal, queueName, null, null);
                        subscription = this.getResolvedSubscription(adminQueue, testSub, null, false);
                        if (subscription == null) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "DurSubEntry not found; new durable subscriber", null);
                                Trace.traceData(this, "setting StatusMgrId = ", (Object)this.statusMgrId);
                            }
                            testSub.setStatusMgrId(this.statusMgrId);
                            returnSub = this.createNewDurableSubscription(adminQueue, testSub);
                            break block34;
                        }
                        subscription.setMQTopic(topic);
                        String canonSel1 = testSub.getSelector();
                        if (canonSel1 == null) {
                            canonSel1 = "";
                        }
                        if ((canonSel2 = subscription.getSelector()) == null) {
                            canonSel2 = "";
                        }
                        if (testSub.getFullName().equals(subscription.getFullName()) && testSub.getTopic().equals(subscription.getTopic()) && canonSel1.equals(canonSel2)) {
                            String originalQueueName;
                            if (Trace.isOn) {
                                Trace.traceData(this, "Found an entry for this client", null);
                                Trace.traceData(this, "Name                  = " + subscription.getSubName(), null);
                                Trace.traceData(this, "Topic name            = " + subscription.getTopic(), null);
                                Trace.traceData(this, "Subscriber queue name = " + subscription.getQueueName(), null);
                                Trace.traceData(this, "Comparing given subscriber queue name: " + queueName, null);
                            }
                            if (!(originalQueueName = subscription.getQueueName().trim()).equals(queueName = queueName.trim())) {
                                if (!queueName.endsWith("*")) {
                                    JMSException je = ConfigEnvironment.newException("MQJMS3022", queueName, originalQueueName);
                                    if (!Trace.isOn) throw je;
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 3);
                                    throw je;
                                }
                                if (subscription.isSharedQueue() || !originalQueueName.regionMatches(0, queueName, 0, queueName.length() - 1)) {
                                    JMSException je = ConfigEnvironment.newException("MQJMS3022", queueName, originalQueueName);
                                    if (!Trace.isOn) throw je;
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 2);
                                    throw je;
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Using original subscriber queue: " + originalQueueName, null);
                                }
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "Reset durable subscriber options", null);
                            }
                            try {
                                this.sendBrokerCommand(subscription, 1, true);
                            }
                            catch (NoBrokerResponseException nbre) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", (Throwable)((Object)nbre), 1);
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "re-subscribe command failed", null);
                                }
                                if (!Trace.isOn) throw nbre;
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", (Throwable)((Object)nbre), 4);
                                throw nbre;
                            }
                            returnSub = this.createExistingDurableSubscription(adminQueue, subscription);
                            break block34;
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Updating a durable subscriber:", null);
                            Trace.traceData(this, "Old subscriber: " + subscription.toString(), null);
                            Trace.traceData(this, "New subscriber: " + testSub.toString(), null);
                        }
                        returnSub = this.createUpdatedDurableSubscriber(adminQueue, testSub);
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 2);
                        }
                        if (!Trace.isOn) throw je;
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 5);
                        throw je;
                    }
                }
                Object var19_22 = null;
                if (!Trace.isOn) break block35;
            }
            catch (Throwable throwable) {
                Object var19_23 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)");
                }
                if (adminQueue == null) throw throwable;
                try {
                    adminQueue.close();
                    throw throwable;
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", mqe, 3);
                    }
                    JMSException je2 = new JMSException("MQJMS2000");
                    je2.setLinkedException((Exception)((Object)mqe));
                    if (!Trace.isOn) throw je2;
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je2, 6);
                    throw je2;
                }
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)");
        }
        if (adminQueue != null) {
            try {}
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", mqe, 3);
                }
                JMSException je2 = new JMSException("MQJMS2000");
                je2.setLinkedException((Exception)((Object)mqe));
                if (!Trace.isOn) throw je2;
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je2, 6);
                throw je2;
            }
            adminQueue.close();
        }
        if (!Trace.isOn) return returnSub;
        Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", returnSub);
        return returnSub;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeDurableSubscription(MQSubscription sub) throws JMSException {
        block21: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)", new Object[]{sub});
            }
            MQQueue adminQueue = null;
            try {
                block22: {
                    MQQueueSubscription subscription = null;
                    if (!(sub instanceof MQQueueSubscription)) {
                        JMSException je = ConfigEnvironment.newException("MQJMS3005");
                        if (!Trace.isOn) throw je;
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 1);
                        throw je;
                    }
                    subscription = (MQQueueSubscription)sub;
                    if (!subscription.isDurable() || subscription.getSubscriberQueue() == null) break block21;
                    MQQueue subscriberQueue = null;
                    try {
                        try {
                            subscriberQueue = subscription.getSubscriberQueue();
                            subscriberQueue.close();
                            subscriberQueue = null;
                            int fiqBehaviour = 1;
                            if (subscription.getMQTopic() != null) {
                                fiqBehaviour = subscription.getMQTopic().getIntProperty("failIfQuiesce");
                            } else if (subscription.getMQSession() != null) {
                                fiqBehaviour = subscription.getMQSession().getFailIfQuiesce();
                            }
                            adminQueue = this.getAdminQueueAccess(subscription.getMQSession(), fiqBehaviour);
                            subscription.setSubscriberState('i');
                            if (Trace.isOn) {
                                Trace.traceData(this, "Add new subscription entry", null);
                            }
                            this.addSubscriptionEntry(adminQueue, subscription, false);
                            if (Trace.isOn) {
                                Trace.traceData(this, "Remove old subscription entry", null);
                            }
                            this.removeSubscriptionEntry(adminQueue, subscription);
                        }
                        catch (MQException e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)", e, 1);
                            }
                            JMSException je = ConfigEnvironment.newException("MQJMS3017", subscription.getQueueName());
                            je.setLinkedException((Exception)((Object)e));
                            if (!Trace.isOn) throw je;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 2);
                            throw je;
                        }
                        Object var8_9 = null;
                        if (!Trace.isOn) break block22;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)");
                        }
                        if (adminQueue == null) throw throwable;
                        try {
                            adminQueue.close();
                            throw throwable;
                        }
                        catch (MQException mqe) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)", mqe, 2);
                            }
                            JMSException je2 = new JMSException("MQJMS2000");
                            je2.setLinkedException((Exception)((Object)mqe));
                            if (!Trace.isOn) throw je2;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je2, 3);
                            throw je2;
                        }
                    }
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)");
                }
                if (adminQueue == null) break block21;
                try {}
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)", mqe, 2);
                    }
                    JMSException je2 = new JMSException("MQJMS2000");
                    je2.setLinkedException((Exception)((Object)mqe));
                    if (!Trace.isOn) throw je2;
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je2, 3);
                    throw je2;
                }
                adminQueue.close();
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 3);
                }
                if (!Trace.isOn) throw je;
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 4);
                throw je;
            }
        }
        if (!Trace.isOn) return;
        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "closeDurableSubscription(MQSubscription)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void durableUnsubscribe(MQSession mqs, String subName) throws JMSException {
        MQQueue adminQueue;
        block14: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "durableUnsubscribe(MQSession,String)", new Object[]{mqs, subName});
            }
            adminQueue = null;
            try {
                try {
                    int fiqBehaviour = 1;
                    if (mqs != null) {
                        fiqBehaviour = mqs.getFailIfQuiesce();
                    }
                    adminQueue = this.getAdminQueueAccess(mqs, fiqBehaviour);
                    this.unsubscribe(adminQueue, mqs, subName);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "durableUnsubscribe(MQSession,String)", je, 1);
                    }
                    if (!Trace.isOn) throw je;
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "durableUnsubscribe(MQSession,String)", je, 1);
                    throw je;
                }
                Object var6_6 = null;
                if (!Trace.isOn) break block14;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "durableUnsubscribe(MQSession,String)");
                }
                if (adminQueue == null) throw throwable;
                try {
                    adminQueue.close();
                    throw throwable;
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "durableUnsubscribe(MQSession,String)", mqe, 2);
                    }
                    JMSException je2 = new JMSException("MQJMS2000");
                    je2.setLinkedException((Exception)((Object)mqe));
                    if (!Trace.isOn) throw je2;
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "durableUnsubscribe(MQSession,String)", je2, 2);
                    throw je2;
                }
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "durableUnsubscribe(MQSession,String)");
        }
        if (adminQueue != null) {
            try {}
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "durableUnsubscribe(MQSession,String)", mqe, 2);
                }
                JMSException je2 = new JMSException("MQJMS2000");
                je2.setLinkedException((Exception)((Object)mqe));
                if (!Trace.isOn) throw je2;
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "durableUnsubscribe(MQSession,String)", je2, 2);
                throw je2;
            }
            adminQueue.close();
        }
        if (!Trace.isOn) return;
        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "durableUnsubscribe(MQSession,String)");
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "close()");
        }
        try {
            if (this.pubsubStatusMgr != null) {
                MQConnection connection = this.getMQConnection();
                this.pubsubStatusMgr.removeConnection(connection.qmgrName, connection.mqProperties, connection.getConnectionID());
                this.pubsubStatusMgr.close();
                this.pubsubStatusMgr = null;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "close()", je);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "close()", 1);
            }
            return;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "close()", 2);
        }
    }

    private static byte[] addNDSubscriptionEntry(MQQueueSubscription subscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "addNDSubscriptionEntry(MQQueueSubscription)", new Object[]{subscription});
        }
        MQQueue statusQueue = null;
        MQQueueManager qMgr = subscription.getMQSession().getQM();
        byte[] msgID = null;
        MQMessage subscriptionMessage = subscription.toMessage();
        try {
            statusQueue = qMgr.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 8208);
            statusQueue.put(subscriptionMessage);
            msgID = subscriptionMessage.messageId;
            statusQueue.close();
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "addNDSubscriptionEntry(MQQueueSubscription)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3013");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "addNDSubscriptionEntry(MQQueueSubscription)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "addNDSubscriptionEntry(MQQueueSubscription)", msgID);
        }
        return msgID;
    }

    private static void removeNDSubscriptionEntry(MQQueueSubscription subscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "removeNDSubscriptionEntry(MQQueueSubscription)", new Object[]{subscription});
        }
        MQQueue statusQueue = null;
        MQMessage ndEntry = new MQMessage();
        ndEntry.messageId = subscription.getCorrelationId();
        byte[] subStatusMgrId = subscription.getStatusMgrId();
        if (subStatusMgrId != null) {
            ndEntry.correlationId = subStatusMgrId;
        }
        try {
            MQQueueManager qm = subscription.getMQSession().getQM();
            statusQueue = qm.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 8194);
            statusQueue.get(ndEntry);
            statusQueue.close();
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "removeNDSubscriptionEntry(MQQueueSubscription)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3013");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "removeNDSubscriptionEntry(MQQueueSubscription)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "removeNDSubscriptionEntry(MQQueueSubscription)");
        }
    }

    private MQQueueSubscription getResolvedSubscription(MQQueue adminQueue, MQQueueSubscription subscription, byte[] JVMRefID, boolean getNext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getResolvedSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription,byte [ ],boolean)", new Object[]{adminQueue, subscription, JVMRefID, getNext});
        }
        try {
            String fullName = subscription.getFullName();
            MQQueueSubscription subscription1 = null;
            MQSubscription subscription2 = null;
            subscription1 = this.getSubscriptionEntry(adminQueue, subscription.getMQSession(), fullName, null, null, getNext);
            if (subscription1 != null) {
                subscription1.setDurable(true);
                if (Trace.isOn) {
                    Trace.traceData(this, "Matching subscriber found. Checking for a second record.", null);
                }
                subscription2 = this.getSubscriptionEntry(adminQueue, subscription.getMQSession(), null, subscription1.getCorrelationId(), null, true);
            }
            if (subscription2 != null) {
                subscription2.setDurable(true);
                if (Trace.isOn) {
                    Trace.traceData(this, "Second record found: earlier problem must have occurred.", null);
                }
                if (this.getSubscriptionEntry(adminQueue, subscription.getMQSession(), null, subscription1.getCorrelationId(), null, false) == null) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "getResolved ERROR: couldn't reset browse cursor position", null);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS3013");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getResolvedSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription,byte [ ],boolean)", je, 1);
                    }
                    throw je;
                }
                if (subscription1.getSubscriberState() == 't' || ((MQQueueSubscription)subscription2).getSubscriberState() == 't') {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Trying to resolve problem detected with earlier create or unsubscribe.", null);
                    }
                    this.deleteSubscriber(subscription1);
                    this.removeSubscriptionEntry(adminQueue, subscription1);
                    this.removeSubscriptionEntry(adminQueue, (MQQueueSubscription)subscription2);
                    if (JVMRefID != null) {
                        subscription1.setSubscriberState('i');
                    } else {
                        subscription1 = null;
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Trying to resolve problem detected with earlier re-create or close.", null);
                    }
                    MQQueueSubscription newSubscription = subscription1;
                    subscription1.setSubscriberState('i');
                    subscription1.setStatusMgrId(MQC.MQCI_NONE);
                    if (Trace.isOn) {
                        Trace.traceData(this, "Remove the first old subscriptionEntry", null);
                    }
                    this.removeSubscriptionEntry(adminQueue, subscription1);
                    if (Trace.isOn) {
                        Trace.traceData(this, "Add the new subscriptionEntry", null);
                    }
                    this.addSubscriptionEntry(adminQueue, newSubscription, false);
                    if (Trace.isOn) {
                        Trace.traceData(this, "Remove the second old subscriptionEntry", null);
                    }
                    this.removeSubscriptionEntry(adminQueue, (MQQueueSubscription)subscription2);
                    subscription1 = newSubscription;
                }
            } else if (subscription1 != null && subscription1.getSubscriberState() == 't') {
                block29: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Trying to resolve problem detected with earlier create or unsubscribe.", null);
                    }
                    try {
                        this.deleteSubscriber(subscription1);
                    }
                    catch (JMSException je) {
                        if (!Trace.isOn) break block29;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getResolvedSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription,byte [ ],boolean)", je, 1);
                    }
                }
                this.removeSubscriptionEntry(adminQueue, subscription1);
                if (JVMRefID != null) {
                    subscription1.setSubscriberState('i');
                } else {
                    subscription1 = null;
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getResolvedSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription,byte [ ],boolean)", subscription1);
            }
            return subscription1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getResolvedSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription,byte [ ],boolean)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getResolvedSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription,byte [ ],boolean)", je, 2);
            }
            throw je;
        }
    }

    private MQQueueSubscription createNewDurableSubscription(MQQueue adminQueue, MQQueueSubscription subscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", new Object[]{adminQueue, subscription});
        }
        String subscriberQueueName = null;
        MQQueue subscriberQueue = null;
        int openOptionsInput = 33;
        byte[] subscriberId = null;
        boolean registered = false;
        MQQueueManager qm = null;
        if (subscription.getMQTopic() != null && subscription.getMQTopic().getIntProperty("failIfQuiesce") == 1) {
            openOptionsInput |= 0x2000;
        } else if (this.connection.getFailIfQuiesce() == 1) {
            openOptionsInput |= 0x2000;
        }
        MQSession mqs = subscription.getMQSession();
        try {
            try {
                qm = mqs.getQM();
                subscriberQueueName = subscription.getQueueName();
                if (!subscription.isSharedQueue()) {
                    subscriberQueue = qm.accessQueue("SYSTEM.JMS.MODEL.QUEUE", openOptionsInput, null, subscriberQueueName, null);
                    subscription.setQueueName(subscriberQueue.name);
                    subscriberQueueName = subscriberQueue.name;
                    if (Trace.isOn) {
                        Trace.traceData(this, "Using multiple-queue approach.", null);
                        Trace.traceData(this, "Model:  SYSTEM.JMS.MODEL.QUEUE", null);
                        Trace.traceData(this, "Prefix: SYSTEM.JMS.D.*", null);
                        Trace.traceData(this, "QName:  " + subscriberQueueName, null);
                    }
                } else {
                    subscriberQueue = qm.accessQueue(subscriberQueueName, openOptionsInput);
                    subscriberQueueName = subscriberQueue.name;
                    if (Trace.isOn) {
                        Trace.traceData(this, "Using shared-queue approach.", null);
                        Trace.traceData(this, "Prefix: SYSTEM.JMS.D.", null);
                        Trace.traceData(this, "QName:  " + subscriberQueueName, null);
                    }
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", e, 1);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS2008", subscriberQueueName);
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je, 1);
                }
                throw je;
            }
            try {
                subscription.setSubscriberQueue(subscriberQueue);
                subscription.setSubscriberState('t');
                subscriberId = this.addSubscriptionEntry(adminQueue, subscription, true);
                subscription.setCorrelationId(subscriberId);
            }
            catch (JMSException je) {
                block49: {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je, 2);
                    }
                    try {
                        subscriberQueue.close();
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", mqe, 3);
                        }
                        if (!Trace.isOn) break block49;
                        Trace.traceData(this, "Error closing subscriber queue.", null);
                    }
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je, 2);
                }
                throw je;
            }
            try {
                this.sendBrokerCommand(subscription, 1, true);
                registered = true;
            }
            catch (NoBrokerResponseException nbre) {
                block50: {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", (Throwable)((Object)nbre), 4);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "subscribe command failed, sending an unsubscribe to cancel it", null);
                    }
                    try {
                        this.sendBrokerCommand(subscription, 2, true);
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je, 5);
                        }
                        if (!Trace.isOn) break block50;
                        Trace.traceData(this, "the cancel command also failed.", null);
                    }
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", (Throwable)((Object)nbre), 3);
                }
                throw nbre;
            }
            catch (BrokerCommandFailedException bcfe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", (Throwable)((Object)bcfe), 6);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", (Throwable)((Object)bcfe), 4);
                }
                throw bcfe;
            }
            subscription.setSubscriberState('u');
            this.addSubscriptionEntry(adminQueue, subscription, false);
            this.removeSubscriptionEntry(adminQueue, subscription);
        }
        catch (JMSException je) {
            boolean cleanupProblems;
            block51: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je, 7);
                }
                cleanupProblems = false;
                if (registered) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "cleanup sending a cancel command", null);
                    }
                    try {
                        this.sendBrokerCommand(subscription, 2, true);
                    }
                    catch (JMSException je2) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je2, 8);
                        }
                        cleanupProblems = true;
                        if (!Trace.isOn) break block51;
                        Trace.traceData(this, "the cancel command also failed.", null);
                    }
                }
            }
            if (subscriberQueue != null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "closing subscription queue", null);
                }
                if (!subscription.isSharedQueue()) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "not a shared queue so will be deleted", null);
                    }
                    subscriberQueue.closeOptions = 2;
                }
                try {
                    subscriberQueue.close();
                }
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", e, 9);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Failed to delete subscription queue.", null);
                    }
                    cleanupProblems = true;
                }
            }
            if (!cleanupProblems) {
                this.removeSubscriptionEntry(adminQueue, subscription);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je, 5);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createNewDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", subscription);
        }
        return subscription;
    }

    private MQQueueSubscription createExistingDurableSubscription(MQQueue adminQueue, MQQueueSubscription subscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createExistingDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", new Object[]{adminQueue, subscription});
        }
        MQQueue subscriberQueue = null;
        MQQueueSubscription newSubscription = null;
        try {
            subscriberQueue = this.checkInactive(subscription);
            subscription.setSubscriberQueue(subscriberQueue);
            newSubscription = subscription;
            newSubscription.setSubscriberState('u');
            newSubscription.setStatusMgrId(this.statusMgrId);
            this.addSubscriptionEntry(adminQueue, newSubscription, false);
            this.removeSubscriptionEntry(adminQueue, subscription);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createExistingDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createExistingDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createExistingDurableSubscription(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", newSubscription);
        }
        return newSubscription;
    }

    private MQQueueSubscription createUpdatedDurableSubscriber(MQQueue adminQueue, MQQueueSubscription subscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createUpdatedDurableSubscriber(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", new Object[]{adminQueue, subscription});
        }
        MQQueueSubscription retSubscription = null;
        try {
            MQQueueSubscription newSubscription = null;
            newSubscription = subscription;
            this.unsubscribe(adminQueue, subscription.getMQSession(), subscription.getSubName());
            newSubscription.setStatusMgrId(this.statusMgrId);
            retSubscription = this.createNewDurableSubscription(adminQueue, newSubscription);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createUpdatedDurableSubscriber(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createUpdatedDurableSubscriber(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "createUpdatedDurableSubscriber(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", retSubscription);
        }
        return retSubscription;
    }

    private MQQueue getAdminQueueAccess(MQSession mqs, int fiqBehaviour) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", new Object[]{mqs, new Integer(fiqBehaviour)});
        }
        int MAXRETRIES = 20;
        int MAXWAIT = 5000;
        MQQueueManager qm = mqs.getQM();
        MQQueue adminQueue = null;
        int attempt = 0;
        block7: while (true) {
            try {
                if (Trace.isOn) {
                    Trace.traceData(this, "Try to open the adminQueue", null);
                }
                int openOptions = 60;
                if (fiqBehaviour == 1) {
                    openOptions |= 0x2000;
                }
                adminQueue = qm.accessQueue("SYSTEM.JMS.ADMIN.QUEUE", openOptions);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Cannot open adminQueue", null);
                }
                switch (e.reasonCode) {
                    case 2042: {
                        if (++attempt < 20) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "admin queue locked, tried " + attempt + "times", null);
                                Trace.traceData(this, "suppressing exception and retrying after wait", null);
                            }
                            try {
                                long daisyTime = (long)(100.0 + 5000.0 * Math.random());
                                if (Trace.isOn) {
                                    Trace.traceData(this, "waiting for " + daisyTime + " milis...", null);
                                }
                                Thread.sleep(daisyTime);
                            }
                            catch (InterruptedException ie) {
                                if (!Trace.isOn) continue block7;
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", ie, 2);
                            }
                            continue block7;
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Tried 20 attempts. I'm bored now so I'll throw an exception", null);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", je, 1);
                        }
                        throw je;
                    }
                    default: {
                        JMSException je = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", je, 2);
                        }
                        throw je;
                    }
                }
                continue;
            }
            break;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "Obtaining the admin queue lock required " + attempt + " retries", null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", adminQueue);
        }
        return adminQueue;
    }

    private byte[] addSubscriptionEntry(MQQueue adminQueue, MQQueueSubscription subscription, boolean checkExists) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "addSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription,boolean)", new Object[]{adminQueue, subscription, checkExists});
        }
        byte[] subscriberId = null;
        if (checkExists && this.contains(adminQueue, subscription.getMQSession(), subscription.getSubName())) {
            if (Trace.isOn) {
                Trace.traceData(this, "In addSubscriptionEntry() - entry already exists!", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3013");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "addSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription,boolean)", je, 1);
            }
            throw je;
        }
        MQMessage subEntryMsg = subscription.toMessage();
        if (Trace.isOn) {
            Trace.traceData(this, "MQPUT with messageId: ", (Object)subEntryMsg.messageId);
        }
        try {
            adminQueue.put(subEntryMsg, new MQPutMessageOptions());
            subscriberId = subEntryMsg.messageId;
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "addSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription,boolean)", e);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "In addSubscriptionEntry() - unable to MQPUT new entry", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3013");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "addSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription,boolean)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "addSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription,boolean)", subscriberId);
        }
        return subscriberId;
    }

    private void removeSubscriptionEntry(MQQueue adminQueue, MQQueueSubscription subscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "removeSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", new Object[]{adminQueue, subscription});
        }
        MQQueueSubscription currentEntry = null;
        byte[] subscriberId = subscription.getCorrelationId();
        String key = subscription.getSubName();
        MQGetMessageOptions gmo = new MQGetMessageOptions();
        if (subscriberId == null) {
            gmo.options = 16;
        }
        boolean carryOn = true;
        if (this.connection.getFailIfQuiesce() == 1) {
            gmo.options |= 0x2000;
        }
        while (carryOn) {
            try {
                MQMessage msg = new MQMessage();
                if (subscriberId != null) {
                    msg.messageId = subscriberId;
                    gmo.matchOptions |= 1;
                }
                adminQueue.get(msg, gmo);
                currentEntry = new MQQueueSubscription(this, subscription.getMQSession(), msg);
                if (subscriberId != null) {
                    carryOn = false;
                    continue;
                }
                if (currentEntry.isValid() && currentEntry.getSubName().equals(key)) {
                    gmo.options = 256;
                    MQMessage delmsg = new MQMessage();
                    adminQueue.get(delmsg, gmo);
                    carryOn = false;
                    continue;
                }
                gmo.options = 32;
                if (this.connection.getFailIfQuiesce() != 1) continue;
                gmo.options |= 0x2000;
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "removeSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", e);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3013");
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.traceData(this, "In removeSubscriptionEntry() - cannot remove msg!", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "removeSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)", je);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "removeSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQQueueSubscription)");
        }
    }

    private MQQueue checkInactive(MQQueueSubscription subscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "checkInactive(MQQueueSubscription)", new Object[]{subscription});
        }
        MQQueueManager qm = null;
        MQQueue subscriberQueue = null;
        boolean subInactive = false;
        qm = subscription.getMQSession().getQM();
        if (subscription.getSubscriberState() == 'i') {
            subInactive = true;
        } else if (subscription.getSubscriberState() != 'u') {
            if (Trace.isOn) {
                Trace.traceData(this, "checkInactive: state is neither unknown or inactive!", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3005");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "checkInactive(MQQueueSubscription)", je, 1);
            }
            throw je;
        }
        int fiqBehaviour = 1;
        if (subscription.getMQTopic() != null) {
            fiqBehaviour = subscription.getMQTopic().getIntProperty("failIfQuiesce");
        } else if (subscription.getMQSession() != null) {
            fiqBehaviour = subscription.getMQSession().getFailIfQuiesce();
        }
        try {
            if (subscription.isSharedQueue() && !subInactive) {
                int openOptions = 10;
                if (fiqBehaviour == 1) {
                    openOptions |= 0x2000;
                }
                MQQueue statusQueue = qm.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", openOptions);
                MQMessage jvmMessage = new MQMessage();
                jvmMessage.messageId = subscription.getStatusMgrId();
                MQGetMessageOptions gmo = new MQGetMessageOptions();
                gmo.options = 16;
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "attempting MQGET for jvm reference msg.", null);
                    }
                    statusQueue.get(jvmMessage, gmo);
                }
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "checkInactive(MQQueueSubscription)", e, 1);
                    }
                    if (e.reasonCode == 2033) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "shared subscriber assumed active.", null);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS3023");
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "checkInactive(MQQueueSubscription)", je, 2);
                        }
                        throw je;
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "checkInactive(MQQueueSubscription)", e, 3);
                    }
                    throw e;
                }
                statusQueue.close();
            }
            if (Trace.isOn) {
                Trace.traceData(this, "opening subscription queue", null);
            }
            subscriberQueue = this.openSubscriberQueue(subscription.getMQSession(), subscription.getQueueName(), subscription.isSharedQueue(), true, fiqBehaviour);
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "checkInactive(MQQueueSubscription)", e, 2);
            }
            JMSException je = e.reasonCode == 2042 ? ConfigEnvironment.newException("MQJMS3023") : ConfigEnvironment.newException("MQJMS3005");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "checkInactive(MQQueueSubscription)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "checkInactive(MQQueueSubscription)", subscriberQueue);
        }
        return subscriberQueue;
    }

    private MQQueueSubscription getSubscriptionEntry(MQQueue adminQueue, MQSession mqs, String key, byte[] subscriberId, byte[] jvmReferenceId, boolean getNext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String,byte [ ],byte [ ],boolean)", new Object[]{adminQueue, mqs, key, subscriberId, jvmReferenceId, getNext});
        }
        MQQueueSubscription ae = null;
        MQQueueSubscription ret = null;
        MQGetMessageOptions gmo = new MQGetMessageOptions();
        gmo.options = getNext ? 32 : 16;
        if (this.connection.getFailIfQuiesce() == 1) {
            gmo.options |= 0x2000;
        }
        boolean carryOn = true;
        while (carryOn) {
            try {
                MQMessage msg = new MQMessage();
                if (subscriberId != null) {
                    msg.messageId = subscriberId;
                }
                if (jvmReferenceId != null) {
                    msg.correlationId = jvmReferenceId;
                }
                adminQueue.get(msg, gmo);
                ae = new MQQueueSubscription(this, mqs, msg);
                if (key == null && ae.isValid()) {
                    ret = ae;
                    carryOn = false;
                    continue;
                }
                if (key != null && ae.isValid() && ae.getFullName().equals(key)) {
                    ret = ae;
                    carryOn = false;
                    continue;
                }
                gmo.options = 32;
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String,byte [ ],byte [ ],boolean)", e);
                }
                carryOn = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getSubscriptionEntry(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String,byte [ ],byte [ ],boolean)", ret);
        }
        return ret;
    }

    private void deleteSubscriber(MQQueueSubscription subscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "deleteSubscriber(MQQueueSubscription)", new Object[]{subscription});
        }
        JMSException deregException = null;
        String fullName = subscription.isDurable() ? subscription.getClientId() + ":" + subscription.getSubName() : "";
        MQSubEntry subEntry = new MQSubEntry(fullName, subscription.getTopic(), subscription.getQueueName(), subscription.getSelector(), subscription.getNoLocal(), subscription.getStatusMgrId(), subscription.isSharedQueue());
        subEntry.setSubscriberId(subscription.getCorrelationId());
        MQQueue subQ = subscription.getSubscriberQueue();
        try {
            block15: {
                try {
                    this.sendBrokerCommand(subscription, 2, true);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "deleteSubscriber(MQQueueSubscription)", je, 1);
                    }
                    deregException = je;
                    if (!Trace.isOn) break block15;
                    Trace.traceData(this, "Failed to deregister.", null);
                }
            }
            SubscriptionHelper.deleteSubscriberMessages(subEntry, subQ);
            if (deregException != null) {
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "deleteSubscriber(MQQueueSubscription)", deregException, 1);
                }
                throw deregException;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "deleteSubscriber(MQQueueSubscription)", je, 2);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Failure in deleteSubscriber.", null);
            }
            if (deregException != null && je != deregException) {
                if (Trace.isOn) {
                    Trace.traceData(this, "NOTE! Throwing pending deregException instead!", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "deleteSubscriber(MQQueueSubscription)", deregException, 2);
                }
                throw deregException;
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "deleteSubscriber(MQQueueSubscription)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "deleteSubscriber(MQQueueSubscription)");
        }
    }

    /*
     * Exception decompiling
     */
    private void sendBrokerCommand(MQQueueSubscription subscription, int command, boolean wait) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void getBrokerResponse(MQSession mqs, MQMsg2 response) throws NoBrokerResponseException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)", new Object[]{mqs, response});
        }
        try {
            MQQueue replyQ = mqs.getResponseQueue();
            MQGetMessageOptions brokerResponseGmo = new MQGetMessageOptions();
            brokerResponseGmo.options = 1;
            brokerResponseGmo.matchOptions = 2;
            brokerResponseGmo.waitInterval = 120000;
            if (this.connection.getFailIfQuiesce() == 1) {
                brokerResponseGmo.options |= 0x2000;
            }
            replyQ.getMsg2(response, brokerResponseGmo);
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)", e, 1);
            }
            String key = "MQJMS5053";
            String msg = ConfigEnvironment.getErrorMessage(key);
            NoBrokerResponseException je = new NoBrokerResponseException(msg, key);
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)", (Throwable)((Object)je), 1);
            }
            throw je;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)", je, 2);
            }
            RuntimeException traceRet1 = new RuntimeException("MQJMS1016");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)", traceRet1, 2);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)");
        }
    }

    public void unsubscribe(MQQueue adminQueue, MQSession mqs, String subName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "unsubscribe(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String)", new Object[]{adminQueue, mqs, subName});
        }
        try {
            MQQueueSubscription sub = new MQQueueSubscription(this, mqs, true, false, mqs.getQMName(), this.getMQConnection().getClientID(), subName, null, null, false, null, null, null);
            MQQueueSubscription subscription = this.getResolvedSubscription(adminQueue, sub, null, false);
            if (subscription == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "No entry found for '" + subName + "'", null);
                }
                String key = "MQJMS3018";
                String msg = ConfigEnvironment.getErrorMessage(key, subName);
                InvalidDestinationException ide = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "unsubscribe(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String)", (Throwable)ide, 1);
                }
                throw ide;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Entry found for '" + subName + "'", null);
                Trace.traceData(this, subscription.toString(), null);
            }
            MQQueue subQ = null;
            try {
                subQ = this.checkInactive(subscription);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "unsubscribe(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String)", je, 1);
                }
                MQException e = (MQException)((Object)je.getLinkedException());
                switch (e.reasonCode) {
                    case 2052: 
                    case 2085: {
                        if (!Trace.isOn) break;
                        Trace.traceData(this, "Warning: durable sub queue '" + subscription.getQueueName() + " is missing\n", null);
                        Trace.traceData(this, "Carrying on with deregister", null);
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "unsubscribe(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String)", je, 2);
                        }
                        throw je;
                    }
                }
            }
            subscription.setSubscriberQueue(subQ);
            subscription.setSubscriberState('t');
            this.addSubscriptionEntry(adminQueue, subscription, false);
            this.deleteSubscriber(subscription);
            try {
                this.removeSubscriptionEntry(adminQueue, subscription);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "unsubscribe(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String)", je, 2);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "unsubscribe problem - failed to remove the admin entry.", null);
                }
                JMSException je2 = ConfigEnvironment.newException("MQJMS3013");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "unsubscribe(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String)", je2, 3);
                }
                throw je2;
            }
            this.removeSubscriptionEntry(adminQueue, subscription);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "unsubscribe(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String)", je, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "unsubscribe(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "unsubscribe(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String)");
        }
    }

    MQPSStatusMgr getPubSubStatusMgr() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getPubSubStatusMgr()", "getter", this.pubsubStatusMgr);
        }
        return this.pubsubStatusMgr;
    }

    byte[] getStatusMgrId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "getStatusMgrId()", "getter", this.statusMgrId);
        }
        return this.statusMgrId;
    }

    boolean contains(MQQueue adminQueue, MQSession mqs, String key) throws JMSException {
        boolean traceRet1;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "contains(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String)", new Object[]{adminQueue, mqs, key});
        }
        boolean bl = traceRet1 = this.getSubscriptionEntry(adminQueue, mqs, key, null, null, false) != null;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "contains(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession,String)", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueSubscriptionEngine.java, jmscc.wmq.v6, k701, k701-112-140304  1.30.1.1 09/08/17 08:13:41");
        }
    }
}

