/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine;

public class MQQueueSubscription
extends MQSubscription {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueSubscription.java, jmscc.wmq.v6, k701, k701-112-140304 1.20.1.1 09/08/17 08:13:30";
    static final String SUBENTRY_SIGNATURE = "MQJMS_PS_SUBENTRY_v2";
    static final String SUBENTRY_v1SIGNATURE = "MQJMS_PS_ADMIN_ENTRY";
    static final String SIGNATURE = "MQJMS_PS_SUBENTRY_v2";
    private char subscriberState;
    private byte[] statusMgrId;
    private boolean validity = false;

    public MQQueueSubscription(MQSubscriptionEngine subscriptionEngine, MQSession session, boolean durable, boolean sharedQueue, String qmgrName, String clientId, String subName, WMQDestination topic, String selector, boolean noLocal, String queueName, MQQueue subscriberQueue, byte[] correlationId) {
        super(subscriptionEngine, session, durable, sharedQueue, qmgrName, clientId, subName, topic, selector, noLocal, queueName, subscriberQueue, correlationId);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "<init>(MQSubscriptionEngine,MQSession,boolean,boolean,String,String,String,WMQDestination,String,boolean,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,byte [ ])", new Object[]{subscriptionEngine, session, durable, sharedQueue, qmgrName, clientId, subName, topic, selector, noLocal, queueName, subscriberQueue, correlationId});
        }
        this.subscriberState = (char)117;
        this.validity = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "<init>(MQSubscriptionEngine,MQSession,boolean,boolean,String,String,String,WMQDestination,String,boolean,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,byte [ ])");
        }
    }

    public MQQueueSubscription(MQSubscriptionEngine subscriptionEngine, MQSession session, MQMessage m) {
        super(subscriptionEngine, session, false, false, session.getQMName(), null, null, null, null, false, null, null, null);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "<init>(MQSubscriptionEngine,MQSession,com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", new Object[]{subscriptionEngine, session, m});
        }
        boolean isQSub = false;
        int version = 2;
        Object subQueue = null;
        try {
            this.setQmgrName(session.getQMName());
            String sig = m.readStringOfByteLength("MQJMS_PS_SUBENTRY_v2".length());
            if (sig.equals("MQJMS_PS_SUBENTRY_v2")) {
                isQSub = true;
            } else if (!sig.equals("MQJMS_PS_SUBENTRY_v2")) {
                isQSub = true;
                version = 2;
                if (sig.equals(SUBENTRY_v1SIGNATURE)) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "v1 style subscriber entry found on DurSubAdmin queue.", null);
                    }
                    version = 1;
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Non-DurSubEntry message on DurSubAdmin queue!", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "<init>(MQSubscriptionEngine,MQSession,com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", 1);
                    }
                    return;
                }
            }
            String fullName = null;
            int l = m.readInt();
            if (l > 0) {
                fullName = m.readStringOfByteLength(l);
                int p = fullName.indexOf(":");
                if (p == -1) {
                    Exception traceRet1 = new Exception();
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "<init>(MQSubscriptionEngine,MQSession,com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", traceRet1);
                    }
                    throw traceRet1;
                }
                String clientId = fullName.substring(0, p);
                String subName = fullName.substring(p + 1);
                this.setClientId(clientId);
                this.setSubName(subName);
            } else {
                this.setClientId("");
                this.setSubName("");
            }
            l = m.readInt();
            this.setTopic(m.readStringOfByteLength(l));
            l = m.readInt();
            this.setQueueName(m.readStringOfByteLength(l));
            l = m.readInt();
            if (l > 0) {
                this.setSelector(m.readStringOfByteLength(l));
            } else {
                this.setSelector("");
            }
            this.setNoLocal(m.readChar() == 'y');
            if (version != 1) {
                this.setSharedQueue(m.readChar() == 'y');
                this.subscriberState = m.readChar();
                this.statusMgrId = m.correlationId;
                this.setCorrelationId(m.messageId);
            }
            this.validity = true;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "<init>(MQSubscriptionEngine,MQSession,com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", e);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Could not create MQQueueSubscription.", null);
            }
            this.validity = false;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "<init>(MQSubscriptionEngine,MQSession,com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", 2);
        }
    }

    void setSubscriberState(char subscriberState) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "setSubscriberState(char)", "setter", new Character(subscriberState));
        }
        this.subscriberState = subscriberState;
    }

    char getSubscriberState() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "getSubscriberState()", "getter", new Character(this.subscriberState));
        }
        return this.subscriberState;
    }

    void setStatusMgrId(byte[] statusMgrId) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "setStatusMgrId(byte [ ])", "setter", statusMgrId);
        }
        this.statusMgrId = statusMgrId;
    }

    byte[] getStatusMgrId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "getStatusMgrId()", "getter", this.statusMgrId);
        }
        return this.statusMgrId;
    }

    boolean isValid() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "isValid()", "getter", this.validity);
        }
        return this.validity;
    }

    MQMessage toMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "toMessage()");
        }
        String subName = this.getSubName();
        String clientId = this.getClientId();
        String topic = this.getTopic();
        String queueName = this.getQueueName();
        String selector = this.getSelector();
        byte[] correlationId = this.getCorrelationId();
        if (Trace.isOn) {
            Trace.traceData(this, "subName: " + subName, null);
            Trace.traceData(this, "clientId: " + clientId, null);
            Trace.traceData(this, "topic: " + topic, null);
            Trace.traceData(this, "queueName: " + queueName, null);
            Trace.traceData(this, "selector: " + selector, null);
            Trace.traceData(this, "correlationId: " + correlationId, null);
        }
        MQMessage newMessage = new MQMessage();
        try {
            String fullName = this.isDurable() ? clientId + ":" + subName : "";
            if (Trace.isOn) {
                Trace.traceData(this, "Writing Signature: MQJMS_PS_SUBENTRY_v2", null);
            }
            newMessage.writeString("MQJMS_PS_SUBENTRY_v2");
            if (Trace.isOn) {
                Trace.traceData(this, "Writing fullNameLength: " + fullName.length(), null);
            }
            newMessage.writeInt(fullName.length());
            if (Trace.isOn) {
                Trace.traceData(this, "Writing fullName: " + fullName, null);
            }
            newMessage.writeString(fullName);
            newMessage.writeInt(topic.length());
            newMessage.writeString(topic);
            newMessage.writeInt(queueName.length());
            newMessage.writeString(queueName);
            if (selector == null) {
                newMessage.writeInt(0);
            } else {
                newMessage.writeInt(selector.length());
                newMessage.writeString(selector);
            }
            newMessage.writeChar(this.getNoLocal() ? 121 : 110);
            newMessage.writeChar(this.isSharedQueue() ? 121 : 110);
            newMessage.writeChar(this.subscriberState);
            if (correlationId != null) {
                newMessage.messageId = correlationId;
            }
            if (this.statusMgrId != null) {
                newMessage.correlationId = this.statusMgrId;
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "toMessage()", e);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Could not convert MQQueueSubscription to MQMessage", null);
            }
            newMessage = null;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "toMessage()", (Object)newMessage);
        }
        return newMessage;
    }

    public String getFullName() {
        String traceRet1 = this.getClientId() + ":" + this.getSubName();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "getFullName()", "getter", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueSubscription.java, jmscc.wmq.v6, k701, k701-112-140304  1.20.1.1 09/08/17 08:13:30");
        }
    }
}

