/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageReference;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import java.io.IOException;
import java.util.HashMap;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.ResourceAllocationException;
import javax.jms.TransactionRolledBackException;

public class MQQueueServices {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final int MQCA_QSG_NAME = 2040;
    private static final String PROBE_01 = "01";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueServices.java, jmscc.wmq.v6, k701, k701-112-140304 1.30.1.4 11/12/12 16:28:22";
    private MQQueue cbInputQueue;
    private String deadLetterQueue;
    private String dynamicQName;
    private MQQueueManager initialQm;
    private String lastQueueName;
    private String messageQueueName;
    private int messageRetention;
    private String qmName;
    private String resolvedQmName;
    private String resolvedQSGName;
    protected byte[] sessionName;
    private String temporaryModelQ;
    private String tempQPrefix;
    private MQQueueManager tempQqm;
    private int tmpQOpenOptions;

    MQQueueServices() {
        this.cbInputQueue = null;
        this.deadLetterQueue = null;
        this.dynamicQName = null;
        this.initialQm = null;
        this.lastQueueName = null;
        this.qmName = null;
        this.resolvedQmName = null;
        this.resolvedQSGName = null;
        this.tempQqm = null;
        this.tmpQOpenOptions = 32;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "<init>()");
        }
    }

    MQQueueServices(MQConnection connection, MQQueueManager qm, boolean transacted, int acknowledgeMode) throws JMSException {
        block10: {
            int selector;
            this.cbInputQueue = null;
            this.deadLetterQueue = null;
            this.dynamicQName = null;
            this.initialQm = null;
            this.lastQueueName = null;
            this.qmName = null;
            this.resolvedQmName = null;
            this.resolvedQSGName = null;
            this.tempQqm = null;
            this.tmpQOpenOptions = 32;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "<init>(MQConnection,MQQueueManager,boolean,int)", new Object[]{connection, qm, transacted, new Integer(acknowledgeMode)});
            }
            try {
                selector = 2015;
                this.resolvedQmName = qm.getAttributeString(selector, 48).trim();
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "<init>(MQConnection,MQQueueManager,boolean,int)", e, 1);
                }
                this.resolvedQmName = qm.name;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Resolving QSGName", null);
            }
            try {
                selector = 2040;
                this.resolvedQSGName = qm.getAttributeString(selector, 4).trim();
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "<init>(MQConnection,MQQueueManager,boolean,int)", e, 2);
                }
                this.resolvedQSGName = null;
                if (!Trace.isOn) break block10;
                Trace.traceData(this, "Setting QSGName to null", null);
            }
        }
        if (Trace.isOn) {
            Trace.traceData(this, "QSGName set to " + this.resolvedQSGName, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "<init>(MQConnection,MQQueueManager,boolean,int)");
        }
    }

    void checkQueueAccess(WMQDestination queue, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "checkQueueAccess(WMQDestination,MQSession)", new Object[]{queue, session});
        }
        if (queue.isTemporary()) {
            queue.checkAccess(session.connection);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "checkQueueAccess(WMQDestination,MQSession)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitQ(MQSession queueSession, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "commitQ(MQSession,MQSession)", new Object[]{queueSession, session});
        }
        try {
            if (!queueSession.transacted) {
                String key = "MQJMS1019";
                String msg = ConfigEnvironment.getErrorMessage(key);
                IllegalStateException je = new IllegalStateException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "commitQ(MQSession,MQSession)", je, 1);
                }
                throw je;
            }
            if (session.getQM() == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "commitQ(MQSession,MQSession)", je, 2);
                }
                throw je;
            }
            try {
                Object je = queueSession.getTransactionLock();
                synchronized (je) {
                    session.getQM().commit();
                }
            }
            catch (MQException e) {
                JMSException je;
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "commitQ(MQSession,MQSession)", e, 1);
                }
                int compCode = e.completionCode;
                int reasonCode = e.reasonCode;
                if (compCode == 1 && reasonCode == 2003) {
                    String key = "MQJMS0011";
                    String msg = ConfigEnvironment.getErrorMessage(key);
                    je = new TransactionRolledBackException(msg, key);
                } else {
                    je = ConfigEnvironment.newException("MQJMS2009");
                }
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "commitQ(MQSession,MQSession)", je, 3);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "commitQ(MQSession,MQSession)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "commitQ(MQSession,MQSession)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "commitQ(MQSession,MQSession)");
        }
    }

    protected ProviderMessage consume(byte[] flattenedRef, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(byte [ ],MQSession)", new Object[]{flattenedRef, session});
        }
        try {
            if (Trace.isOn) {
                Trace.traceData(this, "recreating MessageReference", null);
            }
            ProviderMessageReference newRef = this.recreateMessageReference(flattenedRef, session);
            if (Trace.isOn) {
                Trace.traceData(this, "Recreated MessageReference. Trying to consume message", null);
            }
            ProviderMessage newMessage = this.consume(newRef, session);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(byte [ ],MQSession)", newMessage);
            }
            return newMessage;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(byte [ ],MQSession)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(byte [ ],MQSession)", je);
            }
            throw je;
        }
    }

    protected ProviderMessage consume(ProviderMessageReference mRef, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", new Object[]{mRef, session});
        }
        int reasonCode = 0;
        try {
            MQGetMessageOptions gmo;
            MQMessageReference mr;
            block45: {
                if (!(mRef instanceof MQMessageReference)) {
                    JMSException je = new JMSException("MQJMS1096");
                    if (Trace.isOn) {
                        Trace.traceData(this, "MessageReference is not an MQMessageReference.", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", je, 1);
                    }
                    throw je;
                }
                mr = (MQMessageReference)mRef;
                String queueName = mr.getReferenceQueue();
                if (Trace.isOn) {
                    Trace.traceData(this, "Got referenceQueueName = '" + queueName + "'", null);
                }
                this.messageQueueName = queueName;
                gmo = new MQGetMessageOptions(true);
                MQQueueManager qm = session.getQM();
                if (Trace.isOn) {
                    Trace.traceData(this, "Setting up GMO", null);
                }
                gmo.matchOptions = 1;
                gmo.options = 8256;
                gmo.options = session.calculateUseSPIP() ? (gmo.options |= 0x1000) : (gmo.options |= 2);
                try {
                    if (this.cbInputQueue == null || this.messageQueueName != this.lastQueueName) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Queue " + this.messageQueueName + " to be opened", null);
                        }
                        if (this.cbInputQueue != null) {
                            this.cbInputQueue.close();
                        }
                        this.cbInputQueue = qm.accessQueue(this.messageQueueName, 8194);
                        this.lastQueueName = this.messageQueueName;
                        if (Trace.isOn) {
                            Trace.traceData(this, "Got access to " + this.cbInputQueue.name, null);
                        }
                    } else if (Trace.isOn) {
                        Trace.traceData(this, "using cached queue for " + this.messageQueueName, null);
                    }
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", mqe, 1);
                    }
                    if (mqe.completionCode != 2) break block45;
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", null, 1);
                    }
                    return null;
                }
            }
            JMSMessage outMessage = null;
            if (this.cbInputQueue != null) {
                MQJMSMessage dummyMessage;
                if (mr.getDataQuantity() == 2) {
                    outMessage = mr.getJMSMessage();
                    dummyMessage = mr.getMQJMSMessage();
                    if (dummyMessage == null) {
                        dummyMessage = new MQJMSMessage();
                        dummyMessage.setMessageId(mr.getMessageId());
                        dummyMessage.setCorrelationId(mr.getCorrelId());
                    }
                    if ((reasonCode = this.cbInputQueue.getMsg2NoExc(dummyMessage, gmo, 0)) == 2079) {
                        reasonCode = 0;
                    }
                    if (reasonCode != 0) {
                        outMessage = null;
                    }
                } else {
                    dummyMessage = mr.getMQJMSMessage();
                    if (dummyMessage == null) {
                        dummyMessage = new MQJMSMessage();
                        dummyMessage.setMessageId(mr.getMessageId());
                        dummyMessage.setCorrelationId(mr.getCorrelId());
                    }
                    gmo.options &= 0xFFFFFFBF;
                    reasonCode = this.cbInputQueue.getMsg2NoExc(dummyMessage, gmo);
                    if (reasonCode == 0) {
                        outMessage = dummyMessage.createJMSMessage(session, mr.getDestination());
                    }
                }
                if (reasonCode == 2033) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "NO_MSG_AVAILABLE - message removed from queue", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", null, 2);
                    }
                    return null;
                }
                if (reasonCode != 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Got MQRC " + reasonCode, null);
                    }
                    MQException traceRet1 = new MQException(2, reasonCode, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", traceRet1, 2);
                    }
                    throw traceRet1;
                }
            } else {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", null, 3);
                }
                return null;
            }
            if (!session.getTransacted()) {
                outMessage._setSession(session);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", outMessage, 4);
            }
            return outMessage;
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", mqe, 2);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS2002");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", je, 3);
            }
            throw je;
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", ioe, 3);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Badly formatted message.", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS0006");
            je.setLinkedException((Exception)ioe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", je, 4);
            }
            throw je;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", je, 4);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "consume(ProviderMessageReference,MQSession)", je, 5);
            }
            throw je;
        }
    }

    MQQueue getOutputQueue(WMQDestination dest, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getOutputQueue(WMQDestination,MQSession)", new Object[]{dest, session});
        }
        try {
            MQQueue mqqueue = null;
            if (dest == null) {
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getOutputQueue(WMQDestination,MQSession)", (Throwable)je, 1);
                }
                throw je;
            }
            String qName = dest.getName();
            String qmName = dest.getStringProperty("XMSC_WMQ_QUEUE_MANAGER");
            int openOptions = 16;
            if (dest.getIntProperty("failIfQuiesce") == 1) {
                openOptions |= 0x2000;
            }
            openOptions |= MQMessageProducer.computeMessageContextOptions(dest);
            try {
                mqqueue = session.getQM().accessQueue(qName, openOptions, qmName, this.dynamicQName, "");
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getOutputQueue(WMQDestination,MQSession)", e, 1);
                }
                JMSException je = this.getQueueOpenException(e, qName);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getOutputQueue(WMQDestination,MQSession)", je, 2);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getOutputQueue(WMQDestination,MQSession)", mqqueue);
            }
            return mqqueue;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getOutputQueue(WMQDestination,MQSession)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getOutputQueue(WMQDestination,MQSession)", je, 3);
            }
            throw je;
        }
    }

    MQQueue getQueueForBrowse(WMQDestination queueSpec, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getQueueForBrowse(WMQDestination,MQSession)", new Object[]{queueSpec, session});
        }
        try {
            MQQueue result;
            if (queueSpec == null) {
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getQueueForBrowse(WMQDestination,MQSession)", (Throwable)je, 1);
                }
                throw je;
            }
            if (session.getQM() == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS2004");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getQueueForBrowse(WMQDestination,MQSession)", je, 2);
                }
                throw je;
            }
            String qmgrName = queueSpec.getStringProperty("XMSC_WMQ_QUEUE_MANAGER");
            if (!(qmgrName == null || qmgrName.equals("") || qmgrName.equals(this.resolvedQmName) || qmgrName.equals(this.resolvedQSGName))) {
                JMSException je = ConfigEnvironment.newException("MQJMS1017");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getQueueForBrowse(WMQDestination,MQSession)", je, 3);
                }
                throw je;
            }
            String qName = queueSpec.getName();
            int openOptions = 40;
            if (queueSpec.getIntProperty("failIfQuiesce") == 1) {
                openOptions |= 0x2000;
            }
            try {
                result = session.getQM().accessQueue(qName, openOptions);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getQueueForBrowse(WMQDestination,MQSession)", e, 1);
                }
                JMSException je = this.getQueueOpenException(e, qName);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getQueueForBrowse(WMQDestination,MQSession)", je, 4);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getQueueForBrowse(WMQDestination,MQSession)", result);
            }
            return result;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getQueueForBrowse(WMQDestination,MQSession)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getQueueForBrowse(WMQDestination,MQSession)", je, 5);
            }
            throw je;
        }
    }

    protected JMSException getQueueOpenException(MQException mqe, String qName) {
        Object je;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getQueueOpenException(MQException,String)", new Object[]{mqe, qName});
        }
        String key = "MQJMS2008";
        String message = ConfigEnvironment.getErrorMessage(key, qName);
        switch (mqe.reasonCode) {
            case 2001: 
            case 2011: 
            case 2043: 
            case 2052: 
            case 2057: 
            case 2058: 
            case 2082: 
            case 2085: 
            case 2086: 
            case 2087: 
            case 2091: 
            case 2092: 
            case 2152: 
            case 2153: 
            case 2184: 
            case 2194: 
            case 2196: 
            case 2197: 
            case 2198: 
            case 2199: {
                je = new InvalidDestinationException(message, key);
                break;
            }
            case 2017: 
            case 2071: 
            case 2102: 
            case 2192: {
                je = new ResourceAllocationException(message, key);
                break;
            }
            case 2035: {
                je = new JMSSecurityException(message, key);
                break;
            }
            default: {
                je = new JMSException(message, key);
            }
        }
        je.setLinkedException((Exception)((Object)mqe));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "getQueueOpenException(MQException,String)", je);
        }
        return je;
    }

    protected ProviderMessageReference recreateMessageReference(byte[] flatMR, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "recreateMessageReference(byte [ ],MQSession)", new Object[]{flatMR, session});
        }
        try {
            MQMessageReference traceRet1 = new MQMessageReference(session, flatMR, null);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "recreateMessageReference(byte [ ],MQSession)", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "recreateMessageReference(byte [ ],MQSession)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "recreateMessageReference(byte [ ],MQSession)", je);
            }
            throw je;
        }
    }

    /*
     * Loose catch block
     */
    void redirectMessage(String qName, MQMsg2 message, boolean syncPoint, MQSession session) throws JMSException {
        block25: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", new Object[]{qName, message, syncPoint, session});
            }
            MQQueue queue = null;
            try {
                block24: {
                    if (session.getQM() == null) {
                        JMSException je = ConfigEnvironment.newException("MQJMS2004");
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", je, 1);
                        }
                        throw je;
                    }
                    try {
                        MQPutMessageOptions pmo = new MQPutMessageOptions();
                        if (syncPoint) {
                            pmo.options |= 2;
                            pmo.options &= 0xFFFFFFFB;
                        } else {
                            pmo.options |= 4;
                            pmo.options &= 0xFFFFFFFD;
                        }
                        session.getQM().putMsg2(qName, "", message, pmo);
                        Object var9_10 = null;
                        if (!Trace.isOn) break block24;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)");
                        }
                        if (queue != null) {
                            try {
                                queue.close();
                            }
                            catch (MQException e) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", e, 2);
                                }
                                HashMap<String, Object> ffstData = new HashMap<String, Object>();
                                ffstData.put("Exception", (Object)e);
                                ffstData.put("Message", "MQJMS2000");
                                Trace.ffst(this, "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", PROBE_01, ffstData, JMSException.class);
                            }
                        }
                        throw throwable;
                    }
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)");
                }
                if (queue != null) {
                    try {
                        queue.close();
                    }
                    catch (MQException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", e, 2);
                        }
                        HashMap<String, Object> ffstData = new HashMap<String, Object>();
                        ffstData.put("Exception", (Object)e);
                        ffstData.put("Message", "MQJMS2000");
                        Trace.ffst(this, "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", PROBE_01, ffstData, JMSException.class);
                    }
                }
                break block25;
                {
                    catch (MQException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", e, 1);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS1022");
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", je, 2);
                        }
                        throw je;
                    }
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", je, 3);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", je, 3);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueServices.java, jmscc.wmq.v6, k701, k701-112-140304  1.30.1.4 11/12/12 16:28:22");
        }
    }
}

