/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.DLH;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQXASession;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import javax.jms.JMSException;

public class MQQueueEnumeration
implements Enumeration {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueEnumeration.java, jmscc.wmq.v6, k701, k701-112-140304 1.25.1.5 12/03/30 10:41:17";
    private MQSession session;
    private MQQueueBrowser browser;
    private MQQueue queue;
    private JMSMessage message;
    private boolean bufferFilled;
    private MQJMSMessage baseMessage;
    private MQGetMessageOptions gmo;
    private MQMessageSelector messageSelector;
    private static final String PROBE_01 = "01";
    private static final String PROBE_02 = "02";
    private WMQDestination destination;
    private String backoutRetryQueue;
    private int backoutThreshold;
    private int type;
    private String aliasBaseQueueName;
    private String mqDLQName;

    MQQueueEnumeration(MQSession session, MQQueue queue, MQMessageSelector messageSelector, MQQueueBrowser callingBrowser, WMQDestination destination, MQJMSMessage bMsg, MQGetMessageOptions gmOpts) throws JMSException {
        block19: {
            this.bufferFilled = false;
            this.backoutRetryQueue = null;
            this.backoutThreshold = 20;
            this.type = 0;
            this.aliasBaseQueueName = null;
            this.mqDLQName = null;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "<init>(MQSession,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQMessageSelector,MQQueueBrowser,WMQDestination,MQJMSMessage,MQGetMessageOptions)", new Object[]{session, queue, messageSelector, callingBrowser, destination, bMsg, gmOpts});
            }
            this.session = session;
            this.queue = queue;
            this.messageSelector = messageSelector;
            this.browser = callingBrowser;
            this.destination = destination;
            this.gmo = new MQGetMessageOptions();
            this.gmo.options |= 0x10;
            if (session.connection.getFailIfQuiesce() == 1) {
                this.gmo.options |= 0x2000;
            }
            if (bMsg != null && gmOpts != null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Using provided message at gmo", null);
                }
                this.baseMessage = bMsg;
                if ((gmOpts.matchOptions & 1) == 1) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Matching on message id", null);
                    }
                    this.gmo.matchOptions |= 1;
                }
                if ((gmOpts.matchOptions & 2) == 2) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Matching on correlation id", null);
                    }
                    this.gmo.matchOptions |= 2;
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "baseMessage or gmo not set, using blank message", null);
                }
                this.baseMessage = new MQJMSMessage();
            }
            try {
                this.type = Utils.inquireInt(this.queue, 20);
                if (this.type == 3) {
                    this.obtainAliasQueueDetails();
                } else {
                    int thresh;
                    int[] selectors = new int[]{22, 20, 2019};
                    int[] intAttrs = new int[2];
                    byte[] charAttr = new byte[48];
                    queue.inquire(selectors, intAttrs, charAttr);
                    String inqString = new String(charAttr, MQSESSION.getJmqiEnv().getJavaCharacterSet(session.getQM().getHconn().getCcsid()));
                    String borq = inqString.substring(0, 48).trim();
                    this.backoutThreshold = thresh = intAttrs[0];
                    if (Trace.isOn) {
                        Trace.traceData(this, "returned from inquire, threshold = " + thresh + ", borq = '" + borq + "'", null);
                    }
                    if (borq.length() != 0) {
                        this.backoutRetryQueue = borq;
                    }
                }
                if (this.backoutRetryQueue == null || this.backoutRetryQueue.length() == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "backoutRetryQueue is not valid, setting to DLQName", (Object)this.backoutRetryQueue);
                    }
                    this.backoutRetryQueue = session.getDLQName();
                }
            }
            catch (Exception e) {
                if (!Trace.isOn) break block19;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "<init>(MQSession,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQMessageSelector,MQQueueBrowser,WMQDestination,MQJMSMessage,MQGetMessageOptions)", e, 2);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "<init>(MQSession,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQMessageSelector,MQQueueBrowser,WMQDestination,MQJMSMessage,MQGetMessageOptions)");
        }
    }

    public boolean hasMoreElements() {
        boolean result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "hasMoreElements()");
        }
        if (this.bufferFilled) {
            if (Trace.isOn) {
                Trace.traceData(this, "hasMoreElements found previously cached message", null);
            }
            result = true;
        } else {
            block10: {
                try {
                    this.message = null;
                    this.message = this.retrieveMessage();
                }
                catch (JMSException je) {
                    if (!Trace.isOn) break block10;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "hasMoreElements()", je);
                }
            }
            if (this.message == null) {
                result = false;
            } else {
                this.bufferFilled = true;
                result = true;
                if (Trace.isOn) {
                    Trace.traceData(this, "hasMoreElements put message in cache", null);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "hasMoreElements()", result);
        }
        return result;
    }

    public Object nextElement() throws NoSuchElementException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "nextElement()");
        }
        try {
            JMSMessage result;
            block16: {
                result = null;
                if (this.bufferFilled) {
                    result = this.message;
                    this.bufferFilled = false;
                } else {
                    try {
                        result = this.retrieveMessage();
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "nextElement()", je, 1);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "JMSException thrown by retrieveMessage()", null);
                        }
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "nextElement()", e, 2);
                        }
                        HashMap<String, Object> ffstData = new HashMap<String, Object>();
                        ffstData.put("Exception", e);
                        ffstData.put("Message", "MQJMS1016");
                        Trace.ffst(this, "nextElement()", PROBE_01, ffstData, null);
                        if (!Trace.isOn) break block16;
                        Trace.traceData(this, "Unexpected Exception thrown by retrieveMessage()", null);
                    }
                }
            }
            if (result == null) {
                NoSuchElementException traceRet1 = new NoSuchElementException();
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "nextElement()", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "nextElement()", result);
            }
            return result;
        }
        catch (NoSuchElementException nsee) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "nextElement()", nsee, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "nextElement()", nsee, 2);
            }
            throw nsee;
        }
    }

    public MQQueue getQueue() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "getQueue()", "getter", this.queue);
        }
        return this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JMSMessage retrieveMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()");
        }
        try {
            JMSMessage message = null;
            if (this.queue == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", null, 1);
                }
                return null;
            }
            while (message == null) {
                MQJMSMessage tempBaseMessage;
                block42: {
                    JMSException je;
                    tempBaseMessage = new MQJMSMessage();
                    tempBaseMessage.setMessageId(this.baseMessage.getMessageId());
                    tempBaseMessage.setCorrelationId(this.baseMessage.getCorrelationId());
                    try {
                        boolean cleanSession;
                        this.queue.getMsg2(tempBaseMessage, this.gmo);
                        message = tempBaseMessage.createJMSMessage(this.session, this.destination);
                        if (this.backoutThreshold == 0 || tempBaseMessage.getBackoutCount() < this.backoutThreshold) break block42;
                        boolean bl = cleanSession = !this.session.getCommitRequired();
                        if (cleanSession && !(this.session instanceof MQXASession)) {
                            MQJMSMessage gotMsg;
                            MQQueue getQueue;
                            block43: {
                                getQueue = null;
                                gotMsg = null;
                                int openOpts = 8322;
                                try {
                                    getQueue = this.session.getQM().accessQueue(this.queue.name, openOpts);
                                    gotMsg = new MQJMSMessage();
                                    gotMsg.setMessageId(tempBaseMessage.getMessageId());
                                    MQGetMessageOptions newGmo = new MQGetMessageOptions();
                                    newGmo.options = 8194;
                                    newGmo.matchOptions = 1;
                                    getQueue.getMsg2(gotMsg, newGmo);
                                    if (gotMsg.getBackoutCount() < this.backoutThreshold) {
                                        if (Trace.isOn) {
                                            Trace.data(this, "Destructively got message has a backout count below the threshold, aborting requeue", null);
                                        }
                                        this.session.getQM().backout();
                                        message = null;
                                    }
                                    break block43;
                                }
                                catch (MQException mqe) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", mqe, 3);
                                    }
                                    this.session.getQM().backout();
                                    message = null;
                                }
                                continue;
                            }
                            try {
                                this.backoutRequeue(gotMsg, getQueue);
                            }
                            catch (JMSException je2) {
                                Exception e;
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", je2, 1);
                                }
                                int reason = (e = je2.getLinkedException()) != null && e instanceof MQException ? ((MQException)((Object)e)).reasonCode : 2362;
                                try {
                                    this.removeBadMessage(gotMsg, reason, getQueue);
                                }
                                catch (JMSException je22) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", je22, 2);
                                    }
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "removeBadMessage failed", null);
                                    }
                                    if (Trace.isOn) {
                                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", je22, 1);
                                    }
                                    throw je22;
                                }
                            }
                            this.session.getQM().commit();
                            message = null;
                            break block42;
                        }
                        if (Trace.isOn) {
                            Trace.data(this, "Skipping backout requeue processing as session transaction is unclean or an XA session", (Object)this.session);
                        }
                        message = null;
                    }
                    catch (MQException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", e, 1);
                        }
                        if (e.reasonCode == 2033) {
                            block44: {
                                block45: {
                                    try {
                                        try {
                                            this.queue.close();
                                            this.browser.removeEnumeration(this);
                                        }
                                        catch (MQException e2) {
                                            if (Trace.isOn) {
                                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", e2, 2);
                                            }
                                            HashMap<String, Object> ffstData = new HashMap<String, Object>();
                                            ffstData.put("Exception", (Object)e2);
                                            ffstData.put("Message", "MQJMS2000");
                                            Trace.ffst(this, "retrieveMessage()", PROBE_02, ffstData, JMSException.class);
                                            Object var12_18 = null;
                                            if (Trace.isOn) {
                                                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()");
                                            }
                                            this.queue = null;
                                            break block44;
                                        }
                                        Object var12_17 = null;
                                        if (!Trace.isOn) break block45;
                                    }
                                    catch (Throwable throwable) {
                                        Object var12_19 = null;
                                        if (Trace.isOn) {
                                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()");
                                        }
                                        this.queue = null;
                                        throw throwable;
                                    }
                                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()");
                                }
                                this.queue = null;
                            }
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", null, 2);
                            }
                            return null;
                        }
                        je = ConfigEnvironment.newException("MQJMS1025");
                        je.setLinkedException((Exception)((Object)e));
                        MQConnection mqconnection = this.session.connection;
                        mqconnection.deliverException(je);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", je, 1);
                        }
                        throw je;
                    }
                    catch (IOException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", e, 3);
                        }
                        je = ConfigEnvironment.newException("MQJMS1000");
                        je.setLinkedException((Exception)e);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", je, 2);
                        }
                        throw je;
                    }
                }
                if (this.messageSelector != null && !this.messageSelector.isSelected(message, tempBaseMessage)) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "retrieveMessage() message rejected", null);
                    }
                    message = null;
                }
                this.gmo.options &= 0xFFFFFFEF;
                this.gmo.options |= 0x20;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", message, 3);
            }
            return message;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", je, 4);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "retrieveMessage()", je, 3);
            }
            throw je;
        }
    }

    /*
     * Loose catch block
     */
    private void backoutRequeue(MQJMSMessage msg, MQQueue gotQ) throws JMSException {
        block31: {
            MQQueue destQ;
            block30: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", new Object[]{msg});
                }
                destQ = null;
                if (this.backoutRetryQueue == null || this.backoutRetryQueue.length() == 0) {
                    if (this.type == 0) {
                        this.type = Utils.inquireInt(this.queue, 20);
                    }
                    if (this.type == 3) {
                        this.obtainAliasQueueDetails();
                    } else {
                        this.backoutRetryQueue = Utils.inquireString(this.queue, 2019);
                    }
                }
                if (this.backoutRetryQueue == null || this.backoutRetryQueue.length() == 0) {
                    JMSException jmse = ConfigEnvironment.newException("MQJMS1080");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", jmse, 1);
                    }
                    throw jmse;
                }
                this.backoutRetryQueue = this.backoutRetryQueue.trim();
                if (Trace.isOn) {
                    Trace.traceData(this, "BORQ = <" + this.backoutRetryQueue + ">", null);
                }
                try {
                    int openOptions = 8720;
                    destQ = this.session.getQM().accessQueue(this.backoutRetryQueue, openOptions, "", null, null);
                    MQPutMessageOptions pmo = new MQPutMessageOptions();
                    pmo.options = 514;
                    pmo.contextReference = gotQ;
                    destQ.putMsg2(msg, pmo);
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", mqe, 2);
                    }
                    if (mqe.reasonCode == 2033) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "ProviderMessage to requeue has disappeared! Continue as normal", null);
                        }
                    } else if (Trace.isOn) {
                        Trace.traceData(this, "Unable to requeue message", null);
                    }
                    JMSException jmse = ConfigEnvironment.newException("MQJMS1081");
                    jmse.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", jmse, 2);
                    }
                    throw jmse;
                }
                Object var7_10 = null;
                if (!Trace.isOn) break block30;
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)");
            }
            try {
                if (destQ != null) {
                    destQ.close();
                }
                break block31;
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", mqe, 4);
                }
                break block31;
            }
            {
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", je, 3);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", je, 3);
                    }
                    throw je;
                }
            }
            catch (Throwable throwable) {
                block32: {
                    Object var7_11 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)");
                    }
                    try {
                        if (destQ != null) {
                            destQ.close();
                        }
                    }
                    catch (MQException mqe) {
                        if (!Trace.isOn) break block32;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", mqe, 4);
                    }
                }
                throw throwable;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)");
        }
    }

    private void deadLetter(MQJMSMessage msg, int reason, MQQueue gotQ) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)", new Object[]{msg, new Integer(reason)});
        }
        MQMessage reportMessage = null;
        String replyQ = null;
        String replyQMgr = null;
        MQQueue DLQ = null;
        MQQueue RQ = null;
        try {
            if (this.mqDLQName == null) {
                this.mqDLQName = Utils.inquireString(this.session.getQM(), 2006);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "DLQ = <" + this.mqDLQName + ">", null);
            }
            if (this.mqDLQName == null || this.mqDLQName.length() == 0) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Unable to find DLQ name - is one defined?", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1079");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)", je, 1);
                }
                throw je;
            }
            if ((msg.getReport() & 0x7000000) != 0) {
                reportMessage = this.generateReport(msg, reason);
                replyQ = msg.getReplyToQueueName().trim();
                replyQMgr = msg.getReplyToQueueManagerName().trim();
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Constructing DLH", null);
            }
            DLH dlh = new DLH();
            dlh.reason = reason;
            dlh.destQName = this.backoutRetryQueue == null || this.backoutRetryQueue.length() == 0 ? this.queue.name : this.backoutRetryQueue;
            dlh.destQMgrName = this.session.getQMName();
            dlh.putApplType = 28;
            dlh.putApplName = "MQ JMS ConnectionConsumer";
            GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            dlh.putDate = Utils.getDate(gc);
            dlh.putTime = Utils.getTime(gc);
            MQMessage deadMsg = new MQMessage();
            dlh.write(deadMsg, msg);
            int openOptions = 8720;
            DLQ = this.session.getQM().accessQueue(this.mqDLQName, openOptions, this.session.getQMName(), null, null);
            MQPutMessageOptions pmo = new MQPutMessageOptions();
            pmo.options = 514;
            pmo.contextReference = gotQ;
            DLQ.put(deadMsg, pmo);
            if (reportMessage != null) {
                try {
                    openOptions = 8720;
                    RQ = this.session.getQM().accessQueue(replyQ, openOptions, replyQMgr, null, null);
                    pmo = new MQPutMessageOptions();
                    pmo.options = 514;
                    pmo.contextReference = this.queue;
                    RQ.put(reportMessage, pmo);
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)", mqe, 1);
                    }
                    dlh.destQName = replyQ;
                    dlh.destQMgrName = replyQMgr;
                    dlh.reason = mqe.reasonCode;
                    dlh.write(reportMessage);
                    DLQ.put(reportMessage, pmo);
                }
            }
        }
        catch (MQException mqe) {
            block50: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)", mqe, 2);
                }
                if (mqe.reasonCode == 2033) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage to dead-letter has disappeared! Continue as normal", null);
                    }
                }
                if (msg != null && msg.getPersistence() == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Could not send report message, but message isnon-persistent - so subsume the error", null);
                    }
                }
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "backing out attempt to send Report message", null);
                    }
                    if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to backout Report message as session is transacted or Client Ack", null);
                        }
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "backing out Report message", null);
                        }
                        this.session.getQM().backout();
                    }
                }
                catch (MQException mqe2) {
                    if (!Trace.isOn) break block50;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)", mqe2, 3);
                }
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1079");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)", je, 2);
            }
            throw je;
        }
        catch (JMSException je) {
            block51: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)", je, 4);
                }
                if (msg != null && msg.getPersistence() == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage is non-persistent so ignoring error", null);
                    }
                }
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "backing out attempt to DLQ message", null);
                    }
                    if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to backout DLQ'd message as session is transacted or Client Ack", null);
                        }
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "backing out DLQ'd message", null);
                        }
                        this.session.getQM().backout();
                    }
                }
                catch (MQException mqe) {
                    if (!Trace.isOn) break block51;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)", mqe, 5);
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)", je, 3);
            }
            throw je;
        }
        try {
            if (DLQ != null) {
                DLQ.close();
            }
            if (RQ != null) {
                RQ.close();
            }
            if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Unable to commit requeued message as session is transacted or Client Ack", null);
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "commiting requeued message", null);
                }
                this.session.getQM().commit();
            }
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)", mqe, 6);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1079");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int,MQQueue)");
        }
    }

    private MQMessage generateReport(MQJMSMessage msg, int reason) throws JMSException {
        MQMessage out;
        block15: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", new Object[]{msg, new Integer(reason)});
            }
            out = new MQMessage();
            ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
            DataOutputStream dataBuffer = new DataOutputStream(byteBuffer);
            try {
                out.report = 0;
                out.messageType = 4;
                out.expiry = -1;
                out.feedback = reason;
                out.encoding = msg.getEncoding();
                out.characterSet = msg.getCharacterSet();
                out.format = msg.getFormat();
                out.priority = msg.getPriority();
                out.persistence = msg.getPersistence();
                if ((msg.getReport() & 0x80) == 128) {
                    out.messageId = msg.getMessageId();
                }
                out.correlationId = (msg.getReport() & 0x40) == 64 ? msg.getCorrelationId() : msg.getMessageId();
                out.backoutCount = 0;
                out.replyToQueueName = "";
                out.replyToQueueManagerName = this.session.getQMName();
                out.putApplicationType = 28;
                out.putApplicationName = "MQ JMS Message Consumer";
                if ((msg.getReport() & 0x7000000) == 0x7000000) {
                    byte[] buffer = new byte[msg.getMessageDataLength()];
                    buffer = msg.getMessageData();
                    out.write(buffer);
                    break block15;
                }
                if ((msg.getReport() & 0x3000000) != 0x3000000) break block15;
                String format = msg.getFormat();
                int origCharacterSet = msg.getCharacterSet();
                try {
                    if (format.startsWith("MQH")) {
                        msg.writeTo(dataBuffer, origCharacterSet, true);
                    }
                }
                catch (IOException ioe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", ioe, 1);
                    }
                }
            }
            catch (IOException ioe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", ioe, 2);
                }
                JMSException jmse = ConfigEnvironment.newException("MQJMS1016");
                jmse.setLinkedException((Exception)ioe);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", jmse, 1);
                }
                throw jmse;
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", mqe, 3);
                }
                JMSException jmse = ConfigEnvironment.newException("MQJMS1016");
                jmse.setLinkedException((Exception)((Object)mqe));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", jmse, 2);
                }
                throw jmse;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", (Object)out);
        }
        return out;
    }

    private void removeBadMessage(MQJMSMessage msg, int reason, MQQueue gotQ) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBadMessage(MQJMSMessage,int,MQQueue)", new Object[]{msg, new Integer(reason)});
        }
        try {
            if ((msg.getReport() & 0x8000000) == 0x8000000) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Discarding message as per MQMD.Report", null);
                }
                this.discard(msg, reason);
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "Dead-lettering message as per MQMD.Report", null);
                }
                this.deadLetter(msg, reason, gotQ);
            }
        }
        catch (JMSException jmse) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBadMessage(MQJMSMessage,int,MQQueue)", jmse);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "throwing " + (Object)((Object)jmse), null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBadMessage(MQJMSMessage,int,MQQueue)", jmse);
            }
            throw jmse;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBadMessage(MQJMSMessage,int,MQQueue)");
        }
    }

    private void discard(MQJMSMessage msgRef, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", new Object[]{msgRef, new Integer(reason)});
        }
        MQJMSMessage discardMessage = msgRef;
        MQMessage reportMessage = null;
        try {
            if ((discardMessage.getReport() & 0x7000000) != 0) {
                reportMessage = this.generateReport(discardMessage, reason);
                String replyQ = discardMessage.getReplyToQueueName().trim();
                String replyQMgr = discardMessage.getReplyToQueueManagerName().trim();
                try {
                    int openOptions = 8720;
                    MQQueue RQ = this.session.getQM().accessQueue(replyQ, openOptions, replyQMgr, null, null);
                    MQPutMessageOptions pmo = new MQPutMessageOptions();
                    pmo.options = 514;
                    pmo.contextReference = this.queue;
                    RQ.put(reportMessage, pmo);
                    RQ.close();
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", mqe, 1);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Could not put report message to replyToQ", null);
                        Trace.traceData(this, "Attempting to put to DLQ instead", null);
                    }
                    if (this.mqDLQName == null) {
                        this.mqDLQName = Utils.inquireString(this.session.getQM(), 2006);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "DLQ = <" + this.mqDLQName + ">", null);
                    }
                    if (this.mqDLQName == null || this.mqDLQName.length() == 0) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to find DLQ name - is one defined?", null);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS1079");
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", je, 1);
                        }
                        throw je;
                    }
                    DLH dlh = new DLH();
                    dlh.reason = mqe.reasonCode;
                    dlh.destQName = replyQ;
                    dlh.destQMgrName = replyQMgr;
                    dlh.putApplType = 28;
                    dlh.putApplName = "MQ JMS ConnectionConsumer";
                    GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    dlh.putDate = Utils.getDate(gc);
                    dlh.putTime = Utils.getTime(gc);
                    dlh.write(reportMessage);
                    int openOptions = 8720;
                    MQQueue DLQ = this.session.getQM().accessQueue(this.mqDLQName, openOptions, this.session.getQMName(), null, null);
                    MQPutMessageOptions pmo = new MQPutMessageOptions();
                    pmo.options = 514;
                    pmo.contextReference = this.queue;
                    DLQ.put(reportMessage, pmo);
                    DLQ.close();
                }
            }
        }
        catch (MQException mqe) {
            block45: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", mqe, 2);
                }
                if (mqe.reasonCode == 2033) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage to discard has disappeared! Continue as normal", null);
                    }
                }
                if (discardMessage != null && discardMessage.getPersistence() == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Could not send report message, but message isnon-persistent - so subsume the error", null);
                    }
                }
                try {
                    if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to backout the message as session is transacted or Client Ack", null);
                        }
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "backing out the message", null);
                        }
                        this.session.getQM().backout();
                    }
                }
                catch (MQException mqe2) {
                    if (!Trace.isOn) break block45;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", mqe2, 3);
                }
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1082");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", je, 2);
            }
            throw je;
        }
        catch (JMSException je) {
            block46: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", je, 4);
                }
                if (discardMessage != null && discardMessage.getPersistence() == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage is non-persistent so ignoring error", null);
                    }
                }
                try {
                    if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to backout the message as session is transacted or Client Ack", null);
                        }
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "backing out the message", null);
                        }
                        this.session.getQM().backout();
                    }
                }
                catch (MQException mqe) {
                    if (!Trace.isOn) break block46;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", mqe, 5);
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", je, 3);
            }
            throw je;
        }
        try {
            if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Unable to commit the report message as session is transacted or Client Ack", null);
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "commiting the report message", null);
                }
                this.session.getQM().commit();
            }
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", mqe, 6);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1082");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)");
        }
    }

    private void obtainAliasQueueDetails() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "obtainAliasQueueDetails()");
        }
        PropertyStore.register("com.ibm.mq.jms.useDefaultBOValues", false);
        if (!PropertyStore.getBooleanPropertyObject("com.ibm.mq.jms.useDefaultBOValues").booleanValue()) {
            if (this.aliasBaseQueueName == null || this.aliasBaseQueueName.length() == 0) {
                this.aliasBaseQueueName = Utils.inquireString(this.queue, 2002);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Attempting to read Backout Requeue Queue from underlying LOCAL queue " + this.aliasBaseQueueName, null);
            }
            try {
                int options = 8232;
                MQQueue baseMqQueue = this.session.getQM().accessQueue(this.aliasBaseQueueName, options);
                int[] selectors = new int[]{22, 2019};
                int[] intAttrs = new int[1];
                byte[] charAttr = new byte[48];
                baseMqQueue.inquire(selectors, intAttrs, charAttr);
                String inqString = new String(charAttr, MQSESSION.getJmqiEnv().getJavaCharacterSet(this.session.getQM().getHconn().getCcsid()));
                this.backoutRetryQueue = inqString.substring(0, 48).trim();
                this.backoutThreshold = intAttrs[0];
                baseMqQueue.close();
            }
            catch (Exception mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "obtainAliasQueueDetails()", mqe, 1);
                }
                HashMap<String, Object> inserts = new HashMap<String, Object>();
                inserts.put("XMSC_INSERT_DESTINATION_NAME", this.aliasBaseQueueName);
                inserts.put("XMSC_INSERT_STRING", this.destination.getName());
                inserts.put("XMSC_INSERT_VALUE", new Integer(this.backoutThreshold));
                inserts.put("XMSC_INSERT_EXCEPTION", mqe);
                if (mqe instanceof MQException) {
                    inserts.put("XMSC_INSERT_COMP_CODE", new Integer(((MQException)((Object)mqe)).getCompCode()));
                    inserts.put("XMSC_INSERT_REASON", new Integer(((MQException)((Object)mqe)).getReason()));
                }
                Log.log(this, "obtainAliasQueueDetails()", "MQJMS1115", inserts);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "obtainAliasQueueDetails()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueEnumeration.java, jmscc.wmq.v6, k701, k701-112-140304  1.25.1.5 12/03/30 10:41:17");
        }
    }
}

