/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jms.SyntaxException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderQueueBrowser;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyContext;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueEnumeration;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class MQQueueBrowser
extends WMQPropertyContext
implements ProviderQueueBrowser {
    private static final long serialVersionUID = 2083457851210189095L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueBrowser.java, jmscc.wmq.v6, k701, k701-112-140304 1.31.1.1 09/08/17 08:12:57";
    private WMQDestination queue;
    private MQMessageSelector messageSelector = null;
    private MQSession session;
    private Vector enumerations = new Vector();
    private MQJMSMessage baseMessage = null;
    private boolean specialSelector = false;
    private MQGetMessageOptions selectorGMO = new MQGetMessageOptions();
    private static final String PROBE_01 = "01";
    static /* synthetic */ Class class$javax$jms$JMSException;

    MQQueueBrowser(WMQDestination queue, String selectorString, MQSession session) throws JMSException {
        super(null);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "<init>(WMQDestination,String,MQSession)", new Object[]{queue, selectorString, session});
        }
        try {
            if (!queue.isQueue()) {
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "<init>(WMQDestination,String,MQSession)", (Throwable)je, 1);
                }
                throw je;
            }
            this.queue = queue;
            if (selectorString != null && !selectorString.equals("")) {
                this.messageSelector = new MQMessageSelector();
                this.baseMessage = new MQJMSMessage();
                try {
                    this.selectorGMO.matchOptions = 0;
                    this.specialSelector = this.messageSelector.setSelector(selectorString, this.baseMessage, this.selectorGMO);
                    if (Trace.isOn) {
                        Trace.traceData(this, "Selector set, special case flag is " + this.specialSelector, null);
                    }
                    if (!this.specialSelector) {
                        this.selectorGMO.matchOptions = 0;
                    }
                }
                catch (SyntaxException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "<init>(WMQDestination,String,MQSession)", e, 1);
                    }
                    this.messageSelector = null;
                    String key = "MQJMS0004";
                    String msg = ConfigEnvironment.getErrorMessage(key);
                    InvalidSelectorException je = new InvalidSelectorException(msg, key);
                    je.setLinkedException((Exception)e);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "<init>(WMQDestination,String,MQSession)", je, 2);
                    }
                    throw je;
                }
            }
            this.session = session;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "<init>(WMQDestination,String,MQSession)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "<init>(WMQDestination,String,MQSession)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "<init>(WMQDestination,String,MQSession)");
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "getEnumeration()");
        }
        MQQueueEnumeration result = null;
        MQQueue baseQueue = this.session.getServicesMgr().getQueueForBrowse(this.queue, this.session);
        result = new MQQueueEnumeration(this.session, baseQueue, this.messageSelector, this, this.queue, this.baseMessage, this.selectorGMO);
        this.enumerations.addElement(result);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "getEnumeration()", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(boolean closingFromSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "close(boolean)", new Object[]{closingFromSession});
        }
        for (int i = 0; i < this.enumerations.size(); ++i) {
            MQQueue queue;
            block10: {
                Object var8_7;
                MQQueueEnumeration enumVar = (MQQueueEnumeration)this.enumerations.elementAt(i);
                queue = enumVar.getQueue();
                if (queue == null) continue;
                try {
                    try {
                        queue.close();
                    }
                    catch (MQException e2) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "close(boolean)", e2);
                        }
                        HashMap<String, Object> ffstData = new HashMap<String, Object>();
                        ffstData.put("Exception", (Object)e2);
                        ffstData.put("Message", "MQJMS2000");
                        Trace.ffst(this, "close()", PROBE_01, ffstData, class$javax$jms$JMSException == null ? MQQueueBrowser.class$("javax.jms.JMSException") : class$javax$jms$JMSException);
                        var8_7 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "close(boolean)");
                        }
                        queue = null;
                        continue;
                    }
                    var8_7 = null;
                    if (!Trace.isOn) break block10;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "close(boolean)");
                    }
                    queue = null;
                    throw throwable;
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "close(boolean)");
            }
            queue = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "close(boolean)");
        }
    }

    protected void removeEnumeration(MQQueueEnumeration mqEnumeration) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "removeEnumeration(MQQueueEnumeration)", new Object[]{mqEnumeration});
        }
        if (Trace.isOn) {
            Trace.traceData(this, "Removing enumeration " + mqEnumeration.toString(), null);
        }
        this.enumerations.remove(mqEnumeration);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "removeEnumeration(MQQueueEnumeration)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueBrowser", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueBrowser.java, jmscc.wmq.v6, k701, k701-112-140304  1.31.1.1 09/08/17 08:12:57");
        }
    }
}

