/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread;
import javax.jms.JMSException;

class MQQueueAgentThread2Impl
extends MQQueueAgentThread {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueAgentThread2Impl.java, jmscc.wmq.v6, k701, k701-112-140304  1.24.1.8 13/05/17 10:48:22";
    private static long sweepInterval;
    private int headerDataSize = -1;
    private int messageBufferSize = 0;
    private int messageMQMDandRFH2Size = 0;
    protected static final int sizeofMQMDv2 = 364;
    private MQMessageReference storedMsgReference;
    private static int defaultHeaderDataLength;

    MQQueueAgentThread2Impl(MQQueueAgent mqQueueAgent, MQConnection jmsConnection, String qmgrName, String qName) throws JMSException {
        super(mqQueueAgent, jmsConnection, qmgrName, qName);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "<init>(MQQueueAgent,MQConnection,String,String)", new Object[]{mqQueueAgent, jmsConnection, qmgrName, qName});
        }
        sweepInterval = jmsConnection.getSweepTime();
        this.headerDataSize = jmsConnection.getHeaderDataSize();
        if (Trace.isOn) {
            Trace.traceData(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "headerDataSize= " + this.headerDataSize + " sweepInterval: " + sweepInterval, null);
        }
        this.options = 139434;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "<init>(MQQueueAgent,MQConnection,String,String)");
        }
    }

    MQMessageReference browse(int dataQuantity, long wait) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "browse(int,long)", new Object[]{new Integer(dataQuantity), new Long(wait)});
        }
        MQMessageReference deliverMR = null;
        if (this.storedMsgReference != null) {
            deliverMR = this.storedMsgReference;
        } else {
            long currentTime = 0L;
            try {
                boolean browseFirst = true;
                if (this.startSweep) {
                    currentTime = System.currentTimeMillis();
                    this.sweepStartedTime = System.currentTimeMillis();
                    this.startSweep = false;
                    this.sweepTimeoutStart = 0L;
                }
                if ((deliverMR = this.browseMsg(dataQuantity, browseFirst, (int)wait)) == null) {
                    this.deliverNow();
                    this.startSweep = true;
                } else if (this.sweepTimeoutStart != 0L) {
                    if (currentTime == 0L) {
                        currentTime = System.currentTimeMillis();
                    }
                    if (currentTime > this.sweepTimeoutStart + sweepInterval) {
                        this.deliverNow();
                        this.startSweep = true;
                    }
                } else {
                    if (currentTime == 0L) {
                        currentTime = System.currentTimeMillis();
                    }
                    this.sweepTimeoutStart = currentTime;
                }
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "browse(int,long)", mqe);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1025");
                je.setLinkedException((Exception)((Object)mqe));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "browse(int,long)", je);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "browse(int,long)", deliverMR);
        }
        return deliverMR;
    }

    private MQMessageReference browseMsg(int dataQuantity, boolean browseFirst, int timeout) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "browseMsg(int,boolean,int)", new Object[]{new Integer(dataQuantity), browseFirst, new Integer(timeout)});
        }
        MQMessageReference outMR = null;
        try {
            if (browseFirst) {
                this.mqGMO.options &= 0xFFFFFFDF;
                this.mqGMO.options |= 0x10;
            } else {
                this.mqGMO.options &= 0xFFFFFFEF;
                this.mqGMO.options |= 0x20;
            }
            this.mqGMO.options |= 0x1100000;
            boolean useBatching = dataQuantity == 0;
            this.mqGMO.options |= 1;
            this.mqGMO.waitInterval = timeout;
            if (dataQuantity == 1 && this.headerDataSize != -1) {
                this.messageBufferSize = this.headerDataSize;
            }
            MQJMSMessage message = new MQJMSMessage();
            if (Trace.isOn) {
                Trace.traceData(this, "About to browse message:", null);
                Trace.traceData(this, (this.mqGMO.options & 0x20) == 0 ? "- browsing first message" : "- browsing next message", null);
                Trace.traceData(this, (this.mqGMO.options & 1) == 0 ? "- browsing without waiting" : "- browsing with wait for " + this.mqGMO.waitInterval, null);
                Trace.traceData(this, useBatching ? "- using batched-get" : "- using non-batched get", null);
                Trace.traceData(this, "- browsing with bufferSize " + this.messageBufferSize, null);
            }
            int reason = 0;
            switch (dataQuantity) {
                case 0: {
                    Trace.traceData(this, "- browsing with NO_DATA", null);
                    this.mqGMO.options |= 0x40;
                    Trace.traceData(this, "- browsing with truncation", null);
                    reason = this.mqQueue.spiBatchedGetNoExc(message, this.mqGMO, 0);
                    if (reason != 2079) break;
                    reason = 0;
                    break;
                }
                case 1: {
                    Trace.traceData(this, "- browsing with HEADER_DATA", null);
                    reason = this.getMessageHeaderOnly(message);
                    break;
                }
                case 2: {
                    Trace.traceData(this, "- browsing with FULL_DATA", null);
                    this.mqGMO.options &= 0xFFFFFFBF;
                    Trace.traceData(this, "- browsing with full message", null);
                    reason = this.mqQueue.getMsg2NoExc(message, this.mqGMO);
                    break;
                }
            }
            if (reason == 2033) {
                if (Trace.isOn) {
                    Trace.traceData(this, "MQRC_NO_MSG_AVAILABLE", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "browseMsg(int,boolean,int)", null, 1);
                }
                return null;
            }
            if (reason != 0) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Unexpected reason code " + reason, null);
                }
                MQException traceRet1 = new MQException(2, reason, (Object)this);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "browseMsg(int,boolean,int)", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Browsed message: length" + message.getMessageDataLength() + " dataQuantityHint= " + dataQuantity, null);
            }
            outMR = new MQMessageReference(this.jmsSession);
            outMR.setMsgToken(this.mqGMO.msgToken);
            outMR.setDestination(this.mqQueueAgent.getProviderDestination());
            outMR.setMQJMSMessage(message, dataQuantity, this.messageMQMDandRFH2Size);
            this.mqGMO.options &= 0xFEEFFFFF;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "browseMsg(int,boolean,int)", outMR, 2);
            }
            return outMR;
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "browseMsg(int,boolean,int)", mqe);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "browseMsg(int,boolean,int)", mqe, 2);
            }
            throw mqe;
        }
    }

    protected void deliverMsgRef(MQConnectionBrowser browser, MQMessageReference msgRef) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "deliverMsgRef(MQConnectionBrowser,MQMessageReference)", new Object[]{browser, msgRef});
        }
        MQJMSMessage tmpMessage = null;
        if (Trace.isOn) {
            Trace.traceData(this, "Browsing message with MQGMO_MARK_BROWSE_CO_OP", null);
        }
        this.mqGMO.options &= 0xFEFFFFDE;
        this.mqGMO.options |= 0xA00010;
        this.mqGMO.matchOptions = 32;
        System.arraycopy(msgRef.getMsgToken(), 0, this.mqGMO.msgToken, 0, 16);
        tmpMessage = new MQJMSMessage();
        int reason = 0;
        switch (msgRef.getDataQuantity()) {
            case 1: {
                if (Trace.isOn) {
                    Trace.traceData(this, "Browsing message with MQGMO_MARK_BROWSE_CO_OP - header only : " + msgRef.getHeaderLength() + " bytes", null);
                }
                reason = this.mqQueue.getMsg2NoExc(tmpMessage, this.mqGMO, msgRef.getHeaderLength());
                break;
            }
            default: {
                if (Trace.isOn) {
                    Trace.traceData(this, "Browsing message with MQGMO_MARK_BROWSE_CO_OP - full message", null);
                }
                reason = this.mqQueue.getMsg2NoExc(tmpMessage, this.mqGMO);
            }
        }
        this.mqGMO.options &= 0xFF5FFFFF;
        this.mqGMO.matchOptions = 0;
        this.storedMsgReference = null;
        if (reason == 2033 || reason == 2200) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderMessage has been marked or removed from the queue with reason: " + reason, null);
            }
            msgRef = null;
        } else if (reason != 0 && reason != 2079) {
            if (reason == 2016) {
                this.storedMsgReference = msgRef;
            } else if (!Reason.isConnectionBroken(reason)) {
                this.unmarkBrowseMessage(msgRef);
            }
            MQException me = new MQException(2, reason, (Object)this);
            JMSException je = ConfigEnvironment.newException("MQJMS1025");
            je.setLinkedException((Exception)((Object)me));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "deliverMsgRef(MQConnectionBrowser,MQMessageReference)", je);
            }
            throw je;
        }
        if (msgRef != null) {
            browser.deliver(msgRef);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "deliverMsgRef(MQConnectionBrowser,MQMessageReference)");
        }
    }

    boolean updateConfig() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "updateConfig()");
        }
        if (this.startSweep) {
            try {
                this.mqQueue.close();
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "updateConfig()", mqe, 1);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS2000");
                je.setLinkedException((Exception)((Object)mqe));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "updateConfig()", je, 1);
                }
                throw je;
            }
            try {
                this.mqQueue = this.mqQueueManager.accessQueue(this.qName, this.options);
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "updateConfig()", mqe, 2);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS2008");
                je.setLinkedException((Exception)((Object)mqe));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "updateConfig()", je, 2);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "updateConfig()", true, 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "updateConfig()", false, 2);
        }
        return false;
    }

    private int getMessageHeaderOnly(MQJMSMessage message) {
        int reason;
        block21: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "getMessageHeaderOnly(MQJMSMessage)", new Object[]{message});
            }
            this.mqGMO.options |= 0x40;
            if (Trace.isOn) {
                Trace.traceData(this, "- browsing with truncation", null);
            }
            reason = 0;
            int truncatedBufferSize = 36 + defaultHeaderDataLength;
            if (this.messageBufferSize > truncatedBufferSize) {
                truncatedBufferSize = this.messageBufferSize;
                if (Trace.isOn) {
                    Trace.traceData(this, "Increased truncatedBufferSize to ", (Object)new Integer(truncatedBufferSize));
                }
            } else if (Trace.isOn) {
                Trace.traceData(this, "Using default minimum header browse size of ", (Object)new Integer(truncatedBufferSize));
            }
            if ((reason = this.mqQueue.getMsg2NoExc(message, this.mqGMO, truncatedBufferSize)) == 2033) {
                if (Trace.isOn) {
                    Trace.traceData(this, " - First browse. No message available", null);
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "getMessageHeaderOnly(MQJMSMessage)", new Integer(reason), 1);
                }
                return reason;
            }
            if (reason == 2079) {
                reason = 0;
            }
            long format = 0L;
            try {
                format = message.getFormatAsLong();
                if (format != 5571313732236222496L && format != -3109514705028104128L) {
                    if (Trace.isOn) {
                        Trace.traceData(this, " - Received message does not have RFH2", null);
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "getMessageHeaderOnly(MQJMSMessage)", new Integer(reason), 2);
                    }
                    return reason;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Message: " + ((Object)((Object)message)).toString(), null);
                }
                int msgEncoding = 0;
                int strucLength = 0;
                msgEncoding = message.getEncoding();
                message.skipReadingBytes(8);
                strucLength = message.readInt(msgEncoding);
                this.messageMQMDandRFH2Size = strucLength + 364;
                if (Trace.isOn) {
                    Trace.traceData(this, "MQMD + RFH2 length = " + this.messageMQMDandRFH2Size, null);
                }
                if (truncatedBufferSize < strucLength) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "RFH2 was truncated. Re-browsing message with buffer length " + strucLength, null);
                    }
                    MQGetMessageOptions gmo = new MQGetMessageOptions();
                    gmo.options &= 0xFFFFFFDE;
                    gmo.options |= 0x50;
                    gmo.matchOptions = 32;
                    System.arraycopy(this.mqGMO.msgToken, 0, gmo.msgToken, 0, 16);
                    reason = this.mqQueue.getMsg2NoExc(message, gmo, strucLength);
                    if (reason == 2033) {
                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "getMessageHeaderOnly(MQJMSMessage)", new Integer(reason));
                        return reason;
                    }
                    if (reason == 2079) {
                        reason = 0;
                    }
                } else {
                    Trace.traceData(this, "Resetting read position in message", null);
                    message.resetReadPosition();
                }
            }
            catch (Exception e) {
                reason = 2033;
                if (!Trace.isOn) break block21;
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "getMessageHeaderOnly(MQJMSMessage)", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "getMessageHeaderOnly(MQJMSMessage)", new Integer(reason), 3);
        }
        return reason;
    }

    private void unmarkBrowseMessage(MQMessageReference msgReference) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "unmarkBrowseMessage(MQMessageReference)", new Object[]{msgReference});
        }
        MQJMSMessage tmpMessage = new MQJMSMessage();
        this.mqGMO.options |= 0x800000;
        this.mqGMO.matchOptions = 32;
        System.arraycopy(msgReference.getMsgToken(), 0, this.mqGMO.msgToken, 0, 16);
        int reason = this.mqQueue.getMsg2NoExc(tmpMessage, this.mqGMO);
        if (Trace.isOn) {
            Trace.traceData(this, "ProviderMessage attempted to be unmarked, returned reason: " + reason, null);
        }
        this.mqGMO.options &= 0xFF7FFFFF;
        this.mqGMO.matchOptions = 0;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "unmarkBrowseMessage(MQMessageReference)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl", "static", "SCCS id", (Object)sccsid);
        }
        sweepInterval = 30000L;
        defaultHeaderDataLength = 5000;
    }
}

