/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageGroup;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread;
import javax.jms.JMSException;

class MQQueueAgentThread1Impl
extends MQQueueAgentThread {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static long EOQTimeout;
    private static long sweepInterval;
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueAgentThread1Impl.java, jmscc.wmq.v6, k701, k701-112-140304 1.26.1.2 10/09/08 17:12:07";
    private boolean anyAlreadySeen = false;
    private long eoqTimeoutStart = 0L;
    private int headerDataSize = -1;
    private int messageBufferSize = 0;
    private int messageMQMDandRFH2Size = 0;
    protected static final int sizeofMQMDv2 = 364;
    private boolean lastMessageWasSeen = false;
    private MQMessageGroup seenLastSweep = new MQMessageGroup();
    private MQMessageGroup seenThisSweep = new MQMessageGroup();

    MQQueueAgentThread1Impl(MQQueueAgent mqQueueAgent, MQConnection jmsConnection, String qmgrName, String qName) throws JMSException {
        super(mqQueueAgent, jmsConnection, qmgrName, qName);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "<init>(MQQueueAgent,MQConnection,String,String)", new Object[]{mqQueueAgent, jmsConnection, qmgrName, qName});
        }
        EOQTimeout = jmsConnection.getEoqTimeout();
        this.headerDataSize = jmsConnection.getHeaderDataSize();
        sweepInterval = jmsConnection.getSweepTime();
        if (Trace.isOn) {
            Trace.traceData(this, "MQQueueAgentThread1Impl: headerDataSize= " + this.headerDataSize + " sweepInterval: " + sweepInterval, null);
        }
        this.options = 8362;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "<init>(MQQueueAgent,MQConnection,String,String)");
        }
    }

    MQMessageReference browse(int dataQuantity, long wait) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browse(int,long)", new Object[]{new Integer(dataQuantity), new Long(wait)});
        }
        MQMessageReference deliverMR = null;
        long currentTime = 0L;
        try {
            boolean browseFirst = false;
            if (this.startSweep) {
                browseFirst = true;
                currentTime = System.currentTimeMillis();
                this.sweepStartedTime = System.currentTimeMillis();
                this.startSweep = false;
                this.sweepTimeoutStart = 0L;
                this.eoqTimeoutStart = -1L;
                this.lastMessageWasSeen = this.anyAlreadySeen;
                this.anyAlreadySeen = false;
                MQMessageGroup t = this.seenLastSweep;
                this.seenLastSweep = this.seenThisSweep;
                this.seenThisSweep = t;
                this.seenThisSweep.clear();
            }
            boolean done = false;
            while (!done) {
                deliverMR = this.browseMsg(dataQuantity, browseFirst, 0);
                browseFirst = false;
                if (deliverMR != null) {
                    if ((deliverMR = this.makeSuitableForDelivery(dataQuantity, deliverMR)) == null) continue;
                    done = true;
                    continue;
                }
                done = true;
            }
            if (deliverMR == null) {
                long waitStart;
                this.deliverNow();
                currentTime = waitStart = System.currentTimeMillis();
                done = false;
                if (EOQTimeout != -1L) {
                    if (this.eoqTimeoutStart == -1L) {
                        this.eoqTimeoutStart = waitStart;
                    } else if (waitStart - this.eoqTimeoutStart >= EOQTimeout) {
                        done = true;
                        this.startSweep = true;
                    }
                }
                while (!done) {
                    int timeout = (int)(wait - (currentTime - waitStart));
                    if (EOQTimeout != -1L && (long)timeout > EOQTimeout) {
                        timeout = (int)EOQTimeout;
                    }
                    if (timeout < 1000) {
                        timeout = 1000;
                    }
                    if ((deliverMR = this.browseMsg(dataQuantity, false, timeout)) != null) {
                        if ((deliverMR = this.makeSuitableForDelivery(dataQuantity, deliverMR)) != null) {
                            done = true;
                            continue;
                        }
                        deliverMR = null;
                        currentTime = System.currentTimeMillis();
                        if (wait - (currentTime - waitStart) > 0L) continue;
                        done = true;
                        continue;
                    }
                    done = true;
                    deliverMR = null;
                }
            }
            if (deliverMR == null) {
                this.deliverNow();
                this.startSweep = true;
            } else if (this.sweepTimeoutStart != 0L) {
                if (currentTime == 0L) {
                    currentTime = System.currentTimeMillis();
                }
                if (currentTime > this.sweepTimeoutStart + 30000L) {
                    this.deliverNow();
                    this.startSweep = true;
                }
            } else {
                if (currentTime == 0L) {
                    currentTime = System.currentTimeMillis();
                }
                this.sweepTimeoutStart = currentTime;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browse(int,long)", deliverMR);
            }
            return deliverMR;
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browse(int,long)", mqe, 1);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1025");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browse(int,long)", je, 1);
            }
            throw je;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browse(int,long)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browse(int,long)", je, 2);
            }
            throw je;
        }
    }

    private MQMessageReference browseMsg(int dataQuantity, boolean browseFirst, int timeout) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browseMsg(int,boolean,int)", new Object[]{new Integer(dataQuantity), browseFirst, new Integer(timeout)});
        }
        MQMessageReference outMR = null;
        try {
            boolean useBatching;
            if (browseFirst) {
                this.mqGMO.options &= 0xFFFFFFDF;
                this.mqGMO.options |= 0x10;
            } else {
                this.mqGMO.options &= 0xFFFFFFEF;
                this.mqGMO.options |= 0x20;
            }
            boolean bl = useBatching = dataQuantity == 0;
            if (dataQuantity == 1 && this.headerDataSize != -1) {
                this.messageBufferSize = this.headerDataSize;
            }
            if (timeout == 0) {
                this.mqGMO.options &= 0xFFFFFFFE;
            } else {
                this.mqGMO.options |= 1;
                this.mqGMO.waitInterval = timeout;
            }
            MQJMSMessage message = new MQJMSMessage();
            if (Trace.isOn) {
                Trace.traceData(this, "About to browse message:", null);
                Trace.traceData(this, (this.mqGMO.options & 0x20) == 0 ? "- browsing first message" : "- browsing next message", null);
                Trace.traceData(this, (this.mqGMO.options & 1) == 0 ? "- browsing without waiting" : "- browsing with wait for " + this.mqGMO.waitInterval, null);
                Trace.traceData(this, useBatching ? "- using batched-get" : "- using non-batched get", null);
                Trace.traceData(this, "- browsing with bufferSize ", (Object)new Integer(this.messageBufferSize));
            }
            int reason = 0;
            switch (dataQuantity) {
                case 0: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "- browsing with NO_DATA", null);
                    }
                    this.mqGMO.options |= 0x40;
                    if (Trace.isOn) {
                        Trace.traceData(this, "- browsing with truncation", null);
                    }
                    if ((reason = this.mqQueue.spiBatchedGetNoExc(message, this.mqGMO, 0)) != 2079) break;
                    reason = 0;
                    break;
                }
                case 1: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "- browsing with HEADER_DATA", null);
                    }
                    reason = this.getMessageHeaderOnly(message);
                    break;
                }
                case 2: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "- browsing with FULL_DATA", null);
                    }
                    this.mqGMO.options &= 0xFFFFFFBF;
                    if (Trace.isOn) {
                        Trace.traceData(this, "- browsing with fulle message", null);
                    }
                    reason = this.mqQueue.getMsg2NoExc(message, this.mqGMO);
                    break;
                }
            }
            if (reason == 2033) {
                if (Trace.isOn) {
                    Trace.traceData(this, "MQRC_NO_MSG_AVAILABLE", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browseMsg(int,boolean,int)", null, 1);
                }
                return null;
            }
            if (reason != 0) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Unexpected reason code " + reason, null);
                }
                MQException traceRet1 = new MQException(2, reason, (Object)this);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browseMsg(int,boolean,int)", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Browsed message: length= " + message.getMessageDataLength() + " dataQuantityHint= " + dataQuantity, null);
            }
            outMR = new MQMessageReference(this.jmsSession);
            outMR.setDestination(this.mqQueueAgent.getProviderDestination());
            outMR.setMQJMSMessage(message, dataQuantity, this.messageMQMDandRFH2Size);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browseMsg(int,boolean,int)", outMR, 2);
            }
            return outMR;
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browseMsg(int,boolean,int)", mqe);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "browseMsg(int,boolean,int)", mqe, 2);
            }
            throw mqe;
        }
    }

    long getEOQTimeout() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "getEOQTimeout()", "getter", new Long(EOQTimeout));
        }
        return EOQTimeout;
    }

    private int getMessageHeaderOnly(MQJMSMessage message) {
        int reason;
        block14: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "getMessageHeaderOnly(MQJMSMessage)", new Object[]{message});
            }
            this.mqGMO.options |= 0x40;
            if (Trace.isOn) {
                Trace.traceData(this, "- browsing with truncation", null);
            }
            reason = 0;
            int truncatedBufferSize = 400;
            if (400 < this.messageBufferSize) {
                truncatedBufferSize = this.messageBufferSize;
            }
            if ((reason = this.mqQueue.getMsg2NoExc(message, this.mqGMO, truncatedBufferSize)) == 2033) {
                if (Trace.isOn) {
                    Trace.traceData(this, "getMessageHeaderOnly - First browse. No message available ", null);
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "getMessageHeaderOnly(MQJMSMessage)", 1);
                }
                return reason;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Message: ", (Object)((Object)((Object)message)).toString());
            }
            if (reason == 2079) {
                reason = 0;
            }
            long format = 0L;
            try {
                format = message.getFormatAsLong();
                if (format != 5571313732236222496L && format != -3109514705028104128L) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "getMessageHeaderOnly - Received message does not have RFH2", null);
                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "getMessageHeaderOnly(MQJMSMessage)", 2);
                    }
                    return reason;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Message: ", (Object)((Object)((Object)message)).toString());
                }
                int msgEncoding = 0;
                int strucLength = 0;
                msgEncoding = message.getEncoding();
                message.skipReadingBytes(8);
                strucLength = message.readInt(msgEncoding);
                this.messageMQMDandRFH2Size = strucLength + 364;
                if (Trace.isOn) {
                    Trace.traceData(this, "MQMD + RFH2 length = " + this.messageMQMDandRFH2Size, null);
                }
            }
            catch (Exception e) {
                reason = 2033;
                if (!Trace.isOn) break block14;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "getMessageHeaderOnly(MQJMSMessage)", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "getMessageHeaderOnly(MQJMSMessage)", 3);
        }
        return reason;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQMessageReference makeSuitableForDelivery(int dataQuantity, MQMessageReference msgRef) throws MQException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "makeSuitableForDelivery(int,MQMessageReference)", new Object[]{new Integer(dataQuantity), msgRef});
        }
        MQJMSMessage tmpMessage = null;
        try {
            MQMessageReference outMR;
            block39: {
                MQJMSMessage message;
                block40: {
                    MQMessageReference oldMR = this.seenLastSweep.removeMessage(msgRef);
                    boolean suitable = false;
                    if (oldMR == null) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "New message", null);
                        }
                        outMR = msgRef;
                        msgRef.setBrowseTime(this.sweepStartedTime);
                        tmpMessage = msgRef.getMQJMSMessage();
                        MQMessageReference tmpMR = (MQMessageReference)msgRef.clone();
                        this.seenThisSweep.addMessage(tmpMR);
                        this.lastMessageWasSeen = false;
                        suitable = true;
                    } else {
                        int newQuantity;
                        if (Trace.isOn) {
                            Trace.traceData(this, "Previously seen message", null);
                        }
                        this.lastMessageWasSeen = true;
                        this.anyAlreadySeen = true;
                        int oldBackoutCount = oldMR.getBackoutCount();
                        int newBackoutCount = msgRef.getBackoutCount();
                        boolean backoutCountChanged = newBackoutCount != oldBackoutCount;
                        int oldQuantity = oldMR.getDataQuantity();
                        if (oldQuantity == (newQuantity = msgRef.getDataQuantity()) && null != oldMR.getMQJMSMessage() || oldQuantity == 1 && newQuantity == 0 || oldQuantity == 2) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "using old MessageReference.", null);
                            }
                            outMR = oldMR;
                            if (backoutCountChanged) {
                                outMR.setBackoutCount(newBackoutCount);
                            }
                        } else {
                            if (Trace.isOn) {
                                Trace.traceData(this, "using new MessageReference.", null);
                            }
                            msgRef.setBrowseTime(oldMR.getBrowseTime());
                            outMR = msgRef;
                        }
                        MQMessageReference tmpMR = (MQMessageReference)outMR.clone();
                        this.seenThisSweep.addMessage(tmpMR);
                        if (oldMR.isWanted() && (backoutCountChanged || oldMR.getBrowseTime() + 60000L <= this.sweepStartedTime)) {
                            suitable = true;
                            outMR.setBrowseTime(this.sweepStartedTime);
                        } else {
                            outMR = null;
                        }
                    }
                    if (Trace.isOn) {
                        if (suitable) {
                            Trace.traceData(this, "ProviderMessage is suitable for delivery", null);
                        } else {
                            Trace.traceData(this, "ProviderMessage not suitable for delivery", null);
                        }
                    }
                    if (!suitable || dataQuantity == 0 || outMR.getDataQuantity() == 2) break block39;
                    message = outMR.getMQJMSMessage();
                    if (null == message) {
                        if (null != tmpMessage) {
                            message = tmpMessage;
                        } else {
                            message = new MQJMSMessage();
                            message.setMessageId(outMR.getMessageId());
                            message.setCorrelationId(outMR.getCorrelId());
                        }
                    }
                    if (this.messageMQMDandRFH2Size <= message.getMessageDataLength()) break block40;
                    if (Trace.isOn) {
                        Trace.traceData(this, "messageMQMDandRFH2Size is greater than message length: " + message.getMessageDataLength(), null);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Browsing message with HEADER_DATA : " + outMR.getHeaderLength(), null);
                    }
                    this.mqGMO.options = 80;
                    this.mqGMO.matchOptions = 3;
                    int reason = this.mqQueue.getMsg2NoExc(message, this.mqGMO, this.messageMQMDandRFH2Size);
                    this.mqGMO.matchOptions = 0;
                    if (reason == 2079) {
                        reason = 0;
                        if (Trace.isOn) {
                            Trace.traceData(this, "Using truncated message.", null);
                        }
                    }
                    if (reason == 0) {
                        outMR.setMQJMSMessage(message, 1, this.messageMQMDandRFH2Size);
                        break block39;
                    } else if (reason == 2033) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "MQRC_NO_MSG_AVAILABLE: message has been removed from queue", null);
                        }
                        outMR = null;
                        break block39;
                    } else {
                        MQException traceRet1 = new MQException(2, reason, (Object)this);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "makeSuitableForDelivery(int,MQMessageReference)", traceRet1, 1);
                        }
                        throw traceRet1;
                    }
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "IZ83437 - messageMQMDandRFH2Size is not greater than message length: " + message.getMessageDataLength(), null);
                }
                outMR.setMQJMSMessage(message, 1, this.messageMQMDandRFH2Size);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "makeSuitableForDelivery(int,MQMessageReference)", outMR);
            }
            return outMR;
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "makeSuitableForDelivery(int,MQMessageReference)", mqe, 1);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "makeSuitableForDelivery.", null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "makeSuitableForDelivery(int,MQMessageReference)", mqe, 2);
            }
            throw mqe;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "makeSuitableForDelivery(int,MQMessageReference)", je, 2);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "makeSuitableForDelivery.", null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "makeSuitableForDelivery(int,MQMessageReference)", je, 3);
            }
            throw je;
        }
    }

    void setEOQTimeout(long newTimeout) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "setEOQTimeout(long)", "setter", new Long(newTimeout));
        }
        if ((newTimeout < -2L || newTimeout > 30000L) && Trace.isOn) {
            Trace.traceData(this, "timeout being set to possible invalid value: " + newTimeout, null);
        }
        EOQTimeout = newTimeout;
    }

    boolean updateConfig() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "updateConfig()");
        }
        if (this.startSweep) {
            this.seenThisSweep.clear();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "updateConfig()", true, 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "updateConfig()", false, 2);
        }
        return false;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueAgentThread1Impl.java, jmscc.wmq.v6, k701, k701-112-140304  1.26.1.2 10/09/08 17:12:07");
        }
        EOQTimeout = 3000L;
        sweepInterval = 30000L;
    }
}

