/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.disthub2.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthub2.impl.matching.MatchingException;
import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueManager;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.DLH;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.SearchResults;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.jms.JMSException;

abstract class MQQueueAgentThread
implements Runnable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueAgentThread.java, jmscc.wmq.v6, k701, k701-112-140304  1.36.1.22 13/06/13 10:23:33";
    protected static final long SWEEP_TIMEOUT = 30000L;
    protected static final long REDELIVER_INTERVAL = 60000L;
    protected boolean startSweep = true;
    protected long sweepStartedTime;
    protected long sweepTimeoutStart = 0L;
    protected static final String QUEUEAGENTTHREAD_SLEEPTIME = "com.ibm.mq.jms.tuning.queueAgentThreadSleepTime";
    MQQueueAgent mqQueueAgent;
    String qmgrName;
    String qName;
    MQConnection jmsConnection;
    MQSession jmsSession;
    MQQueueManager mqQueueManager;
    MQQueue mqQueue;
    private String mqBORQName;
    public static final String useDefaultBOValues = "com.ibm.mq.jms.useDefaultBOValues";
    private boolean puttingToBORQ;
    int backoutThreshold;
    boolean retainMessages;
    boolean redeliverUnwanted;
    private boolean fullMessages;
    private boolean active;
    private boolean quit;
    private JMSException exception;
    int oldCount;
    int newCount;
    int failedCount;
    int browserChoice;
    private boolean messagesToDeliver;
    protected final MQGetMessageOptions mqGMO;
    protected int options;
    private Thread queueAgentThreadThread;
    private JMSException lastException;

    MQQueueAgentThread(MQQueueAgent mqQueueAgent, MQConnection jmsConnection, String qmgrName, String qName) throws JMSException {
        PropertyStore.register(QUEUEAGENTTHREAD_SLEEPTIME, 5000L, new Long(0L), null);
        this.mqBORQName = null;
        this.puttingToBORQ = false;
        this.retainMessages = false;
        this.redeliverUnwanted = false;
        this.fullMessages = true;
        this.active = false;
        this.quit = false;
        this.exception = null;
        this.browserChoice = 0;
        this.messagesToDeliver = false;
        this.mqGMO = new MQGetMessageOptions(this instanceof MQQueueAgentThread1Impl);
        this.queueAgentThreadThread = null;
        this.lastException = null;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "<init>(MQQueueAgent,MQConnection,String,String)", new Object[]{mqQueueAgent, jmsConnection, qmgrName, qName});
        }
        this.mqQueueAgent = mqQueueAgent;
        this.jmsConnection = jmsConnection;
        this.qmgrName = qmgrName;
        this.qName = qName;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "<init>(MQQueueAgent,MQConnection,String,String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void go() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "go()");
        }
        try {
            WorkQueueManager.enqueue(this, 0, false);
        }
        catch (CSIException ce) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "go()", ce, 1);
            }
            HashMap<String, CSIException> m = new HashMap<String, CSIException>();
            m.put("exception", ce);
            Trace.ffst(this, "start()", "XO00A001", m, JMSException.class);
        }
        MQQueueAgentThread mQQueueAgentThread = this;
        // MONITORENTER : mQQueueAgentThread
        while (!this.active && this.exception == null) {
            try {
                if (Trace.isOn) {
                    Trace.traceData(this, "go() waiting for thread to start up", null);
                }
                this.wait();
                if (!Trace.isOn) continue;
                Trace.traceData(this, "go() woken up", null);
            }
            catch (InterruptedException ie) {
                if (!Trace.isOn) continue;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "go()", ie, 2);
            }
        }
        // MONITOREXIT : mQQueueAgentThread
        if (!Trace.isOn) return;
        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "go()");
    }

    void retainAllMessages() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "retainAllMessages()");
        }
        this.retainMessages = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "retainAllMessages()");
        }
    }

    void redeliverUnwanted() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "redeliverUnwanted()");
        }
        this.redeliverUnwanted = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "redeliverUnwanted()");
        }
    }

    void quit() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "quit()");
        }
        this.quit = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "quit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForEnd() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "waitForEnd()");
        }
        if (!Thread.currentThread().equals(this.queueAgentThreadThread)) {
            MQQueueAgentThread mQQueueAgentThread = this;
            synchronized (mQQueueAgentThread) {
                while (this.active && this.exception == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        if (!Trace.isOn) continue;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "waitForEnd()", ie);
                    }
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "waitForEnd()");
        }
    }

    void setup() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "setup()");
        }
        try {
            block28: {
                this.mqQueueManager = this.jmsConnection.createQMNonXA();
                this.jmsSession = new MQSession(this.jmsConnection, this.mqQueueManager, false, 0);
                if (Trace.isOn) {
                    Trace.traceData(this, "session created", null);
                }
                try {
                    this.mqQueue = this.mqQueueManager.accessQueue(this.qName, this.options);
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "setup()", mqe, 3);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS2008", this.qName);
                    je.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "setup()", je, 2);
                    }
                    throw je;
                }
                this.mqGMO.options |= 0x2000;
                this.mqGMO.matchOptions = 0;
                int mqQueueType = Utils.inquireInt(this.mqQueue, 20);
                if (mqQueueType == 3) {
                    String baseQueueName = Utils.inquireString(this.mqQueue, 2002);
                    try {
                        PropertyStore.register(useDefaultBOValues, false);
                        if (PropertyStore.getBooleanPropertyObject(useDefaultBOValues).booleanValue()) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "useDefaultBOValues =com.ibm.mq.jms.useDefaultBOValues", null);
                            }
                            this.backoutThreshold = -1;
                            break block28;
                        }
                        int options = 8224;
                        MQQueue mqBaseQueue = this.mqQueueManager.accessQueue(baseQueueName, options);
                        int baseQueueType = Utils.inquireInt(mqBaseQueue, 20);
                        if (baseQueueType == 7) {
                            mqBaseQueue.close();
                            int options_forClusterQ = 8232;
                            mqBaseQueue = this.mqQueueManager.accessQueue(baseQueueName, options_forClusterQ);
                        }
                        this.backoutThreshold = Utils.inquireInt(mqBaseQueue, 22);
                        mqBaseQueue.close();
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "setup()", mqe, 4);
                        }
                        this.backoutThreshold = -1;
                        HashMap<String, Object> inserts = new HashMap<String, Object>();
                        inserts.put("XMSC_INSERT_DESTINATION_NAME", baseQueueName);
                        inserts.put("XMSC_INSERT_STRING", this.qName);
                        inserts.put("XMSC_INSERT_VALUE", new Integer(this.backoutThreshold));
                        inserts.put("XMSC_INSERT_EXCEPTION", (Object)mqe);
                        if (mqe instanceof MQException) {
                            inserts.put("XMSC_INSERT_COMP_CODE", new Integer(mqe.getCompCode()));
                            inserts.put("XMSC_INSERT_REASON", new Integer(mqe.getReason()));
                        }
                        Log.log(this, "setup()", "MQJMS1115", inserts);
                    }
                } else {
                    this.backoutThreshold = Utils.inquireInt(this.mqQueue, 22);
                }
            }
            if (this.backoutThreshold == -1) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Inquire on backoutThreshold failed. Defaulting to 20.", null);
                }
                this.backoutThreshold = 20;
            }
        }
        catch (JMSException e) {
            block29: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "setup()", e, 5);
                }
                try {
                    if (this.jmsSession != null) {
                        this.jmsSession.close(false);
                    }
                    if (this.mqQueueManager != null) {
                        this.mqQueueManager.disconnect();
                    }
                }
                catch (JMSException e2) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "setup()", e2, 6);
                    }
                }
                catch (MQException e2) {
                    if (!Trace.isOn) break block29;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "setup()", e2, 7);
                }
            }
            this.jmsSession = null;
            this.mqQueueManager = null;
            this.mqQueue = null;
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "setup()", e, 3);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "setup()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void shutdown() throws JMSException {
        block10: {
            block11: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "shutdown()");
                }
                try {
                    block9: {
                        try {
                            if (this.jmsSession == null) break block9;
                            this.jmsSession.close(false);
                        }
                        catch (JMSException je) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "shutdown()", je);
                            }
                            Object var3_2 = null;
                            if (Trace.isOn) {
                                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "shutdown()");
                            }
                            this.jmsSession = null;
                            this.mqQueueManager = null;
                            this.mqQueue = null;
                            break block10;
                        }
                    }
                    Object var3_1 = null;
                    if (!Trace.isOn) break block11;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "shutdown()");
                    }
                    this.jmsSession = null;
                    this.mqQueueManager = null;
                    this.mqQueue = null;
                    throw throwable;
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "shutdown()");
            }
            this.jmsSession = null;
            this.mqQueueManager = null;
            this.mqQueue = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "shutdown()");
        }
    }

    abstract MQMessageReference browse(int var1, long var2) throws JMSException;

    abstract boolean updateConfig() throws JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void processMessage(MQMessageReference msgRef) throws JMSException {
        block98: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", new Object[]{msgRef});
            }
            try {
                block97: {
                    i = 0;
                    browsers = null;
                    psBrowsers = null;
                    receiver = null;
                    okay = true;
                    if (this.backoutThreshold != 0 && msgRef.getBackoutCount() >= this.backoutThreshold) {
                        block96: {
                            if (Trace.isOn) {
                                Trace.traceData(this, "backoutThreshold reached", null);
                            }
                            okay = false;
                            try {
                                this.backoutRequeue(msgRef);
                                var12_8 = null;
                                if (!Trace.isOn) break block96;
                            }
                            catch (Throwable var11_29) {
                                var12_9 = null;
                                if (Trace.isOn) {
                                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)");
                                }
                                this.puttingToBORQ = false;
                                throw var11_29;
                            }
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)");
                        }
                        this.puttingToBORQ = false;
                        {
                            break block97;
                            catch (JMSException je) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", je, 1);
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "ProviderMessage requeue failed. Treating it as a bad message", null);
                                }
                                if ((e = je.getLinkedException()) != null && e instanceof MQException) {
                                    reason = ((MQException)e).reasonCode;
                                } else {
                                    reason = 2362;
                                    this.puttingToBORQ = false;
                                }
                                try {
                                    this.removeBadMessage(msgRef, reason);
                                }
                                catch (JMSException je2) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", je2, 2);
                                    }
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "removeBadMessage failed.", null);
                                    }
                                    if (Trace.isOn) {
                                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", je, 1);
                                    }
                                    throw je;
                                }
                                var12_8 = null;
                                if (Trace.isOn) {
                                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)");
                                }
                                this.puttingToBORQ = false;
                            }
                        }
                    }
                }
                if (okay && msgRef.getDataQuantity() != 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Checking format of message", null);
                    }
                    try {
                        msgRef.getJMSMessage();
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", je, 3);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "ProviderMessage is badly formatted", null);
                        }
                        okay = false;
                        try {
                            this.removeBadMessage(msgRef, 2364);
                        }
                        catch (JMSException je2) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", je2, 4);
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "removeBadMessage failed.", null);
                            }
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", je2, 2);
                            }
                            throw je2;
                        }
                    }
                }
                if (!okay) break block98;
                msgRef.setReferenceQueue(this.qName);
                msgRef.setDomain(this.mqQueueAgent.getDomain());
                switch (this.mqQueueAgent.getDomain()) {
                    case 0: {
                        if (Trace.isOn) {
                            Trace.traceData(this, "In the PtP domain", null);
                        }
                        browsers = new Vector();
                        found = false;
                        var8_14 = this.mqQueueAgent.browsers;
                        synchronized (var8_14) {
                            if (this.mqQueueAgent.useSelectors > 0) {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Selectors in use", null);
                                }
                                try {
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "Checking for suitable browsers", null);
                                    }
                                    sResults = new SearchResults();
                                    this.mqQueueAgent.getMatches(MQQueueAgent.PTPTOPIC, msgRef, sResults);
                                    if (sResults.m_receivers.m_count <= 0) ** GOTO lbl130
                                    if (Trace.isOn) {
                                        Trace.traceData(this, sResults.m_receivers.m_count + " matches found", null);
                                    }
                                    vList = sResults.m_receivers;
                                    browsers = vList.makeVector();
                                }
                                catch (MatchingException e) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", e, 5);
                                    }
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "MatchingException thrown trying to get suitable browser matches", null);
                                    }
                                    je = ConfigEnvironment.newException("MQJMS6233", (Object)e);
                                    je.setLinkedException((Exception)e);
                                    if (Trace.isOn) {
                                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", je, 3);
                                    }
                                    throw je;
                                }
                                catch (BadMessageFormatMatchingException e) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", e, 6);
                                    }
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "BadMessageFormatException thrown trying to get suitable browser matches", null);
                                    }
                                    je = ConfigEnvironment.newException("MQJMS6233", (Object)e);
                                    je.setLinkedException((Exception)e);
                                    if (Trace.isOn) {
                                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", je, 4);
                                    }
                                    throw je;
                                }
                            } else {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "No Selectors in use, all browsers are suitable", null);
                                }
                                browsers = this.mqQueueAgent.getBrowsers();
                            }
lbl130:
                            // 3 sources

                            if (browsers.size() != 0) ** GOTO lbl142
                            if (Trace.isOn) {
                                Trace.traceData(this, "No Suitable browsers found. Setting message unwanted", null);
                            }
                            msgRef.setIsWanted(false);
                            if (this.retainMessages) ** GOTO lbl139
                            if (Trace.isOn) {
                                Trace.traceData(this, "MessageRetention off, removing the message", null);
                            }
                            this.removeBadMessage(msgRef, 2363);
                            ** GOTO lbl155
lbl139:
                            // 1 sources

                            if (!Trace.isOn) ** GOTO lbl155
                            Trace.traceData(this, "MessageRetention on, keeping message on queue", null);
                            ** GOTO lbl155
lbl142:
                            // 1 sources

                            ++this.browserChoice;
                            i = this.browserChoice % browsers.size();
                            if (Trace.isOn) {
                                Trace.traceData(this, "Choosing suitable browser: browserChoice = " + this.browserChoice + ", number of choices = " + browsers.size() + ", choosing number " + i, null);
                            }
                            max = browsers.size();
                            for (j = 0; j < max && !found; ++j) {
                                receiver = (MQConnectionBrowser)browsers.elementAt((i + j) % max);
                                if (!receiver.receiveFlag.receiving) continue;
                                found = true;
                            }
                        }
lbl155:
                        // 4 sources

                        if (found) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "Delivering to:\n" + receiver.toString(), null);
                            }
                            this.messagesToDeliver = true;
                            this.deliverMsgRef(receiver, msgRef);
                            ** break;
                        }
                        break;
                    }
                    case 1: {
                        if (Trace.isOn) {
                            Trace.traceData(this, "In the PubSub domain", null);
                        }
                        var8_14 = this.mqQueueAgent.browsers;
                        synchronized (var8_14) {
                            psBrowsers = new Hashtable();
                            receiver = null;
                            psBrowsers = this.mqQueueAgent.getPubSubBrowserLookup();
                            if (this.mqQueueAgent.getUseCorrelId()) {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Shared queue, searching for browser with correlId =" + Utils.bytesToHex(msgRef.getCorrelId()), null);
                                }
                                if (null == (receiver = (MQConnectionBrowser)psBrowsers.get(Utils.bytesToHex(msgRef.getCorrelId())))) {
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "Could not find a suitable entry in the Hashtable", null);
                                    }
                                } else if (!receiver.receiveFlag.receiving) {
                                    receiver = null;
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "Only suitable entry in the Hashtable is not yet active", null);
                                    }
                                }
                            } else {
                                receiver = (MQConnectionBrowser)psBrowsers.get("XXX-Exclusive-Subscriber-Key-XXX");
                            }
                            if (receiver == null && Trace.isOn) {
                                Trace.traceData(this, "No suitable browsers found", null);
                            }
                            if (receiver == null || receiver.getMessageSelector() == null) ** GOTO lbl227
                            if (Trace.isOn) {
                                Trace.traceData(this, "receiving subscription uses selectors", null);
                            }
                            try {
                                if (Trace.isOn) {
                                    if (null == this.jmsConnection) {
                                        Trace.traceData(this, "*** jmsConnection is null!", null);
                                    }
                                    Trace.traceData(this, "msgSelection = " + this.jmsConnection.getMsgSelection(), null);
                                }
                            }
                            catch (Throwable t) {
                                if (!Trace.isOn) ** GOTO lbl198
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", t, 7);
                            }
lbl198:
                            // 3 sources

                            if (this.jmsConnection.getMsgSelection() == 1) ** GOTO lbl224
                            if (Trace.isOn) {
                                Trace.traceData(this, "Using client side selectors", null);
                            }
                            if (msgRef.matches(receiver.getMessageSelector())) ** GOTO lbl232
                            discardMessage = new MQMessage();
                            discardMessage.messageId = msgRef.getMessageId();
                            gmo = new MQGetMessageOptions();
                            gmo.options = 64;
                            gmo.matchOptions = 1;
                            try {
                                this.mqQueue.get(discardMessage, gmo, 0);
                            }
                            catch (MQException mqe) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", mqe, 8);
                                }
                                if (mqe.reasonCode != 2033 && mqe.reasonCode != 2079) {
                                    je = ConfigEnvironment.newException("MQJMS1031");
                                    je.setLinkedException((Exception)mqe);
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "Unable to discard message.", null);
                                    }
                                    if (Trace.isOn) {
                                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", je, 5);
                                    }
                                    throw je;
                                }
                                if (!Trace.isOn) break;
                                Trace.traceData(this, "Ignoring reason code = " + mqe.reasonCode, null);
                            }
                            ** break;
lbl224:
                            // 1 sources

                            if (Trace.isOn) {
                                Trace.traceData(this, "Using Broker side selector, message should already be appropriate", null);
                            }
                            ** GOTO lbl232
lbl227:
                            // 1 sources

                            if (Trace.isOn) {
                                Trace.traceData(this, "No Selectors in use, all browsers are suitable", null);
                            }
                        }
lbl232:
                        // 3 sources

                        if (receiver != null) {
                            if (receiver.receiveFlag.receiving) {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Delivering to:\n" + receiver.toString(), null);
                                }
                                this.messagesToDeliver = true;
                                this.deliverMsgRef(receiver, msgRef);
                                ** break;
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "Receiver not yet active", null);
                                ** break;
                            }
                            break;
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "No Suitable browser found. Setting message unwanted", null);
                        }
                        msgRef.setIsWanted(false);
                        ** break;
                    }
                    default: {
                        if (!Trace.isOn) break;
                        Trace.traceData(this, "Unknown domain, not doing anything", null);
lbl250:
                        // 6 sources

                    }
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", je, 9);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)", je, 6);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "processMessage(MQMessageReference)");
        }
    }

    protected void deliverMsgRef(MQConnectionBrowser browser, MQMessageReference msgRef) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deliverMsgRef(MQConnectionBrowser,MQMessageReference)", new Object[]{browser, msgRef});
        }
        browser.deliver(msgRef);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deliverMsgRef(MQConnectionBrowser,MQMessageReference)");
        }
    }

    void removeBadMessage(MQMessageReference msgRef, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "removeBadMessage(MQMessageReference,int)", new Object[]{msgRef, new Integer(reason)});
        }
        try {
            MQJMSMessage mess = msgRef.getMQJMSMessage();
            if ((mess.getReport() & 0x8000000) == 0x8000000) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Discarding message as per MQMD.Report", null);
                }
                this.discard(msgRef, reason);
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "Dead-lettering message as per MQMD.Report", null);
                }
                this.deadLetter(msgRef, reason);
            }
        }
        catch (JMSException jmse) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "removeBadMessage(MQMessageReference,int)", jmse);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "removeBadMessage(MQMessageReference,int)", jmse);
            }
            throw jmse;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "removeBadMessage(MQMessageReference,int)");
        }
    }

    private void deadLetter(MQMessageReference msgRef, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)", new Object[]{msgRef, new Integer(reason)});
        }
        MQMessage msg = null;
        MQMessage reportMessage = null;
        String replyQ = null;
        String replyQMgr = null;
        String mqDLQName = null;
        try {
            msg = this.retrieveMessage(msgRef);
            mqDLQName = Utils.inquireString(this.mqQueueManager, 2006);
            if (Trace.isOn) {
                Trace.traceData(this, "DLQ = <" + mqDLQName + ">", null);
            }
            if (mqDLQName == null || mqDLQName.length() == 0) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Unable to find DLQ name - is one defined?", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1079");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)", je, 1);
                }
                throw je;
            }
            if ((msg.report & 0x7000000) != 0) {
                reportMessage = this.generateReport(msg, reason);
                replyQ = msg.replyToQueueName.trim();
                replyQMgr = msg.replyToQueueManagerName.trim();
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Constructing DLH", null);
            }
            DLH dlh = new DLH();
            dlh.reason = reason;
            dlh.destQName = this.qName;
            dlh.destQMgrName = this.qmgrName;
            dlh.putApplType = 28;
            dlh.putApplName = "MQ JMS ConnectionConsumer";
            if (this.puttingToBORQ) {
                dlh.destQName = this.mqBORQName;
            }
            GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            dlh.putDate = Utils.getDate(gc);
            dlh.putTime = Utils.getTime(gc);
            dlh.write(msg);
            this.put1WithContext(msg, mqDLQName, null);
            if (reportMessage != null) {
                try {
                    this.put1WithContext(reportMessage, replyQ, replyQMgr);
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)", mqe, 1);
                    }
                    dlh.destQName = replyQ;
                    dlh.destQMgrName = replyQMgr;
                    dlh.reason = mqe.reasonCode;
                    dlh.write(reportMessage);
                    this.put1WithContext(reportMessage, mqDLQName, null);
                }
            }
        }
        catch (MQException mqe) {
            block35: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)", mqe, 2);
                }
                if (mqe.reasonCode == 2033) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage to dead-letter has disappeared! Continue as normal", null);
                    }
                }
                if (msg != null && msg.persistence == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Could not send report message, but message is non-persistent - so subsume the error", null);
                    }
                }
                try {
                    this.mqQueueManager.backout();
                }
                catch (MQException mqe2) {
                    if (!Trace.isOn) break block35;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)", mqe2, 3);
                }
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1079");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)", je, 2);
            }
            throw je;
        }
        catch (JMSException je) {
            block36: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)", je, 4);
                }
                if (msg != null && msg.persistence == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage is non-persistent so ignoring error", null);
                    }
                }
                try {
                    this.mqQueueManager.backout();
                }
                catch (MQException mqe) {
                    if (!Trace.isOn) break block36;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)", mqe, 5);
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)", je, 3);
            }
            throw je;
        }
        try {
            this.mqQueueManager.commit();
            if (reason == 2364) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_MESSAGE_ID", Utils.bytesToHex(msg.messageId));
                inserts.put("XMSC_INSERT_DESTINATION_NAME", this.qName);
                inserts.put("XMSC_INSERT_QUEUE_MANAGER_NAME", this.mqQueueManager.name);
                inserts.put("XMSC_INSERT_STRING", mqDLQName.substring(0, 48));
                Log.log(this, "deadLetter()", "MQJMS1116", inserts);
            }
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)", mqe, 6);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1079");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deadLetter(MQMessageReference,int)");
        }
    }

    void backoutRequeue(MQMessageReference msgRef) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "backoutRequeue(MQMessageReference)", new Object[]{msgRef});
        }
        try {
            if (this.mqBORQName == null) {
                int type = Utils.inquireInt(this.mqQueue, 20);
                if (type == 3) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "MQQueue " + this.mqQueue.name + "is an ALIAS queue.", null);
                    }
                    String baseQueueName = Utils.inquireString(this.mqQueue, 2002);
                    if (Trace.isOn) {
                        Trace.traceData(this, "Attempting to read Backout Requeue Queue from underlying LOCAL queue " + baseQueueName, null);
                    }
                    try {
                        int options = 8224;
                        MQQueue baseMqQueue = this.mqQueueManager.accessQueue(baseQueueName, options);
                        int baseQueueType = Utils.inquireInt(baseMqQueue, 20);
                        if (baseQueueType == 7) {
                            baseMqQueue.close();
                            int options_forClusterQ = 8232;
                            baseMqQueue = this.mqQueueManager.accessQueue(baseQueueName, options_forClusterQ);
                        }
                        this.mqBORQName = Utils.inquireString(baseMqQueue, 2019);
                        baseMqQueue.close();
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "backoutRequeue(MQMessageReference)", mqe, 1);
                        }
                    }
                } else {
                    this.mqBORQName = Utils.inquireString(this.mqQueue, 2019);
                }
            }
            if (this.mqBORQName == null || this.mqBORQName.equals("")) {
                JMSException jmse = ConfigEnvironment.newException("MQJMS1080");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "backoutRequeue(MQMessageReference)", jmse, 1);
                }
                throw jmse;
            }
            this.mqBORQName = this.mqBORQName.trim();
            if (Trace.isOn) {
                Trace.traceData(this, "BORQ = <" + this.mqBORQName + ">", null);
            }
            try {
                MQMessage msg = this.retrieveMessage(msgRef);
                this.puttingToBORQ = true;
                this.put1WithContext(msg, this.mqBORQName, null);
                this.puttingToBORQ = false;
                this.mqQueueManager.commit();
            }
            catch (MQException mqe) {
                block29: {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "backoutRequeue(MQMessageReference)", mqe, 2);
                    }
                    if (mqe.reasonCode == 2033) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "ProviderMessage to requeue has disappeared! Continue as normal", null);
                        }
                        if (Trace.isOn) {
                            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "backoutRequeue(MQMessageReference)", 1);
                        }
                        return;
                    }
                    try {
                        this.mqQueueManager.backout();
                    }
                    catch (MQException mqe2) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "backoutRequeue(MQMessageReference)", mqe2, 3);
                        }
                        if (!Trace.isOn) break block29;
                        Trace.traceData(this, "WARNING: backout after failed requeue failed!", null);
                    }
                }
                JMSException jmse = ConfigEnvironment.newException("MQJMS1081");
                jmse.setLinkedException((Exception)((Object)mqe));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "backoutRequeue(MQMessageReference)", jmse, 2);
                }
                throw jmse;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "backoutRequeue(MQMessageReference)", je, 4);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "backoutRequeue(MQMessageReference)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "backoutRequeue(MQMessageReference)", 2);
        }
    }

    private void discard(MQMessageReference msgRef, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)", new Object[]{msgRef, new Integer(reason)});
        }
        MQMessage discardMessage = null;
        MQMessage reportMessage = null;
        try {
            discardMessage = this.retrieveMessage(msgRef);
            if ((discardMessage.report & 0x7000000) != 0) {
                reportMessage = this.generateReport(discardMessage, reason);
                String replyQ = discardMessage.replyToQueueName.trim();
                String replyQMgr = discardMessage.replyToQueueManagerName.trim();
                try {
                    this.put1WithContext(reportMessage, replyQ, replyQMgr);
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)", mqe, 1);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Could not put report message to replyToQ", null);
                        Trace.traceData(this, "Attempting to put to DLQ instead", null);
                    }
                    String mqDLQName = Utils.inquireString(this.mqQueueManager, 2006);
                    if (Trace.isOn) {
                        Trace.traceData(this, "DLQ = <" + mqDLQName + ">", null);
                    }
                    if (mqDLQName == null || mqDLQName.length() == 0) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to find DLQ name - is one defined?", null);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS1079");
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)", je, 1);
                        }
                        throw je;
                    }
                    DLH dlh = new DLH();
                    dlh.reason = mqe.reasonCode;
                    dlh.destQName = replyQ;
                    dlh.destQMgrName = replyQMgr;
                    dlh.putApplType = 28;
                    dlh.putApplName = "MQ JMS ConnectionConsumer";
                    GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    dlh.putDate = Utils.getDate(gc);
                    dlh.putTime = Utils.getTime(gc);
                    dlh.write(reportMessage);
                    this.put1WithContext(reportMessage, mqDLQName, null);
                }
            }
        }
        catch (MQException mqe) {
            block33: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)", mqe, 2);
                }
                if (mqe.reasonCode == 2033) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage to discard has disappeared! Continue as normal", null);
                    }
                }
                if (discardMessage != null && discardMessage.persistence == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Could not send report message, but message is non-persistent - so subsume the error", null);
                    }
                }
                try {
                    this.mqQueueManager.backout();
                }
                catch (MQException mqe2) {
                    if (!Trace.isOn) break block33;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)", mqe2, 3);
                }
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1082");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)", je, 2);
            }
            throw je;
        }
        catch (JMSException je) {
            block34: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)", je, 4);
                }
                if (discardMessage != null && discardMessage.persistence == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage is non-persistent so ignoring error", null);
                    }
                }
                try {
                    this.mqQueueManager.backout();
                }
                catch (MQException mqe) {
                    if (!Trace.isOn) break block34;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)", mqe, 5);
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)", je, 3);
            }
            throw je;
        }
        try {
            this.mqQueueManager.commit();
            if (reason == 2364) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_MESSAGE_ID", Utils.bytesToHex(discardMessage.messageId));
                inserts.put("XMSC_INSERT_DESTINATION_NAME", this.qName);
                inserts.put("XMSC_INSERT_QUEUE_MANAGER_NAME", this.mqQueueManager.name);
                Log.log(this, "discard()", "MQJMS1117", inserts);
            }
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)", mqe, 6);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1082");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "discard(MQMessageReference,int)");
        }
    }

    private MQMessage generateReport(MQMessage msg, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "generateReport(MQMessage,int)", new Object[]{msg, new Integer(reason)});
        }
        MQMessage out = new MQMessage();
        out.report = 0;
        out.messageType = 4;
        out.expiry = -1;
        out.feedback = reason;
        out.encoding = msg.encoding;
        out.characterSet = msg.characterSet;
        out.format = msg.format;
        out.priority = msg.priority;
        out.persistence = msg.persistence;
        if ((msg.report & 0x80) == 128) {
            out.messageId = msg.messageId;
        }
        out.correlationId = (msg.report & 0x40) == 64 ? msg.correlationId : msg.messageId;
        out.backoutCount = 0;
        out.replyToQueueName = "";
        out.replyToQueueManagerName = this.qmgrName;
        out.putApplicationType = 28;
        out.putApplicationName = "MQ JMS ConnectionConsumer";
        try {
            if ((msg.report & 0x7000000) == 0x7000000) {
                byte[] buffer = new byte[msg.getMessageLength()];
                msg.seek(0);
                msg.readFully(buffer);
                out.write(buffer);
            } else if ((msg.report & 0x3000000) == 0x3000000) {
                msg.seek(0);
                int bytesread = 0;
                String format = msg.format;
                int origCharacterSet = msg.characterSet;
                int origEncoding = msg.encoding;
                boolean done = false;
                int length = 0;
                int nextEncoding = 0;
                int nextCharacterSet = 0;
                String nextFormat = null;
                while (!done) {
                    try {
                        if (format.startsWith("MQH")) {
                            msg.skipBytes(8);
                            length = msg.readInt();
                            nextEncoding = msg.readInt();
                            nextCharacterSet = msg.readInt();
                            nextFormat = msg.readStringOfByteLength(8);
                            msg.skipBytes(length - 28);
                        } else if (format.equals("MQDEAD  ")) {
                            length = 172;
                            msg.skipBytes(108);
                            nextEncoding = msg.readInt();
                            nextCharacterSet = msg.readInt();
                            nextFormat = msg.readStringOfByteLength(8);
                            msg.skipBytes(48);
                        } else if (format.equals("MQXMIT  ")) {
                            length = 428;
                            msg.skipBytes(128);
                            nextEncoding = msg.readInt();
                            nextCharacterSet = msg.readInt();
                            nextFormat = msg.readStringOfByteLength(8);
                            msg.skipBytes(284);
                        } else if (format.equals("MQCICS  ")) {
                            msg.skipBytes(8);
                            length = msg.readInt();
                            msg.skipBytes(8);
                            nextFormat = msg.readStringOfByteLength(8);
                            nextEncoding = msg.encoding;
                            nextCharacterSet = msg.characterSet;
                            msg.skipBytes(length - 36);
                        } else {
                            done = true;
                        }
                        if (done) continue;
                        bytesread += length;
                        format = nextFormat;
                        msg.encoding = nextEncoding;
                        msg.characterSet = nextCharacterSet;
                    }
                    catch (IOException ioe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "generateReport(MQMessage,int)", ioe, 1);
                        }
                        done = true;
                    }
                }
                msg.encoding = origEncoding;
                msg.characterSet = origCharacterSet;
                msg.seek(0);
                byte[] buffer = new byte[Math.min(bytesread + 100, msg.getMessageLength())];
                msg.readFully(buffer);
                out.write(buffer);
            }
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "generateReport(MQMessage,int)", ioe, 2);
            }
            JMSException jmse = ConfigEnvironment.newException("MQJMS1016");
            jmse.setLinkedException((Exception)ioe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "generateReport(MQMessage,int)", jmse);
            }
            throw jmse;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "generateReport(MQMessage,int)", (Object)out);
        }
        return out;
    }

    private MQMessage retrieveMessage(MQMessageReference msgRef) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "retrieveMessage(MQMessageReference)", new Object[]{msgRef});
        }
        MQMessage message = new MQMessage();
        message.messageId = msgRef.getMessageId();
        MQGetMessageOptions gmo = new MQGetMessageOptions();
        gmo.options = 2;
        if (msgRef.checkIfOptionalFieldIsPresent((byte)1)) {
            System.arraycopy(msgRef.getMsgToken(), 0, gmo.msgToken, 0, 16);
            gmo.matchOptions = 32;
        } else {
            gmo.matchOptions = 1;
        }
        this.mqQueue.get(message, gmo);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "retrieveMessage(MQMessageReference)", (Object)message);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put1WithContext(MQMessage msg, String qName, String qmgrName) throws MQException {
        MQQueue destQ;
        block13: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "put1WithContext(MQMessage,String,String)", new Object[]{msg, qName, qmgrName});
            }
            destQ = null;
            try {
                int openOptions = 8720;
                destQ = this.mqQueueManager.accessQueue(qName, openOptions, qmgrName, null, null);
                MQPutMessageOptions pmo = new MQPutMessageOptions();
                pmo.options = 514;
                pmo.contextReference = this.mqQueue;
                destQ.put(msg, pmo);
                Object var8_7 = null;
                if (!Trace.isOn) break block13;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var8_8 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "put1WithContext(MQMessage,String,String)");
                    }
                    if (destQ != null && destQ.isOpen()) {
                        try {
                            destQ.close();
                        }
                        catch (MQException mqe) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "put1WithContext(MQMessage,String,String)", mqe);
                            }
                            if (!Trace.isOn) break block14;
                            Trace.traceData(this, "Could not close destination queue. Carrying on regardless.", null);
                        }
                    }
                }
                throw throwable;
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "put1WithContext(MQMessage,String,String)");
        }
        if (destQ != null && destQ.isOpen()) {
            try {
                destQ.close();
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "put1WithContext(MQMessage,String,String)", mqe);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Could not close destination queue. Carrying on regardless.", null);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "put1WithContext(MQMessage,String,String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block85: {
            block81: {
                block80: {
                    if (Trace.isOn) {
                        Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()");
                    }
                    this.queueAgentThreadThread = Thread.currentThread();
                    try {
                        this.setup();
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", je, 1);
                        }
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", je);
                        }
                        throw je;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "setup() returned", null);
                    }
                    int waitTime = 5000;
                    MQQueueAgentThread mQQueueAgentThread = this;
                    synchronized (mQQueueAgentThread) {
                        this.active = true;
                        if (Trace.isOn) {
                            Trace.traceData(this, "Notifying waiting thread", null);
                        }
                        this.notifyAll();
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Waiting thread notified", null);
                        Trace.traceData(this, "quit flag is " + (this.quit ? "true" : "false"), null);
                    }
                    while (!this.quit) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Starting to browse message", null);
                        }
                        this.newCount = 0;
                        this.oldCount = 0;
                        this.failedCount = 0;
                        if (this.mqQueueAgent.configChangePending() && this.updateConfig()) {
                            this.mqQueueAgent.performConfigChange();
                        }
                        MQMessageReference messageRef = null;
                        try {
                            messageRef = this.browse(this.mqQueueAgent.getRequiredDataQuantity(), waitTime);
                            if (messageRef != null) {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Got message to process", null);
                                }
                                this.processMessage(messageRef);
                                this.lastException = null;
                                continue;
                            }
                            if (!Trace.isOn) continue;
                            Trace.traceData(this, "No message received", null);
                        }
                        catch (JMSException jmsException) {
                            Exception linkedException;
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", jmsException, 6);
                            }
                            if ((linkedException = jmsException.getLinkedException()) instanceof MQException && Reason.isConnectionBroken(((MQException)((Object)linkedException)).getReason())) {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Connection Broken exception", null);
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", jmsException, 2);
                                }
                                throw jmsException;
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "Not a Connection Broken exception", null);
                            }
                            if (this.lastException == null || !this.isSameException(this.lastException, jmsException)) {
                                this.lastException = jmsException;
                                this.mqQueueAgent.deliverException(jmsException);
                            }
                            if (!this.shouldThreadSleep(linkedException)) continue;
                            try {
                                long sleeptime = PropertyStore.getLongPropertyObject(QUEUEAGENTTHREAD_SLEEPTIME);
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Sleeping for " + sleeptime + " ms, before executing browse", null);
                                }
                                Thread.sleep(sleeptime);
                            }
                            catch (InterruptedException ie) {
                                if (!Trace.isOn) continue;
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", ie, 7);
                            }
                        }
                    }
                    Object var8_12 = null;
                    if (!Trace.isOn) break block80;
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()");
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "QueueAgent about to stop; start consumers", null);
                }
                this.mqQueueAgent.startBrowsers();
                if (Trace.isOn) {
                    Trace.traceData(this, "new message count    : " + this.newCount, null);
                    Trace.traceData(this, "old message count    : " + this.oldCount, null);
                    Trace.traceData(this, "failed message count : " + this.failedCount, null);
                }
                try {
                    this.shutdown();
                }
                catch (JMSException je2) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", je2, 4);
                    }
                    if (this.exception == null) {
                        this.exception = je2;
                    }
                }
                catch (Exception e2) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", e2, 5);
                    }
                    if (this.exception != null) break block81;
                    this.exception = ConfigEnvironment.newException("MQJMS1016");
                    this.exception.setLinkedException(e2);
                }
            }
            MQQueueAgentThread mQQueueAgentThread = this;
            synchronized (mQQueueAgentThread) {
                this.active = false;
                this.notifyAll();
            }
            if (this.exception != null) {
                this.mqQueueAgent.deliverException(this.exception);
            }
            break block85;
            {
                catch (JMSException je) {
                    block83: {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", je, 2);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Fatal error duing run() - leaving exception for another thread to pick up", null);
                        }
                        this.exception = je;
                        Object var8_13 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()");
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "QueueAgent about to stop; start consumers", null);
                        }
                        this.mqQueueAgent.startBrowsers();
                        if (Trace.isOn) {
                            Trace.traceData(this, "new message count    : " + this.newCount, null);
                            Trace.traceData(this, "old message count    : " + this.oldCount, null);
                            Trace.traceData(this, "failed message count : " + this.failedCount, null);
                        }
                        try {
                            this.shutdown();
                        }
                        catch (JMSException je2) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", je2, 4);
                            }
                            if (this.exception == null) {
                                this.exception = je2;
                            }
                        }
                        catch (Exception e2) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", e2, 5);
                            }
                            if (this.exception != null) break block83;
                            this.exception = ConfigEnvironment.newException("MQJMS1016");
                            this.exception.setLinkedException(e2);
                        }
                    }
                    MQQueueAgentThread mQQueueAgentThread2 = this;
                    synchronized (mQQueueAgentThread2) {
                        this.active = false;
                        this.notifyAll();
                    }
                    if (this.exception != null) {
                        this.mqQueueAgent.deliverException(this.exception);
                    }
                    break block85;
                }
                catch (Exception e) {
                    block86: {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", e, 3);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS1016");
                        je.setLinkedException(e);
                        this.exception = je;
                        Object var8_14 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()");
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "QueueAgent about to stop; start consumers", null);
                        }
                        this.mqQueueAgent.startBrowsers();
                        if (Trace.isOn) {
                            Trace.traceData(this, "new message count    : " + this.newCount, null);
                            Trace.traceData(this, "old message count    : " + this.oldCount, null);
                            Trace.traceData(this, "failed message count : " + this.failedCount, null);
                        }
                        try {
                            this.shutdown();
                        }
                        catch (JMSException je2) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", je2, 4);
                            }
                            if (this.exception == null) {
                                this.exception = je2;
                            }
                        }
                        catch (Exception e2) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", e2, 5);
                            }
                            if (this.exception != null) break block86;
                            this.exception = ConfigEnvironment.newException("MQJMS1016");
                            this.exception.setLinkedException(e2);
                        }
                    }
                    MQQueueAgentThread mQQueueAgentThread3 = this;
                    synchronized (mQQueueAgentThread3) {
                        this.active = false;
                        this.notifyAll();
                    }
                    if (this.exception != null) {
                        this.mqQueueAgent.deliverException(this.exception);
                    }
                }
            }
            catch (Throwable throwable) {
                block88: {
                    Object var8_15 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()");
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "QueueAgent about to stop; start consumers", null);
                    }
                    this.mqQueueAgent.startBrowsers();
                    if (Trace.isOn) {
                        Trace.traceData(this, "new message count    : " + this.newCount, null);
                        Trace.traceData(this, "old message count    : " + this.oldCount, null);
                        Trace.traceData(this, "failed message count : " + this.failedCount, null);
                    }
                    try {
                        this.shutdown();
                    }
                    catch (JMSException je2) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", je2, 4);
                        }
                        if (this.exception == null) {
                            this.exception = je2;
                        }
                    }
                    catch (Exception e2) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()", e2, 5);
                        }
                        if (this.exception != null) break block88;
                        this.exception = ConfigEnvironment.newException("MQJMS1016");
                        this.exception.setLinkedException(e2);
                    }
                }
                MQQueueAgentThread mQQueueAgentThread4 = this;
                synchronized (mQQueueAgentThread4) {
                    this.active = false;
                    this.notifyAll();
                }
                if (this.exception != null) {
                    this.mqQueueAgent.deliverException(this.exception);
                }
                throw throwable;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "run()");
        }
    }

    public void setFullMessages(boolean newVal) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "setFullMessages(boolean)", "setter", newVal);
        }
        this.fullMessages = newVal;
    }

    public boolean getFullMessages() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "getFullMessages()", "getter", this.fullMessages);
        }
        return this.fullMessages;
    }

    protected void deliverNow() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deliverNow()");
        }
        if (this.messagesToDeliver) {
            this.mqQueueAgent.startBrowsers();
            this.messagesToDeliver = false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "deliverNow()");
        }
    }

    private boolean isSameException(JMSException oldException, JMSException newException) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "isSameException()", new Object[]{oldException, newException});
        }
        boolean isSameException = false;
        Exception oldLinkedException = oldException.getLinkedException();
        Exception newLinkedException = newException.getLinkedException();
        if (oldLinkedException != null && newLinkedException != null) {
            if (oldLinkedException instanceof MQException && newLinkedException instanceof MQException) {
                if (Trace.isOn) {
                    Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "isSameException()", (Object)"Checking if MQExceptions reason codes are equal");
                }
                if (((MQException)((Object)oldLinkedException)).getReason() == ((MQException)((Object)newLinkedException)).getReason()) {
                    isSameException = true;
                }
            } else {
                if (Trace.isOn) {
                    Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "isSameException()", (Object)"Checking if LinkedExceptions messages are equal");
                }
                if (oldLinkedException.getMessage() != null && oldLinkedException.getMessage().equals(newLinkedException.getMessage())) {
                    isSameException = true;
                }
            }
        } else if (oldLinkedException == null && newLinkedException == null) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "isSameException()", (Object)"No LinkedException, checking JMSException message are equal");
            }
            if (oldException.getMessage() != null && oldException.getMessage().equals(newException.getMessage())) {
                isSameException = true;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "isSameException()", new Object[]{isSameException});
        }
        return isSameException;
    }

    private boolean shouldThreadSleep(Exception exception) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "shouldThreadSleep()", new Object[]{exception});
        }
        boolean shouldSleep = false;
        if (exception instanceof MQException) {
            int reason = ((MQException)((Object)exception)).getReason();
            switch (reason) {
                case 2016: {
                    shouldSleep = true;
                    break;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "shouldThreadSleep()", new Object[]{shouldSleep});
        }
        return shouldSleep;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread", "static", "SCCS id", (Object)sccsid);
        }
    }
}

