/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.disthub2.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthub2.impl.matching.FormattedMessage;
import com.ibm.disthub2.impl.matching.InvalidTopicSyntaxException;
import com.ibm.disthub2.impl.matching.MatchSpace;
import com.ibm.disthub2.impl.matching.MatchTarget;
import com.ibm.disthub2.impl.matching.MatchingContext;
import com.ibm.disthub2.impl.matching.MatchingException;
import com.ibm.disthub2.impl.matching.QuerySyntaxException;
import com.ibm.disthub2.impl.matching.selector.EvalContext;
import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread1Impl;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgentThread2Impl;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.SearchResults;
import com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;

class MQQueueAgent {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueAgent.java, jmscc.wmq.v6, k701, k701-112-140304 1.30.1.6 11/05/19 15:40:32";
    private String mqQmgrName;
    private String mqQueueName;
    static final int DOMAIN_PTP = 0;
    static final int DOMAIN_PS = 1;
    private int domainFlag;
    static final int DELIVERED = 0;
    static final int NOT_DELIVERED = 1;
    static final int MSG_SELECTOR_FAILED = 2;
    static final int NO_CONSUMER = 3;
    Vector browsers = new Vector();
    private boolean allBrowsersReceiving = true;
    private int activeCount = 0;
    private MQQueueAgentThread thread = null;
    private static final int QAT_STOPPED = 0;
    private static final int QAT_STARTED = 1;
    private static final int QAT_STOPPING = 2;
    private int threadStatus = 0;
    private Object threadLock = new Object();
    static final int defWaitTime = 5000;
    long sweepInterval = 30000L;
    private boolean useCorrelId = true;
    static final String EXCLUSIVE_SUB_KEY = "XXX-Exclusive-Subscriber-Key-XXX";
    boolean retainAllMessages = false;
    private int version;
    private Hashtable pubSubBrowserLookup = new Hashtable();
    private static final int MQQUEUE_AGENT_V1 = 1;
    private static final int MQQUEUE_AGENT_V2 = 2;
    int useSelectors = 0;
    int needData = 0;
    int quantityRequired = 0;
    private MatchSpace matchSpace;
    private WMQDestination providerDestination;
    static final String PTPTOPIC;

    /*
     * WARNING - void declaration
     */
    static MQQueueAgent getQueueAgent(MQConnection connection, WMQDestination dest, String queueName, boolean correlIdAsIdentity) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getQueueAgent(MQConnection,WMQDestination,String,boolean)", new Object[]{connection, dest, queueName, correlIdAsIdentity});
        }
        MQQueueAgent result = null;
        try {
            void var5_5;
            boolean domain;
            if (dest.isQueue()) {
                domain = false;
            } else if (dest.isTopic()) {
                domain = true;
            } else {
                JMSException traceRet1 = ConfigEnvironment.newException("MQJMS1088");
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getQueueAgent(MQConnection,WMQDestination,String,boolean)", traceRet1, 1);
                }
                throw traceRet1;
            }
            MQSession sess = (MQSession)connection.createSessionInternal(true, 0, 0);
            String qmName = MQQueueAgent.resolveQmgrName(sess);
            String qmID = MQQueueAgent.resolveQmgrID(sess, qmName);
            String qName = MQQueueAgent.resolveQueue(sess, queueName);
            String providerConnUID = Integer.toHexString(System.identityHashCode(connection));
            String agentId = qmID + "/" + qName + "/" + providerConnUID;
            sess.close(false);
            if (Trace.isOn) {
                Trace.traceData("MQQueueAgent", "QueueAgent ID is " + agentId, null);
                Trace.traceData("MQQueueAgent", "Not using queue agent hashtable", null);
            }
            result = new MQQueueAgent(qmName, queueName, agentId, (int)var5_5, correlIdAsIdentity);
            result.setProviderDestination(dest);
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getQueueAgent(MQConnection,WMQDestination,String,boolean)", result);
            }
            return result;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getQueueAgent(MQConnection,WMQDestination,String,boolean)", je);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getQueueAgent(MQConnection,WMQDestination,String,boolean)", je, 3);
            }
            throw je;
        }
    }

    private void setProviderDestination(WMQDestination dest) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "setProviderDestination(WMQDestination)", "setter", dest);
        }
        this.providerDestination = dest;
    }

    public WMQDestination getProviderDestination() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getProviderDestination()", "getter", this.providerDestination);
        }
        return this.providerDestination;
    }

    private MQQueueAgent(String qMgrName, String queueName, String agentId, int domain, boolean correlIdAsIdentity) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "<init>(String,String,String,int,boolean)", new Object[]{qMgrName, queueName, agentId, new Integer(domain), correlIdAsIdentity});
        }
        this.mqQmgrName = qMgrName;
        this.mqQueueName = queueName;
        this.domainFlag = domain;
        this.useCorrelId = correlIdAsIdentity;
        this.version = 1;
        this.matchSpace = new MatchSpace();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "<init>(String,String,String,int,boolean)");
        }
    }

    private static String resolveQmgrName(MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQmgrName(MQSession)", new Object[]{session});
        }
        try {
            if (!(session instanceof MQSession)) {
                JMSException e = ConfigEnvironment.newException("MQJMS1069");
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQmgrName(MQSession)", e, 1);
                }
                throw e;
            }
            MQQueueManager qmgr = session.getQM();
            String qmName = Utils.inquireString(qmgr, 2015);
            if (qmName == null) {
                JMSException e = ConfigEnvironment.newException("MQJMS1072");
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQmgrName(MQSession)", e, 2);
                }
                throw e;
            }
            if (Trace.isOn) {
                Trace.traceData("MQQueueAgent", "Fully resolved Qmgr Name is " + qmName, null);
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQmgrName(MQSession)", (Object)qmName);
            }
            return qmName;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQmgrName(MQSession)", je);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQmgrName(MQSession)", je, 3);
            }
            throw je;
        }
    }

    private static String resolveQmgrID(MQSession session, String qmName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQmgrID(MQSession,String)", new Object[]{session, qmName});
        }
        if (Trace.isOn) {
            Trace.entry("MQQueueAgent", "resolveQmgrID");
        }
        try {
            if (!(session instanceof MQSession)) {
                JMSException e = ConfigEnvironment.newException("MQJMS1069");
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQmgrID(MQSession,String)", e);
                }
                throw e;
            }
            MQQueueManager qmgr = session.getQM();
            String qmID = Utils.inquireString(qmgr, 2032);
            if (qmID == null) {
                if (Trace.isOn) {
                    Trace.traceData("MQQueueAgent", "Inquire failed - falling back to qmgr name", null);
                }
                qmID = qmName;
            }
            if (Trace.isOn) {
                Trace.traceData("MQQueueAgent", "Qmgr ID " + qmID, null);
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQmgrID(MQSession,String)", (Object)qmID, 1);
            }
            return qmID;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQmgrID(MQSession,String)", je);
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQmgrID(MQSession,String)", (Object)qmName, 2);
            }
            return qmName;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String resolveQueue(MQSession session, String queueName) throws JMSException {
        block43: {
            block42: {
                if (Trace.isOn) {
                    Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", new Object[]{session, queueName});
                }
                q = null;
                if (!(session instanceof MQSession)) {
                    e = ConfigEnvironment.newException("MQJMS1069");
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", e, 1);
                    }
                    throw e;
                }
                qmgr = session.getQM();
                try {
                    if (Trace.isOn) {
                        Trace.traceData("MQQueueAgent", "resolveQueue is opening queue", null);
                    }
                    q = qmgr.accessQueue(queueName, 8232);
                    if (Trace.isOn) {
                        Trace.traceData("MQQueueAgent", "resolveQueue opened queue OK", null);
                    }
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", mqe, 1);
                    }
                    e = ConfigEnvironment.newException("MQJMS2008", queueName);
                    e.setLinkedException((Exception)mqe);
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", e, 2);
                    }
                    throw e;
                }
                type = Utils.inquireInt(q, 20);
                switch (type) {
                    case 1: {
                        defType = Utils.inquireInt(q, 7);
                        if (defType == 1) ** GOTO lbl49
                        qName = Utils.inquireString(q, 2016);
                        if (queueName.trim().equals(qName.trim())) break;
                        q.closeOptions = 1;
                        try {
                            q.close();
                            q = null;
                        }
                        catch (MQException mqe) {
                            if (Trace.isOn) {
                                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", mqe, 2);
                            }
                            if (!Trace.isOn) ** GOTO lbl43
                            Trace.traceData("MQQueueAgent", "Warning: could not close queue on implicit close", null);
                        }
lbl43:
                        // 3 sources

                        if (Trace.isOn) {
                            Trace.traceData("MQQueueAgent", "Queue is a QMODEL", null);
                        }
                        traceRet1 = ConfigEnvironment.newException("MQJMS1073");
                        if (Trace.isOn) {
                            Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", traceRet1, 3);
                        }
                        throw traceRet1;
lbl49:
                        // 1 sources

                        if (!Trace.isOn) break;
                        Trace.traceData("MQQueueAgent", "Queue is a QLOCAL", null);
                        break;
                    }
                    case 3: {
                        if (!Trace.isOn) break;
                        Trace.traceData("MQQueueAgent", "Queue " + queueName + " is a QALIAS", null);
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.traceData("MQQueueAgent", "Unexpected response when determining Queue type: " + type, null);
                        }
                        traceRet2 = ConfigEnvironment.newException("MQJMS1073");
                        if (Trace.isOn) {
                            Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", traceRet2, 4);
                        }
                        throw traceRet2;
                    }
                }
                try {
                    if (Trace.isOn) {
                        Trace.traceData("MQQueueAgent", "resolveQueue is closing queue", null);
                    }
                    q.close();
                    q = null;
                    if (Trace.isOn) {
                        Trace.traceData("MQQueueAgent", "resolveQueue closed queue okay", null);
                    }
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", mqe, 3);
                    }
                    e = ConfigEnvironment.newException("MQJMS2000");
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", e, 5);
                    }
                    throw e;
                }
                if (Trace.isOn) {
                    Trace.traceData("MQQueueAgent", "Fully resolved Queue name is " + queueName, null);
                }
                if (Trace.isOn) {
                    Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", (Object)queueName);
                }
                var5_11 = queueName;
                var9_16 = null;
                if (!Trace.isOn) break block42;
                Trace.finallyBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)");
            }
            try {
                if (q != null) {
                    q.close();
                }
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", mqe, 5);
                }
                if (!Trace.isOn) break block43;
                Trace.traceData("MQQueueAgent", "Warning: could not close queue on implicit close", null);
            }
        }
        return var5_11;
        catch (JMSException jmse) {
            try {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", jmse, 4);
                }
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", jmse, 6);
                }
                throw jmse;
            }
            catch (Throwable var8_20) {
                block44: {
                    var9_17 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)");
                    }
                    try {
                        if (q != null) {
                            q.close();
                        }
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "resolveQueue(MQSession,String)", mqe, 5);
                        }
                        if (!Trace.isOn) break block44;
                        Trace.traceData("MQQueueAgent", "Warning: could not close queue on implicit close", null);
                    }
                }
                throw var8_20;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(MQConnection conn) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "activate(MQConnection)", new Object[]{conn});
        }
        Object object = this.threadLock;
        synchronized (object) {
            while (this.threadStatus == 2) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Thread stopping...", null);
                }
                try {
                    this.threadLock.wait();
                }
                catch (InterruptedException ie) {
                    if (!Trace.isOn) continue;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "activate(MQConnection)", ie);
                }
            }
            ++this.activeCount;
            if (this.threadStatus == 0) {
                if (null == conn && Trace.isOn) {
                    Trace.traceData(this, "connection is null!", null);
                }
                if (conn != null && conn.getSupportsQAT2()) {
                    this.version = 2;
                }
                String qatVersionProperty = "com.ibm.mq.jms.tuning.QATVersion";
                PropertyStore.register(qatVersionProperty, "");
                String qatVersion = PropertyStore.getStringProperty(qatVersionProperty);
                if (qatVersion != null && (qatVersion.equals("1") || qatVersion.equals("2"))) {
                    this.version = new Integer(qatVersion);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Creating MQQueueAgentThread, version " + this.version, null);
                }
                switch (this.version) {
                    case 1: {
                        this.thread = new MQQueueAgentThread1Impl(this, conn, this.mqQmgrName, this.mqQueueName);
                        break;
                    }
                    case 2: {
                        this.thread = new MQQueueAgentThread2Impl(this, conn, this.mqQmgrName, this.mqQueueName);
                        break;
                    }
                    default: {
                        JMSException traceRet2 = ConfigEnvironment.newException("MQJMS1099");
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "activate(MQConnection)", traceRet2);
                        }
                        throw traceRet2;
                    }
                }
                this.threadStatus = 1;
                if (this.retainAllMessages) {
                    this.thread.retainAllMessages();
                }
                this.thread.go();
            } else if (this.retainAllMessages) {
                this.thread.retainAllMessages();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "activate(MQConnection)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "deactivate()");
        }
        Object object = this.threadLock;
        synchronized (object) {
            --this.activeCount;
            if (this.activeCount == 0) {
                this.thread.quit();
                this.threadStatus = 2;
                this.retainAllMessages = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "deactivate()");
        }
    }

    protected boolean configChangePending() {
        boolean traceRet1;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "configChangePending()");
        }
        boolean bl = traceRet1 = !this.allBrowsersReceiving;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "configChangePending()", traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performConfigChange() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "performConfigChange()");
        }
        Vector vector = this.browsers;
        synchronized (vector) {
            if (!this.allBrowsersReceiving) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Setting all ConnectionBrowsers to receive messages", null);
                }
                Enumeration enumVar = this.browsers.elements();
                while (enumVar.hasMoreElements()) {
                    MQConnectionBrowser cb = (MQConnectionBrowser)enumVar.nextElement();
                    if (cb.receiveFlag.receiving) continue;
                    cb.receiveFlag.receiving = true;
                    if (Trace.isOn) {
                        Trace.traceData(this, "ConnectionBrowser dataQuantityHint: ", (Object)new Integer(cb.getQuantityHint()));
                    }
                    if (cb.getQuantityHint() != 0) {
                        ++this.needData;
                    }
                    if (cb.getSelectorString() != null && !cb.getSelectorString().equals("")) {
                        ++this.useSelectors;
                    }
                    if (cb.getQuantityHint() == 0 && cb.getSelectorString() != null && !cb.getSelectorString().equals("")) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "DataQuantityHint and selector mismatch. Forcing use of FULL_DATA", null);
                        }
                        this.quantityRequired = 2;
                        continue;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Using dataQuantityHint as specified. dq: " + cb.getQuantityHint(), null);
                    }
                    this.quantityRequired = cb.getQuantityHint();
                }
                this.allBrowsersReceiving = true;
                this.thread.redeliverUnwanted();
            }
        }
        if (Trace.isOn) {
            Trace.traceData(this, "needData = " + this.needData + " useSelectors = " + this.useSelectors, null);
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "performConfigChange()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverException(JMSException je) {
        MQConnection[] connections;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "deliverException(JMSException)", new Object[]{je});
        }
        int num = 0;
        Vector vector = this.browsers;
        synchronized (vector) {
            connections = new MQConnection[this.browsers.size()];
            Enumeration enumVar = this.browsers.elements();
            while (enumVar.hasMoreElements()) {
                MQConnectionBrowser browser = (MQConnectionBrowser)enumVar.nextElement();
                MQConnection conn = browser.getConnection();
                boolean found = false;
                for (int i = 0; i < num && !found; ++i) {
                    if (connections[i] != conn) continue;
                    found = true;
                }
                if (found) continue;
                connections[num] = conn;
                ++num;
            }
        }
        if (Trace.isOn) {
            Trace.traceData(this, num + " unique Connections using QueueAgent", null);
        }
        for (int i = 0; i < num; ++i) {
            connections[i].deliverException(je);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "deliverException(JMSException)");
        }
    }

    protected int getDomain() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getDomain()", "getter", new Integer(this.domainFlag));
        }
        return this.domainFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBrowser(MQConnectionBrowser browser, boolean retain) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "addBrowser(MQConnectionBrowser,boolean)", new Object[]{browser, retain});
        }
        Vector vector = this.browsers;
        synchronized (vector) {
            if (!this.browsers.contains(browser)) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Adding browser to Vector", null);
                }
                this.browsers.addElement(browser);
                if (this.domainFlag == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "This is a Point-to-Point agent", null);
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Adding Browser to MatchSpace", null);
                            Trace.traceData(this, "Browser = \n" + browser.toString(), null);
                        }
                        if (null != browser.getSelectorString()) {
                            this.matchSpace.put(PTPTOPIC, browser.getSelectorString(), (MatchTarget)browser, null, null);
                        }
                    }
                    catch (MatchingException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "addBrowser(MQConnectionBrowser,boolean)", e, 1);
                        }
                        if (Trace.isOn) {
                            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "addBrowser(MQConnectionBrowser,boolean)", 1);
                        }
                        return;
                    }
                    catch (InvalidTopicSyntaxException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "addBrowser(MQConnectionBrowser,boolean)", e, 2);
                        }
                        if (Trace.isOn) {
                            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "addBrowser(MQConnectionBrowser,boolean)", 2);
                        }
                        return;
                    }
                    catch (QuerySyntaxException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "addBrowser(MQConnectionBrowser,boolean)", e, 3);
                        }
                        if (Trace.isOn) {
                            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "addBrowser(MQConnectionBrowser,boolean)", 3);
                        }
                        return;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Browser added to MatchSpace.", null);
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "This is a PubSub QueueAgent", null);
                    }
                    if (this.useCorrelId) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Browser is Pub/Sub, and uses correlIdAsIdentity, so storing its correlId in lookup table", null);
                            Trace.traceData(this, "correlId = '" + Utils.bytesToHex(browser.getCorrelId()) + "'", null);
                        }
                        this.pubSubBrowserLookup.put(Utils.bytesToHex(browser.getCorrelId()), browser);
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Browser is Pub/Sub, but does NOT use correlIdAsIdentity. correlId storage not required", null);
                        }
                        this.pubSubBrowserLookup.put(EXCLUSIVE_SUB_KEY, browser);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Adding browser with selector: " + browser.getSelectorString(), null);
                    }
                }
                browser.receiveFlag.receiving = false;
                this.allBrowsersReceiving = false;
                if (retain) {
                    this.retainAllMessages = true;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "addBrowser(MQConnectionBrowser,boolean)", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBrowser(MQConnectionBrowser browser) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "removeBrowser(MQConnectionBrowser)", new Object[]{browser});
        }
        Object object = this.threadLock;
        synchronized (object) {
            if (this.threadStatus == 2) {
                this.thread.waitForEnd();
                this.threadStatus = 0;
                this.thread = null;
                this.threadLock.notifyAll();
            }
        }
        object = this.browsers;
        synchronized (object) {
            boolean removed;
            block21: {
                removed = this.browsers.removeElement(browser);
                if (Trace.isOn) {
                    Trace.traceData(this, "browser " + (removed ? "removed from " : "not found in ") + " Vector.", null);
                }
                if (browser.isPubSub()) {
                    if (this.useCorrelId) {
                        this.pubSubBrowserLookup.remove(Utils.bytesToHex(browser.getCorrelId()));
                    } else {
                        this.pubSubBrowserLookup.remove(EXCLUSIVE_SUB_KEY);
                    }
                } else {
                    try {
                        this.matchSpace.remove((MatchTarget)browser);
                    }
                    catch (Exception e) {
                        if (!Trace.isOn) break block21;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "removeBrowser(MQConnectionBrowser)", e);
                    }
                }
            }
            if (browser.receiveFlag.receiving && removed) {
                if (browser.getQuantityHint() != 0 && this.needData > 0) {
                    --this.needData;
                }
                if (browser.getSelectorString() != null && !browser.getSelectorString().equals("") && this.useSelectors > 0) {
                    --this.useSelectors;
                }
                if (this.needData == 0 && this.useSelectors == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "needData and useSelectors are zero. Using MR.NO_DATA", null);
                    }
                    this.quantityRequired = 0;
                }
            }
        }
        if (Trace.isOn) {
            Trace.traceData(this, "needData=" + this.needData + " useSelectors=" + this.useSelectors, null);
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "removeBrowser(MQConnectionBrowser)");
        }
    }

    protected void startBrowsers() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "startBrowsers()");
        }
        Enumeration enumVar = this.browsers.elements();
        while (enumVar.hasMoreElements()) {
            MQConnectionBrowser browser = (MQConnectionBrowser)enumVar.nextElement();
            if (browser.getException() != null) continue;
            browser.endDeliver();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "startBrowsers()");
        }
    }

    protected void getMatches(String topic, MQMessageReference msg, SearchResults result) throws MatchingException, BadMessageFormatMatchingException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getMatches(String,MQMessageReference,SearchResults)", new Object[]{topic, msg, result});
        }
        ProviderMessage msgJMS = msg.getMessage();
        MQJMSMessage msgMQSeries = msg.getMQJMSMessage();
        SelectorDataAccessor fMessage = new SelectorDataAccessor(msgJMS, msgMQSeries);
        MatchingContext eContext = new MatchingContext();
        eContext.setMessage((FormattedMessage)fMessage);
        this.matchSpace.get(topic, (EvalContext)eContext, (com.ibm.disthub2.impl.matching.SearchResults)result);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getMatches(String,MQMessageReference,SearchResults)");
        }
    }

    protected Vector getBrowsers() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getBrowsers()", "getter", this.browsers);
        }
        return this.browsers;
    }

    protected Hashtable getPubSubBrowserLookup() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getPubSubBrowserLookup()", "getter", this.pubSubBrowserLookup);
        }
        return this.pubSubBrowserLookup;
    }

    protected boolean getUseCorrelId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getUseCorrelId()", "getter", this.useCorrelId);
        }
        return this.useCorrelId;
    }

    protected int getRequiredDataQuantity() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "getRequiredDataQuantity()", "getter", new Integer(this.quantityRequired));
        }
        return this.quantityRequired;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQQueueAgent.java, jmscc.wmq.v6, k701, k701-112-140304  1.30.1.6 11/05/19 15:40:32");
        }
        PTPTOPIC = new String("PtPTopic");
    }
}

