/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQC;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.jms.internal.BrokerConnectionInfo;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public class MQPubSubServices {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQPubSubServices.java, jmscc.wmq.v6, k701, k701-112-140304 1.20.1.2 10/11/18 13:29:07";
    protected byte[] sessionName;
    private static final int DEFAULT_BROKER_TIMEOUT = 120000;
    private static final int MIN_CLEANUP_TIME = 59000;
    static final int REGISTER_PUBLISHER = 0;
    static final int DEREGISTER_PUBLISHER = 1;
    static final int REGISTER_SUBSCRIBER = 2;
    static final int DEREGISTER_SUBSCRIBER = 3;
    static final int REGISTER_SHAREDQ_SUBSCRIBER = 4;
    static final int DEREGISTER_SHAREDQ_SUBSCRIBER = 5;
    protected static final String REGPUB_CMD_PREFIX = "MQPSCommand RegPub MQPSTopic ";
    protected static final String DEREGPUB_CMD_PREFIX = "MQPSCommand DeregPub MQPSTopic ";
    protected static final String REGSUB_CMD_PREFIX = "MQPSCommand RegSub MQPSTopic ";
    protected static final String DEREGSUB_CMD_PREFIX = "MQPSCommand DeregSub MQPSTopic ";
    protected static final String REGSUB_CORREL_CMD_PREFIX = "MQPSCommand RegSub MQPSRegOpts CorrelAsId MQPSTopic ";
    protected static final String DEREGSUB_CORREL_CMD_PREFIX = "MQPSCommand DeregSub MQPSRegOpts CorrelAsId MQPSTopic ";
    protected static final String MQPS_STREAM_NAME_B = " MQPSStreamName ";
    protected static final String MQPS_Q_NAME_B = " MQPSQName ";
    protected static final String MQPS_REGISTRATION_OPTIONS_B = " MQPSRegOpts ";
    protected static final String MQPS_NON_PERSISTENT = "NonPers";
    protected static final String MQPS_DUPLICATES_OK = "DupsOK";
    protected BrokerConnectionInfo brk = new BrokerConnectionInfo(null, null, null);
    protected MQQueue replyQ = null;
    MQGetMessageOptions brokerReponseGmo;
    protected byte[] responseCorrelId = new byte[24];
    protected int brkOptLevel;
    protected boolean wait_for_reply = true;
    protected int brokerTimeout = 120000;
    protected int brokerVersion = 0;
    protected String nondur_subscribeQ;
    public String SUBSCRIBE_CMD_POSTFIX;
    boolean spiGetSupported = false;

    MQPubSubServices() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "<init>()");
        }
    }

    MQPubSubServices(MQConnection connection, boolean transacted, int acknowledgeMode, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "<init>(MQConnection,boolean,int,MQSession)", new Object[]{connection, transacted, new Integer(acknowledgeMode), session});
        }
        this.initialisePubSub(connection, transacted, acknowledgeMode, session);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "<init>(MQConnection,boolean,int,MQSession)");
        }
    }

    protected void initialisePubSub(MQConnection connection, boolean transacted, int acknowlesdgeMode, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "initialisePubSub(MQConnection,boolean,int,MQSession)", new Object[]{connection, transacted, new Integer(acknowlesdgeMode), session});
        }
        MQSubscriptionEngine subEngine = connection.getSubscriptionEngine();
        this.sessionName = null;
        if (subEngine instanceof MQBrokerSubscriptionEngine) {
            this.sessionName = ((MQBrokerSubscriptionEngine)subEngine).createSessionName(session);
        } else if (subEngine instanceof MQMigrateSubscriptionEngine) {
            this.sessionName = ((MQMigrateSubscriptionEngine)subEngine).createSessionName(session);
        }
        session.sessionName = this.sessionName;
        this.brk.controlQ = connection.getBrkControlQueue();
        this.brk.streamQ = connection.getBrkPubQueue();
        this.brk.qmName = connection.getBrkQueueManager();
        session.brk = this.brk;
        this.brokerVersion = connection.getBrkVersion();
        session.brkOptLevel = this.brkOptLevel = connection.getBrkOptLevel();
        session.nondur_subscribeQ = this.nondur_subscribeQ = connection.getBrkSubQueue();
        session.SUBSCRIBE_CMD_POSTFIX = this.SUBSCRIBE_CMD_POSTFIX = new String(MQPS_STREAM_NAME_B + this.brk.streamQ + MQPS_Q_NAME_B);
        session.responseInterval = connection.getPubAckInterval();
        session.checkInterval = session.responseInterval / 2;
        Integer tmp = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "run()");
                }
                try {
                    Integer traceRet1 = Integer.getInteger("com.ibm.mq.jms.tuning.brokerResponseTimeout");
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.null", "run()", traceRet1, 1);
                    }
                    return traceRet1;
                }
                catch (AccessControlException ace) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.null", "run()", ace);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.null", "run()", null, 2);
                    }
                    return null;
                }
            }
        });
        if (null != tmp && tmp > 0) {
            if (Trace.isOn) {
                Trace.traceData(this, "Setting brokerResponseTimeout from System property = " + tmp, null);
            }
            this.brokerTimeout = tmp;
        } else {
            if (Trace.isOn) {
                Trace.traceData(this, "cannot read brokerResponseTimeout System property. Using default = 120000", null);
            }
            this.brokerTimeout = 120000;
        }
        try {
            if (session.replyQ == null) {
                int openOptions = 1;
                if (connection.getFailIfQuiesce() == 1) {
                    openOptions |= 0x2000;
                }
                this.replyQ = session.getQM().accessQueue("SYSTEM.JMS.REPORT.QUEUE", openOptions);
                if (this.replyQ != null) {
                    session.replyQ = this.replyQ;
                } else {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("brokerVersion", new Integer(this.brokerVersion));
                    data.put("session", session == null ? "is null" : "is set");
                    Trace.ffst("MQPubSubServices", "initialisePubSub", "XO00I001", data, JMSException.class);
                }
            } else {
                this.replyQ = session.replyQ;
            }
            this.brokerReponseGmo = new MQGetMessageOptions();
            this.brokerReponseGmo.options = 1;
            this.brokerReponseGmo.waitInterval = this.brokerTimeout;
            if (connection.getFailIfQuiesce() == 1) {
                this.brokerReponseGmo.options |= 0x2000;
            }
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "initialisePubSub(MQConnection,boolean,int,MQSession)", e);
            }
            JMSException je = new JMSException(ConfigEnvironment.getErrorMessage("MQJMS1111"));
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "initialisePubSub(MQConnection,boolean,int,MQSession)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "initialisePubSub(MQConnection,boolean,int,MQSession)");
        }
    }

    protected void closePubSub(MQSession session) throws JMSException {
        block16: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "closePubSub(MQSession)", new Object[]{session});
            }
            if (session.isStarted() && session.usingAsyncMode()) {
                try {
                    session.stop();
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "closePubSub(MQSession)", e, 1);
                    }
                    if (!Trace.isOn) break block16;
                    Trace.traceData(this, "implicit stop failed", null);
                }
            }
        }
        if (this.replyQ != null) {
            if (session.responseRequested) {
                try {
                    MQMsg2 response = new MQMsg2();
                    this.getBrokerResponse(session, response, false);
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "closePubSub(MQSession)", e, 2);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "closePubSub(MQSession)", e, 1);
                    }
                    throw e;
                }
            }
            try {
                this.replyQ.close();
                this.replyQ = null;
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "closePubSub(MQSession)", e, 3);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS2000");
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "closePubSub(MQSession)", je, 2);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "closePubSub(MQSession)");
        }
    }

    MQQueue getResponseQueue(MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getResponseQueue(MQSession)", new Object[]{session});
        }
        if (session.replyQ == null) {
            try {
                int openOptions = 1;
                if (session.connection.getFailIfQuiesce() == 1) {
                    openOptions |= 0x2000;
                }
                session.replyQ = this.replyQ = session.getQM().accessQueue("SYSTEM.JMS.REPORT.QUEUE", openOptions);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getResponseQueue(MQSession)", e);
                }
                JMSException je = new JMSException(ConfigEnvironment.getErrorMessage("MQJMS1111"));
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getResponseQueue(MQSession)", je);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getResponseQueue(MQSession)", session.replyQ);
        }
        return session.replyQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void getBrokerResponse(MQSession session, MQMsg2 response, boolean immediateResponse) throws NoBrokerResponseException {
        block25: {
            block26: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getBrokerResponse(MQSession,MQMsg2,boolean)", new Object[]{session, response, immediateResponse});
                }
                int elapsedTime = 0;
                if (immediateResponse) {
                    response.setCorrelationId(response.getMessageId());
                    this.brokerReponseGmo.waitInterval = this.brokerTimeout;
                } else {
                    response.setCorrelationId(session.responseCorrelId);
                    session.responseRequested = false;
                    long currentTime = System.currentTimeMillis();
                    elapsedTime = (int)(currentTime - session.responsePutTime);
                    if (Trace.isOn) {
                        Trace.traceData(this, "elapsed time is " + elapsedTime, null);
                    }
                    if (elapsedTime < this.brokerTimeout) {
                        this.brokerReponseGmo.waitInterval = this.brokerTimeout - elapsedTime;
                    } else {
                        this.brokerReponseGmo.options &= 0xFFFFFFFE;
                        this.brokerReponseGmo.waitInterval = 0;
                    }
                }
                response.setMessageId(MQC.MQMI_NONE);
                try {
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Getting Broker Response Lock for session " + session, null);
                        }
                        Object currentTime = session.getBrokerResponseLock();
                        synchronized (currentTime) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "got Broker Response Lock", null);
                            }
                            if (session != null && session.replyQ != null) {
                                session.replyQ.getMsg2(response, this.brokerReponseGmo);
                            } else {
                                HashMap<String, Object> data = new HashMap<String, Object>();
                                data.put("brokerVersion", new Integer(this.brokerVersion));
                                data.put("session name", new String(this.sessionName));
                                data.put("replyQ", this.replyQ == null ? "is null" : "is defined");
                                if (session != null) {
                                    data.put("session.replyQ", session.replyQ == null ? "is null" : "is defined");
                                }
                                Trace.ffst("MQPubSubServices", "getBrokerResponse", "XO00I002", data, NoBrokerResponseException.class);
                                if (session != null && session.replyQ == null) {
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "replyQ has been set to null. The session must have been closed, and the broker response processed  as part of the session's close() method", null);
                                    }
                                    String key1 = "MQJMS1024";
                                    String msg1 = ConfigEnvironment.getErrorMessage(key1);
                                    IllegalStateException e = new IllegalStateException(key1, msg1);
                                    String key = "MQJMS5053";
                                    String msg = ConfigEnvironment.getErrorMessage(key);
                                    NoBrokerResponseException je = new NoBrokerResponseException(msg, key);
                                    je.setLinkedException((Exception)((Object)e));
                                    if (Trace.isOn) {
                                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getBrokerResponse(MQSession,MQMsg2,boolean)", (Throwable)((Object)je), 3);
                                    }
                                    throw je;
                                }
                            }
                        }
                    }
                    catch (MQException e) {
                        block29: {
                            block30: {
                                block27: {
                                    block28: {
                                        if (Trace.isOn) {
                                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getBrokerResponse(MQSession,MQMsg2,boolean)", e);
                                        }
                                        if (immediateResponse) break block27;
                                        if (e.reasonCode != 2033 || elapsedTime <= 59000) break block28;
                                        Object var15_22 = null;
                                        if (!Trace.isOn) break block29;
                                        break block30;
                                    }
                                    String key = "MQJMS5053";
                                    String msg = ConfigEnvironment.getErrorMessage(key);
                                    NoBrokerResponseException je = new NoBrokerResponseException(msg, key);
                                    je.setLinkedException((Exception)((Object)e));
                                    if (Trace.isOn) {
                                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getBrokerResponse(MQSession,MQMsg2,boolean)", (Throwable)((Object)je), 1);
                                    }
                                    throw je;
                                }
                                String key = "MQJMS5053";
                                String msg = ConfigEnvironment.getErrorMessage(key);
                                NoBrokerResponseException je = new NoBrokerResponseException(msg, key);
                                je.setLinkedException((Exception)((Object)e));
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getBrokerResponse(MQSession,MQMsg2,boolean)", (Throwable)((Object)je), 2);
                                }
                                throw je;
                            }
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getBrokerResponse(MQSession,MQMsg2,boolean)");
                        }
                        this.brokerReponseGmo.options |= 1;
                        this.brokerReponseGmo.waitInterval = this.brokerTimeout;
                        break block25;
                    }
                    Object var15_21 = null;
                    if (!Trace.isOn) break block26;
                }
                catch (Throwable throwable) {
                    Object var15_23 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getBrokerResponse(MQSession,MQMsg2,boolean)");
                    }
                    this.brokerReponseGmo.options |= 1;
                    this.brokerReponseGmo.waitInterval = this.brokerTimeout;
                    throw throwable;
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getBrokerResponse(MQSession,MQMsg2,boolean)");
            }
            this.brokerReponseGmo.options |= 1;
            this.brokerReponseGmo.waitInterval = this.brokerTimeout;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "releasing Broker Response Lock for session " + session, null);
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getBrokerResponse(MQSession,MQMsg2,boolean)");
        }
    }

    boolean getSparseSubscriptions(MQSession session) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getSparseSubscriptions(MQSession)", new Object[]{session});
        }
        if (session.connection != null) {
            boolean traceRet1 = session.connection.getSparseSubscriptions();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getSparseSubscriptions(MQSession)", traceRet1, 1);
            }
            return traceRet1;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "getSparseSubscriptions, connection null.", null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getSparseSubscriptions(MQSession)", false, 2);
        }
        return false;
    }

    protected void setBrokerTimeout(int x) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "setBrokerTimeout(int)", new Object[]{new Integer(x)});
        }
        this.brokerTimeout = x;
        this.wait_for_reply = this.brokerTimeout > 0;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "setBrokerTimeout(int)");
        }
    }

    protected int getBrokerTimeout() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "getBrokerTimeout()", "getter", new Integer(this.brokerTimeout));
        }
        return this.brokerTimeout;
    }

    /*
     * Exception decompiling
     */
    void sendCommand(String topicName, int command, String postfix, byte[] subscriberId, boolean wait, boolean nonDurable, MQSession session) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean requestResponse(MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "requestResponse(MQSession)", new Object[]{session});
        }
        ++session.publishCount;
        if (Trace.isOn) {
            Trace.traceData(this, "publishCount is " + session.publishCount, null);
        }
        if (!session.responseRequested && !session.responseOnCommit && session.publishCount >= session.responseInterval) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "requestResponse(MQSession)", true, 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "requestResponse(MQSession)", false, 2);
        }
        return false;
    }

    boolean checkForResponse(MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "checkForResponse(MQSession)", new Object[]{session});
        }
        if (Trace.isOn) {
            Trace.traceData(this, "publishCount is " + session.publishCount, null);
            Trace.traceData(this, "checkInterval is " + session.checkInterval, null);
        }
        if (session.responseRequested) {
            if (session.publishCount >= session.checkInterval) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "checkForResponse(MQSession)", true, 1);
                }
                return true;
            }
            if (System.currentTimeMillis() - session.responsePutTime > 59000L) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "checkForResponse(MQSession)", true, 2);
                }
                return true;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "checkForResponse(MQSession)", false, 3);
        }
        return false;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQPubSubServices.java, jmscc.wmq.v6, k701, k701-112-140304  1.20.1.2 10/11/18 13:29:07");
        }
    }
}

