/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueManager;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueToken;
import com.ibm.msg.client.wmq.v6.base.internal.MQC;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSC;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubAdmin;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubEntry;
import com.ibm.msg.client.wmq.v6.jms.internal.SubscriptionHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.jms.JMSException;

class MQPSStatusMgr {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQPSStatusMgr.java, jmscc.wmq.v6, k701, k701-112-140304 1.39.1.1 09/08/17 08:11:48";
    private final String JVM_MSG_SIGNATURE = "MQJMS_PS_JVM_STATUS_MSG";
    private static Hashtable statusMgrConnections;
    private static Integer statusMgrConnectionsLock;
    private MQQueueManager cleanup_qmgr;
    private String cleanup_controlQName;
    private String cleanup_streamQName;
    private static long monitorDelay;
    static /* synthetic */ Class class$javax$jms$JMSException;

    protected MQPSStatusMgr(MQQueueManager qm, String brokerControlQName, String brokerStreamQName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "<init>(MQQueueManager,String,String)", new Object[]{qm, brokerControlQName, brokerStreamQName});
        }
        this.cleanup_qmgr = qm;
        this.cleanup_controlQName = brokerControlQName;
        this.cleanup_streamQName = brokerStreamQName;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "<init>(MQQueueManager,String,String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] addConnection(MQConnection topicConn) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "addConnection(MQConnection)", new Object[]{topicConn});
        }
        Map mqProperties = topicConn.mqProperties;
        String topicConnectionId = topicConn.getConnectionID();
        StatusMgrConnection conn = null;
        String lookupString = mqProperties.get("transport").equals("MQSeries Bindings") ? this.cleanup_qmgr.name.trim() : this.cleanup_qmgr.name.trim() + mqProperties.get("hostname") + mqProperties.get("channel") + mqProperties.get("port");
        Integer n = statusMgrConnectionsLock;
        synchronized (n) {
            if (statusMgrConnections == null) {
                statusMgrConnections = new Hashtable();
            } else {
                conn = (StatusMgrConnection)statusMgrConnections.get(lookupString);
            }
            if (conn != null) {
                conn.addUser(topicConnectionId);
                try {
                    this.cleanup_qmgr.disconnect();
                    this.cleanup_qmgr = null;
                }
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "addConnection(MQConnection)", e);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS3005", e.toString());
                    je.setLinkedException((Exception)((Object)e));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "addConnection(MQConnection)", je);
                    }
                    throw je;
                }
            } else {
                conn = new StatusMgrConnection(this.cleanup_qmgr, topicConn);
                statusMgrConnections.put(lookupString, conn);
                this.cleanup_qmgr = null;
            }
        }
        if (Trace.isOn) {
            Trace.traceData(this, "addConnection: JVM reference id = " + conn.jvmReferenceId(), null);
        }
        byte[] traceRet1 = conn.jvmReferenceId();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "addConnection(MQConnection)", traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(String qmgrName, Map mqProperties, String topicConnectionId) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "removeConnection(String,Map,String)", new Object[]{qmgrName, mqProperties, topicConnectionId});
        }
        String lookupString = mqProperties.get("transport").equals("MQSeries Bindings") ? qmgrName : qmgrName + mqProperties.get("hostname") + mqProperties.get("channel") + mqProperties.get("port");
        Integer n = statusMgrConnectionsLock;
        synchronized (n) {
            StatusMgrConnection conn = (StatusMgrConnection)statusMgrConnections.get(lookupString);
            if (conn != null) {
                if (conn.removeUser(topicConnectionId) == 0 && (conn = (StatusMgrConnection)statusMgrConnections.remove(lookupString)) == null && Trace.isOn) {
                    Trace.traceData(this, "removeConnection error: hashtable remove failed", null);
                }
            } else if (Trace.isOn) {
                Trace.traceData(this, "removeConnection error: connection not found. Called from TC finalizer after initial close?", null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "removeConnection(String,Map,String)");
        }
    }

    private void cleanup(MQQueueManager qm) {
        block63: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", new Object[]{qm});
            }
            try {
                MQQueue statusQueue;
                MQSession session;
                block62: {
                    session = new MQSession(qm, this.cleanup_controlQName, this.cleanup_streamQName);
                    int openOptions = 8218;
                    statusQueue = qm.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", openOptions);
                    int jvmMsgs = 0;
                    try {
                        while (true) {
                            block61: {
                                boolean unexpectedProblems = false;
                                MQMessage jvmMessage = new MQMessage();
                                jvmMessage.correlationId = JMSC.PS_JVM_REFMSG_CORRELID;
                                MQGetMessageOptions gmo = new MQGetMessageOptions();
                                gmo.options = jvmMsgs == 0 ? 16 : 32;
                                statusQueue.get(jvmMessage, gmo);
                                boolean validMsg = false;
                                String jvmMsgText = "";
                                if (jvmMessage.getMessageLength() > 0) {
                                    jvmMsgText = jvmMessage.readLine();
                                }
                                if (jvmMsgText.indexOf("MQJMS_PS_JVM_STATUS_MSG") != 0) {
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "cleanup: Invalid JVM message signature found within status queue message! Removing.", null);
                                    }
                                    try {
                                        statusQueue.get(jvmMessage);
                                    }
                                    catch (MQException e) {
                                        if (Trace.isOn) {
                                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", e, 1);
                                        }
                                        if (Trace.isOn) {
                                            Trace.traceData(this, "cleanup: remove of invalid msg failed, ignoring.", null);
                                        }
                                    }
                                } else if (jvmMsgText.indexOf("backout") != -1) {
                                    if (jvmMessage.backoutCount > 0) {
                                        validMsg = true;
                                    } else if (Trace.isOn) {
                                        Trace.traceData(this, "cleanup: invalid backout count detected, ignoring message.", null);
                                    }
                                } else {
                                    validMsg = true;
                                }
                                byte[] jvmReferenceId = jvmMessage.messageId;
                                if (validMsg) {
                                    int ndRecs = 0;
                                    try {
                                        while (true) {
                                            MQMessage inactiveSubMsg;
                                            block58: {
                                                inactiveSubMsg = new MQMessage();
                                                inactiveSubMsg.correlationId = jvmReferenceId;
                                                gmo = new MQGetMessageOptions();
                                                gmo.options = ndRecs == 0 ? 16 : 32;
                                                statusQueue.get(inactiveSubMsg, gmo);
                                                MQSubEntry ndSubEntry = new MQSubEntry(inactiveSubMsg);
                                                try {
                                                    SubscriptionHelper.deleteSubscriber(session.getQM(), session.getBrk(), ndSubEntry);
                                                }
                                                catch (JMSException ex) {
                                                    if (Trace.isOn) {
                                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", ex, 2);
                                                    }
                                                    unexpectedProblems = true;
                                                    if (!Trace.isOn) break block58;
                                                    Trace.traceData(this, "cleanup: Non durable record search caught unexpected exception.", null);
                                                }
                                            }
                                            if (!unexpectedProblems) {
                                                try {
                                                    statusQueue.get(inactiveSubMsg);
                                                }
                                                catch (MQException e) {
                                                    if (Trace.isOn) {
                                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", e, 3);
                                                    }
                                                    unexpectedProblems = true;
                                                    if (Trace.isOn) {
                                                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", e);
                                                    }
                                                    throw e;
                                                }
                                            }
                                            ++ndRecs;
                                        }
                                    }
                                    catch (MQException ex) {
                                        block60: {
                                            if (Trace.isOn) {
                                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", ex, 4);
                                            }
                                            if (ex.reasonCode == 2033) {
                                                if (Trace.isOn) {
                                                    Trace.traceData(this, "cleanup: Finished retrieving all non durable records (caught 2033). Found " + ndRecs + " records", null);
                                                }
                                            } else {
                                                unexpectedProblems = true;
                                                if (Trace.isOn) {
                                                    Trace.traceData(this, "cleanup: Non durable record search caught unexpected exception.", null);
                                                }
                                            }
                                            int dRecs = 0;
                                            boolean msgFound = true;
                                            MQSubAdmin admin = null;
                                            try {
                                                admin = new MQSubAdmin(session.getQM());
                                                while (msgFound) {
                                                    MQSubEntry dSubEntry = null;
                                                    dSubEntry = dRecs == 0 ? admin.getResolved(session.getQM(), session.getBrk(), null, jvmReferenceId, false) : admin.getResolved(session.getQM(), session.getBrk(), null, jvmReferenceId, true);
                                                    if (dSubEntry != null) {
                                                        block59: {
                                                            if (dSubEntry.getSubscriberState() == 'u') {
                                                                try {
                                                                    dSubEntry.setSubscriberState('i');
                                                                    dSubEntry.setStatusMgrId(MQC.MQCI_NONE);
                                                                    admin.add(dSubEntry, false);
                                                                    admin.remove(dSubEntry);
                                                                }
                                                                catch (JMSException je) {
                                                                    if (Trace.isOn) {
                                                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", je, 5);
                                                                    }
                                                                    unexpectedProblems = true;
                                                                    if (!Trace.isOn) break block59;
                                                                    Trace.traceData(this, "cleanup: Durable record search caught unexpected exception.", null);
                                                                }
                                                            }
                                                        }
                                                        ++dRecs;
                                                        continue;
                                                    }
                                                    msgFound = false;
                                                }
                                                admin.close();
                                                if (Trace.isOn) {
                                                    Trace.traceData(this, "cleanup: Finished retrieving all durable records. Found " + dRecs + " records", null);
                                                }
                                            }
                                            catch (JMSException je) {
                                                if (Trace.isOn) {
                                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", je, 6);
                                                }
                                                if (admin != null) {
                                                    admin.close();
                                                }
                                                unexpectedProblems = true;
                                                if (!Trace.isOn) break block60;
                                                Trace.traceData(this, "cleanup: Durable record search caught unexpected exception.", null);
                                            }
                                        }
                                        try {
                                            gmo.options = 16;
                                            statusQueue.get(jvmMessage, gmo);
                                            if (!unexpectedProblems) {
                                                statusQueue.get(jvmMessage);
                                            }
                                        }
                                        catch (MQException e) {
                                            if (Trace.isOn) {
                                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", e, 7);
                                            }
                                            if (!Trace.isOn) break block61;
                                            Trace.traceData(this, "cleanup: status queue jvm msg remove failed.", null);
                                        }
                                    }
                                }
                            }
                            ++jvmMsgs;
                        }
                    }
                    catch (MQException ex) {
                        if (Trace.isOn) {
                            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", "Caught expected exception at catch index 8", (Object)ex);
                        }
                        if (Trace.isOn) {
                            if (ex.reasonCode == 2033) {
                                Trace.traceData(this, "cleanup: Finished retrieving all JVM reference messages (caught 2033). Found " + jvmMsgs + " msgs", null);
                            } else {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", ex, 8);
                            }
                            Trace.traceData(this, "cleanup: JVM ref. msg search caught unexpected exception.", null);
                        }
                    }
                    catch (IOException ex) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", ex, 9);
                        }
                        if (!Trace.isOn) break block62;
                        Trace.traceData(this, "cleanup: JVM ref. msg search caught unexpected IO exception.", null);
                    }
                }
                session.setQM(null);
                session.close(false);
                session = null;
                statusQueue.close();
            }
            catch (Exception ex) {
                if (!Trace.isOn) break block63;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)", ex, 10);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "cleanup(MQQueueManager)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "close()");
        }
        this.cleanup_qmgr = null;
        Integer n = statusMgrConnectionsLock;
        synchronized (n) {
            if (statusMgrConnections != null && statusMgrConnections.isEmpty()) {
                statusMgrConnections = null;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "close()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQPSStatusMgr", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQPSStatusMgr.java, jmscc.wmq.v6, k701, k701-112-140304  1.39.1.1 09/08/17 08:11:48");
        }
        statusMgrConnectionsLock = new Integer(0);
        monitorDelay = 30L;
    }

    class StatusMgrConnection
    implements Runnable {
        public static final int MAX_SHUTDOWN_TIME = 5000;
        private MQQueueManager qmgr;
        private MQQueue statusQueue;
        private byte[] jvmReferenceId = null;
        private Object longRunningTranLock = new Object();
        private boolean longRunningTranWaiting = false;
        private boolean longRunningTranPosted = false;
        private boolean longRunningTranEnd = false;
        private boolean runFinished = false;
        private int refreshDelay;
        private MQConnection topicConn;
        private Vector usageVector;
        private WorkQueueToken workQueueToken;

        StatusMgrConnection(MQQueueManager qm, MQConnection topicConn) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "<init>(MQQueueManager,MQConnection)", new Object[]{qm, topicConn});
            }
            this.qmgr = qm;
            this.topicConn = topicConn;
            this.refreshDelay = topicConn.getStatusRefreshInterval();
            try {
                this.statusQueue = qm.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 8210);
                this.putJVMMessage(this.qmgr);
                this.usageVector = new Vector();
                this.addUser(topicConn.getConnectionID());
                try {
                    this.workQueueToken = WorkQueueManager.enqueue(this, 0, false);
                }
                catch (CSIException ce) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "<init>(MQQueueManager,MQConnection)", ce, 1);
                    }
                    HashMap<String, CSIException> m = new HashMap<String, CSIException>();
                    m.put("exception", ce);
                    Trace.ffst(this, "start()", "XO009001", m, class$javax$jms$JMSException == null ? (class$javax$jms$JMSException = MQPSStatusMgr.class$("javax.jms.JMSException")) : class$javax$jms$JMSException);
                }
            }
            catch (MQException ex) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "<init>(MQQueueManager,MQConnection)", ex, 2);
                }
                JMSException je = ex.reasonCode == 2085 ? ConfigEnvironment.newException("MQJMS3014", "SYSTEM.JMS.PS.STATUS.QUEUE") : ConfigEnvironment.newException("MQJMS3005", ex.toString());
                je.setLinkedException((Exception)((Object)ex));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "<init>(MQQueueManager,MQConnection)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "<init>(MQQueueManager,MQConnection)");
            }
        }

        void addUser(String topicConnIDToken) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "addUser(String)", new Object[]{topicConnIDToken});
            }
            if (!this.usageVector.contains(topicConnIDToken)) {
                this.usageVector.addElement(topicConnIDToken);
            } else if (Trace.isOn) {
                Trace.traceData(this, "addUser error: token already exists.", null);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "addUser(String)");
            }
        }

        int removeUser(String topicConnIDToken) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "removeUser(String)", new Object[]{topicConnIDToken});
            }
            if (this.usageVector.contains(topicConnIDToken)) {
                this.usageVector.removeElement(topicConnIDToken);
            }
            int usageCount = this.usageVector.size();
            if (usageCount == 0) {
                if (Trace.isOn) {
                    Trace.traceData(this, "removeUser: no users left; closing connection.", null);
                }
                this.close();
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "removeUser(String)", new Integer(usageCount));
            }
            return usageCount;
        }

        private void putJVMMessage(MQQueueManager qm) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "putJVMMessage(MQQueueManager)", new Object[]{qm});
            }
            try {
                MQMessage jvmMessage = new MQMessage();
                if (this.jvmReferenceId != null) {
                    jvmMessage.messageId = this.jvmReferenceId;
                }
                jvmMessage.correlationId = JMSC.PS_JVM_REFMSG_CORRELID;
                jvmMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                jvmMessage.writeString("backout");
                this.statusQueue.put(jvmMessage);
                if (this.jvmReferenceId == null) {
                    this.jvmReferenceId = jvmMessage.messageId;
                }
                MQGetMessageOptions gmo = new MQGetMessageOptions();
                gmo.options = 2;
                this.statusQueue.get(jvmMessage, gmo);
                jvmMessage.clearMessage();
                jvmMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                jvmMessage.writeString("commit");
                MQPutMessageOptions pmo = new MQPutMessageOptions();
                pmo.options = 2;
                this.statusQueue.put(jvmMessage, pmo);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "putJVMMessage(MQQueueManager)", e, 1);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3005", e.toString());
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "putJVMMessage(MQQueueManager)", je, 1);
                }
                throw je;
            }
            catch (IOException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "putJVMMessage(MQQueueManager)", e, 2);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3005", e.toString());
                je.setLinkedException((Exception)e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "putJVMMessage(MQQueueManager)", je, 2);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "putJVMMessage(MQQueueManager)");
            }
        }

        private void removeJVMMessage(MQQueueManager qm) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "removeJVMMessage(MQQueueManager)", new Object[]{qm});
            }
            try {
                MQGetMessageOptions gmo = new MQGetMessageOptions();
                gmo.options = 2;
                MQMessage jvmMessage = new MQMessage();
                jvmMessage.messageId = this.jvmReferenceId;
                jvmMessage.correlationId = JMSC.PS_JVM_REFMSG_CORRELID;
                this.statusQueue.get(jvmMessage, gmo);
                if (qm != null) {
                    qm.commit();
                } else if (Trace.isOn) {
                    Trace.traceData(this, "Saved NullPointerException on qm.commit", null);
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "removeJVMMessage(MQQueueManager)", e);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3005", e.toString());
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "removeJVMMessage(MQQueueManager)", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "removeJVMMessage(MQQueueManager)");
            }
        }

        private void refreshJVMMessage(MQQueueManager qm) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "refreshJVMMessage(MQQueueManager)", new Object[]{qm});
            }
            try {
                MQMessage jvmMessage = new MQMessage();
                jvmMessage.messageId = this.jvmReferenceId;
                jvmMessage.correlationId = JMSC.PS_JVM_REFMSG_CORRELID;
                jvmMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                jvmMessage.writeString("backout");
                this.statusQueue.put(jvmMessage);
                MQGetMessageOptions gmo = new MQGetMessageOptions();
                gmo.options = 2;
                this.statusQueue.get(jvmMessage, gmo);
                qm.commit();
                this.statusQueue.get(jvmMessage, gmo);
                jvmMessage.clearMessage();
                jvmMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                jvmMessage.writeString("commit");
                MQPutMessageOptions pmo = new MQPutMessageOptions();
                pmo.options = 2;
                this.statusQueue.put(jvmMessage, pmo);
            }
            catch (MQException ex) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "refreshJVMMessage(MQQueueManager)", ex, 1);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3005", ex.toString());
                je.setLinkedException((Exception)((Object)ex));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "refreshJVMMessage(MQQueueManager)", je, 1);
                }
                throw je;
            }
            catch (IOException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "refreshJVMMessage(MQQueueManager)", e, 2);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3005", e.toString());
                je.setLinkedException((Exception)e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "refreshJVMMessage(MQQueueManager)", je, 2);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "refreshJVMMessage(MQQueueManager)");
            }
        }

        byte[] jvmReferenceId() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "jvmReferenceId()");
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "jvmReferenceId()", this.jvmReferenceId);
            }
            return this.jvmReferenceId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "close()");
            }
            boolean WakeUp = false;
            this.workQueueToken.end();
            Object object = this.longRunningTranLock;
            synchronized (object) {
                this.longRunningTranEnd = true;
                if (this.longRunningTranWaiting) {
                    this.longRunningTranPosted = true;
                    WakeUp = true;
                }
            }
            if (Trace.isOn) {
                Trace.traceData(this, "close ending run() loop", null);
            }
            try {
                if (WakeUp) {
                    MQQueueManager newQM = this.topicConn.createQMNonXA();
                    this.topicConn = null;
                    int openOptions = 8208;
                    MQQueue statusQueue = newQM.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", openOptions);
                    MQMessage terminator = new MQMessage();
                    terminator.messageId = this.jvmReferenceId;
                    terminator.correlationId = JMSC.PS_TERMMSG_CORRELID;
                    terminator.expiry = 36000;
                    terminator.persistence = 0;
                    statusQueue.put(terminator);
                    newQM.disconnect();
                }
                this.waitForRunFinished();
                this.usageVector = null;
                this.qmgr = null;
                this.jvmReferenceId = null;
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "close()", e);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3005", e.toString());
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "close()", je);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "close()");
            }
        }

        private synchronized void setRunFinished() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "setRunFinished()");
            }
            this.runFinished = true;
            this.notifyAll();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "setRunFinished()");
            }
        }

        private synchronized void waitForRunFinished() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "waitForRunFinished()");
            }
            long now = System.currentTimeMillis();
            long end = now + 5000L;
            while (!this.runFinished && now < end) {
                block5: {
                    try {
                        this.wait(end - now);
                    }
                    catch (InterruptedException e) {
                        if (!Trace.isOn) break block5;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "waitForRunFinished()", e);
                    }
                }
                now = System.currentTimeMillis();
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "waitForRunFinished()");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block36: {
                block35: {
                    block34: {
                        if (Trace.isOn) {
                            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "run()");
                        }
                        boolean missingTerminator = false;
                        MQPSStatusMgr.this.cleanup(this.qmgr);
                        MQMessage terminator = new MQMessage();
                        MQGetMessageOptions gmo = new MQGetMessageOptions();
                        Object object = this.longRunningTranLock;
                        synchronized (object) {
                            this.longRunningTranWaiting = !this.longRunningTranEnd;
                        }
                        while (this.longRunningTranWaiting) {
                            terminator.messageId = this.jvmReferenceId;
                            terminator.correlationId = JMSC.PS_TERMMSG_CORRELID;
                            gmo.options = 1;
                            gmo.waitInterval = this.refreshDelay;
                            try {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "run() attempting get/wait", null);
                                }
                                this.statusQueue.get(terminator, gmo);
                                object = this.longRunningTranLock;
                                synchronized (object) {
                                    this.longRunningTranWaiting = false;
                                }
                                if (this.longRunningTranEnd || !Trace.isOn) continue;
                                Trace.traceData(this, "run() error: invalid message retrieved?", null);
                            }
                            catch (MQException ex) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "run()", ex, 1);
                                }
                                if (ex.reasonCode == 2033) {
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "run() get/wait finished with 2033 - refreshing JVM msg", null);
                                    }
                                    this.refreshJVMMessage(this.qmgr);
                                    Object object2 = this.longRunningTranLock;
                                    synchronized (object2) {
                                        if (this.longRunningTranPosted) {
                                            if (missingTerminator) {
                                                this.longRunningTranWaiting = false;
                                            } else {
                                                missingTerminator = true;
                                            }
                                        }
                                        continue;
                                    }
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "run() error: caught unexpected exception attempting get/wait.", null);
                                }
                                JMSException je = ConfigEnvironment.newException("MQJMS3005", ex.toString());
                                je.setLinkedException((Exception)((Object)ex));
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "run()", je);
                                }
                                throw je;
                            }
                        }
                        this.removeJVMMessage(this.qmgr);
                        Object var9_11 = null;
                        if (!Trace.isOn) break block34;
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "run()");
                    }
                    try {
                        this.qmgr.disconnect();
                    }
                    catch (Exception ex) {
                        if (!Trace.isOn) break block35;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "run()", ex, 3);
                    }
                }
                this.qmgr = null;
                this.setRunFinished();
                {
                    break block36;
                    catch (JMSException je) {
                        block37: {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "run()", je, 2);
                            }
                            Object var9_12 = null;
                            if (Trace.isOn) {
                                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "run()");
                            }
                            try {
                                this.qmgr.disconnect();
                            }
                            catch (Exception ex) {
                                if (!Trace.isOn) break block37;
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "run()", ex, 3);
                            }
                        }
                        this.qmgr = null;
                        this.setRunFinished();
                    }
                }
                catch (Throwable throwable) {
                    block38: {
                        Object var9_13 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "run()");
                        }
                        try {
                            this.qmgr.disconnect();
                        }
                        catch (Exception ex) {
                            if (!Trace.isOn) break block38;
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "run()", ex, 3);
                        }
                    }
                    this.qmgr = null;
                    this.setRunFinished();
                    throw throwable;
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.StatusMgrConnection", "run()");
            }
        }
    }
}

