/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.WMQCommonUtils;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.BrokerConnectionInfo;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import javax.jms.JMSException;

class MQMigrateSubscriptionEngine
extends MQSubscriptionEngine {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQMigrateSubscriptionEngine.java, jmscc.wmq.v6, k701, k701-112-140304 1.29.1.1 09/08/17 08:11:34";
    private int useBrokerSubStore;
    private static final int BSS_AVAILABLE = 1;
    private static final int BSS_UNAVAILABLE = 0;
    private static final int BSS_UNKNOWN = -1;
    private MQQueueSubscriptionEngine queueSubStore;
    private MQBrokerSubscriptionEngine brokerSubStore;
    private int WSClone = 0;

    public MQMigrateSubscriptionEngine(MQConnection connection, MQQueueManager qm, String resolvedQMName) throws JMSException {
        super(connection);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "<init>(MQConnection,MQQueueManager,String)", new Object[]{connection, qm, resolvedQMName});
        }
        try {
            this.WSClone = connection.getIntProperty("XMSC_WMQ_CLONE_SUPPORT");
            this.useBrokerSubStore = -1;
            if (!qm.spiSupportsDeferred()) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Queue Manager doesn't support deferred messages - using Queue substore", null);
                }
                this.useBrokerSubStore = 0;
            }
            if (this.useBrokerSubStore == -1 || this.useBrokerSubStore == 0) {
                this.queueSubStore = new MQQueueSubscriptionEngine(connection, qm);
            }
            if (this.useBrokerSubStore == -1 || this.useBrokerSubStore == 1) {
                this.brokerSubStore = new MQBrokerSubscriptionEngine(connection, resolvedQMName);
            }
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "<init>(MQConnection,MQQueueManager,String)", mqe, 1);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1016");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "<init>(MQConnection,MQQueueManager,String)", je, 1);
            }
            throw je;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "<init>(MQConnection,MQQueueManager,String)", je, 2);
            }
            if (this.queueSubStore != null) {
                this.queueSubStore.close();
            }
            if (this.brokerSubStore != null) {
                this.brokerSubStore.close();
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "<init>(MQConnection,MQQueueManager,String)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "<init>(MQConnection,MQQueueManager,String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQSubscription openSubscription(MQSession mqts, WMQDestination topic, String selector, boolean noLocal, boolean sharedQueue, String queueName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", new Object[]{mqts, topic, selector, noLocal, sharedQueue, queueName});
        }
        boolean retry = true;
        MQSubscription sub = null;
        try {
            block13: while (retry) {
                switch (this.useBrokerSubStore) {
                    case 1: {
                        retry = false;
                        sub = this.brokerSubStore.openSubscription(mqts, topic, selector, noLocal, sharedQueue, queueName);
                        continue block13;
                    }
                    case -1: {
                        try {
                            if (!mqts.getQM().spiSupportsDeferred()) {
                                if (this.useBrokerSubStore != 0) {
                                    this.useBrokerSubStore = 0;
                                    this.brokerSubStore.close();
                                    this.brokerSubStore = null;
                                }
                                retry = true;
                                continue block13;
                            }
                            try {
                                sub = this.brokerSubStore.openSubscription(mqts, topic, selector, noLocal, sharedQueue, queueName);
                                this.useBrokerSubStore = 1;
                                retry = false;
                                continue block13;
                            }
                            catch (JMSException je) {
                                BrokerCommandFailedException bcfe;
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 1);
                                }
                                if (je instanceof BrokerCommandFailedException && ((bcfe = (BrokerCommandFailedException)je).getReason() == 3083 || bcfe.getReason() == 2337)) {
                                    if (this.useBrokerSubStore != 0) {
                                        this.useBrokerSubStore = 0;
                                        this.brokerSubStore.close();
                                        this.brokerSubStore = null;
                                    }
                                    retry = true;
                                    continue block13;
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "test of brokerSubStore failed. Broker type still unknown", null);
                                }
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 1);
                                }
                                throw je;
                            }
                        }
                        catch (Exception e) {
                            JMSException je;
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", e, 2);
                            }
                            if (e instanceof JMSException) {
                                je = (JMSException)((Object)e);
                            } else {
                                je = ConfigEnvironment.newException("MQJMS1016");
                                je.setLinkedException(e);
                            }
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 2);
                            }
                            throw je;
                        }
                    }
                }
                if (this.WSClone == 1) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Cannot have clone support enabled for a queueSubscriptionEngine.", null);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS4125", "SUBSTORE(BROKER)", "CLONESUPP(ENABLED)");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 3);
                    }
                    throw je;
                }
                retry = false;
                sub = this.queueSubStore.openSubscription(mqts, topic, selector, noLocal, sharedQueue, queueName);
            }
            if (this.queueSubStore != null) {
                MQQueueSubscriptionEngine je = this.queueSubStore;
                synchronized (je) {
                    if (this.useBrokerSubStore == 1 && this.queueSubStore != null) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "BrokerSubEngine is available. Closing QueueSubscriptionEngine", null);
                        }
                        this.queueSubStore.close();
                        this.queueSubStore = null;
                    }
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", sub);
            }
            return sub;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 4);
            }
            throw je;
        }
    }

    public void closeSubscription(MQSubscription sub) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "closeSubscription(MQSubscription)", new Object[]{sub});
        }
        if (sub instanceof MQBrokerSubscription) {
            this.brokerSubStore.closeSubscription(sub);
        } else if (sub instanceof MQQueueSubscription) {
            this.queueSubStore.closeSubscription(sub);
        } else {
            JMSException je = ConfigEnvironment.newException("MQJMS3049");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "closeSubscription(MQSubscription)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "closeSubscription(MQSubscription)");
        }
    }

    /*
     * Exception decompiling
     */
    public MQSubscription openDurableSubscription(MQSession mqs, WMQDestination topic, String selector, boolean noLocal, boolean sharedQueue, String queueName, String subName) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [28[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void closeDurableSubscription(MQSubscription sub) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "closeDurableSubscription(MQSubscription)", new Object[]{sub});
        }
        if (sub instanceof MQBrokerSubscription) {
            this.brokerSubStore.closeDurableSubscription(sub);
        } else if (sub instanceof MQQueueSubscription) {
            this.queueSubStore.closeDurableSubscription(sub);
        } else {
            JMSException je = ConfigEnvironment.newException("MQJMS3049");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "closeDurableSubscription(MQSubscription)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void durableUnsubscribe(MQSession mqts, String subName) throws JMSException {
        MQQueue adminQueue;
        block21: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "durableUnsubscribe(MQSession,String)", new Object[]{mqts, subName});
            }
            adminQueue = null;
            try {
                adminQueue = this.getAdminQueueAccess(mqts, mqts.getFailIfQuiesce());
                if (this.brokerSubStore != null && this.checkQueueSubscription(mqts, subName, adminQueue, mqts.getFailIfQuiesce()) == null) {
                    this.brokerSubStore.durableUnsubscribe(mqts, subName);
                } else {
                    block20: {
                        try {
                            adminQueue.close();
                            adminQueue = null;
                        }
                        catch (MQException me) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "durableUnsubscribe(MQSession,String)", me, 1);
                            }
                            if (!Trace.isOn) break block20;
                            Trace.traceData(this, "error closing adminQueue", null);
                            JMSException je = ConfigEnvironment.newException("MQJMS1032", new Integer(me.reasonCode));
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "durableUnsubscribe(MQSession,String)", je, 1);
                            }
                            throw je;
                        }
                    }
                    this.queueSubStore.durableUnsubscribe(mqts, subName);
                }
                Object var7_6 = null;
                if (!Trace.isOn) break block21;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "durableUnsubscribe(MQSession,String)");
                }
                if (adminQueue != null) {
                    try {
                        adminQueue.close();
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "durableUnsubscribe(MQSession,String)", mqe, 2);
                        }
                        JMSException je2 = new JMSException("MQJMS2000");
                        je2.setLinkedException((Exception)((Object)mqe));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "durableUnsubscribe(MQSession,String)", je2, 2);
                        }
                        throw je2;
                    }
                }
                throw throwable;
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "durableUnsubscribe(MQSession,String)");
        }
        if (adminQueue != null) {
            try {
                adminQueue.close();
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "durableUnsubscribe(MQSession,String)", mqe, 2);
                }
                JMSException je2 = new JMSException("MQJMS2000");
                je2.setLinkedException((Exception)((Object)mqe));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "durableUnsubscribe(MQSession,String)", je2, 2);
                }
                throw je2;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "durableUnsubscribe(MQSession,String)");
        }
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "close()");
        }
        if (this.queueSubStore != null) {
            this.queueSubStore.close();
        }
        if (this.brokerSubStore != null) {
            this.brokerSubStore.close();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "close()");
        }
    }

    private MQQueueSubscription checkQueueSubscription(MQSession mqs, String subName, MQQueue adminQueue, int fiqBehaviour) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "checkQueueSubscription(MQSession,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,int)", new Object[]{mqs, subName, adminQueue, new Integer(fiqBehaviour)});
        }
        MQQueueSubscription testSub = null;
        String clientID = null;
        String fullName = null;
        MQGetMessageOptions gmo = null;
        try {
            clientID = this.getMQConnection().getClientID();
            if (clientID == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS3024");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "checkQueueSubscription(MQSession,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,int)", je, 1);
                }
                throw je;
            }
            fullName = clientID + ":" + subName;
            gmo = new MQGetMessageOptions();
            gmo.options = 16;
            if (fiqBehaviour == 1) {
                gmo.options |= 0x2000;
            }
            boolean carryOn = true;
            while (carryOn) {
                try {
                    MQMessage msg = new MQMessage();
                    adminQueue.get(msg, gmo);
                    testSub = new MQQueueSubscription(this, mqs, msg);
                    if (testSub.isValid() && testSub.getFullName().equals(fullName)) {
                        carryOn = false;
                        continue;
                    }
                    gmo.options = 32;
                    if (fiqBehaviour != 1) continue;
                    gmo.options |= 0x2000;
                }
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "checkQueueSubscription(MQSession,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,int)", e, 1);
                    }
                    testSub = null;
                    carryOn = false;
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "checkQueueSubscription(MQSession,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,int)", testSub);
            }
            return testSub;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "checkQueueSubscription(MQSession,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,int)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "checkQueueSubscription(MQSession,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,int)", je, 2);
            }
            throw je;
        }
    }

    private MQQueue getAdminQueueAccess(MQSession mqs, int fiqBehaviour) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", new Object[]{mqs, new Integer(fiqBehaviour)});
        }
        int MAXRETRIES = 20;
        int MAXWAIT = 5000;
        MQQueueManager qm = mqs.getQM();
        MQQueue adminQueue = null;
        int attempt = 0;
        block7: while (true) {
            try {
                if (Trace.isOn) {
                    Trace.traceData(this, "Try to open the adminQueue", null);
                }
                int openOptions = 60;
                if (fiqBehaviour == 1) {
                    openOptions |= 0x2000;
                }
                adminQueue = qm.accessQueue("SYSTEM.JMS.ADMIN.QUEUE", openOptions);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Cannot open adminQueue", null);
                }
                switch (e.reasonCode) {
                    case 2042: {
                        if (++attempt < 20) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "admin queue locked, tried " + attempt + "times", null);
                                Trace.traceData(this, "suppressing exception and retrying after wait", null);
                            }
                            try {
                                long daisyTime = (long)(100.0 + 5000.0 * Math.random());
                                if (Trace.isOn) {
                                    Trace.traceData(this, "waiting for " + daisyTime + " milis...", null);
                                }
                                Thread.sleep(daisyTime);
                            }
                            catch (InterruptedException ie) {
                                if (!Trace.isOn) continue block7;
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", ie, 2);
                            }
                            continue block7;
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Tried 20 attempts.", null);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", je, 1);
                        }
                        throw je;
                    }
                    default: {
                        JMSException je = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.ADMIN.QUEUE");
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", je, 2);
                        }
                        throw je;
                    }
                }
                continue;
            }
            break;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "Obtaining the admin queue lock required " + attempt + " retries", null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getAdminQueueAccess(MQSession,int)", adminQueue);
        }
        return adminQueue;
    }

    byte[] createSessionName(MQSession mqts) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "createSessionName(MQSession)", new Object[]{mqts});
        }
        if (this.brokerSubStore != null) {
            byte[] traceRet1 = this.brokerSubStore.createSessionName(mqts);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "createSessionName(MQSession)", traceRet1, 1);
            }
            return traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "createSessionName(MQSession)", null, 2);
        }
        return null;
    }

    private MQMsg2 sendBrokerMessage(MQSession mqs, MQMsg2 jmsMessage, MQPutMessageOptions pmo, boolean deferred, int fiqBehaviour) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "sendBrokerMessage(MQSession,MQMsg2,MQPutMessageOptions,boolean,int)", new Object[]{mqs, jmsMessage, pmo, deferred, new Integer(fiqBehaviour)});
        }
        MQQueue brokerQ = null;
        try {
            BrokerConnectionInfo brk = mqs.getBrk();
            try {
                try {
                    int openOptions = 16;
                    MQQueueManager qm = mqs.getQM();
                    if (pmo == null) {
                        pmo = new MQPutMessageOptions();
                    }
                    if (fiqBehaviour == 1) {
                        openOptions |= 0x2000;
                        pmo.options |= 0x2000;
                    }
                    if (deferred) {
                        MQQueueManager spiQm = qm;
                        if (!spiQm.spiSupportsDeferred()) {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "sendBrokerMessage(MQSession,MQMsg2,MQPutMessageOptions,boolean,int)", null, 1);
                            }
                            return null;
                        }
                        brokerQ = spiQm.accessQueue(brk.controlQ, openOptions, brk.qmName, null, null);
                        brokerQ.spiDeferredPut(jmsMessage, pmo);
                    } else {
                        brokerQ = mqs.getQM().accessQueue(brk.controlQ, openOptions, brk.qmName, null, null);
                        brokerQ.putMsg2(jmsMessage, pmo);
                    }
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "sendBrokerMessage(MQSession,MQMsg2,MQPutMessageOptions,boolean,int)", mqe, 1);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS2008", brk.controlQ);
                    je.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.traceData(this, "Failed to MQPUT broker command.", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "sendBrokerMessage(MQSession,MQMsg2,MQPutMessageOptions,boolean,int)", je, 1);
                    }
                    throw je;
                }
                try {
                    brokerQ.close();
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "sendBrokerMessage(MQSession,MQMsg2,MQPutMessageOptions,boolean,int)", mqe, 2);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS2000");
                    je.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.traceData(this, "Failed to close broker queue.", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "sendBrokerMessage(MQSession,MQMsg2,MQPutMessageOptions,boolean,int)", je, 2);
                    }
                    throw je;
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "sendBrokerMessage(MQSession,MQMsg2,MQPutMessageOptions,boolean,int)", je, 3);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Failed to put message to broker queue.", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "sendBrokerMessage(MQSession,MQMsg2,MQPutMessageOptions,boolean,int)", je, 3);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "sendBrokerMessage(MQSession,MQMsg2,MQPutMessageOptions,boolean,int)", je, 4);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "sendBrokerMessage(MQSession,MQMsg2,MQPutMessageOptions,boolean,int)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "sendBrokerMessage(MQSession,MQMsg2,MQPutMessageOptions,boolean,int)", (Object)jmsMessage, 2);
        }
        return jmsMessage;
    }

    private MQBrokerMessage getBrokerResponse(MQSession mqs, MQMsg2 sentMessage) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)", new Object[]{mqs, sentMessage});
        }
        MQBrokerMessage responseMessage = null;
        MQMsg2 qResponse = null;
        MQQueue replyQ = null;
        MQGetMessageOptions brokerResponseGmo = null;
        try {
            MQBrokerMessage sentBrokerMessage;
            if (this.getMQConnection().getBrkVersion() == 0 || this.getMQConnection().getBrkVersion() == -1) {
                responseMessage = new RFH1BrokerMessageImpl();
                sentBrokerMessage = new RFH1BrokerMessageImpl();
            } else {
                responseMessage = new RFH2BrokerMessageImpl();
                sentBrokerMessage = new RFH2BrokerMessageImpl();
            }
            qResponse = new MQMsg2();
            qResponse.setCorrelationId(sentMessage.getMessageId());
            try {
                replyQ = mqs.getResponseQueue();
                brokerResponseGmo = new MQGetMessageOptions();
                brokerResponseGmo.options = 1;
                brokerResponseGmo.waitInterval = 120000;
                if (this.getMQConnection().getFailIfQuiesce() == 1) {
                    brokerResponseGmo.options |= 0x2000;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "setting broker timeout to 120000", null);
                }
                replyQ.getMsg2(qResponse, brokerResponseGmo);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)", e, 1);
                }
                String key = "MQJMS5053";
                String msg = ConfigEnvironment.getErrorMessage(key);
                NoBrokerResponseException je = new NoBrokerResponseException(msg, key);
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)", (Throwable)((Object)je), 1);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "got broker response", null);
            }
            responseMessage.initializeFromMessage(qResponse);
            sentBrokerMessage.initializeFromMessage(sentMessage);
            if (sentBrokerMessage.isOptionSet("MQPSRegOpts", 65536) && Integer.parseInt(responseMessage.get("MQPSCompCode")) != 2 && sentBrokerMessage.get("MQPSTopic") == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Full response didn't work, using workaround and setting fail", null);
                }
                responseMessage.set("MQPSCompCode", Integer.toString(2));
                responseMessage.set("MQPSReason", Integer.toString(2337));
                responseMessage.set("MQPSReasonText", "MQRC_RFH_PARM_ERROR");
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2)", responseMessage);
        }
        return responseMessage;
    }

    /*
     * Loose catch block
     */
    private void removeQueueSubscription(MQSession mqs, MQQueueSubscription oldSubscription) throws JMSException {
        block37: {
            MQQueue adminQueue;
            block36: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)", new Object[]{mqs, oldSubscription});
                }
                adminQueue = null;
                MQQueue subscriberQueue = null;
                MQQueueSubscription currentEntry = null;
                byte[] subscriberId = null;
                String key = null;
                MQGetMessageOptions gmo = null;
                int fiqBehaviour = 1;
                if (oldSubscription.getMQTopic() != null) {
                    fiqBehaviour = oldSubscription.getMQTopic().getIntProperty("failIfQuiesce");
                } else if (mqs != null) {
                    fiqBehaviour = mqs.getFailIfQuiesce();
                }
                adminQueue = this.getAdminQueueAccess(mqs, fiqBehaviour);
                subscriberId = oldSubscription.getCorrelationId();
                key = oldSubscription.getSubName();
                gmo = new MQGetMessageOptions();
                if (subscriberId == null) {
                    gmo.options = 16;
                }
                boolean carryOn = true;
                if (this.getMQConnection().getFailIfQuiesce() == 1) {
                    gmo.options |= 0x2000;
                }
                while (carryOn) {
                    try {
                        MQMessage msg = new MQMessage();
                        if (subscriberId != null) {
                            msg.messageId = subscriberId;
                            gmo.matchOptions |= 1;
                        }
                        adminQueue.get(msg, gmo);
                        currentEntry = new MQQueueSubscription(this, oldSubscription.getMQSession(), msg);
                        if (subscriberId != null) {
                            carryOn = false;
                            continue;
                        }
                        if (currentEntry.isValid() && currentEntry.getSubName().equals(key)) {
                            gmo.options = 256;
                            MQMessage delmsg = new MQMessage();
                            adminQueue.get(delmsg, gmo);
                            carryOn = false;
                            continue;
                        }
                        gmo.options = 32;
                        if (this.getMQConnection().getFailIfQuiesce() != 1) continue;
                        gmo.options |= 0x2000;
                    }
                    catch (MQException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)", e, 1);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS3013");
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.traceData(this, "In removeSubscriptionEntry() - cannot remove msg!", null);
                        }
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)", je, 1);
                        }
                        throw je;
                    }
                }
                try {
                    if (oldSubscription.getSubscriberQueue() != null) {
                        subscriberQueue = oldSubscription.getSubscriberQueue();
                        subscriberQueue.close();
                        subscriberQueue = null;
                    }
                }
                catch (MQException me) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)", me, 2);
                    }
                    JMSException je2 = ConfigEnvironment.newException("MQJMS1032", new Integer(me.reasonCode));
                    je2.setLinkedException((Exception)((Object)me));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)", je2, 2);
                    }
                    throw je2;
                }
                Object var14_16 = null;
                if (!Trace.isOn) break block36;
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)");
            }
            try {
                if (adminQueue != null) {
                    adminQueue.close();
                }
                break block37;
            }
            catch (MQException me) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)", me, 4);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "error closing adminQueue - tracing exception only", null);
                }
                break block37;
            }
            {
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)", je, 3);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)", je, 3);
                    }
                    throw je;
                }
            }
            catch (Throwable throwable) {
                block38: {
                    Object var14_17 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)");
                    }
                    try {
                        if (adminQueue != null) {
                            adminQueue.close();
                        }
                    }
                    catch (MQException me) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)", me, 4);
                        }
                        if (!Trace.isOn) break block38;
                        Trace.traceData(this, "error closing adminQueue - tracing exception only", null);
                    }
                }
                throw throwable;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "removeQueueSubscription(MQSession,MQQueueSubscription)");
        }
    }

    /*
     * Unable to fully structure code
     */
    private MQBrokerSubscription getMigratedSubscription(MQQueueSubscription oldSubscription, MQSession mqs, String subName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", new Object[]{oldSubscription, mqs, subName});
        }
        fullName = null;
        escapedQMgrName = null;
        escapedClientID = null;
        escapedSubName = null;
        escapedSelector = null;
        userSubData = null;
        newSubscription = null;
        brokerMessage = null;
        brokerResponse = null;
        regOpts = 0;
        jmsMessage = null;
        deferredMsgId = null;
        cancelDeferred = false;
        selector = null;
        subscriberQueue = null;
        brk = null;
        rc = 0;
        filter = null;
        try {
            brk = mqs.getBrk();
            escapedQMgrName = WMQCommonUtils.escapeString(oldSubscription.getQmgrName());
            escapedClientID = WMQCommonUtils.escapeString(this.getMQConnection().getClientID());
            escapedSubName = WMQCommonUtils.escapeString(subName);
            fullName = "JMS:" + escapedQMgrName + ":" + escapedClientID + ":" + escapedSubName;
            if (Trace.isOn) {
                Trace.traceData(this, "Fullname = '" + fullName + "'", null);
            }
            if ((selector = oldSubscription.getSelector()) != null && !selector.trim().equals("")) {
                escapedSelector = WMQCommonUtils.escapeString(selector);
                userSubData = "sel=\"" + escapedSelector + "\"";
            } else {
                userSubData = "";
            }
            fiqBehaviour = 1;
            if (oldSubscription.getMQTopic() != null) {
                fiqBehaviour = oldSubscription.getMQTopic().getIntProperty("failIfQuiesce");
            } else if (mqs != null) {
                fiqBehaviour = mqs.getFailIfQuiesce();
            }
            try {
                try {
                    regOpts = 0x180000;
                    if (oldSubscription.isSharedQueue()) {
                        ++regOpts;
                    }
                    brokerMessage = this.getMQConnection().getBrkVersion() == 0 || this.getMQConnection().getBrkVersion() == -1 ? new RFH1BrokerMessageImpl() : new RFH2BrokerMessageImpl();
                    brokerMessage.set("MQPSCommand", "DeregSub");
                    brokerMessage.set("MQPSRegOpts", regOpts);
                    brokerMessage.set("MQPSSubName", fullName);
                    brokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(mqs.getSessionName()));
                    brokerMessage.set("MQPSQMgrName", oldSubscription.getQmgrName());
                    brokerMessage.set("MQPSQName", oldSubscription.getQueueName());
                    brokerMessage.set("MQPSStreamName", brk.streamQ);
                    brokerMessage.set("MQPSTopic", oldSubscription.getTopic());
                    filter = oldSubscription.getFilter();
                    if (filter != null) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "setting filter to " + filter, null);
                        }
                        brokerMessage.set("MQPSFilter", filter);
                    }
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 1);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "error composing update MQBrokerMessage", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 1);
                    }
                    throw je;
                }
                try {
                    jmsMessage = new MQMsg2();
                    brokerMessage.writeToMessage(jmsMessage);
                    jmsMessage.setCorrelationId(oldSubscription.getCorrelationId());
                    jmsMessage.setReplyToQueueManagerName("");
                    jmsMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                    jmsMessage.setFormat(brokerMessage.getHeaderFormat());
                    jmsMessage.setMessageType(8);
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", e, 2);
                    }
                    if (e instanceof JMSException) {
                        je = (JMSException)e;
                    } else {
                        je = ConfigEnvironment.newException(e.getMessage());
                        je.setLinkedException(e);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "error building deferred deregister MQMsg2", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 2);
                    }
                    throw je;
                }
                try {
                    jmsMessage = this.sendBrokerMessage(mqs, jmsMessage, null, true, fiqBehaviour);
                    cancelDeferred = true;
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 3);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "error sending deferred broker message", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 3);
                    }
                    throw je;
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 4);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "error attempting to put deferred deregister", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 4);
                }
                throw je;
            }
            deferredMsgId = jmsMessage.getMessageId();
            try {
                try {
                    regOpts = 0x114000;
                    regOpts = this.WSClone == 1 ? (regOpts += 131072) : (regOpts += 262144);
                    if (mqs.acknowledgeMode == 3 && this.getMQConnection().getBrkOptLevel() > 0) {
                        regOpts += 512;
                    }
                    if (oldSubscription.isSharedQueue()) {
                        ++regOpts;
                    }
                    brokerMessage = this.getMQConnection().getBrkVersion() == 0 || this.getMQConnection().getBrkVersion() == -1 ? new RFH1BrokerMessageImpl() : new RFH2BrokerMessageImpl();
                    brokerMessage.set("MQPSCommand", "RegSub");
                    brokerMessage.set("MQPSRegOpts", regOpts);
                    brokerMessage.set("MQPSSubName", fullName);
                    brokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(mqs.getSessionName()));
                    brokerMessage.set("MQPSQMgrName", oldSubscription.getQmgrName());
                    brokerMessage.set("MQPSQName", oldSubscription.getQueueName());
                    brokerMessage.set("MQPSStreamName", brk.streamQ);
                    brokerMessage.set("MQPSTopic", oldSubscription.getTopic());
                    brokerMessage.set("MQPSSubUserData", userSubData);
                    filter = oldSubscription.getFilter();
                    if (filter != null) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "setting filter to " + filter, null);
                        }
                        brokerMessage.set("MQPSFilter", filter);
                    }
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 5);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "error composing update MQBrokerMessage", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 5);
                    }
                    throw je;
                }
                try {
                    jmsMessage = new MQMsg2();
                    brokerMessage.writeToMessage(jmsMessage);
                    jmsMessage.setCorrelationId(oldSubscription.getCorrelationId());
                    jmsMessage.setReplyToQueueManagerName("");
                    jmsMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                    jmsMessage.setFormat(brokerMessage.getHeaderFormat());
                    jmsMessage.setMessageType(1);
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", e, 6);
                    }
                    if (e instanceof JMSException) {
                        je = (JMSException)e;
                    } else {
                        je = ConfigEnvironment.newException(e.getMessage());
                        je.setLinkedException(e);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "error building broker update MQMsg2", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 6);
                    }
                    throw je;
                }
                try {
                    jmsMessage = this.sendBrokerMessage(mqs, jmsMessage, null, false, fiqBehaviour);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 7);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "error sending update subscription message to broker", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 7);
                    }
                    throw je;
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 8);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "error sending broker update message", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 8);
                }
                throw je;
            }
            try {
                if (this.getMQConnection().getBrkVersion() == 0 || this.getMQConnection().getBrkVersion() == -1) {
                    brokerResponse = new RFH1BrokerMessageImpl();
                    brokerResponse = (RFH1BrokerMessageImpl)this.getBrokerResponse(mqs, jmsMessage);
                } else {
                    brokerResponse = new RFH2BrokerMessageImpl();
                    brokerResponse = (RFH2BrokerMessageImpl)this.getBrokerResponse(mqs, jmsMessage);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "got update response from broker", null);
                }
                cc = Integer.parseInt(brokerResponse.get("MQPSCompCode"));
                rc = Integer.parseInt(brokerResponse.get("MQPSReason"));
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 9);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "error getting response from broker update message", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 9);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "requested full Response. Did we get it?", null);
            }
            if ((brokerResponse.get("MQPSTopic") == null || brokerResponse.get("MQPSTopic").equals("")) && cc != 2) {
                if (Trace.isOn) {
                    Trace.traceData(this, "No full Response. This should be a failure", null);
                }
                cc = 2;
                rc = 2337;
            }
            switch (cc) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    if (rc != 3083 && rc != 2337) ** GOTO lbl228
                    this.useBrokerSubStore = 0;
                    try {
                        this.brokerSubStore.close();
                    }
                    catch (Exception e2) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", e2, 10);
                        }
                        if (!Trace.isOn) ** GOTO lbl227
                        Trace.traceData(this, "error attempting to close brokerSubStore", null);
                    }
lbl227:
                    // 3 sources

                    this.brokerSubStore = null;
                }
lbl228:
                // 3 sources

                default: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "something went wrong updating the subscription", null);
                        Trace.traceData(this, brokerResponse.get("MQPSReasonText"), null);
                    }
                    traceRet1 = new JMSException(brokerResponse.get("MQPSReasonText"));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", traceRet1, 10);
                    }
                    throw traceRet1;
                }
            }
            try {
                qMgrName = brokerResponse.get("MQPSQMgrName").trim();
                queueName = brokerResponse.get("MQPSQName").trim();
                correlId = brokerResponse.get("MQPSCorrelId").trim();
                newSubscription = new MQBrokerSubscription(this, mqs, true, oldSubscription.isSharedQueue(), qMgrName, this.getMQConnection().getClientID(), subName, oldSubscription.getMQTopic(), oldSubscription.getSelector(), oldSubscription.getNoLocal(), queueName, null, Utils.hexToBytes(correlId));
                subscriberQueue = this.openSubscriberQueue(mqs, queueName, oldSubscription.isSharedQueue(), true, fiqBehaviour);
                newSubscription.setSubscriberQueue(subscriberQueue);
                newSubscription.setDeferredMsgId(deferredMsgId);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 11);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "error creating new MQBrokerSubscription object from migrated subscription", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 11);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", newSubscription);
            }
            return newSubscription;
        }
        catch (JMSException je) {
            block100: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 12);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "error encountered while trying to migrate subscription.", null);
                }
                if (cancelDeferred) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "cancelling deferred message", null);
                    }
                    try {
                        qm = mqs.getQM();
                        if (!(qm instanceof MQQueueManager)) {
                            je2 = new JMSException("MQJMS3047");
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je2, 12);
                            }
                            throw je2;
                        }
                        spiQm = qm;
                        spiQm.spiCancelDeferred(deferredMsgId);
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", e, 13);
                        }
                        if (e instanceof JMSException) {
                            je3 = (JMSException)e;
                        } else {
                            je3 = new JMSException(e.getMessage());
                            je3.setLinkedException(e);
                        }
                        if (!Trace.isOn) break block100;
                        Trace.traceData(this, "error cancelling deferred deregister message.", null);
                    }
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "getMigratedSubscription(MQQueueSubscription,MQSession,String)", je, 13);
            }
            throw je;
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQMigrateSubscriptionEngine", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQMigrateSubscriptionEngine.java, jmscc.wmq.v6, k701, k701-112-140304  1.29.1.1 09/08/17 08:11:34");
        }
    }
}

