/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.disthub2.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthub2.impl.matching.FormattedMessage;
import com.ibm.disthub2.impl.matching.MatchingContext;
import com.ibm.disthub2.impl.matching.selector.BooleanValue;
import com.ibm.disthub2.impl.matching.selector.EvalContext;
import com.ibm.disthub2.impl.matching.selector.Evaluator;
import com.ibm.disthub2.impl.matching.selector.MatchParser;
import com.ibm.disthub2.impl.matching.selector.Selector;
import com.ibm.disthub2.impl.matching.selector.TokenMgrError;
import com.ibm.mq.jms.SyntaxException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.SelectorDataAccessor;
import javax.jms.JMSException;

class MQMessageSelector {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#)  com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQMessageSelector.java, jmscc.wmq.v6, k701, k701-112-140304 1.23.1.3 12/06/08 16:00:21";
    private static final String JMSCORRELATIONID = "JMSCorrelationID";
    private static final String JMSMESSAGEID = "JMSMessageID";
    private static final int ID_LENGTH = 24;
    private MatchParser matchParser = null;
    private Selector selectorTree = null;
    private String specialSelector = null;

    public MQMessageSelector() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "<init>()");
        }
    }

    public String getSelector() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "getSelector()");
        }
        String selector = this.selectorTree == null ? this.specialSelector : this.selectorTree.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "getSelector()", selector);
        }
        return selector;
    }

    public boolean isSelected(JMSMessage msgJMS, MQMsg2 msgMQSeries) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "isSelected(com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", new Object[]{msgJMS, msgMQSeries});
        }
        try {
            boolean bResult;
            block17: {
                if (this.selectorTree == null) {
                    bResult = true;
                } else if (msgJMS == null) {
                    bResult = false;
                } else {
                    try {
                        SelectorDataAccessor formattedMessage = new SelectorDataAccessor(msgJMS, msgMQSeries);
                        MatchingContext evalContext = new MatchingContext();
                        evalContext.setMessage((FormattedMessage)formattedMessage);
                        Object result = Evaluator.eval((Selector)this.selectorTree, (EvalContext)evalContext, (boolean)false);
                        if (result instanceof BooleanValue) {
                            bResult = ((BooleanValue)result).booleanValue();
                            break block17;
                        }
                        if (result == null) {
                            bResult = false;
                            break block17;
                        }
                        JMSException traceRet1 = new JMSException("Need a message here");
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "isSelected(com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", traceRet1, 1);
                        }
                        throw traceRet1;
                    }
                    catch (BadMessageFormatMatchingException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "isSelected(com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", e, 1);
                        }
                        boolean bResult2 = false;
                        JMSException traceRet2 = new JMSException(e.toString());
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "isSelected(com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", traceRet2, 2);
                        }
                        throw traceRet2;
                    }
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "isSelected(com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", bResult);
            }
            return bResult;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "isSelected(com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "isSelected(com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je, 3);
            }
            throw je;
        }
    }

    public void setSelector(String selector) throws SyntaxException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "setSelector(String)", "setter", selector);
        }
        this.setSelector(selector, null);
    }

    public boolean setSelector(String selector, MQMsg2 mqmsg2) throws SyntaxException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "setSelector(String,MQMsg2)", new Object[]{selector, mqmsg2});
        }
        boolean traceRet1 = this.setSelector(selector, mqmsg2, null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "setSelector(String,MQMsg2)", traceRet1);
        }
        return traceRet1;
    }

    public boolean setSelector(String selector, MQMsg2 mqmsg2, MQGetMessageOptions gmo) throws SyntaxException {
        boolean bSpecialCase;
        block40: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "setSelector(String,MQMsg2,MQGetMessageOptions)", new Object[]{selector, mqmsg2, gmo});
            }
            bSpecialCase = false;
            if (selector != null && selector.trim().length() == 0) {
                if (Trace.isOn) {
                    Trace.traceData(this, "blank selector changed to null", null);
                }
                selector = null;
            }
            if (selector == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "setSelector(String,MQMsg2,MQGetMessageOptions)", bSpecialCase, 1);
                }
                return bSpecialCase;
            }
            if (mqmsg2 != null && selector != null && selector.length() > 0) {
                String tokens = new String(selector.trim());
                try {
                    byte[] id = null;
                    byte[] msgId = null;
                    byte[] correlId = null;
                    int idLength = 0;
                    boolean bId = false;
                    if (tokens.startsWith(JMSCORRELATIONID)) {
                        tokens = tokens.substring(JMSCORRELATIONID.length()).trim();
                        idLength = 24;
                        bId = true;
                        id = correlId = new byte[idLength];
                        if (gmo != null) {
                            gmo.matchOptions |= 2;
                        }
                    }
                    if (tokens.startsWith(JMSMESSAGEID)) {
                        tokens = tokens.substring(JMSMESSAGEID.length()).trim();
                        idLength = 24;
                        bId = true;
                        msgId = new byte[idLength];
                        id = msgId;
                        if (gmo != null) {
                            gmo.matchOptions |= 1;
                        }
                    }
                    if (bId && tokens.charAt(0) == '=' && (tokens = tokens.substring(1).trim()).startsWith("'ID:")) {
                        boolean bHex = false;
                        if ((tokens = tokens.substring(4).toLowerCase()).length() == idLength * 2 + 1 && tokens.charAt(idLength * 2) == '\'') {
                            bHex = true;
                            for (int i = 0; i < 24; ++i) {
                                int n = 0;
                                char c1 = tokens.charAt(i * 2);
                                if (c1 >= '0' && c1 <= '9') {
                                    n += c1 - 48;
                                } else if (c1 >= 'a' && c1 <= 'f') {
                                    n += c1 - 97 + 10;
                                } else {
                                    bHex = false;
                                }
                                n *= 16;
                                char c2 = tokens.charAt(i * 2 + 1);
                                if (c2 >= '0' && c2 <= '9') {
                                    n += c2 - 48;
                                } else if (c2 >= 'a' && c2 <= 'f') {
                                    n += c2 - 97 + 10;
                                } else {
                                    bHex = false;
                                }
                                id[i] = (byte)n;
                            }
                        }
                        if (bHex) {
                            bSpecialCase = true;
                        }
                    }
                    if (msgId != null) {
                        mqmsg2.setMessageId(msgId);
                    } else if (correlId != null) {
                        mqmsg2.setCorrelationId(correlId);
                    }
                }
                catch (StringIndexOutOfBoundsException e) {
                    if (!Trace.isOn) break block40;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "setSelector(String,MQMsg2,MQGetMessageOptions)", e, 1);
                }
            }
        }
        if (bSpecialCase) {
            if (Trace.isOn) {
                Trace.traceData(this, "Selector is a special case.", null);
            }
            this.specialSelector = selector;
        } else {
            selector = this.parseOctal(selector);
            this.matchParser = MatchParser.prime(null, (String)selector, (boolean)true);
            try {
                this.selectorTree = this.matchParser.getSelector();
                if (Trace.isOn) {
                    Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "setSelector(String,MQMsg2,MQGetMessageOptions)", "selectorTree: ", this.selectorTree.toString());
                }
            }
            catch (TokenMgrError e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "setSelector(String,MQMsg2,MQGetMessageOptions)", e, 2);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Selector was Invalid", null);
                }
                String key = "MQJMS0004";
                String msg = ConfigEnvironment.getErrorMessage(key);
                SyntaxException je = new SyntaxException(msg);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "setSelector(String,MQMsg2,MQGetMessageOptions)", je, 1);
                }
                throw je;
            }
            if (this.selectorTree.type == 2) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Selector was Invalid", null);
                }
                String key = "MQJMS0004";
                String msg = ConfigEnvironment.getErrorMessage(key);
                SyntaxException je = new SyntaxException(msg);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "setSelector(String,MQMsg2,MQGetMessageOptions)", je, 2);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "setSelector(String,MQMsg2,MQGetMessageOptions)", bSpecialCase, 2);
        }
        return bSpecialCase;
    }

    private String parseOctal(String s) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "parseOctal(String)", new Object[]{s});
        }
        String bodged = null;
        if (s != null) {
            String[] elements = s.split("=");
            if (elements.length == 2) {
                elements[0] = elements[0].trim();
                elements[1] = elements[1].trim();
                if (elements[1].startsWith("0") && !elements[1].startsWith("0x")) {
                    try {
                        long decimal = Long.decode(elements[1]);
                        bodged = elements[0] + "=" + Long.toString(decimal);
                    }
                    catch (NumberFormatException nfe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "parseOctal(String)", nfe);
                        }
                        bodged = s;
                    }
                } else {
                    bodged = s;
                }
            } else {
                bodged = s;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "parseOctal(String)", bodged);
        }
        return bodged;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQMessageSelector.java, jmscc.wmq.v6, k701, k701-112-140304  1.23.1.3 12/06/08 16:00:21");
        }
    }
}

