/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageReference;
import com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.jms.JMSException;

class MQMessageReference
implements ProviderMessageReference,
Cloneable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#)  com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQMessageReference.java, jmscc.wmq.v6, k701, k701-112-140304 1.26.1.9 12/01/24 09:11:59";
    private static final long prime1 = 2147483587L;
    private static final long prime2 = Integer.MAX_VALUE;
    private JMSMessage jmsMessage = null;
    private MQJMSMessage mqjmsMessage = null;
    private byte[] messageId = null;
    private byte[] correlId = null;
    private int msgDataLength = 0;
    private int msgHeaderLength = 0;
    private int hashcode = -1;
    private boolean wanted = true;
    private String referenceQueue = null;
    private int domain = 0;
    private int version = 3;
    private static final String FLATTENED_HEADER = "MQMR";
    private static final byte[] FLATTENED_HEADER_AS_BYTES;
    protected static final int MSGREF_VERSION_3 = 3;
    public static final byte OPT_FIELD_MSG_TOKEN = 1;
    protected byte optionalFields = 0;
    private byte[] msgToken = null;
    private static final int MSGREF_DOMAIN_PTP = 0;
    private int dataQuantity = 0;
    private ProviderDestination destination;
    private static final String ASCII = "ASCII";
    private long browseTime;
    private MQSession session = null;
    private int backoutCount = 0;

    MQMessageReference(MQSession session) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "<init>(MQSession)", new Object[]{session});
        }
        this.session = session;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "<init>(MQSession)");
        }
    }

    private MQMessageReference() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "<init>()");
        }
    }

    private static int checkEyeCatcherAndVersion(DataInputStream dis) throws IOException, JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "checkEyeCatcherAndVersion(DataInputStream)", new Object[]{dis});
        }
        byte[] eyeBytes = new byte[4];
        dis.readFully(eyeBytes);
        String header = new String(eyeBytes, ASCII);
        if (!FLATTENED_HEADER.equals(header)) {
            if (Trace.isOn) {
                Trace.traceData("MQMessageReference", "Invalid MessageReferenceHeader.", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1096");
            if (Trace.isOn) {
                Trace.throwing(null, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "checkEyeCatcherAndVersion(DataInputStream)", je, 1);
            }
            throw je;
        }
        int version = dis.readInt();
        if (version != 3) {
            if (Trace.isOn) {
                Trace.traceData("MQMessageReference", "Error. Unrecognised messageReference version.", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1098");
            if (Trace.isOn) {
                Trace.throwing(null, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "checkEyeCatcherAndVersion(DataInputStream)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "checkEyeCatcherAndVersion(dis)", new Integer(version));
        }
        return version;
    }

    MQMessageReference(MQSession session, byte[] flatMR, ProviderDestination dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "<init>(MQSession,byte [ ],ProviderDestination)", new Object[]{session, flatMR, dest});
        }
        this.session = session;
        try {
            ByteArrayInputStream newByteStream = new ByteArrayInputStream(flatMR);
            DataInputStream dataStream = new DataInputStream(newByteStream);
            this.messageId = new byte[24];
            this.correlId = new byte[24];
            this.msgToken = new byte[16];
            this.version = MQMessageReference.checkEyeCatcherAndVersion(dataStream);
            this.optionalFields = dataStream.readByte();
            if ((this.optionalFields & 1) == 1) {
                newByteStream.read(this.msgToken, 0, 16);
            }
            newByteStream.read(this.messageId, 0, 24);
            newByteStream.read(this.correlId, 0, 24);
            String destinationURI = MQMessageReference.reinflateString(dataStream);
            WMQDestinationURIParser uriParser = new WMQDestinationURIParser(destinationURI);
            this.domain = uriParser.getDomain();
            this.destination = dest;
            this.msgDataLength = dataStream.readInt();
            this.msgHeaderLength = dataStream.readInt();
            this.referenceQueue = MQMessageReference.reinflateString(dataStream);
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "<init>(MQSession,byte [ ])", ioe);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1096");
            je.setLinkedException((Exception)ioe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "<init>(MQSession,byte [ ])", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "<init>(MQSession,byte [ ])");
        }
    }

    MQJMSMessage getMQJMSMessage() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getMQJMSMessage()", "getter", (Object)this.mqjmsMessage);
        }
        return this.mqjmsMessage;
    }

    void setMQJMSMessage(MQJMSMessage message, int dataQuantity, int msgHeaderLength) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setMQJMSMessage(MQJMSMessage,int,int)", new Object[]{message, new Integer(dataQuantity), new Integer(msgHeaderLength)});
        }
        this.mqjmsMessage = message;
        this.jmsMessage = null;
        this.dataQuantity = dataQuantity;
        this.msgDataLength = message.getMessageDataLength();
        if (Trace.isOn) {
            Trace.traceData(this, "message length: ", (Object)new Integer(this.msgDataLength));
        }
        this.msgHeaderLength = msgHeaderLength;
        if (Trace.isOn) {
            Trace.traceData(this, "header length:  ", (Object)new Integer(this.msgHeaderLength));
        }
        if (this.mqjmsMessage != null) {
            if (this.mqjmsMessage.getMessageId() != null) {
                this.messageId = this.mqjmsMessage.getMessageId();
                this.correlId = this.mqjmsMessage.getCorrelationId();
                this.hashcode = 0;
                byte[] temp = new byte[8];
                int i = 0;
                while (i + 8 <= this.messageId.length) {
                    System.arraycopy(this.messageId, i, temp, 0, 8);
                    this.hashcode ^= this.hash8bytes(temp);
                    i += 8;
                }
            }
            this.backoutCount = this.mqjmsMessage.getBackoutCount();
        } else {
            this.messageId = null;
            this.correlId = null;
            this.msgDataLength = 0;
            this.msgHeaderLength = 0;
            this.hashcode = -1;
            this.backoutCount = 0;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setMQJMSMessage(MQJMSMessage,int,int)");
        }
    }

    void setJMSMessage(ProviderMessage message, int dataQuantity) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setJMSMessage(ProviderMessage,int)", new Object[]{message, new Integer(dataQuantity)});
        }
        this.jmsMessage = (JMSMessage)message;
        this.mqjmsMessage = null;
        this.dataQuantity = dataQuantity;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setJMSMessage(ProviderMessage,int)");
        }
    }

    private int hash8bytes(byte[] bytes) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "hash8bytes(byte [ ])", new Object[]{bytes});
        }
        int i1 = bytes[0] & 0xFF;
        int i2 = (bytes[1] & 0xFF) << 8;
        int i3 = (bytes[2] & 0xFF) << 16;
        long l4 = (long)(bytes[3] & 0xFF) << 24;
        long w1 = (long)(i1 + i2 + i3) + l4 | 0x40404040L;
        w1 *= 2147483587L;
        w1 = w1 >>> 32 ^ w1 & 0xFFFFFFFFL;
        i1 = bytes[4] & 0xFF;
        i2 = (bytes[5] & 0xFF) << 8;
        i3 = (bytes[6] & 0xFF) << 16;
        l4 = (long)(bytes[7] & 0xFF) << 24;
        long w2 = (long)(i1 + i2 + i3) + l4 | 0x40404040L;
        w2 *= Integer.MAX_VALUE;
        w2 = w2 >>> 32 ^ w2 & 0xFFFFFFFFL;
        w1 *= w2;
        w1 = w1 >>> 32 ^ w1 & 0xFFFFFFFFL;
        int traceRet1 = (int)w1;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "hash8bytes(byte [ ])", new Integer(traceRet1));
        }
        return traceRet1;
    }

    byte[] getMessageId() {
        byte[] result = null;
        if (this.messageId != null) {
            result = new byte[this.messageId.length];
            System.arraycopy(this.messageId, 0, result, 0, this.messageId.length);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getMessageId()", "getter", result);
        }
        return result;
    }

    byte[] getCorrelId() {
        byte[] result = null;
        if (this.correlId != null) {
            result = new byte[this.correlId.length];
            System.arraycopy(this.correlId, 0, result, 0, this.correlId.length);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getCorrelId()", "getter", result);
        }
        return result;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof MQMessageReference) {
            MQMessageReference mr = (MQMessageReference)o;
            if (mr.messageId != null && this.messageId != null && mr.hashcode == this.hashcode && mr.messageId.length == this.messageId.length) {
                result = Arrays.equals(mr.messageId, this.messageId);
            }
        }
        return result;
    }

    boolean matches(MQMessageSelector selector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "matches(MQMessageSelector)", new Object[]{selector});
        }
        boolean result = false;
        try {
            result = selector.isSelected(this.getJMSMessage(), this.mqjmsMessage);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "matches(MQMessageSelector)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "matches(MQMessageSelector)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "matches(MQMessageSelector)", result);
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Version=" + this.version);
        buf.append("\nmessageId=");
        buf.append(Utils.bytesToHex(this.messageId));
        buf.append("\ncorrelId =");
        buf.append(Utils.bytesToHex(this.correlId));
        buf.append("\njmsMessage=" + (this.jmsMessage == null ? "unset" : "set"));
        buf.append("\nmsgDataLength=" + this.msgDataLength);
        buf.append("\nmsgHeaderLength=" + this.msgHeaderLength);
        buf.append("\nreferenceQueue= " + (this.referenceQueue == null ? "unset" : this.referenceQueue));
        buf.append("\nmqjmsMessage=" + (this.mqjmsMessage == null ? "null" : ((Object)((Object)this.mqjmsMessage)).toString()));
        String traceRet1 = buf.toString();
        return traceRet1;
    }

    public int getDataQuantity() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getDataQuantity()", "getter", new Integer(this.dataQuantity));
        }
        return this.dataQuantity;
    }

    JMSMessage getJMSMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getJMSMessage()");
        }
        try {
            switch (this.dataQuantity) {
                case 0: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "dataQuantity is NO_DATA; returning null", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getJMSMessage()", null, 1);
                    }
                    return null;
                }
                case 1: {
                    if (this.jmsMessage != null) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "dataQuantity is HEADER_DATA; returning existing message", null);
                            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getJMSMessage()", this.jmsMessage, 4);
                        }
                        return this.jmsMessage;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "dataQuantity is HEADER_DATA; returning new message", null);
                    }
                    this.jmsMessage = this.mqjmsMessage.createJMSMessage(this.session, this.destination, 1);
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getJMSMessage()", this.jmsMessage, 5);
                    }
                    return this.jmsMessage;
                }
                case 2: {
                    if (this.jmsMessage != null) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "dataQuantity is FULL_DATA; returning existing message", null);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getJMSMessage()", this.jmsMessage, 2);
                        }
                        return this.jmsMessage;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "dataQuantity is FULL_DATA; returning new message", null);
                    }
                    JMSMessage traceRet2 = this.jmsMessage = this.mqjmsMessage.createJMSMessage(this.session, this.destination);
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getJMSMessage()", traceRet2, 3);
                    }
                    return traceRet2;
                }
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Bad dataQuantity " + this.dataQuantity, null);
            }
            IllegalStateException traceRet3 = new IllegalStateException(ConfigEnvironment.getErrorMessage("MQJMS0006"));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getJMSMessage()", traceRet3, 2);
            }
            throw traceRet3;
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getJMSMessage()", ioe);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS0006");
            je.setLinkedException((Exception)ioe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getJMSMessage()", je, 3);
            }
            throw je;
        }
    }

    public ProviderMessage getMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getMessage()");
        }
        switch (this.dataQuantity) {
            case 0: {
                if (Trace.isOn) {
                    Trace.traceData(this, "dataQuantity is NO_DATA; returning null", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getMessage()", null, 1);
                }
                return null;
            }
            case 1: {
                if (this.jmsMessage != null) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "dataQuantity is HEADER_DATA; returning existing message", null);
                    }
                    return this.jmsMessage;
                }
                IllegalStateException ise = new IllegalStateException("MQMessageReference message not parsed yet");
                if (Trace.isOn) {
                    Trace.traceData(this, "dataQuantity is HEADER_DATA but message not parsed yet; ERROR", null);
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getMessage()", ise, 1);
                }
                throw ise;
            }
            case 2: {
                if (Trace.isOn) {
                    Trace.traceData(this, "dataQuantity is HEADER_DATA or FULL_DATA; returning existing message", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getMessage()", this.jmsMessage, 2);
                }
                return this.jmsMessage;
            }
        }
        if (Trace.isOn) {
            Trace.traceData(this, "Bad dataQuantity " + this.dataQuantity, null);
        }
        IllegalStateException traceRet3 = new IllegalStateException(ConfigEnvironment.getErrorMessage("MQJMS0006"));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getMessage()", traceRet3, 2);
        }
        throw traceRet3;
    }

    public Object clone() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "clone()");
        }
        MQMessageReference newClone = new MQMessageReference();
        newClone.session = this.session;
        newClone.messageId = this.messageId;
        newClone.correlId = this.correlId;
        newClone.msgDataLength = this.msgDataLength;
        newClone.msgHeaderLength = this.msgHeaderLength;
        newClone.hashcode = this.hashcode;
        newClone.referenceQueue = this.referenceQueue;
        newClone.domain = this.domain;
        newClone.version = this.version;
        newClone.dataQuantity = 0;
        newClone.jmsMessage = null;
        newClone.mqjmsMessage = null;
        newClone.wanted = this.wanted;
        newClone.backoutCount = this.backoutCount;
        newClone.browseTime = this.browseTime;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "clone()", newClone);
        }
        return newClone;
    }

    public byte[] flatten() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "flatten()");
        }
        try {
            ByteArrayOutputStream newStream = new ByteArrayOutputStream();
            if (Trace.isOn) {
                Trace.traceData(this, "about to flatten a version " + Integer.toString(this.version) + " messageReference.", null);
            }
            newStream.write(FLATTENED_HEADER_AS_BYTES);
            newStream.write(MQMessageReference.intToByteArray(this.version));
            if (this.version == 3) {
                newStream.write(this.optionalFields);
                if ((this.optionalFields & 1) == 1) {
                    newStream.write(this.msgToken);
                }
                newStream.write(this.messageId);
                newStream.write(this.correlId);
                MQMessageReference.flattenString(newStream, this.destination.toURI());
                if (Trace.isOn) {
                    Trace.traceData(this, "writing msgDataLength= ", (Object)new Integer(this.msgDataLength));
                }
                newStream.write(MQMessageReference.intToByteArray(this.msgDataLength));
                if (Trace.isOn) {
                    Trace.traceData(this, "writing msgHeaderLength= ", (Object)new Integer(this.msgHeaderLength));
                }
                newStream.write(MQMessageReference.intToByteArray(this.msgHeaderLength));
                if (Trace.isOn) {
                    Trace.traceData(this, "writing referenceQueue= ", (Object)this.referenceQueue);
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "Error. Unrecognised messageReference version.", null);
                }
                JMSException je2 = ConfigEnvironment.newException("MQJMS1098");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "flatten()", je2, 1);
                }
                throw je2;
            }
            MQMessageReference.flattenString(newStream, this.referenceQueue);
            byte[] traceRet1 = newStream.toByteArray();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "flatten()", traceRet1);
            }
            return traceRet1;
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "flatten()", ioe, 1);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "exception thrown while attempting to write to byte[]", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1098");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "flatten()", je, 2);
            }
            throw je;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "flatten()", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "flatten()", je, 3);
            }
            throw je;
        }
    }

    private static void flattenString(ByteArrayOutputStream baos, String text) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "flattenString(ByteArrayOutputStream,String)", new Object[]{baos, text});
        }
        byte[] bytes = null;
        if (null != text) {
            bytes = text.getBytes(ASCII);
        }
        MQMessageReference.flattenBytes(baos, bytes);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "flattenString(ByteArrayOutputStream,String)");
        }
    }

    private static void flattenBytes(ByteArrayOutputStream baos, byte[] bytes) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "flattenBytes(DataOutputStream,byte [ ])", new Object[]{baos, bytes});
        }
        if (null == bytes) {
            baos.write(MQMessageReference.intToByteArray(0));
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "flattenBytes(DataOutputStream,byte [ ])");
            }
            return;
        }
        baos.write(MQMessageReference.intToByteArray(bytes.length));
        baos.write(bytes);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.internal.WMQMessageReference", "flattenBytes(DataOutputStream,byte [ ])", 2);
        }
    }

    private static byte[] reinflateBytes(DataInputStream dis) throws IOException {
        int len;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "reinflateBytes(DataInputStream)", new Object[]{dis});
        }
        if (0 > (len = dis.readInt())) {
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("len", new Integer(len));
            Trace.ffst("MQMessageReference", "reinflateString", "XN00F004", info, IOException.class);
        }
        if (0 == len) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "reinflateBytes(DataInputStream)", (Object)null, 1);
            }
            return null;
        }
        byte[] bytes = new byte[len];
        dis.readFully(bytes);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "reinflateBytes(DataInputStream)", bytes, 2);
        }
        return bytes;
    }

    private static String reinflateString(DataInputStream dis) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "reinflateString(DataInputStream)", new Object[]{dis});
        }
        byte[] bytes = MQMessageReference.reinflateBytes(dis);
        String text = null;
        if (null != bytes) {
            text = new String(bytes, ASCII);
        }
        if (Trace.isOn) {
            Trace.exit("ccom.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "reinflateString(DataInputStream)", (Object)text);
        }
        return text;
    }

    private static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public boolean checkIfOptionalFieldIsPresent(byte fieldToCheck) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "checkIfOptionalFieldIsPresent(byte)", new Object[]{new Integer(fieldToCheck)});
        }
        if ((this.optionalFields & fieldToCheck) != 0) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "checkIfOptionalFieldIsPresent(byte)", new Boolean(true), 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "checkIfOptionalFieldIsPresent(byte)", new Boolean(false), 2);
        }
        return false;
    }

    private void setOptionalFieldBit(byte fieldToSet, boolean setOn) {
        this.optionalFields = setOn ? (byte)(this.optionalFields | fieldToSet) : (byte)(this.optionalFields & ~fieldToSet);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setOptionalFieldBit(byte, boolean)", "setter", "fieldToSet: " + fieldToSet + ", setOn: " + setOn + ", optionalFields: " + this.optionalFields);
        }
    }

    void setReferenceQueue(String queueName) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setReferenceQueue(String)", "setter", queueName);
        }
        this.referenceQueue = queueName;
    }

    String getReferenceQueue() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getReferenceQueue()", "getter", this.referenceQueue);
        }
        return this.referenceQueue;
    }

    boolean isWanted() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "isWanted()", "getter", this.wanted);
        }
        return this.wanted;
    }

    void setIsWanted(boolean want) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setIsWanted(boolean)", "setter", want);
        }
        this.wanted = want;
    }

    int getDomain() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getDomain()", "getter", new Integer(this.domain));
        }
        return this.domain;
    }

    void setDomain(int domain) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setDomain(int)", "setter", new Integer(domain));
        }
        this.domain = domain;
    }

    void setBrowseTime(long time) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setBrowseTime(long)", "setter", new Long(time));
        }
        this.browseTime = time;
    }

    long getBrowseTime() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getBrowseTime()", "getter", new Long(this.browseTime));
        }
        return this.browseTime;
    }

    void setBackoutCount(int newCount) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setBackoutCount(int)", new Object[]{new Integer(newCount)});
        }
        try {
            this.backoutCount = newCount;
            if (this.mqjmsMessage != null) {
                this.mqjmsMessage.setBackoutCount(newCount);
            }
            if (this.jmsMessage != null) {
                this.jmsMessage.setJMSRedelivered(newCount != 0);
                this.jmsMessage._setJMSXDeliveryCountFromInt(newCount + 1);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setBackoutCount(int)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setBackoutCount(int)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setBackoutCount(int)");
        }
    }

    int getBackoutCount() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getBackoutCount()", "getter", new Integer(this.backoutCount));
        }
        return this.backoutCount;
    }

    public void setMsgToken(byte[] bs) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setMsgToken(byte [ ])", new Object[]{bs});
        }
        this.setOptionalFieldBit((byte)1, true);
        if (this.msgToken == null) {
            this.msgToken = new byte[16];
        }
        for (int i = 0; i < 16; ++i) {
            this.msgToken[i] = bs[i];
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setMsgToken(byte [ ])");
        }
    }

    public byte[] getMsgToken() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getMsgToken()", "getter", this.msgToken);
        }
        return this.msgToken;
    }

    public int getVersion() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getVersion()", "getter", new Integer(this.version));
        }
        return this.version;
    }

    static String getDestinationURI(byte[] flattened) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getDestinationURI(byte [ ])", new Object[]{flattened});
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(flattened);
            DataInputStream dis = new DataInputStream(bais);
            int version = MQMessageReference.checkEyeCatcherAndVersion(dis);
            if (version != 3) {
                if (Trace.isOn) {
                    Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getDestinationURI(byte [ ])", (Object)null, 1);
                }
                return null;
            }
            byte optionalFieldsByte = dis.readByte();
            if ((optionalFieldsByte & 1) == 1) {
                dis.skipBytes(16);
            }
            dis.skipBytes(48);
            String destUri = MQMessageReference.reinflateString(dis);
            dis.close();
            bais.close();
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getDestinationURI(byte [ ])", (Object)destUri, 2);
            }
            return destUri;
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getDestinationURI(byte [ ])", ioe);
            }
            JMSException je = (JMSException)((Object)NLSServices.createException("MQJMS1096", null));
            je.setLinkedException((Exception)ioe);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getDestinationURI(byte [ ])", je);
            }
            throw je;
        }
    }

    public String getDestinationAsString() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getDestinationAsString()", "getter", null);
        }
        return null;
    }

    public void setDestination(ProviderDestination dest) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "setDestination(ProviderDestination)", "setter", dest);
        }
        this.destination = dest;
    }

    ProviderDestination getDestination() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "getDestination()", "getter", this.destination);
        }
        return this.destination;
    }

    public int getMsgDataLength() {
        return this.msgDataLength;
    }

    public int getHeaderLength() {
        return this.msgHeaderLength;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQMessageReference.java, jmscc.wmq.v6, k701, k701-112-140304  1.26.1.9 12/01/24 09:11:59");
        }
        FLATTENED_HEADER_AS_BYTES = new byte[]{77, 81, 77, 82};
    }
}

