/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageProducer;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyContext;
import com.ibm.msg.client.wmq.v6.base.internal.MQC;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.SubscriptionHelper;
import java.io.IOException;
import java.util.HashMap;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

public class MQMessageProducer
extends WMQPropertyContext
implements ProviderMessageProducer {
    private static final long serialVersionUID = 3088542628007809451L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQMessageProducer.java, jmscc.wmq.v6, k701, k701-112-140304 1.64.1.3 11/03/29 14:28:10";
    private static final int JMS101_DEFAULT_VAL = -1;
    private boolean closed = false;
    private MQPutMessageOptions pmo;
    private MQSession session = null;
    private boolean setForPTP = false;
    private boolean setForPubSub = false;
    private WMQDestination queueSpec = null;
    private MQQueue queue = null;
    private MQJMSMessage mqMessage = new MQJMSMessage();
    private WMQDestination TopicSpec = null;
    private MQQueue mqPubQ = null;
    private MQQueueManager qm = null;
    private MQJMSMessage baseMessage = new MQJMSMessage();
    private boolean firstMsg = true;
    private boolean firstMsgP2P = true;
    private boolean firstPublish = true;
    private byte[] cachedRFHData = null;
    private String cachedBaseTopic = null;
    private int cachedEncoding = 0;
    private String brokerPubQMgr;
    private static final String PROBE_01 = "01";
    private static final String PROBE_02 = "02";
    private static final String PROBE_03 = "03";

    MQMessageProducer(WMQDestination dest, MQQueue queue, MQSession session) throws JMSException {
        super(null);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "<init>(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession)", new Object[]{dest, queue, session});
        }
        this.setForPTP = true;
        this.queueSpec = dest;
        this.queue = queue;
        this.session = session;
        this.pmo = new MQPutMessageOptions(true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "<init>(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,MQSession)");
        }
    }

    MQMessageProducer(WMQDestination dest, MQQueue mqqueue, MQQueueManager qm, MQConnection connection, MQSession session) throws JMSException {
        super(null);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "<init>(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager,MQConnection,MQSession)", new Object[]{dest, mqqueue, qm, connection, session});
        }
        if (Trace.isOn && mqqueue != null) {
            Trace.traceData(this, mqqueue + "(" + mqqueue.name + ")", null);
        }
        this.setForPubSub = true;
        this.TopicSpec = dest;
        this.mqPubQ = mqqueue;
        this.qm = qm;
        this.session = session;
        this.brokerPubQMgr = qm.name;
        this.pmo = new MQPutMessageOptions(true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "<init>(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager,MQConnection,MQSession)");
        }
    }

    MQMessageProducer(MQQueue mqqueue, MQQueueManager qm, MQConnection connection, MQSession session) throws JMSException {
        super(null);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager,MQConnection,MQSession)", new Object[]{mqqueue, qm, connection, session});
        }
        this.TopicSpec = null;
        this.queue = null;
        this.mqPubQ = mqqueue;
        this.qm = qm;
        this.session = session;
        this.pmo = new MQPutMessageOptions(true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQQueue,com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager,MQConnection,MQSession)");
        }
    }

    public void close(boolean closingFromSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "close(boolean)", new Object[]{closingFromSession});
        }
        try {
            block15: {
                this.closed = true;
                if (this.setForPTP) {
                    this.closeQ();
                }
                if (this.setForPubSub) {
                    this.closeT();
                }
                try {
                    if (this.mqPubQ != null && this.mqPubQ.isOpen()) {
                        this.mqPubQ.close();
                    }
                    this.mqPubQ = null;
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "close(boolean)", mqe, 1);
                    }
                    if (!Trace.isOn) break block15;
                    Trace.traceData(this, "Exception closing mqPubQ: " + mqe.getMessage() + " Reason: " + mqe.reasonCode, null);
                }
            }
            if (this.session != null) {
                this.session.removeProducer(this);
            } else if (Trace.isOn) {
                Trace.traceData(this, "session null, can't call removeSender", null);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "close(boolean)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "close(boolean)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "close(boolean)");
        }
    }

    private void closeQ() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeQ()");
        }
        try {
            this.closed = true;
            if (this.session != null) {
                this.session.removeSender(this);
            } else if (Trace.isOn) {
                Trace.traceData(this, "session null, can't call removeSender", null);
            }
            if (this.queue != null) {
                try {
                    this.queue.close();
                    this.queue = null;
                }
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeQ()", e, 1);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS2000");
                    je.setLinkedException((Exception)((Object)e));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeQ()", je, 1);
                    }
                    throw je;
                }
            }
            try {
                if (this.mqPubQ != null && this.mqPubQ.isOpen()) {
                    this.mqPubQ.close();
                }
                this.mqPubQ = null;
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeQ()", mqe, 2);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Exception closing mqPubQ: " + mqe.getMessage() + " Reason: " + mqe.reasonCode, null);
                }
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeQ()", je, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeQ()", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeQ()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeT() throws JMSException {
        block16: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeT()");
            }
            this.closed = true;
            if (this.TopicSpec != null) {
                block15: {
                    try {
                        try {
                            this.TopicSpec = null;
                            this.mqPubQ.close();
                        }
                        catch (Exception e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeT()", e, 1);
                            }
                            JMSException je = ConfigEnvironment.newException("MQJMS2000");
                            je.setLinkedException(e);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeT()", je);
                            }
                            throw je;
                        }
                        Object var4_1 = null;
                        if (!Trace.isOn) break block15;
                    }
                    catch (Throwable throwable) {
                        Object var4_2 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeT()");
                        }
                        this.mqPubQ = null;
                        throw throwable;
                    }
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeT()");
                }
                this.mqPubQ = null;
                this.session.removePublisher(this);
            } else {
                try {
                    if (this.mqPubQ != null && this.mqPubQ.isOpen()) {
                        this.mqPubQ.close();
                    }
                    this.mqPubQ = null;
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeT()", mqe, 2);
                    }
                    if (!Trace.isOn) break block16;
                    Trace.traceData(this, "Exception closing mqPubQ: " + mqe.getMessage() + " Reason: " + mqe.reasonCode, null);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "closeT()");
        }
    }

    private int getDeliveryMode() throws JMSException {
        int retVal = this.getIntProperty("deliveryMode");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "getDeliveryMode()", "getter", new Integer(retVal));
        }
        return retVal;
    }

    private int getPriority() throws JMSException {
        int retVal = this.getIntProperty("priority");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "getPriority()", "getter", new Integer(retVal));
        }
        return retVal;
    }

    private long getTimeToLive() throws JMSException {
        long retVal = this.getLongProperty("timeToLive");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "getTimeToLive()", "getter", new Long(retVal));
        }
        return retVal;
    }

    private void send(ProviderMessage message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderMessage,int,int,long)", new Object[]{message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        try {
            if (this.closed) {
                String msg = ConfigEnvironment.getErrorMessage("MQJMS3026");
                IllegalStateException je = new IllegalStateException(msg);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderMessage,int,int,long)", je, 1);
                }
                throw je;
            }
            if (this.setForPubSub) {
                this.publishInt(message, deliveryMode, priority, timeToLive);
            } else {
                if (this.queueSpec == null) {
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS1091");
                    UnsupportedOperationException uoe = new UnsupportedOperationException(msg);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderMessage,int,int,long)", uoe, 2);
                    }
                    throw uoe;
                }
                if (this.queue == null) {
                    JMSException je = ConfigEnvironment.newException("MQJMS2001");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderMessage,int,int,long)", je, 3);
                    }
                    throw je;
                }
                if (this.session.usingAsyncMode() && !this.session.callingFromOnMessage() && this.session.isStarted()) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "can't send because session is actively using async delivery", null);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS1013");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderMessage,int,int,long)", je, 4);
                    }
                    throw je;
                }
                this.sendInternal(this.queueSpec, this.queue, message, deliveryMode, priority, timeToLive);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderMessage,int,int,long)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderMessage,int,int,long)", je, 5);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderMessage,int,int,long)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendInternal(WMQDestination dest, MQQueue mqQueue, ProviderMessage message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", new Object[]{dest, mqQueue, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        try {
            long sendTime;
            boolean transacted;
            JMSMessage jmsMessage;
            block88: {
                block85: {
                    jmsMessage = null;
                    if (this.firstMsgP2P) {
                        this.session.addQueueServices();
                        this.firstMsgP2P = false;
                    }
                    if (message == null) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "sendInternal given a null message", null);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS1006", "message", "null");
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", je, 1);
                        }
                        throw je;
                    }
                    if (!(message instanceof JMSMessage)) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "sendInternal publishing alien message of class " + message.getClass().getName(), null);
                        }
                        jmsMessage = JMSMessage._copyFromMessage(this.session, message);
                    } else {
                        jmsMessage = (JMSMessage)message;
                    }
                    if (dest != null) {
                        if (dest.getIntProperty("failIfQuiesce") == 1) {
                            this.pmo.options |= 0x2000;
                            if (Trace.isOn) {
                                Trace.traceData(this, "FIQ behaviour: YES", null);
                            }
                        } else {
                            this.pmo.options &= 0xFFFFDFFF;
                            if (Trace.isOn) {
                                Trace.traceData(this, "FIQ behaviour: NO", null);
                            }
                        }
                    }
                    if (transacted = this.session.getTransacted()) {
                        this.pmo.options |= 2;
                        this.pmo.options &= 0xFFFFFFFB;
                    } else {
                        this.pmo.options |= 4;
                        this.pmo.options &= 0xFFFFFFFD;
                    }
                    this.pmo.options |= MQMessageProducer.computeMessageContextOptions(dest);
                    try {
                        if (this.session.getQM().getCommandLevel() > 700) {
                            this.pmo.options |= 0x20000;
                        }
                    }
                    catch (MQException me) {
                        if (!Trace.isOn) break block85;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", me, 1);
                    }
                }
                sendTime = System.currentTimeMillis();
                try {
                    int ccsid;
                    String charset;
                    int destPer;
                    int destPri;
                    block87: {
                        block90: {
                            block86: {
                                long destExp;
                                block89: {
                                    this.mqMessage.clearMessageData();
                                    this.mqMessage.setFormat("MQHRF2  ");
                                    if (dest.propertyExists("encoding")) {
                                        this.mqMessage.setEncoding(dest.getIntProperty("encoding"));
                                    }
                                    if (mqQueue != null) {
                                        this.mqMessage.setCharacterSet(mqQueue._getConnectionCCSID());
                                    } else {
                                        this.mqMessage.setCharacterSet(this.session.getQM()._getConnectionCCSID());
                                    }
                                    jmsMessage.setJMSDestinationAsString(dest.toURI());
                                    jmsMessage.setJMSTimestamp(sendTime);
                                    this.mqMessage.setPersistenceFromMD(this.session.getPersistenceFromMD());
                                    destExp = dest.getLongProperty("timeToLive");
                                    if (destExp != -2L) break block89;
                                    if (timeToLive == -1L) {
                                        jmsMessage._setTimeToLive(sendTime, this.getTimeToLive());
                                        break block86;
                                    } else if (timeToLive >= 0L) {
                                        jmsMessage._setTimeToLive(sendTime, timeToLive);
                                        break block86;
                                    } else {
                                        JMSException je = ConfigEnvironment.newException("MQJMS1006", "timeToLive", String.valueOf(timeToLive));
                                        if (Trace.isOn) {
                                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", je, 2);
                                        }
                                        throw je;
                                    }
                                }
                                jmsMessage._setTimeToLive(sendTime, destExp);
                            }
                            destPri = dest.getIntProperty("priority");
                            if (destPri != -2) break block90;
                            if (priority == -1) {
                                jmsMessage.setJMSPriority(this.getPriority());
                                break block87;
                            } else if (priority >= 0 && priority <= 9) {
                                jmsMessage.setJMSPriority(priority);
                                break block87;
                            } else {
                                JMSException je = ConfigEnvironment.newException("MQJMS1006", "priority", String.valueOf(priority));
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", je, 3);
                                }
                                throw je;
                            }
                        }
                        if (destPri == -1) {
                            jmsMessage.setJMSPriority(4);
                        } else {
                            jmsMessage.setJMSPriority(destPri);
                        }
                    }
                    if (dest.getIntProperty("deliveryMode") == 3 && !dest.isNPHighCheckDone()) {
                        if (this.queue != null) {
                            dest.setNPHighSupported(!this.session.getPersistenceFromMD() && dest.getIntProperty("targetClient") != 1 && dest.getIntProperty("messageBody") != 1 && this.queue.isNPMClassHigh());
                        } else {
                            try {
                                MQQueue theQueue = this.session.getQM().accessQueue(dest.getName(), 32, dest.getStringProperty("XMSC_WMQ_QUEUE_MANAGER"), this.session.connection != null ? this.session.connection.temporaryModelQ : null, null);
                                if (theQueue != null) {
                                    dest.setNPHighSupported(!this.session.getPersistenceFromMD() && dest.getIntProperty("targetClient") != 1 && dest.getIntProperty("messageBody") != 1 && theQueue.isNPMClassHigh());
                                } else {
                                    dest.setNPHighSupported(false);
                                }
                                if (theQueue != null) {
                                    theQueue.close();
                                }
                            }
                            catch (MQException me) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", me, 2);
                                }
                                dest.setNPHighSupported(false);
                            }
                        }
                    }
                    if ((destPer = dest.getIntProperty("deliveryMode")) == -2 || destPer == 3) {
                        switch (deliveryMode) {
                            case -1: {
                                jmsMessage.setJMSDeliveryMode(this.getDeliveryMode());
                                break;
                            }
                            case 1: 
                            case 2: {
                                jmsMessage.setJMSDeliveryMode(deliveryMode);
                                break;
                            }
                            default: {
                                JMSException je = ConfigEnvironment.newException("MQJMS1006", "deliveryMode", String.valueOf(deliveryMode));
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", je, 4);
                                }
                                throw je;
                            }
                        }
                    } else if (destPer == -1) {
                        jmsMessage.setJMSDeliveryMode(-2);
                    } else {
                        jmsMessage.setJMSDeliveryMode(destPer);
                    }
                    Integer enc = (Integer)jmsMessage.getObjectProperty("JMS_IBM_Encoding");
                    if (enc != null) {
                        this.mqMessage.setEncoding(enc);
                    }
                    if ((charset = jmsMessage.getStringProperty("JMS_IBM_Character_Set")) == null) {
                        ccsid = dest.getIntProperty("CCSID");
                    } else {
                        ccsid = MQJMSMessage.getCCSID(charset);
                        if (ccsid == 0) {
                            JMSException je = ConfigEnvironment.newException("MQJMS1006", "JMS_IBM_Character_Set", charset);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", je, 5);
                            }
                            throw je;
                        }
                    }
                    boolean rfh2Required = this.isMQRFH2Required(dest);
                    this.mqMessage.write(jmsMessage, rfh2Required, ccsid, dest);
                    if (destPri == -1) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "sendInternal fixing MQMD for priority as qdef", null);
                        }
                        this.mqMessage.setPriority(-1);
                    }
                    if (destPer == -1) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "sendInternal fixing MQMD for persistence as qdef", null);
                        }
                        this.mqMessage.setPersistence(2);
                        break block88;
                    }
                    if (destPer == 3 && dest.getNPHighSupported()) {
                        this.mqMessage.setPersistence(0);
                    }
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", e, 3);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", e, 6);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", e, 4);
                    }
                    HashMap<String, Object> ffstData = new HashMap<String, Object>();
                    ffstData.put("Exception", e);
                    ffstData.put("Message", "MQJMS1016");
                    Trace.ffst(this, "sendInternal(MQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", PROBE_02, ffstData, JMSException.class);
                    JMSException je = ConfigEnvironment.newException("MQJMS1016", e.toString());
                    je.setLinkedException(e);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", je, 7);
                    }
                    throw je;
                }
            }
            try {
                if (mqQueue == null) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "put1 to " + dest, null);
                    }
                    this.session.getQM().putMsg2(dest.getName(), dest.getStringProperty("XMSC_WMQ_QUEUE_MANAGER"), this.mqMessage, this.pmo);
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "send to " + mqQueue.name, null);
                    }
                    mqQueue.putMsg2(this.mqMessage, this.pmo);
                }
                if (transacted) {
                    this.session.setCommitRequired(true);
                }
                this.mqMessage.setHeaderFromMQMD(message);
            }
            catch (MQException e) {
                JMSException je;
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", e, 5);
                }
                if (e.reasonCode == 2052) {
                    String key = "MQJMS3001";
                    String msg = ConfigEnvironment.getErrorMessage(key);
                    je = new InvalidDestinationException(msg, key);
                } else {
                    je = ConfigEnvironment.newException("MQJMS2007");
                }
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", je, 8);
                }
                throw je;
            }
            if (jmsMessage != message) {
                message.setJMSDestinationAsString(dest.toURI());
                message.setJMSDeliveryMode(deliveryMode);
                message.setJMSTimestamp(sendTime);
                message.setJMSExpiration(jmsMessage.getJMSExpiration());
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", je, 6);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)", je, 9);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "sendInternal(WMQDestination,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,ProviderMessage,int,int,long)");
        }
    }

    private void publishInt(ProviderMessage message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", new Object[]{message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        if (Trace.isOn) {
            Trace.traceData(this, "firstPublish is " + this.firstPublish, null);
        }
        int savedMsgType = -1;
        boolean requestAck = false;
        try {
            boolean transacted;
            block55: {
                if (this.closed) {
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS3028");
                    IllegalStateException traceRet1 = new IllegalStateException(msg);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", traceRet1, 1);
                    }
                    throw traceRet1;
                }
                if (this.TopicSpec == null) {
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS1091");
                    UnsupportedOperationException uoe = new UnsupportedOperationException(msg);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", uoe, 2);
                    }
                    throw uoe;
                }
                this.validateParms(this.TopicSpec, message, deliveryMode, priority, timeToLive);
                if (this.mqPubQ == null) {
                    JMSException je = ConfigEnvironment.newException("MQJMS2001");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", je, 3);
                    }
                    throw je;
                }
                if (this.session.usingAsyncMode() && !this.session.callingFromOnMessage() && this.session.isStarted()) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "can't publish because session is actively using async delivery", null);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS1013");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", je, 4);
                    }
                    throw je;
                }
                if (this.TopicSpec != null) {
                    if (this.TopicSpec.getIntProperty("failIfQuiesce") == 1) {
                        this.pmo.options |= 0x2000;
                        if (Trace.isOn) {
                            Trace.traceData(this, "FIQ behaviour YES", null);
                        }
                    } else {
                        this.pmo.options &= 0xFFFFDFFF;
                        if (Trace.isOn) {
                            Trace.traceData(this, "FIQ behaviour NO", null);
                        }
                    }
                }
                if (transacted = this.session.getTransacted()) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderSession is transacted", null);
                    }
                    this.pmo.options |= 2;
                    this.pmo.options &= 0xFFFFFFFB;
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderSession is NOT transacted", null);
                    }
                    this.pmo.options |= 4;
                    this.pmo.options &= 0xFFFFFFFD;
                }
                try {
                    if (this.session.getQM().getCommandLevel() > 700) {
                        this.pmo.options |= 0x20000;
                    }
                }
                catch (MQException me) {
                    if (!Trace.isOn) break block55;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", me, 1);
                }
            }
            this.buildBaseMessage(this.TopicSpec, message, deliveryMode, priority, timeToLive);
            if (this.firstMsg && !transacted) {
                if (Trace.isOn) {
                    Trace.traceData(this, "First message on this publisher", null);
                }
                requestAck = true;
            } else if (!this.firstMsg && this.session.responseInterval > 0 && this.session.getServicesMgr().requestResponse(this.session)) {
                requestAck = true;
            }
            if (this.baseMessage.getReport() != 0) {
                requestAck = false;
            }
            if (requestAck) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Requesting a Broker response", null);
                }
                savedMsgType = this.baseMessage.getMessageType();
                this.baseMessage.setReport(3);
                this.baseMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                this.baseMessage.setReplyToQueueManagerName("");
            } else if (this.baseMessage.getReport() == 0) {
                this.baseMessage.setMessageType(8);
            }
            if (this.session.getSessionName() != null && null == message.getJMSCorrelationID()) {
                this.baseMessage.setCorrelationId(this.session.getSessionName());
            }
            if (this.firstPublish) {
                this.session.addPubSubServices();
                this.firstPublish = false;
            }
            try {
                if (this.session.getAcknowledgeMode() == 0 && this.session.getOptimisticPublication() && this.session.getQM() instanceof MQQueueManager && this.session.getQM().spiSupportsInherited()) {
                    this.mqPubQ.spiPut(this.baseMessage, this.pmo, 32);
                } else {
                    this.mqPubQ.putMsg2(this.baseMessage, this.pmo);
                }
                if (transacted) {
                    this.session.setCommitRequired(true);
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", e, 2);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3011");
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", je, 5);
                }
                throw je;
            }
            if (requestAck) {
                if (!this.firstMsg) {
                    this.session.responseRequested(System.currentTimeMillis(), this.baseMessage.getMessageId());
                }
                this.baseMessage.setMessageType(savedMsgType);
                this.baseMessage.setReport(0);
                this.baseMessage.setReplyToQueueName("");
                this.baseMessage.setReplyToQueueManagerName("");
            }
            this.baseMessage.setHeaderFromMQMD(message);
            if (this.firstMsg && requestAck || this.session.getServicesMgr().checkForResponse(this.session)) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Checking for a Broker response", null);
                }
                this.checkBrokerResponse();
                if (this.firstMsg) {
                    SubscriptionHelper.checkResponse(this.baseMessage);
                }
            }
            if (this.firstMsg) {
                this.firstMsg = false;
            }
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", e, 3);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3011");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", je, 6);
            }
            throw je;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", je, 4);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)", je, 7);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(ProviderMessage,int,int,long)");
        }
    }

    private void publishInt(WMQDestination topic, ProviderMessage message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", new Object[]{topic, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        int savedMsgType = -1;
        boolean requestAck = false;
        try {
            boolean transacted;
            block62: {
                JMSException je;
                if (this.closed) {
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS3028");
                    IllegalStateException traceRet1 = new IllegalStateException(msg);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", traceRet1, 1);
                    }
                    throw traceRet1;
                }
                if (this.TopicSpec != null) {
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS1014");
                    UnsupportedOperationException uoe = new UnsupportedOperationException(msg);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", uoe, 2);
                    }
                    throw uoe;
                }
                if (this.firstPublish) {
                    this.session.addPubSubServices();
                    this.firstPublish = false;
                }
                this.validateParms(topic, message, deliveryMode, priority, timeToLive);
                if (topic != null) {
                    String brokerPubQueue = this.session.connection.getBrkPubQueue();
                    String topicBrokerPubQ = topic.getStringProperty("XMSC_WMQ_BROKER_PUBQ");
                    String topicBrokerQMgr = topic.getStringProperty("XMSC_WMQ_BROKER_QMGR");
                    boolean change = false;
                    if (!(topicBrokerPubQ == null || topicBrokerPubQ.length() == 0 || topicBrokerPubQ != null && brokerPubQueue.equals(topicBrokerPubQ))) {
                        brokerPubQueue = topicBrokerPubQ;
                        change = true;
                    }
                    if (!(topicBrokerQMgr == null || topicBrokerQMgr.length() == 0 || topicBrokerQMgr != null && this.brokerPubQMgr.equals(topicBrokerQMgr))) {
                        this.brokerPubQMgr = topicBrokerQMgr;
                        change = true;
                    }
                    if (change || this.mqPubQ == null) {
                        try {
                            this.mqPubQ = this.qm.accessQueue(brokerPubQueue, 48, this.brokerPubQMgr, null, null);
                        }
                        catch (MQException e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", e, 1);
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "publish failed to access publish queue", null);
                            }
                            JMSException je2 = ConfigEnvironment.newException("MQJMS2008", brokerPubQueue);
                            je2.setLinkedException((Exception)((Object)e));
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", je2, 3);
                            }
                            throw je2;
                        }
                    }
                }
                if (this.mqPubQ == null) {
                    je = ConfigEnvironment.newException("MQJMS2001");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", je, 4);
                    }
                    throw je;
                }
                if (!this.session.callingFromOnMessage() && this.session.usingAsyncMode() && this.session.isStarted()) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "can't publish because session is actively using async delivery", null);
                    }
                    je = ConfigEnvironment.newException("MQJMS1013");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", je, 5);
                    }
                    throw je;
                }
                if (topic != null) {
                    if (topic.getIntProperty("failIfQuiesce") == 1) {
                        this.pmo.options |= 0x2000;
                        if (Trace.isOn) {
                            Trace.traceData(this, "FIQ behaviour YES", null);
                        }
                    } else {
                        this.pmo.options &= 0xFFFFDFFF;
                        if (Trace.isOn) {
                            Trace.traceData(this, "FIQ behaviour NO", null);
                        }
                    }
                }
                if (transacted = this.session.getTransacted()) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderSession is transacted", null);
                    }
                    this.pmo.options |= 2;
                    this.pmo.options &= 0xFFFFFFFB;
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderSession is NOT transacted", null);
                    }
                    this.pmo.options |= 4;
                    this.pmo.options &= 0xFFFFFFFD;
                }
                try {
                    if (this.session.getQM().getCommandLevel() > 700) {
                        this.pmo.options |= 0x20000;
                    }
                }
                catch (MQException me) {
                    if (!Trace.isOn) break block62;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", me, 2);
                }
            }
            this.buildBaseMessage(topic, message, deliveryMode, priority, timeToLive);
            if (this.firstMsg && !transacted) {
                if (Trace.isOn) {
                    Trace.traceData(this, "First message on this publisher", null);
                }
                requestAck = true;
            } else if (!this.firstMsg && this.session.responseInterval > 0 && this.session.getServicesMgr().requestResponse(this.session)) {
                requestAck = true;
            }
            if (this.baseMessage.getReport() != 0) {
                requestAck = false;
            }
            if (requestAck) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Requesting a Broker response", null);
                }
                savedMsgType = this.baseMessage.getMessageType();
                this.baseMessage.setReport(3);
                this.baseMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                this.baseMessage.setReplyToQueueManagerName("");
            } else if (this.baseMessage.getReport() == 0) {
                this.baseMessage.setMessageType(8);
            }
            if (this.session.getSessionName() != null && null == message.getJMSCorrelationID()) {
                this.baseMessage.setCorrelationId(this.session.getSessionName());
            }
            try {
                if (this.session.getAcknowledgeMode() == 0 && this.session.getOptimisticPublication() && this.session.getQM() instanceof MQQueueManager && this.session.getQM().spiSupportsInherited()) {
                    this.mqPubQ.spiPut(this.baseMessage, this.pmo, 32);
                } else {
                    this.mqPubQ.putMsg2(this.baseMessage, this.pmo);
                }
                if (transacted) {
                    this.session.setCommitRequired(true);
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", e, 3);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3011");
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", je, 6);
                }
                throw je;
            }
            if (requestAck) {
                if (!this.firstMsg) {
                    this.session.responseRequested(System.currentTimeMillis(), this.baseMessage.getMessageId());
                }
                this.baseMessage.setMessageType(savedMsgType);
                this.baseMessage.setReport(0);
                this.baseMessage.setReplyToQueueName("");
                this.baseMessage.setReplyToQueueManagerName("");
            }
            this.baseMessage.setHeaderFromMQMD(message);
            if (this.firstMsg && requestAck || this.session.getServicesMgr().checkForResponse(this.session)) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Checking for a Broker response", null);
                }
                this.checkBrokerResponse();
                if (this.firstMsg) {
                    SubscriptionHelper.checkResponse(this.baseMessage);
                }
            }
            if (this.firstMsg) {
                this.firstMsg = false;
            }
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", e, 4);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3011");
            je.setLinkedException((Exception)((Object)e));
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", je, 5);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)", je, 7);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "publishInt(WMQDestination,ProviderMessage,int,int,long)");
        }
    }

    private void validateParms(WMQDestination topic, ProviderMessage message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "validateParms(WMQDestination,ProviderMessage,int,int,long)", new Object[]{topic, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        try {
            if (deliveryMode != 2 && deliveryMode != 1 && deliveryMode != -1) {
                JMSException je = ConfigEnvironment.newException("MQJMS1006", "Delivery Mode", String.valueOf(deliveryMode));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "validateParms(WMQDestination,ProviderMessage,int,int,long)", je, 1);
                }
                throw je;
            }
            if (priority != -1 && (priority < 0 || priority > 9)) {
                JMSException je = ConfigEnvironment.newException("MQJMS1006", "Priority", String.valueOf(priority));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "validateParms(WMQDestination,ProviderMessage,int,int,long)", je, 2);
                }
                throw je;
            }
            if (timeToLive != -1L && timeToLive < 0L) {
                JMSException je = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(timeToLive));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "validateParms(WMQDestination,ProviderMessage,int,int,long)", je, 3);
                }
                throw je;
            }
        }
        catch (JMSException je2) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "validateParms(WMQDestination,ProviderMessage,int,int,long)", je2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "validateParms(WMQDestination,ProviderMessage,int,int,long)", je2, 4);
            }
            throw je2;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "validateParms(WMQDestination,ProviderMessage,int,int,long)");
        }
    }

    private void buildBaseMessage(WMQDestination topic, ProviderMessage message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessage(WMQDestination,ProviderMessage,int,int,long)", new Object[]{topic, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        try {
            int destPer;
            JMSMessage jmsMessage;
            if (message instanceof JMSMessage) {
                jmsMessage = (JMSMessage)message;
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "buildBaseMessage publishing alien message", null);
                }
                jmsMessage = JMSMessage._copyFromMessage(this.session, message);
            }
            long sendTime = System.currentTimeMillis();
            this.baseMessage.clearMessageData();
            this.baseMessage.setEncoding(topic.getIntProperty("encoding"));
            this.baseMessage.setCharacterSet(this.qm._getConnectionCCSID());
            jmsMessage.setJMSDestinationAsString(topic.toURI());
            jmsMessage.setJMSTimestamp(sendTime);
            this.baseMessage.setPersistenceFromMD(this.session.getPersistenceFromMD());
            long destExp = topic.getLongProperty("timeToLive");
            if (destExp == -2L) {
                if (timeToLive == -1L) {
                    jmsMessage._setTimeToLive(sendTime, this.getTimeToLive());
                } else {
                    jmsMessage._setTimeToLive(sendTime, timeToLive);
                }
            } else {
                jmsMessage._setTimeToLive(sendTime, destExp);
            }
            int destPri = topic.getIntProperty("priority");
            if (destPri == -2) {
                if (priority == -1) {
                    jmsMessage.setJMSPriority(this.getPriority());
                } else {
                    jmsMessage.setJMSPriority(priority);
                }
            } else if (destPri == -1) {
                jmsMessage.setJMSPriority(4);
            } else {
                jmsMessage.setJMSPriority(destPri);
            }
            if (topic.getIntProperty("deliveryMode") == 3 && !topic.isNPHighCheckDone()) {
                topic.setNPHighSupported(!this.session.getPersistenceFromMD() && topic.getIntProperty("targetClient") != 1 && topic.getIntProperty("messageBody") != 1 && this.mqPubQ.isNPMClassHigh());
            }
            if ((destPer = topic.getIntProperty("deliveryMode")) == -2 || destPer == 3) {
                if (deliveryMode == -1) {
                    jmsMessage.setJMSDeliveryMode(this.getDeliveryMode());
                } else {
                    jmsMessage.setJMSDeliveryMode(deliveryMode);
                }
            } else if (destPer == -1) {
                jmsMessage.setJMSDeliveryMode(-2);
            } else {
                jmsMessage.setJMSDeliveryMode(destPer);
            }
            StringBuffer topicBuffer = new StringBuffer();
            RFH1BrokerMessageImpl.formatNameValueValue(topicBuffer, topic.getName());
            String directive = "UNIQUE_CONNECTION_ID " + this.session.getConnectionID() + " " + "MQPSCommand Publish MQPSTopic " + topicBuffer.toString() + " MQPSPubOpts NoReg";
            try {
                int ccsid;
                String charset;
                jmsMessage.setJMSDestinationAsString(topic.toURI());
                Integer enc = (Integer)jmsMessage.getObjectProperty("JMS_IBM_Encoding");
                if (enc != null) {
                    this.baseMessage.setEncoding(enc);
                }
                if ((charset = jmsMessage.getStringProperty("JMS_IBM_Character_Set")) == null) {
                    ccsid = topic.getIntProperty("CCSID");
                } else {
                    ccsid = MQJMSMessage.getCCSID(charset);
                    if (ccsid == 0) {
                        JMSException bve = ConfigEnvironment.newException("MQJMS1006", "JMS_IBM_Character_Set", charset);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessage(WMQDestination,ProviderMessage,int,int,long)", bve, 1);
                        }
                        throw bve;
                    }
                }
                if (this.session.getConnectionBrokerVersion() == 1) {
                    jmsMessage.setPSCTopic(topic.getStringProperty("XMSC_DESTINATION_NAME"));
                    jmsMessage.setPSCConnID(this.session.getConnectionID());
                    this.baseMessage.write(jmsMessage, true, ccsid, topic);
                } else {
                    boolean rfh2Required = this.isMQRFH2Required(topic);
                    if (rfh2Required) {
                        this.buildBaseMessageWithCachedRFHAndRFH2(directive, jmsMessage, ccsid, topic);
                    } else {
                        this.baseMessage.writeRFH(directive, jmsMessage, false, ccsid, topic);
                    }
                }
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessage(WMQDestination,ProviderMessage,int,int,long)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessage(WMQDestination,ProviderMessage,int,int,long)", e, 2);
                }
                throw e;
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessage(WMQDestination,ProviderMessage,int,int,long)", e, 2);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3010");
                je.setLinkedException(e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessage(WMQDestination,ProviderMessage,int,int,long)", je, 3);
                }
                throw je;
            }
            if (destPri == -1) {
                if (Trace.isOn) {
                    Trace.traceData(this, "buildBaseMessage: MQMD priority set as QDEF", null);
                }
                this.baseMessage.setPriority(-1);
            }
            if (destPer == -1) {
                if (Trace.isOn) {
                    Trace.traceData(this, "buildBaseMessage: MQMD persistence set as QDEF", null);
                }
                this.baseMessage.setPersistence(2);
            } else if (destPer == 3 && topic.getNPHighSupported()) {
                this.baseMessage.setPersistence(0);
            }
            if (this.session.getConnectionBrokerVersion() == 1) {
                this.baseMessage.setFormat("MQHRF2  ");
            } else {
                this.baseMessage.setFormat("MQHRF   ");
            }
            this.baseMessage.setGroupId(MQC.MQGI_NONE);
            this.baseMessage.setMessageSequenceNumber(1);
            this.baseMessage.setMessageFlags(this.baseMessage.getMessageFlags() & 0xFFFFFFF7);
            if (jmsMessage != message) {
                message.setJMSDestinationAsString(topic.toURI());
                message.setJMSDeliveryMode(deliveryMode);
                message.setJMSTimestamp(sendTime);
                message.setJMSExpiration(jmsMessage.getJMSExpiration());
            }
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessage(WMQDestination,ProviderMessage,int,int,long)", e, 3);
            }
            JMSException je2 = new JMSException("MQJMS1000");
            je2.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessage(WMQDestination,ProviderMessage,int,int,long)", je2, 4);
            }
            throw je2;
        }
        catch (JMSException je2) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessage(WMQDestination,ProviderMessage,int,int,long)", je2, 4);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessage(WMQDestination,ProviderMessage,int,int,long)", je2, 5);
            }
            throw je2;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessage(WMQDestination,ProviderMessage,int,int,long)");
        }
    }

    private void buildBaseMessageWithCachedRFHAndRFH2(String directive, JMSMessage jmsMsg, int ccsid, ProviderDestination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessageWithCachedRFHAndRFH2(String,JMSMessage,int,ProviderDestination)", new Object[]{directive, jmsMsg, new Integer(ccsid), destination});
        }
        try {
            if (this.TopicSpec != null) {
                if (this.cachedRFHData == null || this.cachedBaseTopic != null && !this.cachedBaseTopic.equals(this.TopicSpec.getStringProperty("XMSC_DESTINATION_NAME")) || this.cachedEncoding != this.baseMessage.getEncoding()) {
                    this.cachedRFHData = this.baseMessage.buildCacheableRFH(directive, ccsid, this.baseMessage.getEncoding());
                    this.cachedBaseTopic = this.TopicSpec.getStringProperty("XMSC_DESTINATION_NAME");
                    this.cachedEncoding = this.baseMessage.getEncoding();
                }
                this.baseMessage.appendByteArray(this.cachedRFHData);
                this.baseMessage.write(jmsMsg, true, ccsid, this.TopicSpec);
            } else {
                this.baseMessage.writeRFH(directive, jmsMsg, true, ccsid, destination);
            }
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessageWithCachedRFHAndRFH2(String,JMSMessage,int,ProviderDestination)", e, 1);
            }
            JMSException je = new JMSException("MQJMS1000");
            je.setLinkedException((Exception)e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessageWithCachedRFHAndRFH2(String,JMSMessage,int,ProviderDestination)", je, 1);
            }
            throw je;
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessageWithCachedRFHAndRFH2(String,JMSMessage,int,ProviderDestination)", e, 2);
            }
            JMSException je = new JMSException("MQJMS1000");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessageWithCachedRFHAndRFH2(String,JMSMessage,int,ProviderDestination)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "buildBaseMessageWithCachedRFHAndRFH2(String,JMSMessage,int,ProviderDestination)");
        }
    }

    private void checkBrokerResponse() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "checkBrokerResponse()");
        }
        try {
            this.session.getServicesMgr().getBrokerResponse(this.session, this.baseMessage, this.firstMsg);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "checkBrokerResponse()", e);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "checkBrokerResponse()", e);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "checkBrokerResponse()");
        }
    }

    private void send(ProviderDestination destination, ProviderMessage message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        block10: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderDestination,ProviderMessage,int,int,long)", new Object[]{destination, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
            }
            try {
                if (destination == null) {
                    this.send(message, deliveryMode, priority, timeToLive);
                    break block10;
                }
                if (destination.isQueue()) {
                    this.sendInternal((WMQDestination)destination, null, message, deliveryMode, priority, timeToLive);
                    break block10;
                }
                if (destination.isTopic()) {
                    this.publishInt((WMQDestination)destination, message, deliveryMode, priority, timeToLive);
                    break block10;
                }
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderDestination,ProviderMessage,int,int,long)", (Throwable)je, 1);
                }
                throw je;
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderDestination,ProviderMessage,int,int,long)", je);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderDestination,ProviderMessage,int,int,long)", je, 2);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderDestination,ProviderMessage,int,int,long)");
        }
    }

    public void send(ProviderDestination destination, ProviderMessage message) throws JMSException {
        block13: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderDestination,ProviderMessage)", new Object[]{destination, message});
            }
            try {
                int localDeliveryMode = message.getJMSDeliveryMode();
                int localPriority = message.getJMSPriority();
                long localExpiration = message.getJMSExpiration();
                long localTimestamp = message.getJMSTimestamp();
                if (localTimestamp == 0L) {
                    localTimestamp = System.currentTimeMillis();
                }
                long localTimeToLive = 0L;
                if (localExpiration > 0L) {
                    localTimeToLive = localExpiration - localTimestamp;
                }
                if (localTimeToLive < 0L) {
                    localTimeToLive = 1L;
                }
                if (destination == null) {
                    this.send(message, localDeliveryMode, localPriority, localTimeToLive);
                    break block13;
                }
                if (destination.isQueue()) {
                    this.send(destination, message, localDeliveryMode, localPriority, localTimeToLive);
                    break block13;
                }
                if (destination.isTopic()) {
                    this.publishInt((WMQDestination)destination, message, localDeliveryMode, localPriority, localTimeToLive);
                    break block13;
                }
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderDestination,ProviderMessage)", (Throwable)je, 1);
                }
                throw je;
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderDestination,ProviderMessage)", je);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderDestination,ProviderMessage)", je, 2);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "send(ProviderDestination,ProviderMessage)");
        }
    }

    public boolean providerPriorityValidate(int priority) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "providerPriorityValidate(int)", new Object[]{new Integer(priority)});
        }
        if (-1 == priority) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "providerPriorityValidate(int)", true, 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "providerPriorityValidate(int)", false, 2);
        }
        return false;
    }

    public boolean providerTimeToLiveValidate(long timeToLive) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "providerTimeToLiveValidate(long)", new Object[]{new Long(timeToLive)});
        }
        if (-2L == timeToLive) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "providerTimeToLiveValidate(long)", true, 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "providerTimeToLiveValidate(long)", false, 2);
        }
        return false;
    }

    private boolean isMQRFH2Required(WMQDestination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "isMQRFH2Required(WMQDestination)", new Object[]{destination});
        }
        boolean rfh2Required = true;
        int messageBodyStyle = destination.getIntProperty("messageBody");
        switch (messageBodyStyle) {
            case 2: {
                int targetClient = destination.getIntProperty("targetClient");
                if (targetClient == 0) {
                    rfh2Required = true;
                    break;
                }
                if (targetClient == 1) {
                    rfh2Required = false;
                    break;
                }
                HashMap<String, Integer> info = new HashMap<String, Integer>();
                info.put("targetClient", new Integer(targetClient));
                Trace.ffst(this, "isMQRFH2Required(WMQDestination)", "XO00K001", info, JMSException.class);
                break;
            }
            case 0: {
                rfh2Required = true;
                break;
            }
            case 1: {
                rfh2Required = false;
                break;
            }
            default: {
                HashMap<String, Integer> info = new HashMap<String, Integer>();
                info.put("messageBody", new Integer(messageBodyStyle));
                Trace.ffst(this, "isMQRFH2Required(WMQDestination)", "XO00K002", info, JMSException.class);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "isMQRFH2Required(WMQDestination)", rfh2Required);
        }
        return rfh2Required;
    }

    static int computeMessageContextOptions(WMQDestination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "computeMessageContextOptions(WMQDestination)", new Object[]{destination});
        }
        int messageContextOptions = 0;
        int value = destination.getIntProperty("mdMessageContext");
        messageContextOptions = value == 1 ? 1024 : (value == 2 ? 2048 : 0);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "computeMessageContextOptions(WMQDestination)", new Integer(messageContextOptions));
        }
        return messageContextOptions;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQMessageProducer.java, jmscc.wmq.v6, k701, k701-112-140304  1.64.1.3 11/03/29 14:28:10");
        }
    }
}

